implementation module Grafiek


import	StdInt, StdBool, StdReal, StdChar, StdList, StdFunc, StdEnum, StdTuple, StdMisc
import	deltaEventIO, deltaPicture, deltaFont, deltaDialog
import	Bord, Letters

::	Size			:==	(!Int,!Int)

font size			:== snd (SelectFont "MS Sans Serif" [] 8)

letterfont :== snd (SelectFont "Times" ["Bold"] 9)
smallfont  :== snd (SelectFont "Small Fonts" [] 6)

zwart				:==	BlackColour
blauw				:==	BlueColour
groen				:==	GreenColour
blauwgroen			:==	RGB 0.0 0.72 0.68
rood				:==	RedColour
paars				:==	RGB 0.78 0.31 1.0
lichtgroen			:==	RGB 0.5 1.0 0.5
grijs				:==	RGB 0.5 0.5 0.5
donkergrijs			:==	RGB 0.31 0.31 0.31
felblauw			:==	RGB 0.0 0.0 1.0
felgroen			:== RGB 0.0 1.0 0.0
viesblauw			:==	RGB 0.27 0.67 0.92
felpaars			:==	MagentaColour
geel				:==	YellowColour
wit					:==	WhiteColour
rbBordGrijs			:== RGB 0.75  0.75  0.75
rbDlogGrijs			:== RGB 0.751 0.751 0.751
rbLichterGrijs		:== RGB 0.878 0.878 0.878
rbBordRoodDrie		:== RGB 1.0   0.5   0.5
rbBordRoodTwee		:== RGB 0.75  0.625 0.625
rbBordBlauwDrie		:== RGB 0.5   0.5   1.0
rbBordBlauwTwee		:== RGB 0.625 0.625 0.75
rbStartGroen		:== RGB 0.625 0.75  0.625
rbDonkerGroen		:== RGB 0.625 0.875 0.625
rbBlokje			:== RGB 1.0   1.0   0.75 
rbDonkerGeel		:== RGB 0.5   0.5   0.0


meldingbreedte		:==	280
meldinghoogte		:==	100
bordbreedte			:==	391	// Peter: was 330
bordhoogte			:==	391	// Peter: was 330
blokbreedte			::	Int
blokbreedte			=:	bordbreedte/15
blokhoogte			::	Int
blokhoogte			=:	bordbreedte/15		


/*	Omrekening van 'Amanda-space' naar 'Scrabble-space' naar 'Pixel-space':
	Amanda-space	: ((-1.0,1.0),(1.0,-1.0))
	Scrabble-space	: ((0.0,0.0), (14.0,14.0))
	Pixel-space		: ((0,0), (width,height))
*/

abs2rel :: !(!Int,!Int) -> (!Int,!Int)
abs2rel (x,y) = (x/blokbreedte,y/blokhoogte)

instance toString ControlState
where
	toString :: !ControlState -> {#Char}
	toString (StringCS s)	= s
	toString _				= abort "toString not applied to (StringCS _).\n"

toStringCS :: String -> ControlState
toStringCS s = StringCS s


/*	De teken operaties.	*/



tekenbord :: !Bord !Size SelectState ControlState -> [DrawFunction]
tekenbord (hor,ver) size=:(w,h) _ _
	= [	SetPenColour	rbBordGrijs 
	  ,	FillRectangle	((0,0),size)
	  ,	SetPenColour	WhiteColour
	  ]
	  ++ 
	  [	DrawLine ((blokbreedte*i+1,0),(blokbreedte*i+1,h)) \\ i<-[0..15] ]
	  ++
	  [	DrawLine ((0,blokbreedte*i+1),(w,blokbreedte*i+1)) \\ i<-[0..15] ]
	  ++
      [ SetPenColour donkergrijs : [ DrawLine ((blokbreedte*i,1),(blokbreedte*i,h)) \\ i<-[0..15] ] ]
	  ++
	  [	DrawLine ((1,blokbreedte*i),(w,blokbreedte*i)) \\ i<-[0..15] ]
	  ++
	  [	tekenbonus "letter" (zwart,blauwgroen) (rbBordBlauwTwee,rbBordBlauwDrie) (dubbelletterposities,driedubbelletterposities)
	  ,	tekenbonus "woord"  (zwart,zwart)      (rbBordRoodTwee, rbBordRoodDrie)  (dubbelwoordposities, driedubbelwoordposities)
	  ]
	  ++tekenster
	  ++
	  [	SetPenColour blauw ]
	  ++
	  [	TekenLetter l (i,j) \\ i <- [0..14], j <- [0..14], l <- [(hor!j)!i] ]
where
	tekenbonus :: !String !(!Colour,!Colour) !(!Colour,!Colour) ([(Int,Int)],[(Int,Int)]) !Picture -> Picture
	tekenbonus woord_letter (tekstkleur2,tekstkleur3) (hokjekleur2,hokjekleur3) (pos2,pos3) picture
		= picture2
	where
		picture1			= SetFont (font 8) picture
		picture2			= seq (flatten	(	map (tekenhokje  hokjekleur2)					pos2
											++	map (tekenNtekst tekstkleur2 2 woord_letter)	pos2
											++	map (tekenhokje  hokjekleur3)					pos3
											++	map (tekenNtekst tekstkleur3 3 woord_letter)	pos3
											)
								  ) picture1
		tekenNtekst kleur n woord_letter (i,j)
			= [
			  ]
		where
			i`	= toReal i
			j`	= toReal j
			
		//	tekstpositie rekent een positie in 'Scrabble-space' om in 'Pixel-space' voor de plaatsing van tekst.
			tekstpositie :: !(!Real,!Real) -> (!Int,!Int)
			tekstpositie (col,row)
				= (toInt ((col+0.05)*breedte),toInt ((row+0.3)*breedte))
			where
				breedte	= toReal blokbreedte
	
	tekenster :: [DrawFunction]
	tekenster	= tekenhokje rbBordGrijs (7,7) ++	[SetPenColour grijs,FillPolygon (abspositie (7.5,7.5),vorm)]
	where
		h		= (blokbreedte-1)/2
		v		= (blokbreedte-1)/2
		vorm	=  [(0,0-v),(h,v),(0-h,v),(0-h,0-v),(h,0-v)]
	//	abspositie rekent een positie in 'Scrabble-space' om in 'Pixel-space'.
		abspositie :: !(!Real,!Real) -> (!Int,!Int)
		abspositie (col,row)
			= (toInt (col*breedte),toInt (row*breedte))
		where
			breedte	= toReal blokbreedte
	
	tekenhokje :: !Colour !(!Int,!Int) -> [DrawFunction]
	tekenhokje kleur (col,row)
		= [	SetPenColour	kleur
		  ,	FillRectangle	((l,t),(r,b))
		  ]
    where
	  l = col*blokbreedte+2
	  t = row*blokbreedte+2
      r = (inc col)*blokbreedte
	  b = (inc row)*blokbreedte



TekenLetter :: !Char !(!Int,!Int) !Picture -> Picture
TekenLetter l (i,j) picture
|	l==' '		= picture
|	otherwise	= picture`
with
    picture`  = draw [  SetPenColour rbBlokje
					 ,  FillRectangle ((x+2,y+2),(x+blokbreedte,y+blokhoogte))
					 ,  MovePenTo (x+2,y+blokhoogte-1)
					 ,  SetPenColour WhiteColour
					 ,  LinePenTo (x+2,y+2)
					 ,  LinePenTo (x+blokbreedte-1,y+2)
					 ,  SetPenColour YellowColour
					 ,  LinePenTo (x+blokbreedte-1,y+blokbreedte-1)
					 ,  LinePenTo (x+2,y+blokhoogte-1)
					 ,  SetFont (letterfont)
					 ,  MovePenTo (x+blokbreedte/4,y+h-h/3)
					 ,  SetPenColour BlackColour
					 ,  DrawChar (toUpper l)
					 ,  SetFont (smallfont)
					 ,  SetPenColour rbDonkerGeel
					 ,  MovePenTo (x+blokbreedte -2 -plen,y+h-3)
					 ,  DrawString (puntstring)
					 ] picture
	
	x			= i*blokbreedte
	y			= j*blokhoogte
	h			= blokhoogte

	puntstring  = toString (letterwaarde l)
	plen        = FontStringWidth puntstring smallfont 


hertekenbord :: !Bord !(IOState t) -> IOState t
hertekenbord bord iostate
	= ChangeDialog scrabbleId [ChangeControlLook 100 (tekenbord bord (bordbreedte,bordhoogte))] iostate

tekenspeler1letterbalkje :: !Woord !(IOState t) -> IOState t
tekenspeler1letterbalkje w iostate
	= ChangeDialog scrabbleId [ChangeControlState 102 (StringCS (toString w))] iostate

tekenspeler2letterbalkje :: !Woord !(IOState t) -> IOState t
tekenspeler2letterbalkje w iostate
	= ChangeDialog scrabbleId [ChangeControlState 104 (StringCS (toString w))] iostate

tekenspelerletterbalkje :: !Size SelectState !ControlState -> [DrawFunction]
tekenspelerletterbalkje size=:(w,h) _ (StringCS ws)
	= [	SetPenColour	rbBordGrijs
	  ,	FillRectangle	((0,0),size)
	  :
	  [	TekenLetter l (i,0) \\ i<-[0..length woord-1], l<-[woord!i] ]
	  ]
where
	woord		= fromString ws            
	blokbreedte	= w/7
	
	
tekenspelerletterbalkje _ _ _
	= abort "tekenspelerletterbalkje not applied to (StringCS _).\n"


tekenspeler1score :: !Int !(IOState t) -> IOState t
tekenspeler1score s iostate
	= ChangeDialog scrabbleId [ChangeDynamicText 106 (toString s)] iostate

tekenspeler2score :: !Int !(IOState t) -> IOState t
tekenspeler2score s iostate
	= ChangeDialog scrabbleId [ChangeDynamicText 108 (toString s)] iostate

tekenmelding :: !Size [String] !(IOState s) -> IOState s
tekenmelding size melding iostate
	= ChangeDialog scrabbleId [	ChangeControlState 110 (ListCS (map toStringCS melding))
							  ,	ChangeControlLook  110 (meldinglook size)
							  ] iostate


meldinglook :: !Size SelectState !ControlState -> [DrawFunction]
meldinglook size=:(w,h) _ (ListCS melding)
	= [tekenmelding` (map toString melding) size]
where
	tekenmelding` :: ![String] !Size !Picture -> Picture
	tekenmelding` melding size=:(w,h) picture
		= picture5
	where
		picture2 = tekenmeldingpanel size picture
		picture3 = SetFont (font 10) picture2
		picture4 = SetPenColour rood picture3
		picture5 = seq [ \p->DrawString l (MovePenTo (w/20,h*y/10) p) \\ (y,l) <- zip2 [2,4..] melding ] picture4


tekenvordering :: !Size !Speler !Vordering !Plaatsing !Plaatsing !(IOState t) -> IOState t
tekenvordering size speler vordering plaatsing1 plaatsing2 iostate
	= ChangeDialog scrabbleId [ChangeControlLook 110 (vorderinglook size speler vordering plaatsing1 plaatsing2)] iostate
where
	vorderinglook :: !Size !Speler !Vordering !Plaatsing !Plaatsing SelectState ControlState -> [DrawFunction]
	vorderinglook size speler vordering plaatsing1 plaatsing2 _ _
		= [vorderinglook` size speler vordering plaatsing1 plaatsing2]
	where
		vorderinglook` :: !Size !Speler !Vordering !Plaatsing !Plaatsing !Picture -> Picture
		vorderinglook` size=:(w,h) speler (Letter letter p) oplaatsing nplaatsing picture
			= picture`
		where
			(ow,_,_,_)		= oplaatsing
			(nw,(x,y),r,s)	= nplaatsing

			picture`        = draw [ tekenmeldingpanel size
			                       , SetFont hetfont
								   , SetPenColour grijs 
								   , DrawStringAt letterspos alfabet
								   , SetPenColour groen 
								   , DrawStringAt letterspos alfabet_tot_en_met_l
								   , SetPenColour rood
								   , DrawStringAt letterspos alfabet_tot_l 
								   , SetPenColour groen 
								   , DrawStringAt (tekstindent, toInt (0.15*h`)) (toString speler+++" bepaalt een nieuw woord")
								   , DrawStringAt (gevondenpos, toInt (0.60*h`)) gevondenstring
								   , MovePen (10,0)
								   , DrawString (toString nw)
								   , DrawStringAt (oppos, toInt (0.75*h`)) opstring
								   , MovePen (10,0)
								   , DrawString plaatsingtext
								   , DrawStringAt (scorepos, toInt (0.90*h`)) scorestring
								   , MovePen (10,0)
								   , DrawString (toString s)
								   ] picture
            hetfont         = font 10

            gevondenstring  = "gevonden woord tot nu toe:"
			opstring        = "op:"
			scorestring     = "score tot nu toe:"

			gevondenlen     = FontStringWidth gevondenstring hetfont
            rtabstop        = tekstindent + gevondenlen

			gevondenpos     = tekstindent
			oppos           = rtabstop - FontStringWidth opstring hetfont
            scorepos        = rtabstop - FontStringWidth scorestring hetfont
			
			w`				= toReal w
			h`				= toReal h
			letterspos		= (toInt (0.05 *w`),toInt (0.35*h`))
			tekstindent		=  toInt (0.05*w`)
			
			alfabet			= "abcdefghijklmnopqrstuvwxyz"
			alfabet_tot_l	= if (letter=='a') "" (alfabet%(0,l_index-1))
			alfabet_tot_en_met_l
							= alfabet%(0,l_index)
			l_index			= toInt letter-a_index
			a_index			= toInt 'a'
			
			plaatsingtext	= "("+++toString x+++","+++toString y+++")"+++(if (r==Hor) " horizontaal" " verticaal")
		vorderinglook` size=:(w,h) speler (Klaar _) _ _ picture
			= picture5
		where
			picture1		= SetPenColour grijs picture
			picture2		= FillRectangle ((0,0),size) picture1
			picture3		= SetFont (font 10) picture2
			picture4		= SetPenColour rood picture3
			picture5		= DrawStringAt (toInt (0.05*w`),toInt (0.95*h`)) (toString speler+++" heeft nieuw woord bepaald!!") picture4
			
			w`				= toReal w
			h`				= toReal h
		
		DrawStringAt :: !(!Int,!Int) !String !Picture -> Picture
		DrawStringAt (x,y) text picture
			= picture2
		where
			picture1 = MovePenTo (x,y) picture
			picture2 = DrawString text picture1


tekenmeldingpanel :: (Int,Int) Picture -> Picture
tekenmeldingpanel size=:(w,h) p = p2
where
  p2 = draw [  SetPenColour BlackColour
            ,  SetBackColour BlackColour
            ,  FillRectangle ((0,0),size)
			,  SetPenColour grijs
			,  MovePenTo (-1,h-1)
			,  LinePenTo (-1,-1)
			,  LinePenTo (w,-1)
			,  SetPenColour grijs
			,  MovePenTo (-2,h)
			,  LinePenTo (-2,-2)
			,  LinePenTo (w+1,-2)
			,  SetPenColour wit
			,  MovePenTo (-1,h)
			,  LinePenTo (w,h)
			,  LinePenTo (w,-2)
			,  SetPenColour rbLichterGrijs
			,  MovePenTo (-2,h+1)
			,  LinePenTo (w+1,h+1)
			,  LinePenTo (w+1,-3)
			]  p


draw :: ![Picture ->Picture] !Picture -> Picture
draw [] p = p
draw [ f : rest] p = draw rest (f p)
