implementation module Bord

import	StdInt, StdBool, StdChar, StdString, StdArray, StdList, StdString, StdEnum, StdClass, StdFile, StdMisc
import	Letters

scrabbleId		:==	1
toevoegId		:==	2
computerId		:== 1

::	Spelmode	=	Pauze | Einde | EindeSpeler1 | EindeSpeler2 | Spelend
::	Spelersoort	=	Computer | Persoon
::	Speler		=	Speler1 | Speler2
::	Sterkte		=	Maximaal | EersteBeste | Sterkte Int


::	Vordering
	=	Letter Char Plaatsing
	|	Klaar  Plaatsing			// | Woord Char [Char] Plaatsing
::	Plaatsing
	:==	(	Woord
		,	Positie
		,	Richting
		,	Int
		)

geefplaatsing :: !Vordering -> Plaatsing
geefplaatsing (Letter l p) = p
geefplaatsing (Klaar p)    = p

geefletter :: !Vordering -> Char
geefletter (Letter l p) = l
geefletter (Klaar p)    = 'z'
	
nognietklaar :: !Vordering -> Bool
nognietklaar (Klaar _)	= False
nognietklaar _			= True


::	Bord		:==	(![[Char]],![[Char]])
::	Positie		:==	(!Int,!Int)
::	Posities	:==	[Positie]
::	Richting	=	Hor | Ver 


instance == Spelmode
where
	(==) :: !Spelmode !Spelmode -> Bool
	(==) Pauze			mode	= case mode of
									Pauze			-> True
									_				-> False
	(==) Einde			mode	= case mode of
									Einde			-> True
									_				-> False
	(==) EindeSpeler1	mode	= case mode of
									EindeSpeler1	-> True
									_				-> False
	(==) EindeSpeler2	mode	= case mode of
									EindeSpeler2	-> True
									_				-> False
	(==) Spelend		mode	= case mode of
									Spelend			-> True
									_				-> False
instance == Sterkte
where
	(==) :: !Sterkte !Sterkte -> Bool
	(==) Maximaal		sterkte	= case sterkte of
									Maximaal		-> True
									_				-> False
	(==) EersteBeste	sterkte	= case sterkte of
									EersteBeste		-> True
									_				-> False
	(==) (Sterkte s1)	sterkte	= case sterkte of
									(Sterkte s2)	-> s1==s2
									_				-> False
instance == Spelersoort
where
	(==) :: !Spelersoort !Spelersoort -> Bool
	(==) Computer Computer	= True
	(==) Persoon  Persoon	= True
	(==) _		  _			= False
instance == Speler
where
	(==) :: !Speler !Speler -> Bool
	(==) Speler1 Speler1 = True
	(==) Speler2 Speler2 = True
	(==) _		 _		 = False
instance == Richting
where
	(==) :: !Richting !Richting -> Bool
	(==) Hor Hor = True
	(==) Ver Ver = True
	(==) _	 _	 = False
instance toString Speler
where
	toString :: !Speler -> {#Char}
	toString Speler1 = "Speler 1"
	toString Speler2 = "Speler 2"
instance toString (a,b,c,d)	| toString a & toString b & toString c & toString d
where
	toString :: !(a,b,c,d) -> {#Char} | toString a & toString b & toString c & toString d
	toString (a,b,c,d) = "("+++toString a+++","+++toString b+++","+++toString c+++","+++toString d+++")"

anderespeler :: !Speler -> Speler
anderespeler Speler1 = Speler2
anderespeler Speler2 = Speler1


/***************************************************************** 
	De afmetingen van het bord lopen van 0..14 bij 0..14
*******************************************************************/

initbord :: Bord
initbord
	= (leegbord,leegbord)
where
	leegbord = repeatn 15 (repeatn 15 ' ')

initplaatsing :: Plaatsing
initplaatsing = ([],(0,0),Hor,0)


geefgeplaatsteletters :: !Bord -> [Char]
geefgeplaatsteletters (h,v) 
	= sort (removeMembers (removeDup (flatten h)) [])

geefvrijehorposities :: !Bord !Char -> Posities
geefvrijehorposities (h,v) l
	= flatten (map (vrijeposities True l 0) (zip2 [0..] h))

geefvrijeverposities :: !Bord !Char -> Posities
geefvrijeverposities (h,v) l
	= map swap (flatten (map (vrijeposities True l 0) (zip2 [0..] v)))

vrijeposities :: !Bool !Char !Int !(!Int,!Woord) -> Posities
vrijeposities b k x (y,[])
	= []
vrijeposities True k x (y,[l:ls])
|	l==k		= [(x,y) : vrijeposities False k (x+1) (y,ls)]
|	l==' '		= vrijeposities True  k (x+1) (y,ls)
|	otherwise	= vrijeposities False k (x+1) (y,ls)
vrijeposities False k x (y,[l:ls])
|	l==' '		= vrijeposities True  k (x+1) (y,ls)
|	otherwise	= vrijeposities False k (x+1) (y,ls)


/********************************************************
* De functie 'zoekvrijeposities bord letter positie' is *
* een algemener toepasbare functie. De functie bepaalt  *
* welke posities op het bord beschikbaar zijn om        *
* een woord met de letter op deze positie te plaatsen.  *
*
* Deze functie wordt gebruikt voor het bepalen,         *
* van alle mogelijke plaatsingen, van woorden           *
* waarbij 1 of meer letters van de letters op het bord  *
* gebruikt moeten worden.                               *
*                                                       *
* Deze optimalisatie is bruikbaar voor letters          *
* die op het letterbalkje van de computerspeler         *
* staan. Maar dan alleen wanneer er ten minste 1 letter *
* van het te plaatsen woord ontbreekt.                  *
*                                                       *
* Deze optimalistie is veel minder effectief, omdat nu  *
* voor ieder nieuw mogelijk woord alle mogelijke        *
* posities opnieuw bepaald moeten worden.               *
*********************************************************/

zoekvrijehorposities :: !Bord !Char !Int -> Posities
zoekvrijehorposities (h,v) k p
	= flatten (map (zoekvrijeposities 0 p k 0) (zip2 [0..] h))

swap :: !(.a,.b) -> (.b,.a)
swap (a,b) = (b,a)

zoekvrijeverposities :: !Bord !Char !Int -> Posities
zoekvrijeverposities (h,v) k p
	= map swap (flatten (map (zoekvrijeposities 0 p k 0) (zip2 [0..] v) ))

zoekvrijeposities :: !Int !Int !Char !Int !(!Int,!Woord) -> Posities
zoekvrijeposities a p k x (y,[])
	= []
zoekvrijeposities a p k x (y,[l:ls])
|	a>=p && k==l		= [(x-p,y) : zoekvrijeposities 0 p k (x+1) (y,ls)]
|	l==' '				= zoekvrijeposities (a+1) p k (x+1) (y,ls)
|	otherwise			= zoekvrijeposities 0 p k (x+1) (y,ls)


/***************************************************************** 
	Met scorevoegtoe wordt geprobeerd om een woord toe te voegen
	indien dit lukt wordt het nieuwe bord teruggegeven,
	of het toevoegen wel of niet gelukt is, de letters die
	toegevoegd zijn (om te bepalen welke letters
	de speler gebruikt heeft), de score en de nieuw gevonden
	woorden.

	Hierna moet nog gecontroleerd worden of alle nieuwe woorden
	die gevormd zijn wel bestaan.

	DE SCORE MOET DAARNA NOG GECORRIGEERD WORDEN VOOR 
	WEL/NIET WEGSPELEN VAN ALLE LETTERS.
*******************************************************************/

scorevoegtoe :: !Bord !Woord !Positie !Richting -> (!Bord,!Bool,[Char],Int,Woorden)
scorevoegtoe (h,v) w (x,y) Hor
|	isEmpty w			= ((h,v),True, [],0,[])
|	length w + x > 15	= ((h,v),False,[],0,[])
|	otherwise			= ((nh,nv),mogelijk,nieuwe,score,nieuwewoorden)
where
	(nh,mogelijk,scorenieuweletters,woordverdubbeling)
						= scorevoegtoeaanregels h w (x,y)
	(nv,vscore,nieuwewoorden)
						= scorevoegdwarstoeaanregels v (0,y) scorenieuweletters
	hscore				= woordverdubbeling*(sum [letterscore \\ (letter,pos,letterscore) <- scorenieuweletters] + scoreoudeletters)
	score
	|	not mogelijk	= 0
	|	otherwise		= hscore + vscore
	scoreoudeletters	= sum (map letterwaarde (removeMembers w nieuwe))
	nieuwe				= [letter \\ (letter,pos,letterscore) <- scorenieuweletters]
scorevoegtoe (h,v) w (x,y) Ver
|	isEmpty w			= ((h,v),True, [],0,[])
|	length w + y > 15	= ((h,v),False,[],0,[])
|	otherwise			= ((nh,nv),mogelijk,nieuwe,vscore+hscore,nieuwewoorden)
where
	(nv,mogelijk,scorenieuweletters,woordverdubbeling)
						= scorevoegtoeaanregels v w (y,x)
	(nh,hscore,nieuwewoorden)
						= scorevoegdwarstoeaanregels h (0,x) scorenieuweletters
	vscore				= woordverdubbeling*(sum [letterscore \\ (letter,pos,letterscore) <- scorenieuweletters] + scoreoudeletters)
	scoreoudeletters	= sum (map letterwaarde (removeMembers w nieuwe))
	nieuwe				= [letter \\ (letter,pos,letterscore) <- scorenieuweletters]

scorevoegtoeaanregels :: !Woorden Woord Positie -> (!Woorden,!Bool,[(Char,Int,Int)],Int)
scorevoegtoeaanregels rs w p=:(x,y) = scorevoegtoeaanregelsvanaf rs w p y

scorevoegtoeaanregelsvanaf :: !Woorden Woord Positie !Int -> (!Woorden,!Bool,![(Char,Int,Int)],Int)
scorevoegtoeaanregelsvanaf [] w p y
	= ([],False,[],0)
scorevoegtoeaanregelsvanaf [r:rs] w p=:(x,y) 0
	= ([nr:rs],mogelijk,scorenieuweletters,woordverdubbeling)
where
	(nr,mogelijk,scorenieuweletters,woordverdubbeling) = scorevoegtoeaanregel r w p x
scorevoegtoeaanregelsvanaf [r:rs] w p j
	= ([r:nrs],mogelijk,scorenieuweletters,woordverdubbeling)
where
	(nrs,mogelijk,scorenieuweletters,woordverdubbeling) = scorevoegtoeaanregelsvanaf rs w p (j-1)

scorevoegtoeaanregel :: !Woord !Woord Positie !Int -> (!Woord,!Bool,![(Char,Int,Int)],Int)
scorevoegtoeaanregel [l:ls] [w] p=:(x,y) 0
|	l==' ' && (ls==[] || hd ls==' ')	= ([w:ls],True, [lwrd],wwrd)
|	l==w   && (ls==[] || hd ls==' ')	= ([w:ls],True, [],1)
|	otherwise							= ([l:ls],False,[],1)
where
	lwrd = (w,x,letterwaardeop w p)
	wwrd = woordwaardeop p
scorevoegtoeaanregel [l:ls] [w:ws] p=:(x,y) 0
|	l==' '						= ([w:nr],mogelijk,[lwrd:lwrds],wwrd*wwrds)
|	l==w						= ([w:nr],mogelijk,lwrds,wwrds)
|	otherwise					= ([l:ls],False,[],1)
where
	(nr,mogelijk,lwrds,wwrds)	= scorevoegtoeaanregel ls ws (x+1,y) 0
	lwrd						= (w,x,letterwaardeop w p)
	wwrd						= woordwaardeop p
scorevoegtoeaanregel [l:ls] ws p 1
|	l==' '						= ([l:nr],mogelijk,lwrds,wwrds)
|	otherwise					= ([l:ls],False,[],1)
where
	(nr,mogelijk,lwrds,wwrds)	= scorevoegtoeaanregel ls ws p 0
scorevoegtoeaanregel [l:ls] ws p n
	= ([l:nr],mogelijk,lwrds,wwrds)
where
	(nr,mogelijk,lwrds,wwrds)	= scorevoegtoeaanregel ls ws p (n-1)

scorevoegdwarstoeaanregels :: !Woorden !Positie ![(Char,Int,Int)] -> (!Woorden,Int,!Woorden)
scorevoegdwarstoeaanregels rs _ []
				= (rs,0,[])
scorevoegdwarstoeaanregels [r:rs] p=:(x,y) [(nl,nx,ls)]
|	x==nx		= ([nr:rs],regelscore,nieuwewoord)
|	otherwise	= ([r:nrs],rscore,nw)
where
	(nr,regelscore,nieuwewoord)	= scorevoegmeteentoeaanregel r nl p y []
	(nrs,rscore,nw)				= scorevoegdwarstoeaanregels rs (x+1,y) [(nl,nx,ls)]
scorevoegdwarstoeaanregels [r:rs] p=:(x,y) [(nl,nx,ls):lwrds]
|	x==nx		= ([nr:nrs],regelscore+restregelsscore,nieuwewoord++nieuwewoorden)
|	otherwise	= ([r:nrs2],restregelsscore2,nieuwewoorden2)
where
	(nrs, restregelsscore, nieuwewoorden)	= scorevoegdwarstoeaanregels rs (x+1,y) lwrds
	(nrs2,restregelsscore2,nieuwewoorden2)	= scorevoegdwarstoeaanregels rs (x+1,y) [(nl,nx,ls):lwrds]
	(nr,regelscore,nieuwewoord)				= scorevoegmeteentoeaanregel r nl p y []
scorevoegdwarstoeaanregels [r:rs] (x,y) lwrds
	= ([r:restregels],score,nieuwewoorden)
where
	(restregels,score,nieuwewoorden) = scorevoegdwarstoeaanregels rs (x-1,y) lwrds

scorevoegmeteentoeaanregel :: !Woord !Char Positie !Int ![Char] -> (!Woord,Int,!Woorden)
scorevoegmeteentoeaanregel [l:ls] w p 0 initwoord
|	initwoordscore+restwoordscore<>0	= ([w:ls],(initwoordscore+lscore+restwoordscore)*wscore,[woord])
|	otherwise							= ([w:ls],0,[])
where
	lscore			= letterwaardeop w p
	wscore			= woordwaardeop p
	restwoord		= takeWhile ((<>) ' ') ls
	initwoordscore	= sum (map letterwaarde initwoord)
	restwoordscore	= sum (map letterwaarde restwoord)
	woord			= initwoord ++ [w] ++ restwoord
scorevoegmeteentoeaanregel [l:ls] w p ry initwoord
	= ([l:nls],score,nieuwewoord)
where
	(nls,score,nieuwewoord) = scorevoegmeteentoeaanregel ls w p (ry-1) ninitwoord
	ninitwoord
	|	l<>' '				= initwoord ++ [l]
	|	otherwise			= []


/***************************************************************** 
	De computer gaat zetten bepalen, die geldig zijn.
	De gevonden woorden beginnen allemaal met letter 'l' en
	de letter 'l' komt voor op het letterbalkje van de computer.

	Per woord uit de woordenlijst moeten dus steeds opnieuw
	alle mogelijke posities bepaald worden.
*******************************************************************/

voegmaximaaltoeopjuistepositie :: !Bord Boom [Char] !(!Int,!Int,!Int,!Int) !Vordering !Sterkte Bool -> Plaatsing
voegmaximaaltoeopjuistepositie	bord woordenlijst computerletters (minx,maxx,miny,maxy) vordering=:(Letter l plaatsing)
								sterkte eerstespeelbeurt
	= scoremax [plaatsing:nieuwgevondenplaatsingen1++nieuwgevondenplaatsingen2]
where
	beginnendmet
		= woorden_beginnend_met l woordenlijst
	nieuwgevondenplaatsingen1
		= [ (nw,p,r,/*eindscore*/ if (length gl==7) (s+50) s)
								\\	nws <- beginnendmet
								,	nw <- [[c \\ c<-:nws]]
//								|	removeMembers uniekecomputerletters nw<>uniekecomputerletters
								,	(eersteontbrekendeletter,plaats) <- [verschil nw uniekecomputerletters 0]
								,	r <- [Hor,Ver]
								,	p <- if (plaats<>7) (if	(r==Hor)
                                                            (zoekvrijehorposities bord eersteontbrekendeletter plaats)
                                                            (zoekvrijeverposities bord eersteontbrekendeletter plaats)
                                                        )
														(if (r==Hor)
                                                             [(i,j) \\ i <- [max 0 (minx-length nw) .. min (14-length nw) maxx]
																	,  j <- [max 0 (miny-1)         .. min 14 (maxy+1)]]
                                                             [(i,j) \\ i <- [max 0 (minx-1)         .. min 14 (maxx+1)]
																	,  j <- [max 0 (miny-length nw) .. min (14-length nw) maxy]]
                                                        )
								,	(_,m,gl,s,nws) <- [scorevoegtoe bord nw p r]
/*								|	m
								|	not (isEmpty gl)
								|	isEmpty (removeMembers gl computerletters)
								|	((not (isEmpty nws)) || length gl<>length nw || eerstespeelbeurt)
								|	bestaanallemaal woordenlijst nws
*/
								|	ok_oplossing m gl nws nw
		  ]
	ok_oplossing m gl nws nw
		= m																	&& 
		  (not (isEmpty gl))												&&
		  isEmpty (removeMembers gl computerletters)						&&
		  ((not (isEmpty nws)) || length gl<>length nw || eerstespeelbeurt)	&&
		  bestaanallemaal woordenlijst nws

	
	nieuwgevondenplaatsingen2
		= voegtoeopposities	bord woordenlijst computerletters (poshor,posver) vordering (inverteer sterkte) eerstespeelbeurt
	
	inverteer (Sterkte n)	= Sterkte (0-n)
	inverteer Maximaal		= Sterkte 0
	
	poshor					= geefvrijehorposities bord l
	posver					= geefvrijeverposities bord l
	
	uniekecomputerletters	= removeDup computerletters


/***************************************************************** 
	De computer gaat zetten bepalen, die geldig zijn.
	De gevonden woorden beginnen allemaal met letter 'l' en
	de letter 'l' komt NIET voor op het letterbalkje van de computer.

	De mogelijke posities op het bord voor woorden beginnend
	met de letter l, moeten dus vrijliggende l's zijn.
*******************************************************************/

voegmaximaaltoe :: !Bord Boom [Char] (Posities,Posities) !Vordering !Sterkte Bool -> Plaatsing
voegmaximaaltoe	bord woordenlijst computerletters poshv vordering=:(Letter l plaatsing) sterkte eerstespeelbeurt
	= scoremax [plaatsing:plaatsingen]
where
	plaatsingen	= voegtoeopposities	bord woordenlijst computerletters poshv vordering sterkte eerstespeelbeurt
voegmaximaaltoe	_ _ _ _ (Klaar klaar) _ _
	= klaar

voegtoeopposities :: !Bord Boom [Char] (Posities,Posities) !Vordering !Sterkte Bool -> [Plaatsing]
voegtoeopposities	bord woordenlijst computerletters (poshor,posver)
					(Letter l (oudwoord,oudepositie,ouderichting,oudescore))
					sterkte eerstespeelbeurt
	= [ (nw,p,r,/*eindscore*/ if (length gl==7) (s+50) s)
								\\	nws <- beginnendmet
								,	nw  <- [[c \\ c<-:nws]]
//								|	removeMembers uniekecomputerletters nw<>uniekecomputerletters
								|	woordbevatcomputerletter nw uniekecomputerletters
								,	r <- [Hor,Ver]
								,	p <- if (r==Hor) poshor posver
								,	(_,m,gl,s,nws) <- [scorevoegtoe bord nw p r]

/*								|	m
								|	not (isEmpty gl)
								|	isEmpty (removeMembers gl computerletters)
								|	(not (isEmpty nws) || length gl<>length nw || eerstespeelbeurt)
								|	bestaanallemaal woordenlijst nws
*/
								|	ok_oplossing m gl nws nw
	  ]
where
	ok_oplossing m gl nws nw
		= m																	&&
		  not (isEmpty gl)													&&
		  isEmpty (removeMembers gl computerletters)						&&
		  (not (isEmpty nws) || length gl<>length nw || eerstespeelbeurt)	&&
		  bestaanallemaal woordenlijst nws

	beginnendmet			= woorden_beginnend_met l woordenlijst
	uniekecomputerletters	= removeDup computerletters


woordbevatcomputerletter [] uniekecomputerletters
	= False
woordbevatcomputerletter [l:rw] uniekecomputerletters
	| is_member l uniekecomputerletters
		= True
		= woordbevatcomputerletter rw uniekecomputerletters

is_member x [hd:tl] 
	| hd==x		= True 
				= is_member x tl
is_member x []	= False

/***************************************************************** 
	Met scoremax kan van alle mogelijke plaatsingen
	de plaatsing geselecteerd worden, die de hoogste score heeft
*******************************************************************/

scoremax :: ![Plaatsing] -> Plaatsing
scoremax []			= initplaatsing
scoremax [p]		= p
scoremax [(woord1,positie1,richting1,score1):ps]
|	score1>score2	= (woord1,positie1,richting1,score1)
|	otherwise		= (woord2,positie2,richting2,score2)
where
	(woord2,positie2,richting2,score2) = scoremax ps

/*
woordenbeginnendmet :: !Char !Sterkte !Files -> (![Woord],!Files)
woordenbeginnendmet l Maximaal files
					= leeswoorden ("lexicon"+++toString l) files
woordenbeginnendmet l EersteBeste files
					= (take 1 woorden,files1)
where
	(woorden,files1)= leeswoorden ("lexicon"+++toString l) files
woordenbeginnendmet l (Sterkte n) files
|	n>=0			= (take n woorden,files1)
|	otherwise		= (drop n woorden,files1)
where
	(woorden,files1)= leeswoorden ("lexicon"+++toString l) files
*/

//	Peter: om files in te kunnen lezen moet je het filesysteem hebben (type Files).

 
leeswoorden :: !String !Files -> (![Woord],!Files)
leeswoorden filename files
|	not ok			= abort ("Could not open file: "+++filename)
|	otherwise		= (lines,files2)
					with
						(lines,f1)	= readlines f
						(_,files2)	= fclose f1 files1
						
						readlines :: *File -> ([Woord],*File)
						readlines f
						|	sfend f		= ([],f)
						|	lengte>1	= ([fromString (line%(0,lengte-2)):lines],f2)	// verwijder '\n'
						|	otherwise	= (lines,f2)
						where
							(line, f1)	= freadline f
							(lines,f2)	= readlines f1
					 		lengte		= size line
where
	(ok,f,files1)	= fopen filename FReadText files
 
/*
leeswoorden :: !String !Files -> (![Woord],!Files)
leeswoorden filename files = (woorden, files)
where
  alfabet = [ 'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z' ] 
  threeletterwords = [ [ a, b, c ] \\ a <- alfabet, b<- alfabet, c <-alfabet ]

  woorden = threeletterwords
*/




/***************************************************************** 
	Verschil bepaalt de letter en de positie van de letter
	in een woord waarvan de letter niet voorkomt op het 
	computerletterbalkje.

	Deze letter moet namelijk vrij liggen op het bord.
*******************************************************************/

verschil :: ![Char] ![Char] !Int -> (!Char,!Int)
verschil [l:ls] cl p
|	is_member l cl	= verschil ls cl (p+1)
|	otherwise		= (l,p)
verschil []		cl p
					= ('a',7)


::	Boom
	=	Blad !String
	|	Knoop Boom !String Boom

::	Woord	:== [Char]
::	Woorden	:== [Woord]


maakzoekboom :: !Woorden -> Boom
maakzoekboom []		= Blad ""
maakzoekboom [w]	= Blad (toString w)
maakzoekboom xs 	= Knoop	(maakzoekboom eerstehelft)
							(toString middelstewoord)
							(maakzoekboom tweedehelft)
where
	helft										= length xs/2
	(eerstehelft,[middelstewoord:tweedehelft])	= splitAt helft xs


woorden_beginnend_met :: !Char !Boom -> [String]
woorden_beginnend_met letter (Knoop l w r)
	| w.[0]>letter
		= woorden_beginnend_met letter l
	| w.[0]<letter
		= woorden_beginnend_met letter r
		= woorden_beginnend_met_links letter l [w:woorden_beginnend_met_rechts letter r]
woorden_beginnend_met letter (Blad b)
	| size b>0 && b.[0]==letter
		= [b]
		= []

woorden_beginnend_met_links letter (Knoop l w r) t
	| w.[0]==letter
		= woorden_beginnend_met_links letter l [w:woorden_in_boom r t]
		= woorden_beginnend_met_links letter r t
woorden_beginnend_met_links letter (Blad b) t
	| size b>0 && b.[0]==letter
		= [b:t]
		= t

woorden_beginnend_met_rechts letter (Knoop l w r)
	| w.[0]==letter
		= woorden_in_boom l [w:woorden_beginnend_met_rechts letter r]
		= woorden_beginnend_met_rechts letter l
woorden_beginnend_met_rechts letter b
	= woorden_beginnend_met letter b

woorden_in_boom (Knoop l w r) t
	= woorden_in_boom l [w:woorden_in_boom r t]
woorden_in_boom (Blad b) t
	| size b<>0
		= [b:t]
		= t

zoekboom :: !Files -> (!Boom,!Files)
zoekboom files
	= (maakzoekboom woorden,files1)
where
	(woorden,files1)	= woordenlijst files

woordenlijst :: !Files -> (![Woord],!Files)
woordenlijst files = leeswoorden "lexicon" files

bestaanallemaal :: Boom ![Woord] -> Bool
bestaanallemaal lijst woorden = and [zoek lijst w \\ w <- woorden]

voegtoeboom :: !Boom Woord -> Boom
voegtoeboom b w = voegtoeboom  b (toString w)
where
	voegtoeboom (Knoop l w r) x
	|	x<w			= Knoop (voegtoeboom l x) w r
	|	x>w			= Knoop l w (voegtoeboom r x)
	|	otherwise	= Knoop l w r
	voegtoeboom (Blad b) x
	|	x<b			= Knoop (Blad x)  b (Blad "")
	|	x>b			= Knoop (Blad "") b (Blad x)
	|	otherwise	= Blad b

voegmeerderetoe :: !Boom ![Woord] -> Boom
voegmeerderetoe b wrds = foldl voegtoeboom b wrds

zoek :: !Boom Woord -> Bool
zoek b w = zoek b (toString w)
where
	zoek :: !Boom String -> Bool
	zoek (Blad b) x			= b==x
	zoek (Knoop l w r) x	= (w==x) || (x<w && zoek l x) || (x>w && zoek r x)

grootte :: !Boom -> Int
grootte (Blad b)		= 1
grootte (Knoop l w r)	= grootte l+grootte r+1

diepte :: !Boom -> Int
diepte (Blad b)			= 1
diepte (Knoop l w r)	= max (diepte l+1) (diepte r+1)
