definition module deltaSystem

import StdString

UpKey     :== '\036'
DownKey   :== '\037'
LeftKey   :== '\034'
RightKey  :== '\035'
PgUpKey   :== '\013'
PgDownKey :== '\014'
BeginKey  :== '\001'
EndKey    :== '\004'
BackSpKey :== '\010'
DelKey    :== '\177'
TabKey    :== '\011'
ReturnKey :== '\015'
EnterKey  :== '\003'
EscapeKey :== '\033'
HelpKey   :== '\005'

ShiftOnly   :== (True,False,False,False)
OptionOnly  :== (False,True,False,False)
CommandOnly :== (False,False, True,True)
ControlOnly :== (False,False, True,True)

HomePath :: !String -> String
ApplicationPath :: !String -> String

DirSeparator :== '\\'

MaxScrollWindowSize :: (!Int,!Int)

MaxFixedWindowSize :: (!Int,!Int)

MMToHorPixels   :: !Real -> Int
MMToVerPixels   :: !Real -> Int
InchToHorPixels :: !Real -> Int
InchToVerPixels :: !Real -> Int
