implementation module Window1

import Events, clCrossCall, Window0, picture

Void :== 0

InitWindows :: !(IOSystem *s (IOState *s)) !(IOadmin *s) !OS -> ( IOadmin *s, OS)
InitWindows [ WindowSystem windowdefs : rest ] adm os = CreateWindows windowdefs adm os
InitWindows [ other                   : rest ] adm os = InitWindows rest adm os
InitWindows []							       adm os = ( adm, os )


CreateWindows :: ![ WindowDef *s (IOState *s) ] !(IOadmin *s) !OS -> ( IOadmin *s, OS)
CreateWindows [ FixedWindow id pos title domain updatef atts : rest ] admin os
	=  CreateWindows rest newadmin newos
where
	(newadmin, newos) = case FindWindowWithId id admin.io_windowState of
	                      Nope -> CreateFixedWindow id pos title domain updatef atts admin os
						  OK w -> (admin, os)
CreateWindows [ ScrollWindow id pos title hscroll vscroll domain minsize initsize updatef atts : rest ] admin os
	=  CreateWindows rest newadmin newos
where
	(newadmin, newos) = case FindWindowWithId id admin.io_windowState of
	                      Nope -> CreateScrollWindow id pos title hscroll vscroll domain minsize initsize updatef atts admin os
						  OK w -> (admin, os)
CreateWindows []  admin os
	= (admin, os)
 


CreateFixedWindow :: !Int !Point !String !PictureDomain !(UpdateFunction *s) ![ WindowAttribute *s (IOState *s) ]
					 !(IOadmin *s) !OS ->  ( (IOadmin *s), OS )
CreateFixedWindow id (px,py) title domain funct attrlist admin os
	| domainfits = ( newioadmin, newos ) 
	             = CreateScrollWindow id (px,py) title 
				                   (ScrollBar (Thumb 0) (Scroll FixedScrollValue))
								   (ScrollBar (Thumb 0) (Scroll FixedScrollValue))
								   domain (0,0) WinMaxScrollWindowSize
								   funct attrlist admin os
where 
	betterdomain        =  AdjustPictureDomain domain
	domainfits          =  CheckPictureDomainForFixedWindow betterdomain
	(textptr, os2)		=  WinMakeCString title os
	(width,height)      =  RectangleDimensions betterdomain
	createCci           =  (CcRqCREATEFIXEDWINDOW, textptr, px, py, width, height, 0 )
	(returncci, admin2, os4)
						=  IssueCleanRequest CreateFixedCallback  createCci admin os2
	newos				=  WinReleaseCString textptr os4
	(_, handle, _,_,_,_,_ )
					    =  returncci
	atts                =  GetWinAtts id attrlist
	newwinadmin			=  {  wkind       =  FixedK,
							  wid         =  id,
							  whandle     =  handle,
			           		  wtitle      =  title,
							  wminwidth   =  0,
							  wminheight  =  0,
					   		  wupdatef    =  funct,
				 	   		  wdomain     =  betterdomain,
							  wpicstate   =  InitialPictureState,
							  whscroll    =  0,
							  wvscroll    =  0,  
							  whthumb     =  0,
							  wvthumb     =  0,  
							  wactivate   =  atts.wa_activatefunct,
							  wdeactivate =  atts.wa_deactivatefunct,
							  wgoaway     =  atts.wa_goawayfunct,
							  wkeyboardf  =  atts.wa_keyfunct,
							  wkeybable   =  atts.wa_keyable,
							  wmousef     =  atts.wa_mousefunct,
							  wmouseable  =  atts.wa_mouseable,
							  wcursor     =  atts.wa_cursor
						   }
	newioadmin          =  { admin2 & io_windowState = [ newwinadmin : admin2.io_windowState ] }



CreateFixedCallback :: !CrossCallInfo !(IOadmin *s) !OS -> (Bool, CrossCallInfo, (IOadmin *s), OS)
CreateFixedCallback cci adm os 
    =  case cci of
			(CcWmCREATE, hwnd, _,_,_,_,_)
				->  (True, Return0Cci, adm, os)
			(CcWmPAINT, hwnd, _,_,_,_,_) 
  			    ->  (True, Return0Cci, adm, newos)
				    where newos  =  DelayUpdate hwnd os
			(CcWmGETMINMAXINFO, hwnd, _,_,_,_,_)
				->  (True, Return0Cci, adm, os)
            cci=:(CcWmACTIVATE, hwnd,_,_,_,_,_)
			    -> (True, Return0Cci, DelayMessage cci adm, os)
            cci=:(CcWmDEACTIVATE, _,_,_,_,_,_) 
			    -> (True, Return0Cci, DelayMessage cci adm, os)
			( othermess, _,_,_,_,_,_)
			    ->  (False, Return0Cci, adm, WinMessage ("CreateFixedCallback couldn't handle message " +++ toString othermess) os )



CreateScrollWindow :: !Int !Point !String !ScrollBarDef !ScrollBarDef !PictureDomain !(!Int,!Int) 
                      !(!Int,!Int) !(UpdateFunction *s) ![ WindowAttribute *s (IOState *s) ]
					  !(IOadmin *s) !OS ->  ( (IOadmin *s), OS )
CreateScrollWindow id (px,py) title hscrollbar vscrollbar domain minsize initsize funct attrlist admin os
	= ( newioadmin, newos ) 
where 
	(textptr, os2)		=  WinMakeCString title os
    betterdomain        =  AdjustPictureDomain domain
    (minw,minh)         =  AdjustMinimumWindowSize minsize betterdomain
	(width, height)     =  AdjustInitialScrollWindowSize initsize (minw,minh) betterdomain
	(ScrollBar (Thumb ht) (Scroll hv)) 
	                    = hscrollbar
	(ScrollBar (Thumb vt) (Scroll vv))
	                    = vscrollbar
	(hthumb, hscroll,
	 vthumb, vscroll)   =  AdjustScrollBars (ht, hv, vt, vv) (width, height) betterdomain 
	createCci           =  (CcRqCREATESCROLLWINDOW, textptr, px, py, width, height, 0 )
	scrolldata          =  (width,height, hthumb, vthumb)
	(returncci, admin2, os3)
						=  Iprint ("Creating scroll-window with id = " +++ toString id +++ ", and title = " +++ title)
						   IssueCleanRequest (CreateScrollCallback minw minh betterdomain scrolldata) createCci admin os2
	newos				=  WinReleaseCString textptr os3
	(_, handle, _,_,_,_,_ )
					    =  returncci
    atts                =  GetWinAtts id attrlist
	newwinadmin			=  {  wkind       =  ScrollK,
							  wid         =  id,
							  whandle     =  handle,
			           		  wtitle      =  title,
							  wminwidth   =  minw,
							  wminheight  =  minh,
					   		  wupdatef    =  funct,
				 	   		  wdomain     =  betterdomain,
							  wpicstate   =  InitialPictureState,
							  whscroll    =  hscroll,
							  wvscroll    =  vscroll,  
							  whthumb     =  hthumb,
							  wvthumb     =  vthumb,  
							  wactivate   =  atts.wa_activatefunct,
							  wdeactivate =  atts.wa_deactivatefunct,
							  wgoaway     =  atts.wa_goawayfunct,
							  wkeyboardf  =  atts.wa_keyfunct,
							  wkeybable   =  atts.wa_keyable,
							  wmousef     =  atts.wa_mousefunct,
							  wmouseable  =  atts.wa_mouseable,
							  wcursor     =  atts.wa_cursor
						   }
	newioadmin          =  { admin2 & io_windowState = [ newwinadmin : admin2.io_windowState ] }


CreateScrollCallback :: Int Int PictureDomain (Int,Int,Int,Int) !CrossCallInfo !(IOadmin *s) !OS -> (Bool, CrossCallInfo, (IOadmin *s), OS)
CreateScrollCallback minw minh domain sd cci adm os 
	=  case cci of
		(CcWmCREATE, hwnd, _,_,_,_,_)
			->  (True, Return0Cci, adm, newos)
			where  newos = WinSetScrollInfos hwnd domain sd os
		(CcWmGETMINMAXINFO, hwnd, _,_,_,_,_)
			->  (True, Return4Cci maxw maxh minw minh, adm, os)
			where (maxw,maxh) = GetWindowDimensions domain
		(CcWmPAINT, hwnd, _,_,_,_,_) 
			->  (True, Return0Cci, adm, newos)
		    where newos = DelayUpdate hwnd os
        cci=:(CcWmACTIVATE, hwnd,_,_,_,_,_)
		    -> (True, Return0Cci, DelayMessage cci adm, os)
        cci=:(CcWmDEACTIVATE, _,_,_,_,_,_) 
		    -> (True, Return0Cci, DelayMessage cci adm, os)
		( othermess, _,_,_,_,_,_)
			->  (False, Return0Cci, adm, WinMessage ("CreateScrollCallback couldn't handle message " +++ toString othermess) os )



OpenWindows :: ![ WindowDef *s (IOState *s) ] !(IOState *s) -> IOState *s
OpenWindows []             iostate = iostate
OpenWindows [ FixedWindow  id pos title domain updatef atts : rest ] iostate = newiostate
where
  (adm, os)       = UnpackIOState iostate
  (newadm, newos) = case FindWindowWithId id adm.io_windowState of
                        Nope -> CreateFixedWindow id pos title domain updatef atts adm os
						OK w -> ( adm, os ) 
  newiostate      = OpenWindows rest ( PackIOState newadm newos )
OpenWindows [ ScrollWindow  id pos title hscroll vscroll domain minsize initsize updatef atts : rest ] iostate = newiostate
where
  (adm, os)       = UnpackIOState iostate
  (newadm, newos) = case FindWindowWithId id adm.io_windowState of
                       Nope -> CreateScrollWindow id pos title hscroll vscroll domain minsize initsize updatef atts adm os
					   OK w -> ( adm, os ) 
  newiostate      = OpenWindows rest ( PackIOState newadm newos )




:: WindowAtts *s = { wa_activatefunct   :: WindowFunction s (IOState s),
                     wa_deactivatefunct :: WindowFunction s (IOState s),
					 wa_goawayfunct     :: WindowFunction s (IOState s),
					 wa_keyable         :: Bool,
					 wa_keyfunct        :: KeyboardFunction s (IOState s),
					 wa_mouseable       :: Bool,
					 wa_mousefunct      :: MouseFunction s (IOState s),
					 wa_cursor          :: CursorShape
				   }

EmptyWindowAtts :: !WindowId -> WindowAtts s
EmptyWindowAtts id = { wa_activatefunct   =  donothing,
                       wa_deactivatefunct =  donothing,
					   wa_goawayfunct     =  closeit id,
					   wa_keyable         =  True,
					   wa_keyfunct        =  keynothing,
					   wa_mouseable       =  True,
					   wa_mousefunct      =  mousenothing,
					   wa_cursor          =  StandardCursor
				     }
where
	donothing       s io  =  (s, io)
	closeit      id s io  =  (s, CloseWindows [id] io) 
	keynothing   k  s io  =  (s, io)
	mousenothing m  s io  =  (s, io)


GetWinAtts :: !WindowId ![ WindowAttribute *s (IOState *s) ]  -> ( WindowAtts *s )
GetWinAtts id [] = EmptyWindowAtts id
GetWinAtts id [att:rest] 
   =  case att of
        Activate actf       ->  {  restatts  & wa_activatefunct   =  actf    }
        Deactivate deactf   ->  {  restatts  & wa_deactivatefunct =  deactf  }
		GoAway goawayf      ->  {  restatts  & wa_goawayfunct     =  goawayf }
        Keyboard able keyf  ->  {  restatts  & wa_keyable         =  Enabled able, wa_keyfunct   =  keyf }
        Mouse able mousef   ->  {  restatts  & wa_mouseable       =  Enabled able, wa_mousefunct =  mousef }
        Cursor cursorshape  ->  {  restatts  & wa_cursor          =  cursorshape }
		StandByWindow       ->  restatts
where
  restatts = GetWinAtts id rest


CloseWindows :: ![ WindowId ] !(IOState s) -> IOState s
CloseWindows []          iostate = iostate
CloseWindows [id : rest] iostate = CloseWindows rest newiostate
where
  (adm,    os)    = UnpackIOState iostate
  (newadm, newos) = case FindWindowWithId id adm.io_windowState of
						Nope -> (adm, os)
						OK w -> DoDestroyWindow id w.whandle adm os
  newiostate      = PackIOState newadm newos


  DoDestroyWindow id hwnd admin os = (newadm, newos)
  where
     destroycci       =  (CcRqDESTROYWINDOW, hwnd, 0,0,0,0,0 )
	 (_, adm2, newos) =  Iprint ("Destroying window with id = " +++ toString id) IssueCleanRequest DelayCallback destroycci admin os
	 newadm           =  { adm & io_windowState = RemoveWindowWithId id adm2.io_windowState }
  
  RemoveWindowWithId id [] = []
  RemoveWindowWithId id [ win  : rest ] 
    | id == win.wid  =  rest
	                 =  [ win : RemoveWindowWithId id rest ]

CloseActiveWindow :: !(IOState s) -> IOState s
CloseActiveWindow iostate 
	| found  = CloseWindows [id] iostate2
	         = iostate2
where
  (found, id, iostate2) =  GetActiveWindow iostate



GetActiveWindow :: !(IOState s) -> (Bool, WindowId, IOState s)
GetActiveWindow iostate
  = case win of
      Nope  ->   ( False,    0, newiostate )                  
	  OK w  ->   ( True, w.wid, newiostate )
where
  (adm, os)   =  UnpackIOState iostate
  (win, os2)  =   FindForegroundWindow adm os
  newiostate  =  PackIOState adm os2   


ActivateWindow :: !WindowId !(IOState s) -> IOState s
ActivateWindow id iostate = newiostate
where
  (adm,os)    = UnpackIOState iostate
  (newadm, newos)
              = case FindWindowWithId id adm.io_windowState of
					Nope -> (adm, os)
					OK w -> WinSetForegroundWindow w.whandle adm os
  newiostate  = PackIOState newadm newos
					  

WinSetForegroundWindow :: !HWND !(IOadmin s) !OS -> (!IOadmin s, !OS)
WinSetForegroundWindow hwnd adm os = (newadm, newos)
where
  setcci            =  ( CcRqSETFOREGROUNDWINDOW, hwnd, 0,0,0,0,0 )
  (_,newadm,newos)  =  IssueCleanRequest DelayCallback setcci adm os



FindForegroundWindow :: !(IOadmin s) !OS -> ( Perhaps (WindowAdmin s), OS )
FindForegroundWindow adm os = ( perhapswin`, newos )
where
  (hwnd, newos)  =  WinGetForegroundWindow os
  perhapswin     =  if (hwnd == 0) Nope (FindWindowWithHandle hwnd adm.io_windowState)
  perhapswin`    =  case perhapswin of
                       Nope ->  Nope
					   OK w -> OK w

DrawInActiveWindow :: ![DrawFunction] !(IOState s) -> IOState s
DrawInActiveWindow drawfs iostate
  | found      =  DrawInWindow winid drawfs iostate2
  | otherwise  =  iostate2 
where
  (found, winid, iostate2) = GetActiveWindow iostate
  

ChangeActiveWindowTitle :: !WindowTitle !(IOState s) -> IOState s
ChangeActiveWindowTitle title iostate 
	| found  = ChangeWindowTitle id title iostate2
	         = iostate2
where
  (found, id, iostate2) = GetActiveWindow iostate

ChangeActiveWindowCursor :: !CursorShape !(IOState s) -> IOState s
ChangeActiveWindowCursor shape iostate 
	| found  = ChangeWindowCursor id shape iostate2
	         = iostate2
where
  (found, id, iostate2) = GetActiveWindow iostate

EnableActiveKeyboard :: !(IOState s) -> IOState s
EnableActiveKeyboard iostate 
	| found  = EnableKeyboard id iostate2
	         = iostate2
where
  (found, id, iostate2) = GetActiveWindow iostate


DisableActiveKeyboard :: !(IOState s) -> IOState s
DisableActiveKeyboard iostate 
	| found  = DisableKeyboard id iostate2
	         = iostate2
where
  (found, id, iostate2) = GetActiveWindow iostate

ChangeActiveKeyboardFunction :: !(KeyboardFunction s (IOState s)) !(IOState s) -> IOState s
ChangeActiveKeyboardFunction keyf iostate 
	| found  = ChangeKeyboardFunction id keyf iostate2
	         = iostate2
where
  (found, id, iostate2) = GetActiveWindow iostate



EnableActiveMouse :: !(IOState s) -> IOState s
EnableActiveMouse iostate 
	| found  = EnableMouse id iostate2
	         = iostate2
where
  (found, id, iostate2) = GetActiveWindow iostate


DisableActiveMouse :: !(IOState s) -> IOState s
DisableActiveMouse iostate 
	| found  = DisableMouse id iostate2
	         = iostate2
where
  (found, id, iostate2) = GetActiveWindow iostate

ChangeActiveMouseFunction :: !(MouseFunction s (IOState s)) !(IOState s) -> IOState s
ChangeActiveMouseFunction mousef iostate 
	| found  = ChangeMouseFunction id mousef iostate2
	         = iostate2
where
  (found, id, iostate2) = GetActiveWindow iostate

:: ScrollBarChange
   =  ChangeThumbs Int Int
   |  ChangeScrolls Int Int
   |  ChangeHThumb Int
   |  ChangeHScroll Int
   |  ChangeVThumb Int
   |  ChangeVScroll Int
   |  ChangeHBar Int Int
   |  ChangeVBar Int Int


ChangeActiveScrollBar :: !ScrollBarChange !*s !(IOState *s) -> (*s, IOState *s)
ChangeActiveScrollBar change s iostate 
	| found  = ChangeScrollBar id change s iostate2
	         = (s, iostate2)
where
  (found, id, iostate2) = GetActiveWindow iostate

   
ChangeScrollBar :: !WindowId !ScrollBarChange !*s !(IOState *s) -> (*s, IOState *s)
ChangeScrollBar id change s iostate = (news, PackIOState newadm newos)
where
  (adm,os) = UnpackIOState iostate
  (news, newadm, newos) 
	 = case FindWindowWithId id adm.io_windowState of
		 OK w=:{ wkind = ScrollK }   -> if doscroll (WinScrollWindow w.whandle dx dy ht vt s adm2 os2)
		                                            (s, adm2, os2)
		   where
		     newscrolls    =  NewScrollState change w.whthumb w.whscroll w.wvthumb w.wvscroll
			 (winsize,os2) =  WinGetClientSize w.whandle os
			 (ht,hv,vt,vv) =  AdjustScrollBars newscrolls winsize w.wdomain
			 newwin        =  { w & whthumb = ht, whscroll = hv, wvthumb = vt, wvscroll = vv }
			 newwinstate   =  ReplaceWindowAdmin newwin adm.io_windowState
			 adm2          =  { adm & io_windowState = newwinstate }
			 dx            =  w.whthumb - ht
			 dy            =  w.wvthumb - vt
			 doscroll      =  dx <> 0 || dy <> 0

	 	 _      -> (s, adm, os)


WinScrollWindow :: HWND Int Int Int Int *s (IOadmin *s) OS -> (*s, IOadmin *s, OS)
WinScrollWindow hwnd dx dy ht vt s adm os = (s`, adm`, os`)
where
  scrollcci           =  ( CcRqSCROLLWINDOW, hwnd, dx, dy, ht, vt, 0 )
  (_,(s`,adm`),os`)   =  IssueCleanRequest StdCallback scrollcci (s,adm) os


NewScrollState :: ScrollBarChange Int Int Int Int -> (Int,Int,Int,Int)
NewScrollState (ChangeThumbs nht nvt)  ht hv vt vv = (nht,  hv, nvt,  vv)
NewScrollState (ChangeScrolls nhv nvv) ht hv vt vv = ( ht, nhv,  vt, nvv)
NewScrollState (ChangeHThumb nht)      ht hv vt vv = (nht,  hv,  vt,  vv)
NewScrollState (ChangeHScroll nhv)     ht hv vt vv = ( ht, nhv,  vt,  vv)
NewScrollState (ChangeVThumb nvt)      ht hv vt vv = ( ht,  hv, nvt,  vv)
NewScrollState (ChangeVScroll nvv)     ht hv vt vv = ( ht,  hv,  vt, nvv)
NewScrollState (ChangeHBar nht nhv)    ht hv vt vv = (nht, nhv,  vt,  vv)
NewScrollState (ChangeVBar nvt nvv)    ht hv vt vv = ( ht,  hv, nvt, nvv)


AdjustScrollBars :: (Int, Int, Int, Int) (Int,Int) PictureDomain -> (Int,Int,Int,Int)
AdjustScrollBars (hthumb, hscroll, vthumb, vscroll)	 (wsizew, wsizeh) ((l,t),(r,b))
              =  (hthumb`, hscroll`, vthumb`, vscroll`)
where
  hthumb`  = hthumb  Between (l,r-wsizew) 
  hscroll` = hscroll Between (0, r-l) 
  vthumb`  = vthumb  Between (t,b-wsizeh) 
  vscroll` = vscroll Between (0, b-t) 


WindowGetPos :: !WindowId !(IOState s) -> (!(!Int,!Int), !IOState s)
WindowGetPos id iostate = (pos, PackIOState adm newos)
where
  (adm,os) = UnpackIOState iostate
  (pos, newos)
           = case FindWindowWithId id adm.io_windowState of
               Nope   -> ( (0,0), os )
			   OK win -> WinGetWindowPos win.whandle os


WindowGetFrame :: !WindowId !(IOState s) -> (!PictureDomain, !IOState s)
WindowGetFrame id iostate = (domain, PackIOState adm newos)
where
  (adm,os) = UnpackIOState iostate
  (domain, newos)
           = case FindWindowWithId id adm.io_windowState of
               Nope   -> ( ((0,0),(0,0)), os )
			   OK win -> GetWindowFrame win os


GetWindowFrame :: (WindowAdmin s) OS -> (PictureDomain, OS)
GetWindowFrame win os = ( ((l,t),(r,b)), os2)
where
  ((w,h),os2)  =  WinGetClientSize win.whandle os
  (l,t)        =  case win.wkind of
                     FixedK  -> fst win.wdomain
                     ScrollK -> ( win.whthumb, win.wvthumb)
  (r,b)        =  (l+w,t+h)



ActiveWindowGetFrame :: !(IOState s) -> (PictureDomain, IOState s)
ActiveWindowGetFrame iostate 
	| found  = WindowGetFrame id iostate2
	         = (((0,0),(0,0)), iostate2)
where
  (found, id, iostate2) = GetActiveWindow iostate


ChangeActiveUpdateFunction :: !(UpdateFunction s ) !(IOState s) -> IOState s
ChangeActiveUpdateFunction updatef iostate 
	| found  = ChangeUpdateFunction id updatef iostate2
	         = iostate2
where
  (found, id, iostate2) = GetActiveWindow iostate

ChangeUpdateFunction :: !WindowId !(UpdateFunction s) !(IOState s) -> IOState s
ChangeUpdateFunction id updatef iostate = PackIOState newadm os
where
  (adm, os ) = UnpackIOState iostate
  newadm     = case FindWindowWithId id adm.io_windowState of 
					Nope -> adm
					OK w -> { adm & io_windowState = ReplaceWindowAdmin { w & wupdatef = updatef } adm.io_windowState }




DrawInWindowFrame :: !WindowId !(UpdateFunction *s) !*s !(IOState *s) -> (*s, IOState *s)
DrawInWindowFrame  id updatef s iostate = (news, PackIOState newadm newos)
where
  (adm,os) = UnpackIOState iostate
  (news, newadm, newos)
           = case FindWindowWithId id adm.io_windowState of
				Nope  -> abort "can't find window" //(s, adm, os)
				OK win  -> (ns, nadm, nos)
				where
				  ((w,h), os2)  =  WinGetClientSize win.whandle os
				  os3           =  WinInvalidateWindow win.whandle os2
				  origin        =  case win.wkind of
								     FixedK  -> fst win.wdomain
									 ScrollK -> ( win.whthumb, win.wvthumb)
				  area          =  ((0,0),(w,h))
				  (newpic, ns,nos)
				                =  UpdateWindow area win.whandle origin win.wpicstate updatef s os3
				  newwin        =  { win & wpicstate = newpic }
				  newwinstate   =  ReplaceWindowAdmin newwin adm.io_windowState
	    		  nadm          =  { adm & io_windowState = newwinstate }

DrawInActiveWindowFrame :: !(UpdateFunction *s) !*s !(IOState *s) -> (*s, IOState *s)
DrawInActiveWindowFrame updatef s iostate
 	| found  = DrawInWindowFrame id updatef s iostate2
	         = (s, iostate2)
where
  (found, id, iostate2) = GetActiveWindow iostate


ChangePictureDomain :: WindowId PictureDomain !*s (IOState *s) -> (!*s,!IOState *s)
ChangePictureDomain id domain s iostate = (s, PackIOState newadm newos)
where
  (adm, os)  =  UnpackIOState iostate
  (newadm, newos) = case FindWindowWithId id adm.io_windowState of
                      Nope                        -> (adm, os)
					  OK win=:{ wkind = ScrollK } -> ChangeScrollWindowDomain win domain adm os
					  OK win=:{ wkind = FixedK  } -> ChangeFixedWindowDomain win domain adm os


ChangeActivePictureDomain :: PictureDomain !*s (IOState *s) -> (!*s,!IOState *s)
ChangeActivePictureDomain domain s iostate 
  | found  = ChangePictureDomain id domain s iostate2
           = (s, iostate2)
where
  (found, id, iostate2) = GetActiveWindow iostate
		    					   

ChangeFixedWindowDomain :: (WindowAdmin s) PictureDomain (IOadmin s) OS -> (IOadmin s, OS)
ChangeFixedWindowDomain win domain adm os 
	| domainfits = (adm`, os`)
                 = ChangeFixedToScroll win betterdomain adm os
where 
	betterdomain   =  AdjustPictureDomain domain
	domainfits     =  CheckPictureDomainForFixedWindow betterdomain
	(width,height) =  RectangleDimensions betterdomain
    resizecci      =  (CcRqRESIZEFIXED, win.whandle, width, height, 0,0,0)
    (_, adm2, os2) =  IssueCleanRequest DelayCallback resizecci adm os 
	(oldwidth,
	 oldheight)    =  RectangleDimensions win.wdomain
	(oldleft,
	 oldtop)       =  fst win.wdomain
	(newleft,
	 newtop)       =  fst betterdomain

	need_redraw    =  width > oldwidth || height > oldheight || newtop <> oldtop || newleft <> oldleft
	os`            =  case need_redraw of
					  False -> os2
					  true  -> WinInvalidateWindow win.whandle os2
	newwin         =  { win & wdomain = betterdomain }
	newwinstate    =  ReplaceWindowAdmin newwin adm.io_windowState
	adm`           =  { adm2 & io_windowState = newwinstate }


ChangeFixedToScroll :: (WindowAdmin s) PictureDomain (IOadmin s) OS -> (IOadmin s, OS)
ChangeFixedToScroll win domain adm os =  (adm`, os`)
where
  (picwidth, picheight)
              =  RectangleDimensions domain
  (picleft, pictop )
              =  fst domain
  (newhandle, width, height, os2)
			  =  CloseFixedOpenScroll win.whandle picwidth picheight os
  os3         =  WinSetScrollInfos newhandle domain (width, height, picleft, pictop) os2
  os`         =  WinInvalidateWindow newhandle os3
  (minw,minh) =  WinMinimumWinSize
  newwin	  =  {  win & wkind =  ScrollK,
				    whandle     =  newhandle,
				    wminwidth   =  minw,
				    wminheight  =  minh,
				    wdomain     =  domain,
	 			    whscroll    =  min FixedScrollValue picwidth,
				    wvscroll    =  min FixedScrollValue picheight,  
 				    whthumb     =  picleft,
				    wvthumb     =  pictop  
			     }
  newwinstate =  ReplaceWindowAdmin newwin adm.io_windowState
  adm`        =  { adm & io_windowState = newwinstate }


  
CloseFixedOpenScroll :: HWND Int Int OS -> (HWND, Int, Int, OS)
CloseFixedOpenScroll hwnd width height os= (hw, nw, nh, os`)
where
  fixscrollcci  = (CcRqFIXEDTOSCROLL, hwnd, width, height, 0,0,0)
  (cci, _, os`) = IssueCleanRequest IgnoreCallback fixscrollcci Void os
  (hw, nw, nh)  = case cci of
                    (CcRETURN3, hwnd, newwidth, newheight,_,_,_)
					       -> (hwnd, newwidth, newheight)
					other  -> abort "Expected RETURN3 for CcRqFixedScroll"



ChangeScrollWindowDomain :: (WindowAdmin s) PictureDomain (IOadmin s) OS -> (IOadmin s, OS)
ChangeScrollWindowDomain win domain adm os = (adm`, os`)
where
	betterdomain =  AdjustPictureDomain domain
	(newmin=:(nminw, nminh)) 
				 =  AdjustMinimumWindowSize (win.wminwidth, win.wminheight) betterdomain
	(size, os2)
				 =  WinGetScrollWinFrameSize win.whandle os
	newsize      =  AdjustInitialScrollWindowSize size newmin betterdomain
	scrolls      =  ( win.whthumb, win.whscroll, win.wvthumb, win.wvscroll)
	(newscrolls=:(nht,nhv,nvt,nvv)) 
				 =  AdjustScrollBars scrolls newsize betterdomain
	maxsize      =  RectangleDimensions betterdomain 
	((anw, anh), adm2,os3)
				 =  WinResizeScrollWindow win.whandle newsize maxsize adm os2
	need_redraw  =  True // nht <> win.whthumb || nvt <> win.wvthumb
	os4          =  case need_redraw of
					  False -> os3
					  true  -> WinInvalidateWindow win.whandle os3
	os`          =  WinSetScrollInfos win.whandle betterdomain (anw,anh,nht,nvt) os4
	newwin       =  { win & wdomain    = betterdomain,
							wminwidth  = nminw,
							wminheight = nminh,
							whthumb    = nht,
							whscroll   = nhv,
							wvthumb    = nvt,
							wvscroll   = nvv  }
	newwinstate  = ReplaceWindowAdmin newwin adm.io_windowState
	adm`         = { adm2 & io_windowState = newwinstate }



				  
WinResizeScrollWindow :: !HWND !(!Int, !Int) !(!Int,!Int) (IOadmin s) !OS -> ((Int,Int), IOadmin s, !OS)
WinResizeScrollWindow hwnd (w,h) (mw,mh) adm os = (adjustedsize, adm`, os`)
where
  resizecci           =  ( CcRqRESIZESCROLL, hwnd, w, h, mw, mh,0 )
  (retcci, adm`, os`) =  IssueCleanRequest DelayCallback resizecci adm os 
  adjustedsize        =  case retcci of
                            ( CcRETURN2, w, h, _,_,_,_) -> (w,h)
							other                       -> abort "expected a RETURN2 from RESIZESCROLL\n"



//---------------------------------

FixedScrollValue :== 10

NormalizeRect :: Rectangle ->Rectangle
NormalizeRect ((l,t), (r,b)) = ((l`,t`), (r`,b`))
where
  (l`,r`) = if (l<r)  (l,r)  (r,l)
  (t`,b`) = if (t<b)  (t,b)  (b,t)

MaxPictureDomain :== ((-32767,-32767),(32767,32767))

AdjustPictureDomain :: PictureDomain -> PictureDomain
AdjustPictureDomain domain = AdjustToMinMax (NormalizeRect domain)
where
	AdjustToMinMax ((l,t),(r,b)) = ((l`,t`),(r``,b``))
	where
	  ((ml,mt),(mr,mb)) = MaxPictureDomain
	  (mw,mh)           = WinMinimumWinSize
	  l`  =  max l ml
	  t`  =  max t mt
	  r`  =  min r mr
	  b`  =  min b mb
      r`` =  if (r`-l` >= mw) r` (l`+mw)
	  b`` =  if (b`-t` >= mh) b` (b`+mh)
	   

CheckPictureDomainForFixedWindow :: PictureDomain -> Bool
CheckPictureDomainForFixedWindow domain = ok
where
    ok           = pw <= maxw  && ph <= maxh
    (pw,ph)      = RectangleDimensions domain
	(maxw, maxh) = WinMaxFixedWindowSize



AdjustMinimumWindowSize :: (Int,Int) PictureDomain -> (Int,Int)
AdjustMinimumWindowSize (w,h) domain = newsize
where
  newsize = (w`,h`)
  (pw,ph) = RectangleDimensions domain
  (mw,mh) = WinMinimumWinSize
  w`      = w Between (mw, pw)
  h`      = h Between (mh, ph)


AdjustInitialScrollWindowSize :: (Int,Int) (Int,Int) PictureDomain -> (Int,Int)
AdjustInitialScrollWindowSize (iw,ih) (minw,minh) domain = newsize
where
  newsize     = (iw`, ih`)
  (pw,ph)     = RectangleDimensions domain 
  (maxw,maxh) = WinMaxScrollWindowSize
  iw`         = iw Between (minw, min maxw pw)
  ih`         = ih Between (minh, min maxh ph)





(Between) infixl 0 :: Int (Int,Int) -> Int
(Between) v (mn, mx) = max mn ( min v mx ) 