definition module Timer1

import ioTypes

InitTimers :: !(IOSystem *s (IOState *s)) !(IOadmin *s) !OS -> ( !IOadmin *s, !OS)

TicksPerSecond :== 18

:: CurrentTime :== ( !Int, !Int, !Int )
:: CurrentDate :== ( !Int, !Int, !Int, !Int )

EnableTimer  :: !TimerId !(IOState s) -> (IOState s)
DisableTimer :: !TimerId !(IOState s) -> (IOState s)


GetCurrentTime :: !(IOState s) -> (!CurrentTime, !IOState s)
GetCurrentDate :: !(IOState s) -> (!CurrentDate, !IOState s)

Wait  :: TimerInterval x -> x
UWait :: TimerInterval *x -> *x

OpenTimer :: !(TimerDef *s (IOState *s)) (IOState *s) -> IOState *s
CloseTimer :: !TimerId !(IOState *s) -> IOState *s

ChangeTimerFunction :: !TimerId !(TimerFunction *s (IOState *s)) !(IOState *s) -> IOState *s
SetTimerInterval :: !TimerId !TimerInterval !(IOState *s) -> IOState *s

GetTimerBlinkInterval :: !(IOState s) -> (!TimerInterval, !IOState s)
