definition module Dialog1

import ioTypes

InitDialogs:: !(IOSystem *s (IOState *s)) !(IOadmin *s) !OS -> ( !IOadmin *s, !OS)


:: DialogChange *s :== (DialogState s (IOState s)) -> DialogState s (IOState s)

OpenDialog :: !(DialogDef s (IOState s)) !(IOState s) -> IOState s
OpenModalDialog :: (DialogDef *s (IOState *s)) *s (IOState *s) -> (*s, IOState *s)


CloseActiveDialog :: (IOState s) -> IOState s
CloseDialog :: DialogId (IOState s) -> IOState s

OpenNotice` :: NoticeDef *s (IOState *s) -> (NoticeButtonId, *s, IOState *s)

Beep :: (IOState s) -> (IOState s)

EnableDialogItems :: [DialogItemId] (DialogState s (IOState s)) -> (DialogState s (IOState s))
DisableDialogItems :: [DialogItemId] (DialogState s (IOState s)) -> (DialogState s (IOState s))

MarkCheckBoxes :: [DialogItemId] (DialogState s (IOState s)) -> (DialogState s (IOState s))
UnmarkCheckBoxes :: [DialogItemId] (DialogState s (IOState s)) -> (DialogState s (IOState s))

SelectDialogRadioItem :: DialogItemId (DialogState s (IOState s)) -> (DialogState s (IOState s))

ChangeEditText :: DialogItemId String 
                  (DialogState s (IOState s)) -> DialogState s (IOState s)
ChangeDynamicText :: DialogItemId String
                  (DialogState s (IOState s)) -> DialogState s (IOState s)
ChangeIconLook :: DialogItemId IconLook 
                  (DialogState s (IOState s)) -> DialogState s (IOState s)

ChangeControlState :: DialogItemId ControlState 
                     (DialogState s (IOState s)) -> DialogState s (IOState s)
ChangeControlLook :: DialogItemId ControlLook 
                     (DialogState s (IOState s)) -> DialogState s (IOState s)
ChangeControlFeel :: DialogItemId ControlFeel 
                     (DialogState s (IOState s)) -> DialogState s (IOState s)

ChangeDialogFunction :: DialogItemId (DialogFunction s (IOState s))
                        (DialogState s (IOState s)) -> DialogState s (IOState s)
ChangeButtonFunction :: DialogItemId (ButtonFunction s (IOState s)) 
                        (DialogState s (IOState s)) -> DialogState s (IOState s)
ChangeSetFunction :: (SetFunction s (IOState s)) 
                     (DialogState s (IOState s)) -> (DialogState s (IOState s))
ChangeResetFunction :: (ResetFunction s (IOState s)) 
                     (DialogState s (IOState s)) -> (DialogState s (IOState s))


GetDialogInfo :: DialogId (IOState s) -> (Bool, DialogInfo, IOState s)
GetActiveDialogInfo :: (IOState s) -> (Bool, DialogInfo, IOState s)

DialogStateGetDialogInfo :: (DialogState s (IOState s)) -> (DialogInfo, DialogState s (IOState s))

GetEditText :: DialogItemId DialogInfo -> String
GetSelectedRadioItemId :: DialogItemId DialogInfo -> DialogItemId
CheckBoxesMarked :: DialogItemId DialogInfo -> [ (DialogItemId, Bool) ]
CheckBoxMarked :: DialogItemId DialogInfo -> Bool
GetControlState :: DialogItemId DialogInfo -> ControlState

ChangeDialog :: DialogId [ DialogChange s ] (IOState s) -> (IOState s)
