module	scrabble


import	StdInt, StdBool, StdString, StdReal, StdChar, StdList, StdFunc, StdEnum, StdFile,StdTuple
import	deltaEventIO, deltaDialog, deltaTimer, scrollList, deltaWindow, deltaMenu, deltaFileSelect, deltaIOState
import	Bord, Grafiek
import  StdFile

from intrface import Rand, MaxRand

::	*Toestand
	=	{	spelmode		:: Spelmode				//	De spelmode
		,	bord			:: Bord					//	Het speelbord, met daarop de geplaatste letters
		,	soort1			:: Spelersoort			//	Voor beide mogelijke spelers de spelersoort
		,	soort2			:: Spelersoort			//		(indien de computer tegen zichzelf speelt staat hier 2 * computer)
		,	laatstewoord	:: Woord				//	Laatst ingevoerde woord door een menselijke speler
		,	richting		:: Richting				//	De richting die gekozen is voor plaatsing van dit woord
		,	letters1		:: [Char]				//	Letters van speler1
		,	letters2		:: [Char]				//	Letters van speler2
		,	score1			:: Int					//	Score speler1
		,	score2			:: Int					//	Score speler2 
		,	letterbak		:: [Char]				//	De (rest)letterbak, hieruit worden steeds nieuwe letters gehaald
		,	woordenboek		:: Boom					//	De woordenlijst van geldige woorden
		,	afmetingen		:: (Int,Int,Int,Int)	//	Afmetingen van het kleinste rechthoek om de reeds gelegde letters heen
		,	speler			:: Speler				//	De speler die aan zet is (Speler1 of Speler2)
		,	sterkte			:: Sterkte				//	De sterkte van eventuele computerspelers
		,	vordering		:: Vordering			//	De vordering van een eventuele computerspeler
		
		,	files			:: Files				//	Nieuw: het file systeem
		,	random			:: [Int]				//	Nieuw: een oneindige random Integer lijst
		}
 

/***************************************************************** 
	initialisatiefuncties:
*******************************************************************/
initvordering :: Vordering
initvordering = Letter 'a' initplaatsing


/***************************************************************** 
	initafmetingen is zo gekozen dat een eerste zet die door de 
	computer wordt uitgerekend altijd positie (7,7) bezet.
	Dit is de positie van de 'ster', het midden van het bord.
*******************************************************************/
initafmetingen :: (Int,Int,Int,Int)
initafmetingen = (8,6,8,6)


/***************************************************************** 
	In de inittoestand wordt een beginspeler meteen vastgelegd.
	Eigenlijk moet dit door de gebruiker bepaald worden.
*******************************************************************/
inittoestand :: Files -> Toestand
inittoestand fs
	=	{	spelmode		= EindeSpeler2
		,	bord			= initbord
		,	soort1			= Persoon
		,	soort2			= Computer
		,	laatstewoord	= []
		,	richting		= Hor
		,	letters1		= []
		,	letters2		= []
		,	score1			= 0
		,	score2			= 0
		,	letterbak		= letterbak
		,	woordenboek		= woordenlijst
		,	afmetingen		= initafmetingen
		,	speler			= Speler2
		,	sterkte			= Maximaal
		,	vordering		= initvordering
		
		,	files			= fs1
		,	random			= []
		}
where
	(woordenlijst,fs1)		= zoekboom fs


/***************************************************************** 
	Bij het opnieuw opstarten van een spel moet de woordenlijst
	niet opnieuw ingelezen worden, want dat duurt te lang.
	Vandaar de functie 'initialiseertoestand'.
*******************************************************************/
initialiseertoestand :: Toestand (IOState Toestand) -> (Toestand,IOState Toestand)
initialiseertoestand t=:{random} io
	= (	{t	& spelmode				= EindeSpeler2
			, speler				= Speler2
			, bord					= initbord
			, letters1				= bakje1
			, letters2				= bakje2
			, score1				= 0
			, score2				= 0
			, letterbak				= restbak
			, afmetingen			= initafmetingen
			
			, random				= rs2
		}
	  ,	io1
	  )
where
	rs								= if (isEmpty random) (random_list (1+((3600*hours+60*minutes+seconds) bitand 65535))) random
	(restbak1,bakje1,rs1)			= graai letterbak 7 rs
	(restbak, bakje2,rs2)			= graai restbak1  7 rs1
	
	((hours,minutes,seconds),io1)	= GetCurrentTime io
	
	random_list seed
		= let!
			next_seed	= if (next_seed0>=0) next_seed0 (next_seed0+65537)
		  in
			[seed : random_list next_seed]
		where
			next_seed0	= (seed75 bitand 65535)-(seed75>>16)
			seed75		= seed*75


/***************************************************************** 
	In 'main' wordt eerst het scherm getekend, en
	vervolgens de woordenlijst ingelezen.
*******************************************************************/


Start :: *World -> *World
Start world
	= world4
where
	(es,world1)			= OpenEvents world
	(fs,world2)			= openfiles  world1
	t0					= inittoestand fs
	(soort1,soort2,sterkte,t1)
						= (\t=:{soort1,soort2,sterkte}->(soort1,soort2,sterkte,t)) t0
	(tn,es1)			= StartIO [	MenuSystem
										[	filemenu
										,	sterktemenu sterkte
										,	spelersmenu (soort1,soort2)
										]
								  ,	TimerSystem 
								  		[	Timer computerId Unable 0 computer
								  		]
								  ] t1 [initialiseertoestand,scrabblepanel,arbitreer] es
	world3				= CloseEvents es1 world2
	world4				= closefiles tn.files world3


/*
Start w = finalw
where
  (fs, w1)    = openfiles w
  (_, f, fs1) = fopen  "Lexicon" FReadText	fs 
  (_,fs2)     = fclose f fs1
  finalw      = closefiles fs2 w1
*/

/***************************************************************** 
	Er moet een woord gelegd worden (klikken van button 'leg woord').
*******************************************************************/
legwoord :: DialogInfo Toestand (IOState Toestand) -> (Toestand,IOState Toestand)
legwoord info t=:{	bord
				 ,	spelmode
				 ,	afmetingen=(minx,maxx,miny,maxy)
				 ,	speler
				 ,	soort1,	letters1, score1
				 ,	soort2,	letters2, score2
				 ,	letterbak
				 ,	woordenboek
				 ,	random
				 }	io
|	isEmpty laatstewoord
	= arbitreer nt (tekenbalk (tekenmelding (meldingbreedte,meldinghoogte) melding io))
	with
		nt					= {t2 & random=rs1,letterbak=restletterbak}
		t2
		|	speler==Speler1	= {t1 & spelmode=EindeSpeler1,letters1=nieuweletterbalk}
		|	otherwise		= {t1 & spelmode=EindeSpeler2,letters2=nieuweletterbalk}
		tekenbalk
		|	speler==Speler1	= tekenspeler1letterbalkje nieuweletterbalk
		|	otherwise		= tekenspeler2letterbalkje nieuweletterbalk
		
		melding				= [toString speler+++" ruilt letters in."]
		spelerletters
		|	speler==Speler1	= letters1
		|	otherwise		= letters2
		(restletterbak,nieuweletterbalk,rs1)
							= graai (spelerletters++letterbak) 7 random

|	not (zoek woordenboek laatstewoord)
	= OpenModalDialog (toevoegpanel [laatstewoord:foutievewoorden]) t1 (tekenmelding (meldingbreedte,meldinghoogte) melding io)
	with
		melding	= ["'"+++toString laatstewoord+++"'"+++" staat niet in woordenboek!"]

|	buitenspeelveld
	= (t1,tekenmelding (meldingbreedte,meldinghoogte) melding io)
	with
		melding	= [	"Door het woord:"
				  ,	"'"+++toString laatstewoord+++"'"
				  ,	" op ("+++toString (inc i)+++","+++toString (inc j)+++" te plaatsen"
				  ,	" overlapt/grenst het nergens aan de liggende letters!"
				  ]

|	not (isEmpty ontbrekendeletters)
	= (t1,tekenmelding (meldingbreedte,meldinghoogte) melding io)
	with
		melding	= [	"je kunt het woord niet vormen want je mist de letter(s): "
				  ,	"   "+++(foldr (+++) "" (map toString ontbrekendeletters))
				  ]

|	not mogelijk
	= (t1,tekenmelding (meldingbreedte,meldinghoogte) melding io)
	with
		melding	= ["woord kan daar niet geplaatst worden!"]

|	not (isEmpty foutievewoorden)
	= OpenModalDialog (toevoegpanel foutievewoorden) t1 (tekenmelding (meldingbreedte,meldinghoogte) melding io)
	with
		melding	= ["deze woorden bestaan niet: "]

|	otherwise
	= arbitreer nt (teken			(
					hertekenbord nb	(
					tekenmelding (meldingbreedte,meldinghoogte) melding io)))
	with
		nt
		|	speler==Speler1		= {nt1 & letters1=nieuweletterbalk,score1=totalescore,spelmode=EindeSpeler1}
		|	otherwise			= {nt1 & letters2=nieuweletterbalk,score2=totalescore,spelmode=EindeSpeler2}
    	nt1 					= {t1  & letterbak	= restletterbak
									   , afmetingen	= nieuweafmetingen
									   , bord		= nb
									   , random		= rs1
								  }
		teken
		|	speler==Speler1		= tekenspeler1score totalescore o tekenspeler1letterbalkje nieuweletterbalk
		|	otherwise			= tekenspeler2score totalescore o tekenspeler2letterbalkje nieuweletterbalk
		
		nieuweletterbalk		= resterendeletters++aanvullendeletters
		(restletterbak,aanvullendeletters,rs1)
								= graai letterbak (7-length resterendeletters) random
		
		melding					= [	toString (inc (length nieuwewoorden))+++" nieuwe woorden geplaatst."
								  ,	"afmetingen (minx,maxx,miny,maxy):"
								  ,	toString nieuweafmetingen
								  ]
where
	(x,y)				= (\(PairCS (IntCS x) (IntCS y))->(x,y)) (GetControlState 100 info)
	richting			= if (GetSelectedRadioItemId 1 info==201) Hor Ver
    lws                 = GetEditText 200 info
	laatstewoord		= fromString lws
	t1					= {t & laatstewoord=laatstewoord,richting=richting}
	
	(spelerletters,spelerscore)
						= spelergegevens
	spelergegevens
	|	speler==Speler1	= (letters1,score1)
	|	otherwise		= (letters2,score2)
	nieuweafmetingen
	|	richting==Hor	= (min i minx, max (i+woordlengte-1) maxx, min j miny, max j maxy)
	|	otherwise		= (min i minx, max i maxx, min j miny, max (j+woordlengte-1) maxy)
	
	buitenspeelveld		= (richting==Hor && ((i+woordlengte<minx)||(i>maxx+1)||(j<miny-1)||(j>maxy+1)))
							||
						  (richting==Ver && ((i<minx-1)||(i>maxx+1)||(j+woordlengte<miny-1)||(j>maxy+1)))
							||
						  (isEmpty nieuwewoorden && length gebruikteletters==woordlengte && not eerstespeelbeurt)
	
	foutievewoorden		= filter (not o (zoek woordenboek)) nieuwewoorden
	
	woordlengte			= length laatstewoord
	eerstespeelbeurt	= score1+score2==0
	
	totalescore			= if (length gebruikteletters==7) (spelerscore+score+50) (spelerscore+score)
	ontbrekendeletters	= removeMembers gebruikteletters spelerletters
	resterendeletters	= removeMembers spelerletters gebruikteletters
	(nb,mogelijk,gebruikteletters,score,nieuwewoorden)
						= scorevoegtoe bord laatstewoord (i,j) richting
	(i,j)				= abs2rel (x,y)


/***************************************************************** 
	arbitreer bepaalt wie aan zet is.
*******************************************************************/


arbitreer :: Toestand (IOState Toestand) -> (Toestand,IOState Toestand)
arbitreer t=:{spelmode,speler,soort1,letters1,score1,soort2,letters2,score2} io
/*
|	spelmode==Einde
	= beslis t (OpenNotice (Notice [uitslag] (NoticeButton doorgaan "Nieuw spel") [NoticeButton stoppen "Stoppen"]) io)
	with
		uitslag		= if (score1>score2) "Speler 1 heeft gewonnen."
					( if (score2>score1) "Speler 2 heeft gewonnen."
										 "Gelijk spel."
					)
		doorgaan	= 1
		stoppen		= 2
		beslis t (keuze,io)
		|	keuze==doorgaan	= nieuw t io
		|	otherwise		= quit  t io
*/
|	(speler==Speler1 && spelmode==EindeSpeler1 && soort2==Computer) ||
	(speler==Speler2 && spelmode==EindeSpeler2 && soort1==Computer)
	= (	nt
	  ,	EnableTimer  computerId (
	  	ChangeDialog scrabbleId [DisableDialogItems [3]] io1)
	  )
	with
		(bordletters,t1)= (\t=:{bord}->(geefgeplaatsteletters bord,t)) t
		spelerletters	= if (nieuwespeler==Speler1) letters1 letters2
		beginvordering	= Letter eersteletter initplaatsing
		eersteletter	= hd (	sort (removeMembers (removeDup (spelerletters++bordletters)) [' '])
							 ++	['@']
							 )
		nt				= {t1 &	vordering	= beginvordering
							  ,	speler		= nieuwespeler
							  ,	spelmode	= Spelend
						  }

|	spelmode==EindeSpeler1 || spelmode==EindeSpeler2
	= (	nt
	  ,	DisableTimer computerId (
	  	ChangeDialog scrabbleId [EnableDialogItems [3]] io1)
	  )
	with
		nt				= {t & speler=nieuwespeler,spelmode=Spelend}

|	otherwise
	= (t,io)
where
	nieuwespeler		= anderespeler speler
	io1					= tekenmelding (meldingbreedte,meldinghoogte) [toString nieuwespeler+++" is aan zet."] io


/***************************************************************** 
	De computer (een timer) bepaalt een zet.
*******************************************************************/
computer :: TimerState Toestand (IOState Toestand) -> (Toestand, IOState Toestand)
computer _ t=:{	bord
			  ,	afmetingen
			  ,	speler
			  ,	score1,letters1
			  ,	score2,letters2
			  ,	sterkte
			  ,	spelmode
			  ,	woordenboek
			  ,	letterbak
			  ,	vordering
			  ,	random
			  }	io
|	nognietklaar vordering
	= (nt, tekenvordering (meldingbreedte,meldinghoogte) speler vordering plaatsing nieuweplaatsing io)
	with
		nt						= {t2 & vordering=nieuwevordering}
		(nieuweplaatsing,t2)	= bepaalnieuweplaatsing t1

		bepaalnieuweplaatsing :: Toestand -> (Plaatsing,Toestand)
		bepaalnieuweplaatsing t=:{	bord
								 ,	afmetingen
								 ,	speler
								 ,	score1, letters1
								 ,	score2, letters2
								 ,	sterkte
								 ,	woordenboek
								 ,	vordering
								 }
		|	isMember (geefletter vordering) spelerletters
			= (voegmaximaaltoeopjuistepositie bord woordenboek spelerletters afmetingen vordering sterkte eerstespeelbeurt,t)
		|	otherwise
			= (voegmaximaaltoe bord woordenboek spelerletters (horpos,verpos) vordering sterkte eerstespeelbeurt,t)
		where
			spelerletters
			|	speler==Speler1	= letters1
			|	otherwise		= letters2
			horpos				= geefvrijehorposities bord (geefletter vordering)
			verpos				= geefvrijeverposities bord (geefletter vordering)
			eerstespeelbeurt	= score1+score2==0
		
		nieuwevordering
		|	laatstbekekenletter<>'z' && nieuweletter<>'@'
								= Letter nieuweletter nieuweplaatsing
		|	otherwise			= Klaar nieuweplaatsing
		where
			laatstbekekenletter	= geefletter vordering
			nieuweletter		= hd (	(dropWhile	(\l->(l<=laatstbekekenletter))
													(sort (removeMembers (removeDup (spelerletters++bordletters)) [' '])))
										++ ['@']
									 )

|	woordlengte>0
	= arbitreer ntklaar	(UWait TicksPerSecond (teken				(
						 hertekenbord nb	(
						 tekenmelding (meldingbreedte,meldinghoogte) melding io))))
	with
		teken
		|	speler==Speler1	= tekenspeler1score totalescore o tekenspeler1letterbalkje nieuweletterbalk
		|	otherwise		= tekenspeler2score totalescore o tekenspeler2letterbalkje nieuweletterbalk
		aantalnieuwe		= length nieuwewoorden
		melding
		|	aantalnieuwe==0	= [ "1 nieuw woord geplaatst." ]
		|	otherwise		= [ toString (inc aantalnieuwe)+++" nieuwe woorden geplaatst." ]

|	otherwise
	= arbitreer	ntklaar (tekenbalk (tekenmelding (meldingbreedte,meldinghoogte) melding io))
	with
		tekenbalk
		|	speler==Speler1	= tekenspeler1letterbalkje nieuweletterbalk
		|	otherwise		= tekenspeler2letterbalkje nieuweletterbalk
		melding				= ["computer heeft geen woord gevonden en","ruilt dus al z'n letters in"]

where
	ntklaar
	|	speler==Speler1			= {nt1 & letters1=nieuweletterbalk,score1=totalescore,spelmode=EindeSpeler1}
	|	otherwise				= {nt1 & letters2=nieuweletterbalk,score2=totalescore,spelmode=EindeSpeler2}
	nt1							= {t1 & bord		= nb
									  ,	letterbak	= restletterbak
									  , afmetingen	= nieuweafmetingen
									  ,	random		= rs1
								  }
	(bordletters,t1)			= (\t=:{bord}->(geefgeplaatsteletters bord,t)) t
	
	plaatsing					= geefplaatsing	vordering
	(w,(i,j),r,_)				= plaatsing
	
	geenwoordgevonden			= woordlengte==0
	
	(minx,maxx,miny,maxy)		= afmetingen
	nieuweafmetingen
	|	geenwoordgevonden		= afmetingen
	|	r==Hor					= (min i minx, max (i+woordlengte-1) maxx, min j miny, max j maxy)
	|	otherwise				= (min i minx, max i maxx, min j miny, max (j+woordlengte-1) maxy)
	
	woordlengte					= length w
	
	nieuweletterbalk
	|	geenwoordgevonden		= aanvullendeletters
	|	otherwise				= resterendeletters++aanvullendeletters
	
	(restletterbak,aanvullendeletters,rs1)
								= graailetters
	graailetters
	|	geenwoordgevonden		= graai (spelerletters++letterbak) 7 random
	|	otherwise				= graai letterbak (7-length resterendeletters) random
	
	(spelerletters,spelerscore)	= spelergegevens
	spelergegevens
	|	speler==Speler1			= (letters1,score1)
	|	otherwise				= (letters2,score2)
	totalescore					= spelerscore+score
	resterendeletters			= removeMembers spelerletters gebruikteletters
	
	(nb,_,gebruikteletters,score,nieuwewoorden)
								= scorevoegtoe bord w (i,j) r



/***************************************************************** 
	De definitie van de dialogen:
*******************************************************************/

filemenu
	= PullDownMenu 1 "File" Able 
		[	MenuItem 310 "Nieuw"	(Key 'n') Able nieuw
//		,	MenuItem 311 "Pauze"	(Key 'p') Able pauze
//		,	MenuItem 312 "Herstart"	(Key 'h') Able herstart
		,	MenuItem 2   "Quit"		(Key 'q') Able quit
		]
/*
where
	pauze :: Toestand (IOState Toestand) -> (Toestand, IOState Toestand)
	pauze t io
        = ({t & spelmode=Pauze},tekenmelding (meldingbreedte,meldinghoogte) ["","","","       PAUZE"] io)
	
	herstart :: Toestand (IOState Toestand) -> (Toestand, IOState Toestand)
	herstart t=:{speler,soort1,soort2} io
		= ({t & spelmode=Spelend},tekenmelding (meldingbreedte,meldinghoogte) [melding] io)
	where
		melding
		|	speler==Speler1 && soort1==Computer	= "Speler1 (computer) is aan zet."
		|	speler==Speler2 && soort2==Computer	= "Speler2 (computer) is aan zet."
		|	speler==Speler1						= "Speler1 is aan zet."
		|	otherwise							= "Speler2 is aan zet."
*/

nieuw :: Toestand (IOState Toestand) -> (Toestand,IOState Toestand)
nieuw t io
	= (t3,io3)
where
	io0			= CloseDialog scrabbleId io
	(t1,io1)	= initialiseertoestand t io0
	(t2,io2)	= scrabblepanel t1 io1
	(t3,io3)	= arbitreer t2 io2

quit :: Toestand (IOState Toestand) -> (Toestand,IOState Toestand)
quit t io = (t,QuitIO io)


sterktemenu sterkte
	= PullDownMenu 2 "Speelsterkte" Able
		[	MenuRadioItems initsterkte
		[	MenuRadioItem 320 "Maximaal"			NoKey Able (zetsterkte Maximaal)
		,	MenuRadioItem 321 "Eerste Beste"		NoKey Able (zetsterkte EersteBeste)
		,	MenuRadioItem 322 "Gemiddeld"			NoKey Able (zetsterkte (Sterkte 1000))
		,	MenuRadioItem 323 "Makkelijk"			NoKey Able (zetsterkte (Sterkte 500))
		,	MenuRadioItem 324 "Heel Makkelijk"		NoKey Able (zetsterkte (Sterkte 100))
		]]
where
	initsterkte
	|	sterkte==Maximaal		= 320
	|	sterkte==EersteBeste	= 321
	|	sterkte==Sterkte 1000	= 322
	|	sterkte==Sterkte 500	= 323
	|	otherwise				= 324
	
	zetsterkte :: Sterkte Toestand (IOState Toestand) -> (Toestand,IOState Toestand)
	zetsterkte nst t io = ({t & sterkte=nst},io)


spelersmenu (soort1,soort2)
	= PullDownMenu 3 "Spelers" Able
		[	MenuRadioItems initmarkering
		[	MenuRadioItem 330 "computer/persoon"	NoKey Able (zetspelersoorten (Computer,Persoon ))
		,	MenuRadioItem 331 "computer/computer"	(Key 'C') Able (zetspelersoorten (Computer,Computer))
		,	MenuRadioItem 332 "persoon/persoon"		(Key 'P') Able (zetspelersoorten (Persoon ,Persoon ))
		,	MenuRadioItem 333 "persoon/computer"	NoKey Able (zetspelersoorten (Persoon ,Computer))
		]]
where
	initmarkering
	|	soort1==Persoon && soort2==Computer	= 330
	|	soort1==Computer&& soort2==Computer	= 331
	|	soort1==Persoon && soort2==Persoon	= 332
	|	otherwise							= 333
	
	zetspelersoorten :: (Spelersoort,Spelersoort) Toestand (IOState Toestand) -> (Toestand,IOState Toestand)
	zetspelersoorten (s1,s2) t io = ({t & soort1=s1,soort2=s2},io)


scrabblepanel :: Toestand (IOState Toestand) -> (Toestand,IOState Toestand)
scrabblepanel t=:{woordenboek,soort1,letters1,soort2,letters2,speler} io
	= (t,OpenDialog panel io)
where
	panel = CommandDialog scrabbleId "Scrabble" [DialogMargin (Pixel 25) (Pixel 25)] 3
				[	Control		 100 (XY (Pixel 0) (Pixel 0)) ((0,0),(bordbreedte,bordhoogte)) Unable
									 (cs_tuple (-1) (-1)) (tekenbord initbord (bordbreedte,bordhoogte)) bordfeel k`
				,	StaticText	 101 (XOffset 100 (Pixel 10)) "speler1:"
				,	Control		 102 (YOffset 101 (Pixel 0)) ((0,0),grootte_balk) Unable
									 (StringCS (toString letters1)) (tekenspelerletterbalkje grootte_balk) nofeel k`
				,	StaticText	 105 (XOffset 101 (Pixel 140)) "score:"
				,	DynamicText	 106 (YOffset 105 (Pixel 0)) (Pixel 40) "0"
				,	StaticText	 103 (YOffset 102 (Pixel 10)) "speler2:"
				,	Control		 104 (YOffset 103 (Pixel 0)) ((0,0),grootte_balk) Unable
									 (StringCS (toString letters2)) (tekenspelerletterbalkje grootte_balk) nofeel k`
				,	StaticText	 107 (XOffset 103 (Pixel 140)) "score:"
				,	DynamicText	 108 (YOffset 107 (Pixel 0)) (Pixel 40) "0"
				,	Control		 110 (YOffset 104 (Pixel 20)) ((-2,-2),(meldingbreedte+2,meldinghoogte+2)) Unable
									 (ListCS melding) (meldinglook (meldingbreedte,meldinghoogte)) nofeel k`
				,	StaticText	 109 (YOffset 110 (Pixel 20))  "speler woord:"
				,	EditText	 200 (XOffset 109 (Pixel 5)) (Pixel 80) 1 ""
				,	StaticText	 0	 (Below 109)  "richtingkeuze"
				,	RadioButtons 1	 (Below 200)  (Columns 1) 201
				[	RadioItem	 201 "horizontaal" Able k`
				,	RadioItem	 202 "vertikaal"   Able k`
				]
				,	DialogButton 3 (Below 1) "Leg woord" legwoordselekteerbaar legwoord
				]
	nofeel _ cs				= (cs,[])
	k` _ x					= x
	cs_tuple x y			= PairCS (IntCS x) (IntCS y)
	grootte_balk			= (blokbreedte*7,blokhoogte)
	legwoordselekteerbaar
	|	speler==Speler1 && soort1==Persoon
							= Able
	|	speler==Speler2 && soort2==Persoon
							= Able
	|	otherwise			= Unable
	
	bordfeel :: MouseState ControlState -> (ControlState,[DrawFunction])
	bordfeel ((x,y),ButtonDown,_) _
							= (cs_tuple x y,[])
	bordfeel _ cs			= (cs,[])
	
	melding					= map toStringCS [	"aantal ingelezen woorden: "
											 ,	toString (grootte woordenboek)
											 ,	"diepte zoekboom:"
											 ,	toString (diepte woordenboek)
											 ]

toevoegpanel woorden
	= CommandDialog toevoegId "Toevoegen" [] 202
		[	StaticText	  0		Center mededeling1
		,	StaticText	  1		Center mededeling2
		,	ScrollingList 300	Center (Pixel 260)	Able (max 10 10) (hd regels) regels (\_ ds->ds)
		,	DialogButton  2		Center		"Nee"	Able (\_ s io->(s,CloseActiveDialog io))
		,	DialogButton  202	(RightTo 2)	"Ja"	Able (voegalletoe woorden)
		]
where
	regels		= map toString woorden ++ kabuo ++ kabuo ++ kabuo ++ kabuo ++ kabuo ++ kabuo ++ kabuo ++ kabuo 
	kabuo       = [
	               "The accused man, Kabuo Miyamoto,",
	               "sat proudly upright with a rigid face,",
				   "his palms placed softly on the",
				   "defandant's table -- the posture of a man",
				   "who has detached himself insofar as",
				   "is possible at his own trial.",
				   "Some in the gallery would later say that",
				   "his stillness suggested a disdain for the",
				   "proceedings; others felt certain it veiled",
				   "a fear of the verdict that was to come.",
				   "Whichever it was, Kabuo showed nothing",
				   "-- not even a flicker of the eyes.",
				   "He was dressed in a white shirt worn",
				   "buttoned to the throat and gray,",
				   "neatly pressed trousers.",
				   "His figure, especially the neck and",
				   "shoulders, communicated the impression of",
				   "irrefutable physical strength end of",
				   "precise, even imperial bearing.",
				   "Kabuo's features were smooth and angular;",
				   "his hair had been cropped close to his",
				   "skull in a manner that made its musculature",
				   "prominent.",
				   "In the face of the charge that had been",
				   "leveled against him he sat with his dark",
				   "eyes trained straight ahead and did not",
				   "appear to be moved at all.",
				   ""
				  ]
									
	(mededeling1,mededeling2)
				= if (length woorden==1) ("Woord komt niet voor."	, "Wil je het woord toevoegen?") 
										 ("Woorden komen niet voor.", "Wil je de woorden toevoegen?")
	
	voegalletoe :: Woorden DialogInfo Toestand (IOState Toestand) -> (Toestand,IOState Toestand)
	voegalletoe woorden info t=:{woordenboek} io
		= (	{t & woordenboek=voegmeerderetoe woordenboek woorden}
		  ,	CloseActiveDialog io
		  )
