implementation module Random

//	By Marco Pil

import StdBool, StdInt, StdClass, deltaEventIO, deltaTimer

:: Seed :== Int

Random :: .Int !Seed -> .(Int,Seed)
Random range seed
		| 0<=seed && seed<body	=  (rnd,newSeed)
		| otherwise			=  Random range ((abs seed) mod body)
	where
	newSeed = (seed * alpha) mod body
	rnd = newSeed mod range

InitSeed :: Seed
InitSeed = 19997		//  prime

RandomSeed :: (IOState s) -> (Seed, IOState s)
RandomSeed io = (newSeed, newIO)
	where
	((hours,minutes,seconds),newIO) = GetCurrentTime io
	seed = (hours + minutes + seconds) mod body
	newSeed	| seed==0		=  seed + 1
			| otherwise 	=  seed

body:==30011			//  prime
alpha:==19683			//  3^9