implementation module Letters

import	StdInt, StdBool, StdChar, StdTuple, StdList,StdArray,StdEnum

dubbelletterposities :: [(Int,Int)]
dubbelletterposities
	=: [(0,3),(0,11),(2,6),(2,8),(3,7),(3,14),(6,2),(6,6),(6,8),(6,12),(7,3),(7,11),(8,2),(8,6),(8,8),(8,12),(11,7),(11,14),(12,6),(12,8),(14,3),(14,11)]

driedubbelletterposities :: [(Int,Int)]
driedubbelletterposities
	=: [ (1,5),(1,9),(5,1),(5,5),(5,9),(5,13),(9,1),(9,5),(9,9),(9,13),(13,5),(13,9) ]

dubbelwoordposities :: [(Int,Int)]
dubbelwoordposities
	=: [ (1,1),(2,2),(3,3),(4,4),(1,13),(2,12),(3,11),(4,10),(10,4),(10,10),(11,3),(11,11),(12,12),(12,2),(13,13),(13,1) ]

driedubbelwoordposities :: [(Int,Int)]
driedubbelwoordposities
	=: [ (0,0),(0,7),(0,14),(7,0),(7,14),(14,0),(14,7),(14,14) ]

letterbak :: [Char]
letterbak 
	=:	repeatn 6  'a' ++ repeatn 2  'b' ++ repeatn 2 'c' ++ repeatn 5 'd' ++
		repeatn 18 'e' ++ repeatn 1  'f' ++ repeatn 3 'g' ++ repeatn 2 'h' ++
		repeatn 4  'i' ++ repeatn 2  'j' ++ repeatn 3 'k' ++ repeatn 3 'l' ++
		repeatn 3  'm' ++ repeatn 10 'n' ++ repeatn 6 'o' ++ repeatn 2 'p' ++
		repeatn 1  'q' ++ repeatn 5  'r' ++ repeatn 4 's' ++ repeatn 5 't' ++
		repeatn 3  'u' ++ repeatn 2  'v' ++ repeatn 2 'w' ++ repeatn 1 'x' ++
		repeatn 1  'y' ++ repeatn 2  'z'

graai :: ![Char] !Int [Int] -> (![Char],![Char],[Int])
graai lb 0 rs			= (lb,[],rs)
graai [] n rs			= ([],[],rs)
graai lb n rs			= (restbak,[l:rest],rs2)
where
	(r,rs1)				= random (length lb) rs
	l					= lb!r
	(restbak,rest,rs2)	= graai (removeMembers lb [l]) (n-1) rs1

random :: !Int ![Int] -> (!Int,![Int])
random i [r:rs] = (r rem i,rs)

/*
letterwaardeop :: !Char !(!Int,!Int) -> Int
letterwaardeop l (i,j) = letterwaarde l*letter_waarde_op_array.[i,j]
*/

letterwaarde :: !Char -> Int
letterwaarde l
|	isMember l ['a','e','i','n','o']		= 1
|	isMember l ['d','r','s','t']			= 2
|	isMember l ['b','g','k','l','m','p']	= 3
|	isMember l ['f','h','j','u','v','z']	= 4
|	isMember l ['c','w']					= 5
|	isMember l ['x','y']					= 8
|	l=='q'									= 10
|	otherwise								= 0		// voor de blancoletters

/*

letterwaarde :: !Char -> Int
letterwaarde l = letter_waarde_array.[toInt l-toInt 'a'];



letter_waarde_array :: {#Int}
letter_waarde_array =: {letterwaarde (toChar (j+toInt 'a')) \\ j<- [0..25]}
where
	letterwaarde :: !Char -> Int
	letterwaarde l
	|	isMember l ['a','e','i','n','o']		= 1
	|	isMember l ['d','r','s','t']			= 2
	|	isMember l ['b','g','k','l','m','p']	= 3
	|	isMember l ['f','h','j','u','v','z']	= 4
	|	isMember l ['c','w']					= 5
	|	isMember l ['x','y']					= 8
	|	l=='q'									= 10
	|	otherwise								= 0		// voor de blancoletters


letter_waarde_op_array :: {#{#Int}}
letter_waarde_op_array =: a3
where
	a3 = {a2 & [i,j]=3 \\ (i,j)<-driedubbelletterposities }
	a2 = {a1 & [i,j]=2 \\ (i,j)<-dubbelletterposities }
	a1 = {{1 \\ j<- [0..14]} \\ i <- [0..14]};
*/

letterwaardeop :: !Char !(!Int,!Int) -> Int
letterwaardeop l pos
|	isMember pos dubbelletterposities	 	= lw*2
|	isMember pos driedubbelletterposities	= lw*3
|	otherwise								= lw
where
	lw = letterwaarde l

/*
woordwaardeop :: !(!Int,!Int) -> Int
woordwaardeop (i,j) = woord_waarde_op_array.[i,j];


woord_waarde_op_array :: {#{#Int}}
woord_waarde_op_array =: a3
where
	a3 = {a2 & [i,j]=3 \\ (i,j)<-driedubbelwoordposities }
	a2 = {a1 & [i,j]=2 \\ (i,j)<-dubbelwoordposities }
	a1 = {{1 \\ j<- [0..14]} \\ i <- [0..14]};
*/

woordwaardeop :: !(!Int,!Int) -> Int
woordwaardeop pos
|	isMember pos dubbelwoordposities		= 2
|	isMember pos driedubbelwoordposities	= 3
|	otherwise								= 1


//------------ added by rbrt -------------

:: PositieType = Normaal 
               | DubbelLetter
			   | DrieDubbelLetter
			   | DubbelWoord
			   | DrieDubbelWoord


CalcPosType :: (Int,Int) -> PositieType
CalcPosType (x,y) 
  |  posinlist dubbelletterposities     = DubbelLetter
  |  posinlist dubbelwoordposities      = DubbelWoord	
  |  posinlist driedubbelletterposities = DrieDubbelLetter
  |  posinlist driedubbelwoordposities  = DrieDubbelWoord
                                        = Normaal
where
   posinlist [] = False
   posinlist [ (x`, y`):r] 
     | x == x` && y == y` = True
	                      = posinlist r
