definition module Bord


from	StdString	import	String
import	StdClass, StdFile
import	Letters


/*****************************************************************
	Globaal bekende Ids voor het scrabble window.
******************************************************************/

scrabbleId		:==	1
toevoegId		:==	2
computerId		:== 1


/***************************************************************** 
	Een aantal veelgebruikte typen:
******************************************************************/

::	Spelmode	=	Pauze | Einde | EindeSpeler1 | EindeSpeler2 | Spelend
::	Spelersoort	=	Computer | Persoon
::	Speler		=	Speler1 | Speler2
::	Sterkte		=	Maximaal | EersteBeste | Sterkte Int

instance == Spelmode
instance == Spelersoort
instance == Speler
instance == Sterkte
instance == Richting
instance toString Speler
instance toString (a,b,c,d)	| toString a & toString b & toString c & toString d

anderespeler :: !Speler -> Speler


/***************************************************************** 
	het type vordering wordt gebruikt, wanneer de computer
	een zet bedenkt. De computer gaat alfabetisch alle woorden
	met een bepaalde beginletter na.  

	Sommige beginletters worden heel snel verwerkt,
	namelijk wanneer de beginletter van	een woord niet voorkomt
	op het letterbalkje van de computer. In dat geval wordt
	bekeken welke posities op het spelbord in aanmerking
	komen als beginpositie voor woorden die beginnen met
	de desbtereffende letter (horizontale en vertikale
	posities worden apart bepaald.)

	Voor woorden die beginnen met een letter die de computer
	op z'n letterbalk heeft staan komen veel meer posities
	op het scrabblebord in aanmerking.  Per woord moeten deze 
	mogelijke posities bepaald worden.  
*******************************************************************/

::	Vordering
	=	Letter Char Plaatsing
	|	Klaar  Plaatsing			// | Woord Char [Char] Plaatsing
::	Plaatsing
	:==	(	Woord
		,	Positie
		,	Richting
		,	Int
		)
geefplaatsing	:: !Vordering -> Plaatsing
geefletter		:: !Vordering -> Char
nognietklaar	:: !Vordering -> Bool


::	Bord		:==	(![[Char]],![[Char]])
::	Positie		:==	(!Int,!Int)
::	Posities	:==	[Positie]
::	Richting	=	Hor | Ver 


initbord				:: Bord
initplaatsing			:: Plaatsing
geefgeplaatsteletters	:: !Bord -> [Char]

/********************************************************
* De functie 'geefvrijehorposities bord letter' bepaald *
* welke posities op het bord beschikbaar zijn om        *
* een woord met deze letter te laten beginnen.          *
*
* Deze functie wordt gebruikt voor het bepalen,         *
* van alle mogelijke beginposities, van woorden         *
* die horizontaal geplaatst worden,                     *
* waarbij het woord moet beginnen met de desbetreffende *
* letter.                                               *
*                                                       *
* Deze optimalisatie is alleen bruikbaar voor letters   *
* die niet op het letterbalkje van de computerspeler    *
* staan.                                                *
*********************************************************/

geefvrijehorposities	:: !Bord !Char -> Posities


/********************************************************
* De functie 'geefvrijeverposities bord letter' bepaald *
* welke posities op het bord beschikbaar zijn om        *
* een woord met deze letter te laten beginnen.          *
*
* Deze functie wordt gebruikt voor het bepalen,         *
* van alle mogelijke beginposities, van woorden         *
* die vertikaal geplaatst worden,                       *
* waarbij het woord moet beginnen met de desbetreffende *
* letter.                                               *
*                                                       *
* Deze optimalisatie is alleen bruikbaar voor letters   *
* die niet op het letterbalkje van de computerspeler    *
* staan.                                                *
*********************************************************/

geefvrijeverposities	:: !Bord !Char -> Posities


/***************************************************************** 
	met scorevoegtoe wordt geprobeerd om een woord toe te voegen
	indien dit lukt wordt het nieuwe bord teruggegeven,
	of het toevoegen wel of niet gelukt is, de letters die
	toegevoegd zijn ( om te bepalen welke letters
	de speler gebruikt heeft), de score en de nieuw gevonden
	woorden.

	Hierna moet nog gecontroleerd worden of alle nieuwe woorden
	die gevormd zijn wel bestaan.

	DE SCORE MOET DAARNA NOG GECORRIGEERD WORDEN VOOR 
	WEL/NIET WEGSPELEN VAN ALLE LETTERS.
*******************************************************************/

scorevoegtoe :: !Bord !Woord !Positie !Richting -> (!Bord,!Bool,[Char],Int,Woorden)


/***************************************************************** 
	De computer gaat zetten bepalen, die geldig zijn.
	De gevonden woorden beginnen allemaal met letter 'l' en
	de letter 'l' komt voor op het letterbalkje van de computer.

	Per woord uit de woordenlijst moeten dus steeds opnieuw
	alle mogelijke posities bepaald worden.
*******************************************************************/

voegmaximaaltoeopjuistepositie :: !Bord Boom [Char] !(!Int,!Int,!Int,!Int) !Vordering !Sterkte Bool -> Plaatsing

/***************************************************************** 
	De computer gaat zetten bepalen, die geldig zijn.
	De gevonden woorden beginnen allemaal met letter 'l' en
	de letter 'l' komt NIET voor op het letterbalkje van de computer.

	De mogelijke posities op het bord voor woorden beginnend
	met de letter l, moeten dus vrijliggende l's zijn.
*******************************************************************/

voegmaximaaltoe :: !Bord Boom [Char] (Posities,Posities) !Vordering !Sterkte Bool -> Plaatsing


::	Boom
	=	Blad !String
	|	Knoop Boom !String Boom
::	Woord	:==	[Char]
::	Woorden	:==	[Woord]

zoekboom		:: !Files				-> (!Boom,!Files)
woordenlijst	:: !Files				-> (![Woord],  !Files)
zoek			:: !Boom Woord -> Bool
grootte			:: !Boom				-> Int
diepte			:: !Boom			-> Int
voegmeerderetoe :: !Boom ![Woord]	-> Boom
