implementation module StdTime

import	StdBool, StdClass, StdFunc, StdInt, StdReal, StdString
import	ostime 

::      Tick    :== Int

::      Time
	=	{	hours   :: !Int		// hours                (0-23)
		,	minutes :: !Int		// minutes              (0-59)
		,	seconds :: !Int		// seconds              (0-59)
		}
::      Date
	=	{       year    :: !Int		// year
		,	month   :: !Int		// month                (1-12)
		,	day	:: !Int		// day                  (1-31)
		,	dayNr   :: !Int		// day of week
						// convention:  (1-7, Sunday=1, Saturday=7)
		}

instance toString Time
where
	toString {hours, minutes, seconds} = (toString hours) +++ ":" +++ (toString minutes) +++ ":" +++ (toString seconds)

instance toString Date
where
	toString {year, month, day, dayNr}	=
		(toString year) +++ "-" +++
		(toString month) +++ "-" +++
		(toString day) +++ " (" +++
		(toString dayNr) +++ ")"

instance == Time
where
	(==)  {hours = xh, minutes = xm, seconds = xs} {hours = yh, minutes = ym, seconds = ys} = xh == yh && xm == ym && xs == ys

instance == Date
where
	(==) {year = xy, month = xm, day = xd, dayNr = xr} {year = yy, month = ym, day = yd, dayNr = yr} = xy == yy && xm == ym && xd == yd && xr == yr

instance < Tick
	where
		(<) t1 t2		// tried to solve millenium bug like bugs
			# t1 = unpack_tick t1
			  t2 = unpack_tick t2
			= t2-t1>0	// this is better than "t1<t2" (plays a role if Mac is running longer than about 1.2 years)

intPlusTick	::	!Int !Tick	-> Tick
intPlusTick i t
	= pack_tick (i+ (unpack_tick t))

tickDifference	::	!Tick !Tick	-> Int
tickDifference t1 t2
	= (unpack_tick t1) - (unpack_tick t2)

pack_tick	::	!Int		-> Tick
pack_tick i = i

unpack_tick	::	!Tick		-> Int
unpack_tick t = t

class TimeEnv env where
	sleep			:: !Int !*env -> *env
	getCurrentTime		:: !*env -> (!Time, !*env)
	getCurrentDate		:: !*env -> (!Date, !*env)
	getCurrentTick		:: !*env -> (!Tick, !*env)

instance TimeEnv World where
	sleep :: !Int !*World -> *World
	sleep d world
		= osSleep d world
	getCurrentTime :: !*World -> (!Time,!*World)
	getCurrentTime world
		# ((hours,minutes,seconds),world) = osGetCurrentTime world
		= ({hours=hours,minutes=minutes,seconds=seconds},world)
	getCurrentDate :: !*World -> (!Date,!*World)
	getCurrentDate world
		# ((year,month,day,dayOfWeek),world) = osGetCurrentDate world
		= ({year=year,month=month,day=day,dayNr=dayOfWeek},world)
	getCurrentTick	:: !*World -> (!Tick,!*World)
	getCurrentTick world
		= osGetCurrentTick world

