definition module StdTime
//	********************************************************************************
//	Replacement module for StdTime which is part of Object I/O library.
//	This module provides a similar API as the one in Object I/O but has no dependencies.
//	
//	StdTime contains time related operations.
//	********************************************************************************

import  ostime
from 	StdOverloaded	import class <
from 	StdOverloaded	import class ==
from	StdString		import class toString

::      Tick 	:== 	Int

::      Time
	=	{	hours   :: !Int		// hours                (0-23)
		,	minutes :: !Int		// minutes              (0-59)
		,	seconds :: !Int		// seconds              (0-59)
		}
::      Date
	=	{       year    :: !Int		// year
		,	month   :: !Int		// month                (1-12)
		,	day	:: !Int		// day                  (1-31)
		,	dayNr   :: !Int		// day of week
						// convention:  (1-7, Sunday=1, Saturday=7)
		}

instance toString Time
instance toString Date

instance == Time
instance == Date

instance < Tick

intPlusTick		:: !Int !Tick 	-> Tick
tickDifference		:: !Tick !Tick 	-> Int

class TimeEnv env where
	sleep		:: !Int !*env -> *env
	getCurrentTime	:: !*env -> (!Time,	!*env)
	getCurrentDate	:: !*env -> (!Date,	!*env)
	getCurrentTick	:: !*env -> (!Tick,	!*env)
/*
	sleep n 
		waits for n seconds.
	getCurrentTime
		returns the current Time.
	getCurrentDate
		returns the current Date.
	getCurrentTick
		returns the current Tick.
*/

instance TimeEnv World
