definition module GenSQL

import StdGeneric, StdMaybe
import SQL 

:: GSQLMode		= GSQLCreate
				| GSQLRead
				| GSQLUpdate
				| GSQLDelete
				| GSQLInfo
				| GSQLInit

:: GSQLPass :== Int

:: GSQLToken	= GSQLValue SQLValue
				| GSQLTerminator
				| GSQLOverride String SQLValue

//GSQLValue:		Plain value, index in the stream determines to which field it is mapped
//GSQLTerminator:	Terminator token, indicates the end of a list of values
//GSQLOVerride:		Field override, if there is such a token in the stream for a given field,
//					it's value is used instead of the 'normal' value in the stream

// Information about the structure of types
:: GSQLFieldInfo =	{ fld_table		:: String			//The database table in which this value is stored
					, fld_select	:: Maybe String		//The database field in which this value is stored
					, fld_match		:: Maybe String		//The database field on which can be matched to find the right database record
					, rec_table		:: String			//The database table of the key field of the parent record
					, rec_key		:: String			//The database field of the key field of the parent record
					, val_list		:: Bool				//Are dealing with one, or with a set of values
					, val_maybe		:: Bool				//Is the value optional
					, val_fields	:: [GSQLFieldInfo]	//Information about the fields if this value is a record
					, val_id		:: Bool				//Is the field an ID type or an entity record
					}
// Errors
:: GSQLError	= GSQLDatabaseError SQLError
				| GSQLTypeError String

instance toString GSQLError

// The separator used in representation type fieldnames
gsql_fieldSeparator	:== "_"

// *The* core generic function
// This function does all operations on a database. It can both read and write information
generic		gSQL t ::
     !GSQLMode !GSQLPass !(Maybe t) ![GSQLFieldInfo] ![GSQLToken] !*cur
 -> (!(Maybe GSQLError), !(Maybe t),![GSQLFieldInfo],![GSQLToken],!*cur)	| SQLCursor cur

// Derives for the standard data types
derive 		gSQL Int, Real, Bool, Char, String, UNIT, PAIR, EITHER, CONS, FIELD, OBJECT, {}, {!}, Maybe, []

// Wrapper functions which provide the basic operations
gsql_read	:: !a !*cur -> (!(Maybe GSQLError), !(Maybe b), !*cur)	| gSQL{|*|} a & gSQL{|*|} b & SQLCursor cur & bimap{|*|} cur
gsql_create	:: !b !*cur -> (!(Maybe GSQLError), !(Maybe a), !*cur)	| gSQL{|*|} a & gSQL{|*|} b & SQLCursor cur & bimap{|*|} cur
gsql_update :: !b !*cur -> (!(Maybe GSQLError), !(Maybe a), !*cur)	| gSQL{|*|} a & gSQL{|*|} b & SQLCursor cur & bimap{|*|} cur
gsql_delete	:: !a !*cur -> (!(Maybe GSQLError), !(Maybe b), !*cur)	| gSQL{|*|} a & gSQL{|*|} b & SQLCursor cur & bimap{|*|} cur
