//Cursor emulation for MySQL
typedef struct st_cursor CURSOR;

//Constants for the types defined in StdSQL
#define STDSQLTYPE_CHAR 1
#define STDSQLTYPE_VARCHAR 2
#define STDSQLTYPE_TEXT 3
#define STDSQLTYPE_INTEGER 4
#define STDSQLTYPE_REAL 5
#define STDSQLTYPE_FLOAT 6
#define STDSQLTYPE_DOUBLE 7
#define STDSQLTYPE_DATE 8
#define STDSQLTYPE_TIME 9
#define STDSQLTYPE_TIMESTAMP 10
#define STDSQLTYPE_DATETIME 11
#define STDSQLTYPE_ENUM 12
#define STDSQLTYPE_NULL 0
#define STDSQLTYPE_UNKNOWN -1

int sql_initC();
void sql_endC(int context);
MYSQL* sql_openConnectionC(CleanString host, CleanString username, CleanString password, CleanString database);
void sql_closeConnectionC(MYSQL* mysql);
void sql_openCursorC(MYSQL* mysql, CURSOR** cursor_out, MYSQL** mysql_out);
void sql_executeC(CleanString statement, CURSOR* cursor, int* error_out, CURSOR** cursor_out);
void sql_escapeC(CleanString from_statement, CleanString to_statement, CURSOR* cursor, int* length_out, CURSOR** cursor_out);
void sql_insertIdC(CURSOR* cursor, int* id_out, CURSOR** cursor_out);
void sql_numRowsC (CURSOR* cursor, int* num_out, CURSOR** cursor_out);
void sql_numFieldsC (CURSOR* cursor, int* num_out, CURSOR** cursor_out);
void sql_fetchC (CURSOR* cursor, int* done_out, CURSOR** cursor_out);
void sql_fetchC_length (int i, CURSOR* cursor, int* length_out, CURSOR** cursor_out);
void sql_fetchC_data (int i, CleanString data, CURSOR* cursor, int* type_out, CURSOR** cursor_out);
void sql_closeCursorC(CURSOR* cursor);
