
Module set Import basic Q;

(* --------------------------------------------------------------------------------
   Define the type of equality relations: EqRel
*)

[     EqRel [T:SET] : TYPE
          = <R:rel T> and3 R.reflexive R.symmetric R.transitive
]
[     EqRelI [T|SET] [R:rel T]
             [refl:R.reflexive] [sym:R.symmetric] [trans:R.transitive]
          : EqRel T
          = (R, pair3 refl sym trans : EqRel T)
];

(* --------------------------------------------------------------------------------
   Define the type of sets: Set
*)

[     Set : TYPE
          = <T:SET> EqRel T
]
[     SetI [T|SET] [R|rel T]
           [refl : reflexive R] [sym : symmetric R] [trans : transitive R]
          : Set
          = (T, EqRelI R refl sym trans : Set)
];

[     el [A:Set] : SET
           = A.1
]
[     Eq_rel [A:Set] : EqRel A.el
          = A.2
];

[A | Set]
[     Eq : rel A.el
          = A.Eq_rel.1
]
[     Eq_refl : reflexive Eq
          = and3_out1 A.Eq_rel.2
]
[     Eq_sym : symmetric Eq
          = and3_out2 A.Eq_rel.2
]
[     Eq_trans : transitive Eq
          = and3_out3 A.Eq_rel.2
];
Discharge A;

[     ExOne [A|Set] [P:A.el->Prop]
          = (Ex P) /\ ({x,x':el A} (P x) -> (P x') -> Eq x x')
]
[     Discrete [A:Set]
          = decidable_rel (Eq|A)
];

(* --------------------------------------------------------------------------------
*)

Goal QSet : {S:SET} Set;
  intros; Refine SetI; Refine S;
  Refine +1 Q_refl; Refine Q_sym; Refine Q_trans;
Save;

Goal nonemptySet : Set -> Prop;
  intros A;
  Refine Ex [x:el A] trueProp;
Save;

(* --------------------------------------------------------------------------------
   Define the empty set, the one, two ans three element set.
*)

Inductive [EmptySET : SET];

Goal {S|SET} EmptySET -> S;
  intros;
  Refine EmptySET_elim (EmptySET\S) H;
Save EmptySET_lemma;

[EmptySet : Set = QSet EmptySET];

Inductive [UnitSET : SET]
Constructors [star : UnitSET];

[UnitSet : Set = QSet UnitSET];

[Star : el UnitSet = star];

Goal {x,y:el UnitSet} Eq x y;
  Refine UnitSET_elim [x:UnitSet.el] {y:el UnitSet} Eq x y;
  Refine UnitSET_elim (Eq Star);
  Refine Eq_refl;
Save UnitSet_trivial;

Goal UnitSet_discr : Discrete UnitSet;
  Intros __; Refine inl;
  Refine UnitSet_trivial;
Save;

Inductive [TwoSET : SET]
Constructors [star21, star22 : TwoSET];

Inductive [ThreeSET : SET]
Constructors [star31, star32, star33 : ThreeSET];

Inductive [FourSET : SET]
Constructors [star41, star42, star43, star44 : FourSET];

Inductive [FiveSET : SET]
Constructors [star51, star52, star53, star54, star55 : FiveSET];

Inductive [SixSET : SET]
Constructors [star61, star62, star63, star64, star65, star66 : SixSET];

Inductive [SevenSET : SET]
Constructors [star71, star72, star73, star74, star75, star76, star77 : SevenSET];

(* --------------------------------------------------------------------------------
   Define Fun and BFun
*)

[A,B,C,D,E | Set];
  [extensional  [o:A.el -> B.el]
     = preserve1 (Eq|A) (Eq|B) o
  ]
  [extensional2 [o:A.el -> B.el -> C.el]
     = preserve2 (Eq|A) (Eq|B) (Eq|C) o
  ]
  [extensional3 [o:A.el -> B.el -> C.el -> D.el]
     = {x,x'|A.el}(Eq x x') -> {y,y'|B.el}(Eq y y') -> {z,z'|C.el}(Eq z z') ->
       Eq (o x y z) (o x' y' z')
  ]
  [extensional4 [o:A.el -> B.el -> C.el -> D.el -> E.el]
     = {a,a'|A.el}(Eq a a') -> {b,b'|B.el}(Eq b b') ->
       {c,c'|C.el}(Eq c c') -> {d,d'|D.el}(Eq d d') ->
       Eq (o a b c d) (o a' b' c' d')
  ];
Discharge A;

[A,B,C,D : Set];
  [Fun  : SET = <f:A.el -> B.el> extensional f];
  [Fun2 : SET = <f:A.el -> B.el -> C.el> extensional2 f];
  [Fun3 : SET = <f:A.el -> B.el -> C.el -> D.el> extensional3 f];
DischargeKeep A;
  [UFun = Fun A A];
  [BFun = Fun2 A A A];
Discharge A;

[A,B,C,D | Set];
  [ap  [f:Fun A B]      : A.el -> B.el         = f.1];
  [ap2 [f:Fun2 A B C]   : A.el -> B.el -> C.el = f.1];
  [ap3 [f:Fun3 A B C D] : A.el -> B.el -> C.el -> D.el = f.1];
  [exten  [f:Fun A B]      : extensional f.ap   = f.2];
  [exten2 [f:Fun2 A B C]   : extensional2 f.ap2 = f.2];
  [exten3 [f:Fun3 A B C D] : extensional3 f.ap3 = f.2];

  [FunI [o:A.el->B.el] [exten:extensional o] : Fun A B
     = (o, exten : Fun A B)
  ];
  [Fun2I [o:A.el->B.el->C.el] [exten:extensional2 o] : Fun2 A B C
     = (o, exten : Fun2 A B C)
  ];
  [Fun3I [o:A.el->B.el->C.el->D.el] [exten:extensional3 o] : Fun3 A B C D
     = (o, exten : Fun3 A B C D)
  ];

DischargeKeep A;
  [UFunI [o:A.el->A.el]       [exten:extensional o]  : UFun A = FunI o exten];
  [BFunI [o:A.el->A.el->A.el] [exten:extensional2 o] : BFun A = Fun2I o exten];
Discharge A;

(* --------------------------------------------------------------------------------
*)

Goal QFun : {S,T|SET} {f:S->T} Fun (QSet S) (QSet T);
  intros; Refine FunI;
  Refine f;
  Intros ___; Refine Q_resp; Refine H;
Save;

Goal QFun2 : {S,T,U|SET} {f:S->T->U} Fun2 (QSet S) (QSet T) (QSet U);
  intros; Refine Fun2I;
  Refine f;
  Intros ______; Refine Q_resp2; Refine H; Refine H1;
Save;

(* --------------------------------------------------------------------------------
   The identity and composition of functions
*)

[A : Set];

[     iden : A.el -> A.el
          = Id | A.el
]
[     Iden : Fun A A
          = FunI iden ([x,x'|el A][H:Eq x x']H)
];

Discharge A;

[A,B,C | Set] [g : Fun B C] [f : Fun A B];

[     comp [g:B.el->C.el][f:A.el->B.el] : A.el -> C.el
          = compose g f
]
[     Comp : Fun A C
          = FunI (comp g.ap f.ap) ([x,x'|el A][H:Eq x x']exten g (exten f H))
];

Discharge A;

(* --------------------------------------------------------------------------------
   Define predicates on functions etc.
*)

[A,B,C | Set]
[f : BFun A] [e : el A] [id, neg : UFun A];
  [Associative   = associative   (Eq|A) f.ap2];
  [Commutative   = [f:Fun2 A A B] commutative (Eq|B) f.ap2];
  [Involutive    = involutive    (Eq|A) id.ap];
  [Idempotent    = idempotent    (Eq|A) f.ap2];
  [lIdentity     = [f:Fun2 B A A][e:el B] l_identity (Eq|A) f.ap2 e];
  [rIdentity     = [f:Fun2 A B A][e:el B] r_identity (Eq|A) f.ap2 e];
  [Identity      = identity      (Eq|A) f.ap2 e];
  [lInverse      = [o:Fun2 C B A][e:el A][f:Fun B C] l_inverse (Eq|A) o.ap2 e f.ap];
  [rInverse      = [o:Fun2 C B A][e:el A][f:Fun C B] r_inverse (Eq|A) o.ap2 e f.ap];
  [Inverse       = [o:Fun2 B B A][e:el A][f:Fun B B] inverse   (Eq|A) o.ap2 e f.ap];
  [lCancelation  = [f:Fun2 B A C] l_cancelation (Eq|A) (Eq|C) f.ap2];
  [rCancelation  = [f:Fun2 A B C] r_cancelation (Eq|A) (Eq|C) f.ap2];
  [Cancelation   = [f:Fun2 A B C] cancelation   (Eq|A) (Eq|B) (Eq|C) f.ap2];
Discharge f; DischargeKeep A;

[f | BFun A] [e | el A] [id, neg | UFun A];

  Goal IdentityI : (Commutative f) -> (rIdentity f e) -> (Identity f e);
    Intros commut ident; Refine pair ? ident;
    Intros x; Refine Eq_trans (f.ap2 x e); Refine commut; Refine ident;
  Save;

  Goal InverseI : (Commutative f) -> (rInverse f e neg) -> (Inverse f e neg);
    Intros commut invers; Refine pair ? invers;
    Intros x; Refine Eq_trans (f.ap2 x (neg.ap x)); Refine commut; Refine invers;
  Save;

  Goal CancelationI : (Commutative f) -> (rCancelation f) -> (Cancelation f);
    Intros commut cancel; Refine pair ? cancel;
    Intros a x y _; Refine cancel a;
    Refine Eq_trans (f.ap2 a x); Refine commut;
    Refine Eq_trans (f.ap2 a y); Refine H; Refine commut;
  Save;

Discharge A;

[lDistributive [A,B|Set][Plus:BFun A] [Times:Fun2 B A A]
  = {y:el B} distributive (Eq|A) Plus.ap2 (Times.ap2 y)];
[rDistributive [A,B|Set][Plus:BFun A] [Times:Fun2 A B A]
  = {y:el B} distributive (Eq|A) Plus.ap2 ([x:el A]Times.ap2 x y)];

[A | Set] [Plus, Times : BFun A] [Zero, One : el A] [Recip : UFun A];
  [MultInverse = {x:el A} iff (not (Eq x Zero)) (Eq (Times.ap2 x (Recip.ap x)) One)];
  [Distributive = and (lDistributive Plus Times) (rDistributive Plus Times)];
Discharge A;

Goal DistributiveI : {A|Set}{Plus,Times|BFun A}
     (Commutative Times) -> (rDistributive Plus Times) -> (Distributive Plus Times);
  Intros ___ commut distrib; Refine pair ? distrib;
  Intros x y y';
    Refine Eq_trans (Times.ap2 (Plus.ap2 y y') x); Refine commut;
    Refine Eq_trans (Plus.ap2 (Times.ap2 y x) (Times.ap2 y' x)); Refine distrib;
    Refine exten2; Refine commut; Refine commut;
Save;

(* --------------------------------------------------------------------------------
   Define the set of propositions
*)

Goal iff_refl : reflexive iff;
  Intros _;
  andI; Refine ?+1; intros; Immed;
Save;

Goal iff_sym : symmetric iff;
  Intros ___;
  andE H; andI; Immed;
Save;

Goal iff_trans : transitive iff;
  Intros _____;
  Refine pair;
  Refine [z:x] H1.fst (H.fst z);
  Refine [z:z] H.snd (H1.snd z);
Save;

[     Omega : Set
          = SetI iff_refl iff_sym iff_trans
];
