
Module Syntax Import nelist product;

(* =========================================================================
   Syntax
*)

(*
   A signature are tow sets S,T of function and predicate symbols and
   two arity maps S->nat and T->nat.
*)

[     Signature : TYPE
          = <FuncSymb, PredSymb : SET> (FuncSymb -> nat) # (PredSymb -> nat)
]
[     FuncSymb [s:Signature] : SET
          = s.1
]
[     PredSymb [s:Signature] : SET
          = s.2.1
]
[     FuncArity [s|Signature] : (FuncSymb s) -> nat
          = s.2.2.1
]
[     PredArity [s|Signature] : (PredSymb s) -> nat
          = s.2.2.2
]
[     SignatureI [FuncSymb,PredSymb:SET] [ConsAr:FuncSymb->nat] [PredAr:PredSymb->nat]
          : Signature
          = (FuncSymb, PredSymb, ConsAr, PredAr : Signature)
];

(*
   Let s be a Signature.
   Define n-tuples of terms. Define terms.
   Define atomic formulas.
*)

[s : Signature];

Inductive [terms : nat -> SET]
Constructors [TFV   : nat -> (terms OneN)]
             [TFC   : {c:FuncSymb s} (terms (FuncArity c)) -> (terms OneN)]
             [tnil  : terms ZeroN]
             [tcons : {n|nat} (terms OneN) -> (terms n) -> (terms (succ n))];

[     term : SET
          = terms OneN
];

(* terms is made into the setoid Terms using Leibniz equality. *)

[Terms [n:nat] : Set = QSet (terms n)];

[Term : Set = Terms OneN];

Inductive [atomic_form : SET]
Constructors [AFPred : {p:PredSymb s} (terms (PredArity p)) -> atomic_form]
             [AFEq   : (terms TwoN) -> atomic_form];

Inductive [formula : SET]
Constructors [FFAtom : atomic_form -> formula]
             [FFEx, FFAll, FFnot : formula -> formula]
             [FFimp, FFor, FFand : formula -> formula -> formula];

Discharge s;

[s | Signature];

[     TFcons : ((terms s ZeroN) -> term s) -> (term s)
          = [H:(terms s ZeroN) -> term s] H (tnil s)
]
[     TFfun : ((terms s OneN) -> term s) -> (term s) -> (term s)
          = Id|((terms s OneN) -> term s)
]
[     TFbfun : ((terms s TwoN) -> term s) -> bop (term s)
          = [H:(terms s TwoN) -> term s] [t,u:term s] H (tcons s t u)
];

(* Define simultaneous and normal substitution. *)

Goal SimSubst : {rho:el (neList (Prod Nat (Term s)))}
                {n|nat} (Terms s n).el -> (Terms s n).el;
  intros _;
  Refine terms_elim ? [n:nat] (Terms s n).el \ (Terms s n).el;
  intros n; Refine nelist_iter ?? rho;
    intros z; Refine if Nat_discr n z.First z.Second (TFV s n);
    intros z ih; Refine if Nat_discr n z.First z.Second ih;
  intros c _; Refine TFC s c;
  Refine tnil;
  intros ___; Refine tcons;
Save;

Goal Subst_n : {n|nat} (Terms s n).el -> Nat.el -> (Term s).el -> (Terms s n).el;
  intros n t x u;
  Refine SimSubst (base (Tuple x u)) t;
Save;

Goal Subst : (Term s).el -> Nat.el -> (Term s).el -> (Term s).el;
  Refine Subst_n;
Save;

Discharge s;
