Module Q Import basic;

(* Contents
   --------
   o Definition and rules for manipulating Leibniz equality.

   Note
   ----
   o Loading this file causes Qrepl to be configured for Leibniz equality.

*)

echo "Searching for definition of SET, TYPE";

SET; TYPE;

[T,S,U|SET];

[     Q = [x,y:T]{P:T->Prop}(P x)->P y
          : T->T->Prop 
] 
[     Q_refl = [t:T][P:T->Prop][h:P t]h
          : refl Q
]
[     Q_sym = [t,u|T][g:Q t u]g ([x:T]Q x t) (Q_refl t)
          : sym Q
]
[     Q_trans = [t,u,v|T][p:Q t u][q:Q u v][P:T->Prop]compose (q P) (p P)
          : trans Q
];

DischargeKeep T;

[     Q_resp = [f:T->S][t,u|T][h:Q t u]
                   h ([z:T]Q (f t) (f z)) (Q_refl (f t))
          : {f:T->S}respect f Q 
]
[     Q_resp2 = [f:T->U->S][t,t'|T][u,u':U][Eqtt':Q t t'][Equu':Q u u']
                  Eqtt' ([x:T]Q (f t u) (f x u'))
                        (Equu' ([y:U]Q (f t u) (f t y))
                               (Q_refl (f t u)))
          : {f:T->U->S}respect2 f Q
];

Goal {x,y|T}(Q x y)->{P:T->Prop}(P x)->P y;
 Intros x y H P H1;
 Refine H P H1;
Save Q_subst;

Discharge T;

Configure Qrepl Q Q_subst Q_sym;

[T | SET] [R : rel T];

  [    substitutive : Prop
            = {x,y|T} (R x y) -> Q x y
  ];

[subs : substitutive];

  [    subs_sym [R_refl : reflexive R]
            : symmetric R
            = [x,y|T] [H:R x y] subs H ([z:T]R z x) x.R_refl
  ]
  [    subs_trans
            : transitive R
            = [x,y,z:T] [H:R x y] [H1:R y z] subs H1 (R x) H
  ];

Discharge T;

