
(*
   The times in comment strings are CPU seconds measured on a
   SPARCstation 20 MP (4 X 390Z55, Model 541) @ 50.0 MHz
   running Lego generated on May 1th, 1996.
*)

Module Examples Import Group;

(* ----------------------------------------------------------------------
   Define the terms of a group. Let G be a group.
*)

[     termGr : SET
          = term sigGr
]
[     VAR : nat -> termGr
          = TFV sigGr
]
[     ONE : termGr
          = TFcons (TFC sigGr star31)
]
[     INV : termGr -> termGr
          = TFfun (TFC sigGr star32)
]
[     TIMES : termGr -> termGr -> termGr
          = TFbfun (TFC sigGr star33)
];

[G : Group];

[     one : G.obj
          = G.OneGr
]
[     inv : op G.obj
          = ap  G.InvGr
]
[     times : bop G.obj
          = ap2 G.TimesGr
];

(* ----------------------------------------------------------------------
   Example 1, show

                   y = z  ->  z ((x/y) y) = z ((x/z) z)
*)

(* First, proof it on the traditional way. *)

Goal {x,y,z:obj G} (Eq y z) -> Eq (times (times y (times x (inv y))) z)
                                  (times (times z (times x (inv z))) z);
  intros;
  Refine exten2;
  Refine exten2;
  Refine H;
  Refine exten2;
  Refine Eq_refl;
  Refine exten;
  Refine H;
  Refine Eq_refl;
Save ExampleGr1;

(* Now using lego tactics (experimental). *)

Goal {x,y,z:obj G} (Eq y z) -> Eq (times (times y (times x (inv y))) z)
                                  (times (times z (times x (inv z))) z);
  intros;
  Repeat (Refine exten Else Refine exten2 Else Refine Eq_refl Else Immed);
Save Example1_tactic;

(* Using the two-level approach. *)

Goal {x,y,z:obj G} (Eq y z) -> Eq (times (times y (times x (inv y))) z)
                                  (times (times z (times x (inv z))) z);
  intros;
  rho == necons x (necons y (base z));
  t   == TIMES (TIMES (VAR OneN) (TIMES (VAR ZeroN) (INV (VAR OneN)))) (VAR TwoN);
  u   == TIMES (TIMES (VAR TwoN) (TIMES (VAR ZeroN) (INV (VAR TwoN)))) (VAR TwoN);
  Equiv Eq (int G rho t) (int G rho u);
  Refine SubstitutionLemma ? OneN;
  Refine H;
Save ExampleGr1_2level;

(* ----------------------------------------------------------------------
   Example 2, show

               x = y 1  ->  z = z'  ->  z/x = z'/(y 1)
*)

Goal {x,y,z,z':obj G} (Eq x (times y one)) -> (Eq z z') ->
     (Eq (times z (inv x)) (times z' (inv (times y one))));
  intros;
  rho1 == necons x             (base z );
  rho2 == necons (times y one) (base z');
  t    == TIMES (VAR OneN) (INV (VAR ZeroN));
  Equiv Eq (int G rho1 t) (int G rho2 t);
  Refine CompAss;
  Refine pair H H1;
Save ExampleGr2;

Goal {x,y,z,z':obj G} (Eq x (times y one)) -> (Eq z z') ->
     (Eq (times z (inv x)) (times z' (inv (times y one))));
  intros;
  Repeat (Refine exten Else Refine exten2 Else Refine Eq_refl Else Immed);
Save ExampleGr2_tactic;

(* ----------------------------------------------------------------------
   Example 3, show

                  b = b'  ->  a (b c) = (a b') c
*)

Goal {a,b,b',c:obj G} (Eq b b') -> (Eq (times a (times b c)) (times (times a b') c));
  intros;
  rho == necons a (necons b (necons b' (base c)));
  t   == TIMES (VAR ZeroN) (TIMES (VAR OneN) (VAR ThreeN));
  u   == TIMES (TIMES (VAR ZeroN) (VAR TwoN)) (VAR ThreeN);
  Equiv Eq (int G rho t) (int G rho u);
  Refine Unify G OneN (VAR TwoN);
  Refine H;
  Refine TimesGr_assoc;
Save ExampleGr3;

(*
Goal {a,b,b',c:obj G} (Eq b b') -> (Eq (times a (times b c)) (times (times a b') c));
  intros;
  Repeat (Refine exten Else Refine exten2 Else Refine Eq_refl Else Immed);
*)


(* =====================================================================================
   The Knuth-Bendix completion
*)

$[FreeGroup : SET];

$[varFg   : nat -> FreeGroup];
$[oneFg   : FreeGroup];
$[invFg   : FreeGroup -> FreeGroup];
$[timesFg : FreeGroup -> FreeGroup -> FreeGroup];

(* Completion of the group equations *)

[ [x,y,z : FreeGroup]

   timesFg (invFg x) x             ==> oneFg
|| timesFg x (invFg x)             ==> oneFg
|| invFg oneFg                     ==> oneFg
|| timesFg (timesFg x (invFg z)) z ==> x
|| timesFg (timesFg x y) (invFg y) ==> x
|| timesFg oneFg x                 ==> x
|| timesFg x oneFg                 ==> x
|| invFg (invFg x)                 ==> x
|| invFg (timesFg x y)             ==> timesFg (invFg y) (invFg x)
|| timesFg x (timesFg y z)         ==> timesFg (timesFg x y) z
];

Goal classes : {n|nat} (terms sigGr n) -> product FreeGroup n;
  Refine terms_elim sigGr [n:nat](terms sigGr n)\product FreeGroup n;
  intros x; Refine prod1 (varFg x);
  Refine ThreeSET_elim [c:FuncSymb sigGr] (terms sigGr (FuncArity c)) ->
                       (product FreeGroup (FuncArity c)) -> product FreeGroup OneN;
    intros _ ih; Refine prod1 oneFg;
    intros _ ih; Refine prod1 (invFg ih.first);
    intros _ ih; Refine prod1 (timesFg ih.first ih.second.first);
  Refine prod0;
  intros ___ ih1 ihn; Refine tuple ih1.first ihn;
Save;

[     class : (termGr) -> FreeGroup
          = [t:termGr] prod1_elim (classes t)
];

[     Soundness : {s,t:termGr}{rho:el (Assignment G)}
                  (Q (class s) (class t)) -> Eq (int G rho s) (int G rho t)
];

(* -------------------------------------------------------------------------
   Example, show
                             -1     -1  -1
                        (x y)   =  y   x
*)

Goal {x,y:obj G} Eq (inv (times x y)) (times (inv y) (inv x));
  intros;
  rho == necons x (base y);
  t   == INV (TIMES (VAR ZeroN) (VAR OneN));
  u   == TIMES (INV (VAR OneN)) (INV (VAR ZeroN));
  Equiv Eq (int G rho t) (int G rho u);
  Refine Soundness;
  Refine Q_refl;
Save Inv_distrib;

(* -------------------------------------------------------------------------
   Define commutator x y = [x,y] = (x y)/(y x)
          conjugate  x y =  x*y  = y(x/y)
*)

[     commFg [x,y : FreeGroup] : FreeGroup
          = timesFg (timesFg x y) (invFg (timesFg y x))
]
[     conjFg [x,y : FreeGroup] : FreeGroup
          = timesFg y (timesFg x (invFg y))
]
[     comm [x,y : obj G] : obj G
          = times (times x y) (inv (times y x))
]
[     conj [x,y : obj G] : obj G
          = times y (times x (inv y))
]
[     COMM [x,y : termGr] : termGr
          = TIMES (TIMES x y) (INV (TIMES y x))
]
[     CONJ [x,y : termGr] : termGr
          = TIMES y (TIMES x (INV y))
];

(* ----------------------------------------------------------------------
   Example, show
                                       -1
                          [x,y] = [y,x]
*)

echo "Show [x,y] = [y,x]^{-1} using Knuth-Bendix completion";
StartTimer;

Goal {x,y:obj G} Eq (comm x y) (inv (comm y x));
  intros;
  rho == necons x (base y);
  t   == COMM (VAR ZeroN) (VAR OneN);
  u   == INV (COMM (VAR OneN) (VAR ZeroN));
  Equiv Eq (int G rho t) (int G rho u);
  Refine Soundness;
  Refine Q_refl;
Save comm_inv;

PrintTimer;        (* time= 251.370000  gc= 15.610000  sys= 0.050000 *)


(* ----------------------------------------------------------------------
   Example, show

                        [x,y]*z = [x*z,y*z]
*)

echo "Show [x,y]*z = [x*z,y*z] using Knuth-Bendix completion";
StartTimer;

Goal {x,y,z:obj G} Eq (conj (comm x y) z) (comm (conj x z) (conj y z));
  intros;
  rho == necons x (necons y (base z));
  t   == CONJ (COMM (VAR ZeroN) (VAR OneN)) (VAR TwoN);
  u   == COMM (CONJ (VAR ZeroN) (VAR TwoN)) (CONJ (VAR OneN) (VAR TwoN));
  Equiv Eq (int G rho t) (int G rho u);
  Refine Soundness;
  Refine Q_refl;
Save comm_conj;

PrintTimer;        (* time= 36013.570000 (10 hours)
                      gc= 3960.560000  sys= 19.460000 *)

(* -------------------------------------------------------------------------
   Proof the last lemma again on the traditional way.
*)

StartTimer;

(* Show x^{-1}^{-1} = x *)

Goal {x:obj G} Eq (inv (inv x)) x;
  Intros x;
  Refine Eq_trans (times one (inv (inv x)));
    Refine Eq_sym; Refine lOneGr_ident;
  Refine Eq_trans (times (times x (inv x)) (inv (inv x)));
    Refine exten2 ?? ?.Eq_refl; Refine Eq_sym; Refine rInvGr_invers;
  Refine Eq_trans (times x (times (inv x) (inv (inv x))));
    Refine Eq_sym; Refine TimesGr_assoc;
  Refine Eq_trans (times x one);
    Refine exten2 ? ?.Eq_refl; Refine rInvGr_invers;
  Refine rOneGr_ident;
Save inv_invol;

(* Show (x y)^{-1} = y^{-1} x^{-1} *)

Goal {x,y:obj G} Eq (inv (times x y)) (times (inv y) (inv x));
  intros;
  Refine Eq_sym;
  Refine Eq_trans (times (times (inv y) (inv x)) one);
    Refine Eq_sym; Refine rOneGr_ident;
  Refine Eq_trans (times (times (inv y) (inv x)) (times (times x y) (inv (times x y))));
    Refine exten2 ? ?.Eq_refl; Refine Eq_sym; Refine rInvGr_invers;
  Refine Eq_trans (times (times (times (inv y) (inv x)) (times x y)) (inv (times x y)));
    Refine TimesGr_assoc;
  Refine Eq_trans (times one (inv (times x y)));
    Refine +1 lOneGr_ident;
  Refine exten2 ?? ?.Eq_refl;
  Refine Eq_trans (times (inv y) (times (inv x) (times x y)));
    Refine Eq_sym; Refine TimesGr_assoc;
  Refine Eq_trans (times (inv y) y);
    Refine +1 lInvGr_invers;
  Refine exten2 ? ?.Eq_refl;
  Refine Eq_trans (times (times (inv x) x) y);
    Refine TimesGr_assoc;
  Refine Eq_trans (times one y);
    Refine exten2 ?? ?.Eq_refl; Refine lInvGr_invers;
  Refine lOneGr_ident;
Save inv_distrib;

(* Show (x*z)(y*z) = (x y)*z *)

Goal {x,y,z:obj G} Eq (times (conj x z) (conj y z)) (conj (times x y) z);
  intros;
  Refine Eq_trans (times z (times (times x (inv z)) (conj y z)));
    Refine Eq_sym; Refine TimesGr_assoc;
  Refine exten2 ? ?.Eq_refl;
  Refine Eq_trans (times x (times (inv z) (conj y z)));
    Refine Eq_sym; Refine TimesGr_assoc;
  Refine Eq_trans (times x (times y (inv z)));
    Refine +1 TimesGr_assoc;
  Refine exten2 ? ?.Eq_refl;
  Refine Eq_trans (times (times (inv z) z) (times y (inv z)));
    Refine TimesGr_assoc;
  Refine Eq_trans (times one (times y (inv z)));
    Refine +1 lOneGr_ident;
  Refine exten2 ?? ?.Eq_refl;
  Refine lInvGr_invers;
Save conj_distrib;

(* Show (x*y)^{-1} = x^{-1}*y *)

Goal {x,y:obj G} Eq (inv (conj x y)) (conj (inv x) y);
  intros;
  Refine Eq_trans (times (inv (times x (inv y))) (inv y));
    Refine inv_distrib;
  Refine Eq_trans (times (times y (inv x)) (inv y));
    Refine +1 Eq_sym; Refine +1 TimesGr_assoc;
  Refine exten2 ?? ?.Eq_refl;
  Refine Eq_trans (times (inv (inv y)) (inv x));
    Refine inv_distrib;
  Refine exten2 ?? ?.Eq_refl;
  Refine inv_invol;
Save inv_conj;

(* Show [x,y]*z = [x*z,y*z] *)

Goal {x,y,z:obj G} Eq (conj (comm x y) z) (comm (conj x z) (conj y z));
  intros;
  Refine Eq_sym;
  Refine Eq_trans (times (conj (times x y) z) (conj (inv (times y x)) z));
    Refine +1 conj_distrib;
  Refine exten2; Refine conj_distrib;
  Refine Eq_trans (inv (conj (times y x) z));
    Refine exten; Refine conj_distrib;
  Refine inv_conj;
Save comm_conj_hand;

PrintTimer;        (* time= 5.250000  gc= 1.250000  sys= 0.020000 *)

Discharge G;

ExportState "Examples";
