
Module neList Import List;

(* --------------------------------------------------------------------------------
   In some occasions it is convenient to have list which will never be empty.
*)

Inductive [nelist : SET]
Parameters [S : SET]
Constructors [base' : S -> nelist] [necons' : S -> nelist -> nelist];
Discharge S;

[S | SET];

[     base  : S -> (nelist S)
          = base' S
]
[     necons : S -> (nelist S) -> (nelist S)
          = necons' S
];

[     nelist_rec [T|TYPE] : ({x:S}T) -> ({x:S}{l:nelist S}{ih:T}T) -> (nelist S) -> T 
            = nelist_elim S (nelist S)\T
]
[     nelist_iter [T|TYPE][f0:{x:S}T][f1:{x:S}{ih:T}T] : (nelist S) -> T
            = nelist_rec f0 ([x:S](nelist S)\f1 x)
]
[     nelist_ind [P:(nelist S) -> Prop]
            : ({x:S}P (base x)) ->
              ({x:S}{l:nelist S}{ih:P l} P (necons x l)) ->
              {l:nelist S} P l
            = nelist_elim S P
];

DischargeKeep S;

Goal {T,U|SET}
     {psi:(nelist T)->(nelist U)->TYPE}
     ({t:T}{u:U}psi (base t) (base u)) ->
     ({t:T}{u:U}{m:nelist U}(psi (base t) m) -> psi (base t) (necons u m)) ->
     ({t:T}{l:nelist T}({m:nelist U}psi l m) -> {u:U}psi (necons t l) (base u)) ->
     ({t:T}{l:nelist T}({m:nelist U}psi l m) ->
                     {u:U}{m:nelist U}(psi (necons t l) m) ->
                     psi (necons t l) (necons u m)) ->
     {l:nelist T}{m:nelist U} psi l m;
  Intros _______;
  Refine nelist_elim ? [l:nelist T]{m:nelist U}psi l m;
  intros t; Refine nelist_elim ? (psi (base t)) (H t) (H1 t);
  Intros x l ih;
  Refine nelist_elim ? (psi (necons x l)) (H2 ? ? ih) (H3 ? ? ih);
Save nelist_elim2;

(* --------------------------------------------------------------------------------
   Compared to normal lists, it is easier to take the head and nth
   component of nelists because then it is always possible to return some value.
*)

[    ne_head : (nelist S) -> S
          = nelist_iter (Id|S) ([x,ih:S]x)
]
[    ne_tail : (nelist S) -> (nelist S)
          = nelist_rec (base|S) ([x:S][l:nelist S][ih:nelist S] l)
]
[    ne_nth [l:nelist S] [n:nat] : S
          = nat_rec ne_head ([_:nat][ih:(nelist S)->S][l:nelist S] ih (ne_tail l)) n l
];

Goal list2nelist : {x:S} {l:list S} nelist S;
  intros __;
  Refine list_rec (base|S) ? l x;
  intros a m ih y; Refine necons y (ih a);
Save;

Discharge S;

(* --------------------------------------------------------------------------------
   Turn the type of non-empty lists into a set.
*)

[A | Set];

[     EqneList : (nelist A.el) -> (nelist A.el) -> Prop
          = nelist_elim2 (A.el.nelist\A.el.nelist\Prop)
                         (Eq|A)
                         ([t,u:A.el][m:nelist A.el][ih_m:Prop] absurd)
                         ([t:A.el][l:nelist A.el][ih_l:(nelist A.el)->Prop]
                          [u:el A] absurd)
                         ([t:A.el][l:nelist A.el][ih_l:(nelist A.el)->Prop]
                          [u:A.el][m:nelist A.el][ih_m:Prop] and (Eq t u) (ih_l m))
];

Goal reflexive EqneList;
  Refine nelist_ind ([l:nelist A.el] EqneList l l);
  Refine Eq_refl;
  intros __; Refine pair ?.Eq_refl;
Save EqneList_refl;

Goal symmetric EqneList;
  Refine nelist_elim2 [l,m:nelist A.el] (EqneList l m) -> EqneList m l;
  Refine Eq_sym;
  intros ____; Refine Id;
  intros ____; Refine Id;
  intros; Refine pair H2.fst.Eq_sym (H ? H2.snd);
Save EqneList_sym;

Goal transitive EqneList;
  Refine nelist_elim2 [a,b:nelist A.el]
               {c:nelist A.el} (EqneList a b) -> (EqneList b c) -> EqneList a c;
  
  intros a b m _;
    Refine nelist_ind [c:nelist A.el] (EqneList (base b) c) -> EqneList (base a) c;
    intros c; Refine Eq_trans ? H;
    intros ___; Refine Id;
  intros; Refine H1;
  intros; Refine H1;
  intros a k ih_a b l ih_b m _;
    Refine nelist_ind [c:nelist A.el]
                        (EqneList (necons b l) c) -> EqneList (necons a k) c;
    intros _; Refine Id;
    intros c ___; Refine pair;
    Refine Eq_trans ? H.fst H1.fst;
    Refine ih_a ? ? H.snd H1.snd;
Save EqneList_trans;

DischargeKeep A;

[     neList [A:Set] : Set
          = Set_intro (EqneList_refl|A) (EqneList_sym|A) (EqneList_trans|A)
];

Goal {x,y|el A} (Eq x y) -> {l,m|el (neList A)} (Eq l m) ->
                            EqneList (necons x l) (necons y m);
  intros _____;
  Refine pair H;
Save EqneList_intro;

(* --------------------------------------------------------------------------------
   Proof some operations over nelists to be extensional and make
   functions out of them.
*)

Goal extensional (ne_head|A.el : (neList A).el -> A.el);
  Refine nelist_elim2 [l,m:(neList A).el] (Eq l m) -> Eq (ne_head l) (ne_head m);
  intros __; Refine Id;
  intros; Refine H1;
  intros; Refine H1;
  intros; Refine H2.fst;
Save ne_head_exten;

Goal extensional (ne_tail|A.el : (neList A).el -> (neList A).el);
  Refine nelist_elim2 [l,l':(neList A).el]
                          (Eq l l') -> Eq|(neList A) (ne_tail l) (ne_tail l');
  intros __; Refine Id;
  intros; Refine H1;
  intros; Refine H1;
  intros; Refine snd H2;
Save ne_tail_exten;

Goal extensional2 (ne_nth|A.el : (neList A).el -> Nat.el -> A.el);
  Intros l l' _ x x' _;
  Qrepl H1;
  Refine nat_ind [x':nat]
              {l,l':(neList A).el} (Eq l l') -> Eq (ne_nth l x') (ne_nth l' x');
  Refine ne_head_exten;
  intros; Refine ih; Refine ne_tail_exten H2;
  Refine H;
Save ne_nth_exten;

Goal extensional2 (list2nelist|A.el : A.el -> A.List.el -> A.neList.el);
  Intros y y' _ g g' _;
  Refine list_elim2 [g,g':el A.List] (Eq g g') -> {x,x':el A}(Eq x x') ->
                                 Eq|A.neList (list2nelist x g) (list2nelist x' g');
  Refine +4 H1; Refine +4 H;
  intros; Refine H3;
  intros; Refine H3;
  intros; Refine H3;
  intros; Refine pair H5 (H2 ? H4.snd ? ? H4.fst);
Save list2nelist_exten;

Discharge A;

[A : Set];

[     neHead : Fun (neList A) A
          = Fun_intro ? (ne_head_exten|A)
]
[     neTail : Fun (neList A) (neList A)
          = Fun_intro ? (ne_tail_exten|A)
]
[     neNth : Fun2 (neList A) Nat A
          = Fun2_intro ? (ne_nth_exten|A)
]
[     List2neList : Fun2 A (List A) (neList A)
          = Fun2_intro ? (list2nelist_exten|A)
];

Discharge A;
