
Module SqrtR Import Real case;

(*
   This module introduces the square root of positive reals. Because
   of our partial axiomitization of the reals, we have to assume the
   existance of the square root besides two defining lemma's.
*)

$[     SqrtR
          : Fun Real Real
]
$[     SqrtR_lemma1
          : {x|el Real} (PositiveR.ap x) -> Eq (SquareR.ap (SqrtR.ap x)) x
]
$[     PositiveSqrtR
          : {x|el Real} (PositiveR.ap x) -> PositiveR.ap (SqrtR.ap x)
];

(* --------------------------------------------------------------------------------
   Now we are able to develop some theory for the square roots.
*)

Goal SqrtR_lemma2 : {x|el Real} (PositiveR.ap x) -> Eq (SqrtR.ap (SquareR.ap x)) x;
  intros;
  Claim PositiveR.ap (SquareR.ap x);
  Refine SquareR_inj ? H;
  Refine PositiveSqrtR ?6;
  Refine SqrtR_lemma1 ?6;
  Refine PositiveSquareR;
Save;

Goal SqrtZeroR : Eq (SqrtR.ap ZeroR) ZeroR;
  Refine Eq_trans (SqrtR.ap (SquareR.ap ZeroR));  
    Refine exten; Refine Eq_sym; Refine rTimesZeroR;
  Refine SqrtR_lemma2 PositiveZeroR;
Save;

Goal SqrtOneR : Eq (SqrtR.ap OneR) OneR;
  Refine Eq_trans (SqrtR.ap (SquareR.ap OneR));  
    Refine exten; Refine Eq_sym; Refine rOneR_ident;
  Refine SqrtR_lemma2 PositiveOneR;
Save;

Goal SqrtR_lemma3 : {x|el Real} (NegativeR.ap x) ->
                                Eq (SqrtR.ap (SquareR.ap x)) (NegR.ap x);
  intros;
  Refine Eq_trans (SqrtR.ap (SquareR.ap (NegR.ap x)));
    Refine exten; Refine Eq_sym; Refine TimesNegR_distrib;
  Refine SqrtR_lemma2 H;
Save;

Goal SqrtR_not_zero
   : {x|el Real} (PositiveR.ap x) -> ~(Eq x ZeroR) -> ~(Eq (SqrtR.ap x) ZeroR);
  Intros ____; Refine H1;
  Refine Eq_trans (SquareR.ap (SqrtR.ap x));
    Refine Eq_sym; Refine SqrtR_lemma1 H;
  Refine Eq_trans (SquareR.ap ZeroR);
    Refine exten ? H2;
  Refine rTimesZeroR;
Save;

Goal SqrtTimesR
   : {x,y|el Real} (PositiveR.ap x) -> (PositiveR.ap y) -> 
     Eq (SqrtR.ap (TimesR.ap2 x y)) (TimesR.ap2 (SqrtR.ap x) (SqrtR.ap y));
  intros;
  Refine Eq_trans (SqrtR.ap (TimesR.ap2 (SquareR.ap (SqrtR.ap x))
                                        (SquareR.ap (SqrtR.ap y))));
    Refine exten; Refine Eq_sym; Refine exten2;
    Refine SqrtR_lemma1 H; Refine SqrtR_lemma1 H1;
  Refine Eq_trans (SqrtR.ap (SquareR.ap (TimesR.ap2 (SqrtR.ap x) (SqrtR.ap y))));
    Refine exten; Refine Eq_sym; Refine SquareTimesR;
  Refine SqrtR_lemma2;
  Refine PositiveTimesR_compat; Refine PositiveSqrtR H; Refine PositiveSqrtR H1;
Save;

Goal SqrtRecipR
   : {x|el Real} (PositiveR.ap x) -> ~(Eq x ZeroR) ->
     Eq (SqrtR.ap (RecipR.ap x)) (RecipR.ap (SqrtR.ap x));
  intros; [z = SqrtR.ap (RecipR.ap x)] [z' = RecipR.ap (SqrtR.ap x)];
  Refine Eq_trans (TimesR.ap2 z OneR);
    Refine Eq_sym; Refine rOneR_ident;
  Refine Eq_trans (TimesR.ap2 z (TimesR.ap2 (SqrtR.ap x) z'));
    Refine exten2 ? ?.Eq_refl; Refine Eq_sym; Refine rRecipR_invers;
    Refine SqrtR_not_zero H H1;
  Refine Eq_trans (TimesR.ap2 (TimesR.ap2 z (SqrtR.ap x)) z');
    Refine TimesR_assoc;
  Refine Eq_trans (TimesR.ap2 OneR z');
    Refine +1 lOneR_ident;
  Refine exten2 ? ? ?.Eq_refl;
  Refine Eq_trans (SqrtR.ap OneR);
    Refine +1 SqrtOneR;
  Refine Eq_trans (SqrtR.ap (TimesR.ap2 (RecipR.ap x) x));
    Refine Eq_sym; Refine SqrtTimesR ? H;
    Refine PositiveRecipR_compat H H1;
  Refine exten;
  Refine lRecipR_invers H1;
Save;

Goal {x,y|el Real} (PositiveR.ap x) ->
                   (LessEqR.ap2 x y) -> LessEqR.ap2 (SqrtR.ap x) (SqrtR.ap y);
  intros;
  Claim PositiveR.ap y;
  orE LessEqR_total (SqrtR.ap x) (SqrtR.ap y);
  Refine Id;
  intros;
  Refine extenRel ? ?.Eq_refl ? ?.LessEqR_refl;
  Refine exten; Refine LessEqR_antisym H1;
  Refine LessEqR_trans (TimesR.ap2 (SqrtR.ap x) (SqrtR.ap y));
    Refine extenRel ? ?4.SqrtR_lemma1 ?.Eq_refl;
    Refine rLessEqTimesR_compat ? H2;
    Refine PositiveSqrtR ?4;
  Refine extenRel ? ?.Eq_refl H.SqrtR_lemma1;
  Refine lLessEqTimesR_compat ? H2;
  Refine PositiveSqrtR H;

  Refine extenPred; Refine (PlusR.ap2 (MinusR.ap2 y x) x);
  Refine Eq_trans (PlusR.ap2 y (PlusR.ap2 (NegR.ap x) x));
    Refine Eq_sym; Refine PlusR_assoc;
  Refine Eq_trans (PlusR.ap2 y ZeroR);
    Refine exten2 ? ?.Eq_refl; Refine lNegR_invers;
  Refine rZeroR_ident;
  Refine PositivePlusR_compat H1 H;
Save SqrtLessEqR_compat;

Goal SqrtR_inj : {x,y|el Real} (PositiveR.ap x) -> (PositiveR.ap y) ->
                 (Eq (SqrtR.ap x) (SqrtR.ap y)) -> Eq x y;
  intros;
  Refine Eq_trans (SquareR.ap (SqrtR.ap x));
    Refine Eq_sym; Refine SqrtR_lemma1 H;
  Refine Eq_trans (SquareR.ap (SqrtR.ap y));
    Refine exten ? H2;
  Refine SqrtR_lemma1 H1;
Save;

