
Module Product Import Nat;

(* --------------------------------------------------------------------------------
   Define the cartesian product of two types.
*)

Inductive [prod : SET]
Parameters [T,U : SET]
Constructors [tuple' : T -> U -> prod];
Discharge T;

[T,U | SET];

[     first : (prod T U) -> T
          = prod_elim T U ((prod T U)\T) ([t:T][u:U]t)
]
[     second : (prod T U) ->  U
          = prod_elim T U ((prod T U)\U) ([t:T][u:U]u)
]
[     tuple : T -> U -> prod T U
          = tuple' T U
];

Discharge T;

(* --------------------------------------------------------------------------------
   Define the cartesian product of two sets.
*)

[A,B : Set];

[     Eq_prod : (prod A.el B.el) -> (prod A.el B.el) -> Prop
          = [x:prod A.el B.el] [y:prod A.el B.el]
            (Eq x.first y.first) /\ (Eq x.second y.second)
];

Goal reflexive Eq_prod;
  Intros _; Refine pair;
  Refine Eq_refl; Refine Eq_refl;
Save Eq_prod_refl;

Goal symmetric Eq_prod;
  Intros ___; Refine H; intros; Refine pair;
  Refine Eq_sym H1; Refine Eq_sym H2;
Save Eq_prod_sym;

Goal transitive Eq_prod;
  Intros _____; Refine H; Refine H1; intros; Refine pair;
  Refine Eq_trans ? H4 H2; Refine Eq_trans ? H5 H3;
Save Eq_prod_trans;

Goal Prod : Set;
  Refine Set_intro;
  Refine +2 Eq_prod_refl;
  Refine Eq_prod_sym;
  Refine Eq_prod_trans;
Save;

Discharge A;

[A,B | Set];

[     First [x:el (Prod A B)] : el A
          = x.first
]
[     Second [x:el (Prod A B)] : el B
          = x.second
]
[     Tuple [x:el A][y:el B] : el (Prod A B)
          = tuple x y
];

Discharge A;

(* --------------------------------------------------------------------------------
   Let A and B two discrete sets. Show the A#B is also discrete.
   Also show that for any two tuples which are not equal, the pairwise
   first or second projects are not equal.
*)

[A,B | Set] [discr_A : A.Discrete] [discr_B : B.Discrete];

Goal Prod_discr : Discrete (Prod A B);
  Intros x y;
  Refine discr_A x.First y.First;
  intros; Refine discr_B x.Second y.Second;
    intros; Refine inl; Refine pair H H1;
    intros; Refine inr; Intros _; Refine H1; Refine snd H2;
  intros; Refine inr; Intros _; Refine H; Refine fst H1;
Save;

Goal Prod_nEq : {x,y:el (Prod A B)}
                ~(Eq x y) -> (~(Eq x.First y.First) \/ ~(Eq x.Second y.Second));
  intros; Refine discr_A x.First y.First;
  intros; Refine discr_B x.Second y.Second;
  intros; Refine H; Refine pair H1 H2;
  Refine inr;
  Refine inl;
Save;

Discharge A;

(* --------------------------------------------------------------------------------
   Define the product of (unary) functions and isomorphisms.
*)

[A,B,C,D|Set] [f:Fun A B] [g:Fun C D];

[     prodFun : (Prod A C).el -> (Prod B D).el
          = [z:el (Prod A C)] tuple (f.ap z.first) (g.ap z.second)
];

Goal extensional prodFun;
  Intros ___; Refine pair;
  Refine exten; Refine fst H;
  Refine exten; Refine snd H;
Save prodFun_exten;

[     ProdFun : Fun (Prod A C) (Prod B D)
          = Fun_intro prodFun prodFun_exten                      
];

Discharge f; DischargeKeep A;

Goal (Isomorphism A B) -> (Isomorphism C D) -> (Isomorphism (Prod A C) (Prod B D));
  intros f g;
  Intros #; Refine ProdFun f.1 g.1;
  Intros #; Refine ProdFun f.2.1 g.2.1;
  Refine pair;
  Intros _; Refine pair; Refine f.2.2.fst; Refine g.2.2.fst;
  Intros _; Refine pair; Refine f.2.2.snd; Refine g.2.2.snd;
Save ProdIso;

Discharge A;

(* ================================================================================
   Define many-sorted vectors. For this we first define the inductive type of
   lists over a sort.

   Given a list of sorts, vectors are defined as the product of over
   these sorts. We could have used an inductive definition instead,
   but then induction over the sorts of some vector is a bit more
   complex.
*)

Inductive [LIST : TYPE]
Parameters [T : TYPE]
Constructors [NIL : LIST] [CONS : T -> LIST -> LIST];
Discharge T;

[     SETS : TYPE
          = LIST SET
]
[     Sets : TYPE
          = LIST Set
];

[     vector : SETS -> SET
          = LIST_elim ? (SETS\SET) UnitSET
                                   ([S:SET][Ss:SETS][ih:SET] prod S ih)
];

[     Vector : Sets -> Set
          = LIST_elim ? (Sets\Set) UnitSet
                                   ([A:Set][As:Sets][ih:Set] Prod A ih)
];

(* --------------------------------------------------------------------------------
   Define the single-sorted n-ary product of types and sets.
*)

[     ssorted : SET -> nat -> SETS
          = [S:SET] nat_iter (NIL SET)
                             (CONS ? S)
]
[     SSorted : Set -> nat -> Sets
          = [A:Set] nat_iter (NIL Set)
                             (CONS ? A)
];

[     product : SET -> nat -> SET
          = [S:SET] nat_elim (nat\SET)
                             UnitSET
                             ([n:nat][_:SET] nat_iter S (prod S) n)
];

Goal {phi:nat->TYPE} (phi ZeroN) -> (phi OneN) -> 
     {n_ih:{x:nat}(phi (succ x)) -> phi (succ (succ x))}
     {x:nat}phi x;
  intros ____;
  Refine nat_elim; Refine H;
  Refine nat_elim [n:nat] (phi n) -> phi (succ n);
  intros; Refine H1;
  intros; Refine n_ih ? H2;
Save nat_elim_01;

Goal {S:SET} {n:nat} (product S n) -> (vector (ssorted S n));
  intros _;
  Refine nat_elim_01 [n:nat] (product S n) -> vector (ssorted S n);
  Refine Id;
  intros; Refine tuple H star;
  intros; Refine tuple H1.first (H H1.second);
Save product_to_vector;

(* --------------------------------------------------------------------------------
   Construct the set of n-ary products.
*)

[A : Set];

Goal Eq_product : {n:nat} (product A.el n) -> (product A.el n) -> Prop;
  Refine nat_elim_01 [n:nat] (product A.el n) -> (product A.el n) -> Prop;
  Refine Eq|UnitSet;
  Refine Eq;
  Intros n ih p1 p2; Refine (Eq p1.first p2.first) /\ (ih p1.second p2.second);
Save;

Goal {n:nat} reflexive (Eq_product n);
  Refine nat_elim_01 [n:nat] reflexive (Eq_product n);
  Refine Eq_refl|UnitSet;
  Refine Eq_refl;
  Intros n ih _; Refine pair;
  Refine Eq_refl; Refine ih;
Save Eq_product_refl;

Goal {n:nat} symmetric (Eq_product n);
  Refine nat_elim_01 [n:nat] symmetric (Eq_product n);
  Refine Eq_sym|UnitSet;
  Refine Eq_sym;
  Intros _____; Refine H1; intros; Refine pair;
  Refine Eq_sym H2; Refine H H3;
Save Eq_product_sym;

Goal {n:nat} transitive (Eq_product n);
  Refine nat_elim_01 [n:nat] transitive (Eq_product n);
  Refine Eq_trans|UnitSet;
  Refine Eq_trans;
  Intros _______; Refine H1; Refine H2; intros; Refine pair;
  Refine Eq_trans ? H5 H3; Refine H ? H6 H4;
Save Eq_product_trans;

[     Product : nat -> Set
          = [n:nat] Set_intro n.Eq_product_refl n.Eq_product_sym n.Eq_product_trans
];

Discharge A;

(* --------------------------------------------------------------------------------
   Some lemma's with respect to products.
*)

Goal {A|Set} {x,y:el (Product A zeroN)} Eq x y;
  intros _;
  Refine UnitSet_trivial;
Save Product_zero;

Goal Product_discr : {A|Set} A.Discrete -> {n:nat} (Product A n).Discrete;
  intros A A_discr;
  Refine nat_elim_01 [n:nat] (Product A n).Discrete;
  Refine UnitSet_discr;
  Refine A_discr;
  intros;
  Refine Prod_discr A_discr H;
Save;

Goal {A:Set} Isomorphism A (Prod A UnitSet);
  intros;
  Intros #; Refine Fun_intro;
    intros x; Refine tuple x star; Intros ___; Refine pair H ?.Eq_refl;
  Intros #; Refine Fun_intro;
    Refine first; Intros ___; Refine fst H;
  Refine pair; Refine Eq_refl;
  Intros x; Refine pair ?.Eq_refl; Refine UnitSet_trivial;
Save Product_iso_Unit;

Goal {A:Set}{n:nat} Isomorphism (Product A (succ n)) (Prod A (Product A n));
  intros _;
  Refine nat_elim [n:nat] Isomorphism (Product A (succ n)) (Prod A (Product A n));
  Refine Product_iso_Unit;
  Intros __ #; Refine Fun_intro;
    Refine Id|(prod A.el (product A.el (succ n)));
    Intros ___; Refine pair; Refine H.fst; Refine H.snd;
  Intros #; Refine Fun_intro;
    Refine Id|(prod A.el (product A.el (succ n)));
    Intros ___; Refine pair; Refine H.fst; Refine H.snd;
  Refine pair;
  Intros _; Refine Eq_refl;  
  Intros _; Refine Eq_refl;  
Save Product_succ;

Goal {A:Set}{n:nat} Isomorphism (Product A n) (Vector (SSorted A n));
  intros _;
  Refine nat_elim [n:nat] Isomorphism (Product A n) (Vector (SSorted A n));
  Refine Isomorphism_refl;
  intros n ih;
  Refine Isomorphism_trans (Prod A (Product A n));
    Refine Product_succ;
  Refine ProdIso;
    Refine Isomorphism_refl;
  Refine ih;
Save Product_iso_Vector;

Goal {A:Set} Isomorphism (Product A ZeroN) UnitSet;
  intros; Refine Isomorphism_refl;
Save Product0_Unit;

Goal {A:Set} Isomorphism (Product A OneN) A;
  intros; Refine Isomorphism_refl;
Save Product1_Unit;
