
Module Poly1 Import Nat_order Poly Poly_homo Poly_ap FPoly_degree;

(*
   This module define the polynomials in just one variable. We take
   the natural numbers as the index monoid.
*)

[R : Ring];

[     Monomial1 : Set
           = Monomial NatIMonoid R
];

[     Monomial1_intro : Fun2 R.car Nat Monomial1
           = Monomial_intro NatIMonoid R
]
[     CoefMon1 : Fun Monomial1 R.car
           = CoefMon NatIMonoid R
]
[     IndexMon1 : Fun Monomial1 Nat
           = IndexMon NatIMonoid R
]
[     PolyRing1 : Ring
           = PolyRing NatIMonoid R
]
[     Poly1 : Set
           = Polyn NatIMonoid R
]
[     CoefPoly1 : Fun2 Poly1 Nat R.car
           = CoefPoly NatIMonoid R
]
[     ZeroPoly1 : el Poly1
           = ZeroPoly NatIMonoid R
]
[     OnePoly1 : el Poly1
           = OnePoly NatIMonoid R
]
[     Monomial2Poly1 : Fun Monomial1 Poly1
           = Monomial2Poly NatIMonoid R
]
[     ConstPoly1 : Fun R.car Poly1
           = ConstPoly NatIMonoid R
]
[     IdPoly1 : Poly1.el
           = Monomial2Poly1.ap (Monomial1_intro.ap2 R.OneRg OneN)
]
[     PlusPoly1 : Fun2 Poly1 Poly1 Poly1
           = PlusPoly NatIMonoid R
]
[     NegPoly1 : Fun Poly1 Poly1
           = NegPoly NatIMonoid R
]
[     PlusPoly1_distrib
           : {f,g:el Poly1} {i:el Nat}
             Eq (CoefPoly1.ap2 (PlusPoly1.ap2 f g) i)
                (R.PlusRg.ap2 (CoefPoly1.ap2 f i) (CoefPoly1.ap2 g i))
           = CoefPoly_plus NatIMonoid R
]
[     TimesPoly1 : Fun2 Poly1 Poly1 Poly1
           = TimesPoly NatIMonoid R
]
[     PowerPoly1 : Fun2 Poly1 Nat Poly1
          = PowerRg PolyRing1
];

(* ================================================================================
   Define application f(x) and prove some additional lemma's.
*)

[Times_commut : Commutative R.TimesRg];

[     apP1 : Poly1.el -> R.obj -> R.obj
           = apP R NatIMonoid OneN R.PowerRg
]
[     ApP1 : Fun2 Poly1 R.car R.car
           = ApP R NatIMonoid OneN R.PowerRg
];

Goal {c,x:obj R} Eq (apP1 (ConstPoly1.ap c) x) c;
  intros;
  Refine apP_const;
  Refine PowerRg_zero;
Save apP1_const;

Goal apP1_plus : {f,g:el Poly1} {x:obj R}
                 Eq ((PlusPoly1.ap2 f g).apP1 x) (R.PlusRg.ap2 (apP1 f x) (apP1 g x));
  intros;
  Refine apP_plus;
Save;

Goal {f,g:el Poly1}{x:obj R}
     Eq (apP1 (TimesPoly1.ap2 f g) x) (R.TimesRg.ap2 (apP1 f x) (apP1 g x));
  intros;
  Refine apP_times;
  Refine Times_commut;
  Refine PowerRg_plus;
Save apP1_times;

Goal {f:el Poly1}{n:el Nat}{x:obj R}
     Eq (apP1 (PowerPoly1.ap2 f n) x) (R.PowerRg.ap2 (apP1 f x) n);
  intros;
  Refine apP_power;
  Refine Times_commut;
  Refine PowerRg_zero;
  Refine PowerRg_plus;
Save apP1_power;

Goal {x:obj R} Eq (apP1 IdPoly1 x) x;
  intros;
  Refine Eq_trans (R.TimesRg.ap2 R.OneRg (R.PowerRg.ap2 x OneN));
    Refine rZeroRg_ident;
  Refine Eq_trans (R.PowerRg.ap2 x OneN);
    Refine lOneRg_ident;
  Refine PowerRg_one;
Save apP1_id;

(* ================================================================================
   Define the degree for polynomials in one variable.
*)

[R_discr : Discrete R.car];

[     Poly1_discr : Discrete Poly1
           = Poly_discr NatIMonoid R R_discr
]
[     degreeP1' : Poly1.el -> Poly1.el -> Nat.el
           = degreeP' NatIMonoid R R_discr
]
[     DegreeP1 : Fun Poly1 Nat
           = DegreeP NatIMonoid R R_discr
]
[     LCoefP1 : Fun Poly1 R.car
           = LCoefP NatIMonoid R R_discr
];

(* --------------------------------------------------------------------------------
*)

[     DegreeP1_intro
          : {f:el Poly1}{i:el Nat} ~(Eq (CoefPoly1.ap2 f i) R.ZeroRg) ->
                                   (LessEqN.ap2 (DegreeP1.ap f) i) ->
                                   Eq (DegreeP1.ap f) i
          = DegreeP_intro NatIMonoid R R_discr
]
[     DegreeP1_lemma0
          : {f|el Poly1}{i|el Nat} (LessN.ap2 (DegreeP1.ap f) i) ->
            Eq (CoefPoly1.ap2 f i) R.ZeroRg
          = degreeP_lemma1' NatIMonoid R R_discr
]
[     DegreeP1_zero
          : Eq (DegreeP1.ap ZeroPoly1) ZeroN
          = DegreeP_zero NatIMonoid R R_discr
]
[     DegreeP1_const
          : {x:obj R} Eq (DegreeP1.ap (ConstPoly1.ap x)) ZeroN
          = DegreeP_const NatIMonoid R R_discr
]
[     DegreeP1_plus
          : {f,g:el Poly1} LessEqN.ap2 (DegreeP1.ap (PlusPoly1.ap2 f g))
                                       (MaxN.ap2 (DegreeP1.ap f) (DegreeP1.ap g))
          = DegreeP_plus NatIMonoid R R_discr
]
[     DegreeP1_triangle
          : {f,g:el Poly1} LessEqN.ap2 (DegreeP1.ap (PlusPoly1.ap2 f g))
                                       (PlusN.ap2 (DegreeP1.ap f) (DegreeP1.ap g))
          = DegreeP_triangle NatIMonoid R R_discr
]
[     DegreeP1_lemma1
          : {f,g|el Poly1} (LessN.ap2 (DegreeP1.ap f) (DegreeP1.ap g)) ->
                           ~(Eq (LCoefP1.ap g) R.ZeroRg)
          = DegreeP_lemma1 NatIMonoid R R_discr
]
[     DegreePlusP1_lemma
          : {f,g|el Poly1} (LessN.ap2 (DegreeP1.ap f) (DegreeP1.ap g)) ->
                           Eq (DegreeP1.ap (PlusPoly1.ap2 f g)) (DegreeP1.ap g)
          = DegreePlusP_lemma NatIMonoid R R_discr
]
[     DegreePlusP1_lemma1
          : {f,g|el Poly1} (Eq (DegreeP1.ap f) ZeroN) ->
                           Eq (DegreeP1.ap (PlusPoly1.ap2 f g)) (DegreeP1.ap g)
          = DegreePlusP_lemma1 NatIMonoid R R_discr
]
[     DegreePlusP1_lemma2
          : {f,g|el Poly1} (Eq (DegreeP1.ap g) ZeroN) ->
                           Eq (DegreeP1.ap (PlusPoly1.ap2 f g)) (DegreeP1.ap f)
          = DegreePlusP_lemma2 NatIMonoid R R_discr
]
[      DegreeP1_plus_const
          : {P:el Poly1}{x:obj R}
            Eq (DegreeP1.ap (PlusPoly1.ap2 P (ConstPoly1.ap x))) (DegreeP1.ap P)
          = DegreeP_plus_const NatIMonoid R R_discr
]
[     DegreeP1_const_plus
          : {P:el Poly1}{x:obj R}
            Eq (DegreeP1.ap (PlusPoly1.ap2 (ConstPoly1.ap x) P)) (DegreeP1.ap P)
          = DegreeP_const_plus NatIMonoid R R_discr
];

(* --------------------------------------------------------------------------------
   Prove:

    (X * f)_(n+1) = f_n
    (f * X)_(n+1) = f_n
*)

Goal {f:el Poly1}{n:el Nat} Eq (CoefPoly1.ap2 (TimesPoly1.ap2 IdPoly1 f) (Succ.ap n))
      (CoefPoly1.ap2 f n);
  intros;
  TimesAP1 == TimesAP NatIMonoid R;
  TimesBP1 == TimesBP NatIMonoid R;
  TimesMP1 == TimesMP NatIMonoid R;
  Refine Eq_trans (CoefPoly1.ap2 (TimesAP1.ap2 R.OneRg (TimesBP1.ap2 OneN f))
                                 (Succ.ap n));
    Refine exten2 CoefPoly1 ? ?.Eq_refl;
    Refine Eq_trans (TimesMP1.ap2 (Monomial1_intro.ap2 R.OneRg OneN) f);
      Refine rZeroPoly_ident;
    Refine timesMP_lemma1;
  Refine Eq_trans (CoefPoly1.ap2 (TimesBP1.ap2 OneN f) (PlusN.ap2 OneN n));
    Refine +1 CoefPoly_timesBP;
  Refine exten2;
  Intros _;
  Refine Eq_trans (R.TimesRg.ap2 R.OneRg (CoefPoly1.ap2 (TimesBP1.ap2 OneN f) i));
    Refine CoefPoly_timesAP;
  Refine lOneRg_ident;
  Refine Eq_sym;
  Refine Eq_trans (Succ.ap (PlusN.ap2 ZeroN n));
    Refine lPlusSuccN;
  Refine exten ? ?.lZeroN_ident;
Save lCoefP1_id;

Goal {f:el Poly1}{n:el Nat} Eq (CoefPoly1.ap2 (TimesPoly1.ap2 f IdPoly1) (Succ.ap n))
      (CoefPoly1.ap2 f n);
  TimesPA1 == TimesPA NatIMonoid R;
  TimesPB1 == TimesPB NatIMonoid R;
  TimesPM1 == TimesPM NatIMonoid R;
  IdMon == Monomial1_intro.ap2 R.OneRg OneN;
  intros;
  Refine Eq_trans (CoefPoly1.ap2 (TimesPA1.ap2 (TimesPB1.ap2 f OneN) R.OneRg)
                                 (Succ.ap n));
    Refine exten2 CoefPoly1 ? ?.Eq_refl;
    Refine Eq_trans (PlusPoly1.ap2 (TimesPM1.ap2 f IdMon) (TimesPoly1.ap2 f ZeroPoly1));
      Refine TimesP_right;
    Refine Eq_trans (PlusPoly1.ap2 (TimesPM1.ap2 f IdMon) ZeroPoly1);
      Refine exten2 ??.Eq_refl; Refine rTimesP_zero;
    Refine Eq_trans (TimesPM1.ap2 f IdMon);
      Refine rZeroPoly_ident;
    Refine timesPM_lemma1;
  Refine Eq_trans (CoefPoly1.ap2 (TimesPB1.ap2 f OneN) (Succ.ap n));
    Refine +1 CoefPoly_timesPB;
  Refine exten2 ? ? ?.Eq_refl;
  Intros _;
  Refine Eq_trans (R.TimesRg.ap2 (CoefPoly1.ap2 (TimesPB1.ap2 f OneN) i) R.OneRg);
    Refine CoefPoly_timesPA;
  Refine rOneRg_ident;
Save rCoefP1_id;

Discharge R;

(* ================================================================================
*)

[F : Field] [F_discr : Discrete F.car] $[R : Ring = F.RingFd];

[FPolyRing1 : Ring = PolyRing1 R];

[FPoly1 : Set = Poly1 R];

[     CoefFPoly1 : Fun2 FPoly1 Nat F.car
          = CoefPoly1 R
];

[     ZeroFPoly1 : el FPoly1
          = ZeroPoly1 R
]
[     OneFPoly1 : el FPoly1
          = OnePoly1 R
];

[     ConstFPoly1 : Fun F.car FPoly1
          = ConstPoly1 R
]
[     IdFPoly1 : FPoly1.el
          = IdPoly1 R
];

[     PlusFPoly1 : Fun2 FPoly1 FPoly1 FPoly1
          = PlusPoly1 R
]
[     NegFPoly1 : Fun FPoly1 FPoly1
          = NegPoly1 R
]
[     TimesFPoly1 : Fun2 FPoly1 FPoly1 FPoly1
          = TimesPoly1 R
]
[     PowerFPoly1 : Fun2 FPoly1 Nat FPoly1
          = PowerPoly1 R
];

[     DegreeFP1 : Fun FPoly1 Nat
          = DegreeP1 R F_discr
];

[     DegreeFP1_times
          : {P,Q:el FPoly1} ~(Eq P ZeroFPoly1) -> ~(Eq Q ZeroFPoly1) ->
                            Eq (DegreeFP1.ap (TimesFPoly1.ap2 P Q))
                               (PlusN.ap2 (DegreeFP1.ap P) (DegreeFP1.ap Q))
          = DegreeFP_times NatIMonoid F F_discr
];

Goal Eq (DegreeFP1.ap (IdPoly1 R)) OneN;
  Refine DegreeP_monom NatIMonoid R F_discr;
  Equiv ~(Eq F.OneFd F.ZeroFd);
  Refine OneFd_not_zero;
Save DegreeP1_id;

[      DegreeFP1_plus
          : {f,g:el FPoly1} LessEqN.ap2 (DegreeFP1.ap (PlusFPoly1.ap2 f g))
                                        (MaxN.ap2 (DegreeFP1.ap f) (DegreeFP1.ap g))
          = DegreeP1_plus R F_discr
]
[     DegreeFP1_plus_const
         : {P:el FPoly1}{x:obj F}
     Eq (DegreeFP1.ap (PlusFPoly1.ap2 P (ConstFPoly1.ap x))) (DegreeFP1.ap P)
          = DegreeP1_plus_const R F_discr
]
[      DegreeFP1_const_times
          : {c|obj F} ~(Eq c F.ZeroFd) -> {f:el FPoly1}
            Eq (DegreeFP1.ap (TimesFPoly1.ap2 (ConstFPoly1.ap c) f)) (DegreeFP1.ap f)
          = DegreeFP_const_times NatIMonoid F F_discr
]
[     TimesFPoly1_not_zero
          : {P,P'|el FPoly1} ~(Eq P ZeroFPoly1) -> ~(Eq P' ZeroFPoly1) ->
            ~(Eq (TimesFPoly1.ap2 P P') ZeroFPoly1)
          = TimesFPoly_not_zero NatIMonoid F F_discr
]
[     PowerFPoly1_not_zero
          : {P|el FPoly1} ~(Eq P ZeroFPoly1) ->
            {n|el Nat} ~(Eq (PowerFPoly1.ap2 P n) ZeroFPoly1)
          = PowerFPoly_not_zero NatIMonoid F F_discr
];

Freeze DegreeP1;

Goal {P:el FPoly1} {n:el Nat} Eq (DegreeFP1.ap (PowerFPoly1.ap2 P n))
                                 (TimesN.ap2 n (DegreeFP1.ap P));
  intros _;
  Refine nat_ind [n:el Nat] Eq (DegreeFP1.ap (PowerFPoly1.ap2 P n))
                                (TimesN.ap2 n (DegreeFP1.ap P));
  Refine Eq_trans (DegreeFP1.ap OneFPoly1);
    Refine exten; Refine PowerRg_zero FPolyRing1;
  Refine Eq_trans ZeroN;
    Refine DegreeP1_const;
  Refine Eq_sym; Refine lTimesZeroN;

  intros;
  orE Poly1_discr R F_discr P ZeroFPoly1;
  intros;
    Refine Eq_trans (DegreeFP1.ap ZeroFPoly1);
      Refine exten;
      Refine Eq_trans (TimesFPoly1.ap2 (PowerFPoly1.ap2 P n) P);
        Refine PowerRg_succ FPolyRing1;
      Refine Eq_trans (TimesFPoly1.ap2 (PowerFPoly1.ap2 P n) ZeroFPoly1);
        Refine exten2 TimesFPoly1 ?.Eq_refl H;
      Refine rTimesZeroRg (PolyRing1 R);
    Refine Eq_trans ZeroN;
      Refine DegreeP1_zero;
    Refine Eq_sym;
    Refine Eq_trans (TimesN.ap2 (Succ.ap n) ZeroN);
      Refine +1 rTimesZeroN;
    Refine exten2 ? ?.Eq_refl;
    Refine Eq_trans (DegreeFP1.ap ZeroFPoly1);
      Refine exten DegreeFP1 H;
    Refine DegreeP1_zero;
  intros;
    Refine Eq_trans (DegreeFP1.ap (TimesFPoly1.ap2 (PowerFPoly1.ap2 P n) P));
      Refine exten; Refine PowerRg_succ FPolyRing1;
    Refine Eq_trans (PlusN.ap2 (DegreeFP1.ap (PowerFPoly1.ap2 P n)) (DegreeFP1.ap P));
      Refine DegreeFP1_times;
      Refine PowerFPoly1_not_zero H;
      Refine H;
    Refine Eq_trans (PlusN.ap2 (TimesN.ap2 n (DegreeFP1.ap P)) (DegreeFP1.ap P));
      Refine exten2 ? ih ?.Eq_refl;
    Refine Eq_sym; Refine lTimesSuccN;
Save DegreeP1_power;

(* ================================================================================
*)

[     PlusFPoly1_distrib
          : {f,g:el FPoly1} {i:el Nat}
            Eq (CoefFPoly1.ap2 (PlusFPoly1.ap2 f g) i)
               (F.PlusFd.ap2 (CoefFPoly1.ap2 f i) (CoefFPoly1.ap2 g i))
          = PlusPoly1_distrib R
]
[     lTimesFPoly1_const
          : {f:el FPoly1}{x:obj F}{i:el Nat}
            Eq (CoefFPoly1.ap2 (TimesFPoly1.ap2 (ConstFPoly1.ap x) f) i)
               (F.TimesFd.ap2 x (CoefFPoly1.ap2 f i))
          = lTimesPoly_const NatIMonoid R
];

Goal {c:obj F}{n:el Nat}
     Eq (CoefFPoly1.ap2 (PowerFPoly1.ap2 (PlusFPoly1.ap2 IdFPoly1 (ConstFPoly1.ap c)) n)
                       (Succ.ap n))
        F.ZeroFd;
  intros;
  Refine DegreeP1_lemma0 R F_discr;
  Refine extenRel ? ? ?.Eq_refl ?.LessN_succ;
  Refine Eq_sym;
  Refine Eq_trans
         (TimesN.ap2 n (DegreeFP1.ap (PlusFPoly1.ap2 IdFPoly1 (ConstFPoly1.ap c))));
    Refine DegreeP1_power;
  Refine Eq_trans (TimesN.ap2 n OneN);
    Refine +1 rOneN_ident;
  Refine exten2 ? ?.Eq_refl;
  Refine Eq_trans (DegreeFP1.ap IdFPoly1);
    Refine +1 DegreeP1_id;
  Refine DegreePlusP1_lemma2 R F_discr;
  Refine DegreeP1_const;
Save CoefFPoly1_lemma1;

Goal {c:obj F}{n:el Nat}
     Eq (CoefFPoly1.ap2 (PowerFPoly1.ap2 (PlusFPoly1.ap2 IdFPoly1
                                                         (ConstFPoly1.ap c)) n) n)
        F.OneFd;
  intros _;
  [Xc = PlusFPoly1.ap2 IdFPoly1 (ConstFPoly1.ap c)];
  Refine nat_ind [n:el Nat] Eq (CoefFPoly1.ap2 (PowerFPoly1.ap2 Xc n) n) F.OneFd;

  Refine Eq_trans (CoefFPoly1.ap2 OneFPoly1 ZeroN);
    Refine exten2 ? ? ?.Eq_refl; Refine PowerRg_zero FPolyRing1;
  Refine CoefPoly_const NatIMonoid R;

  intros n; [Xcn = PowerFPoly1.ap2 Xc n];
  Equiv (Eq (CoefFPoly1.ap2 Xcn n) F.OneFd) ->
        Eq (CoefFPoly1.ap2 (PowerFPoly1.ap2 Xc (succ n)) (succ n)) F.OneFd;
  intros ih;
  Refine Eq_trans (CoefFPoly1.ap2 (TimesFPoly1.ap2 Xcn Xc) (succ n));
    Refine exten2 ? ? ?.Eq_refl; Refine PowerRg_succ FPolyRing1;
  Refine Eq_trans (CoefFPoly1.ap2 (PlusFPoly1.ap2 (TimesFPoly1.ap2 Xcn IdFPoly1)
                        (TimesFPoly1.ap2 Xcn (ConstFPoly1.ap c))) (succ n));
    Refine exten2 ? ? ?.Eq_refl;
    Refine (DistribP NatIMonoid R).fst Xcn IdFPoly1 (ConstFPoly1.ap c); (* 1996 *)
  Refine Eq_trans (F.PlusFd.ap2 (CoefFPoly1.ap2 (TimesFPoly1.ap2 Xcn IdFPoly1) (succ n))
                    (CoefFPoly1.ap2 (TimesFPoly1.ap2 Xcn (ConstFPoly1.ap c)) (succ n)));
    Refine CoefPoly_plus NatIMonoid R;
  Refine Eq_trans (F.PlusFd.ap2 F.OneFd F.ZeroFd);
    Refine +1 rZeroFd_ident;
  Refine exten2;
  Refine Eq_trans (CoefFPoly1.ap2 Xcn n);
    Refine rCoefP1_id R;
  Refine ih;
  Refine Eq_trans (F.TimesFd.ap2 (CoefFPoly1.ap2 Xcn (succ n)) c);
    Refine rTimesPoly_const NatIMonoid R;
  Refine Eq_trans (F.TimesFd.ap2 F.ZeroFd c);
    Refine exten2 ? ? ?.Eq_refl; Refine CoefFPoly1_lemma1;
  Refine lTimesZeroFd;
Save FPoly_binon_lemma1;

Discharge F;

(* ================================================================================
*)

[      MapM1 : {R,R'|Ring}(Fun R.car R'.car) -> Fun R.Monomial1 R'.Monomial1
          = NatIMonoid.MapM
];

[R,R' | Ring] [h : Homomorphism R.applGroup R'.applGroup];

  $[f : Fun R.car R'.car = Homo_f h];

[     MapGrP1 : Fun R.Poly1 R'.Poly1
          = MapGrP NatIMonoid h
];

[     MapGrP1_distrib
          : {P:el R.Poly1} {i:el Nat}
            Eq (R'.CoefPoly1.ap2 (MapGrP1.ap P) i) (f.ap (R.CoefPoly1.ap2 P i))
          = MapGrP_distrib NatIMonoid h
]
[     MapGrP1_homo : Homomorphism R.PolyRing1.applGroup R'.PolyRing1.applGroup
           = MapGrP_homo NatIMonoid h
]
[     MapGrP1_zero : Eq (MapGrP1.ap R.ZeroPoly1) R'.ZeroPoly1
          = MapGrP_zero NatIMonoid h
]
[     MapGrP1_plus
          : {x,y:el R.Poly1}
            Eq (MapGrP1.ap (R.PlusPoly1.ap2 x y))
               (R'.PlusPoly1.ap2 (MapGrP1.ap x) (MapGrP1.ap y))
           = MapGrP_plus NatIMonoid h
]
[     MapGrP1_neg
          : {x:el R.Poly1} Eq (MapGrP1.ap (R.NegPoly1.ap x))
                              (R'.NegPoly1.ap (MapGrP1.ap x))
          = MapGrP_neg NatIMonoid h
];

[     MapGrP1_const
          : {x:obj R} Eq (MapGrP1.ap (R.ConstPoly1.ap x)) (R'.ConstPoly1.ap (f.ap x))
          = MapGrP_const NatIMonoid h
];

Discharge R;

Goal {R|Ring} {h:Endomorphism R.applGroup}
     (Involutive h.Homo_f) -> Involutive h.MapGrP1;
  intros R h _;
  Refine Polyn_ind ?? [p: el R.Poly1] Eq (h.MapGrP1.ap (h.MapGrP1.ap p)) p;
  Refine Eq_refl;
  intros;
    Refine exten2 (PlusMP ??); Refine +1 ih;
    Refine eq_Monomial_intro; Refine +1 Eq_refl;
    Refine H;
Save MapGrP1_invol;

[R,R' | Ring] [h : Homomorphism R R'];

  $[f : Fun R.car R'.car = Homo_f h];

[     MapRgP1 : Fun R.Poly1 R'.Poly1
          = MapRgP NatIMonoid h
];

[     MapRgP1_distrib
          : {P:el R.Poly1} {i:el Nat}
            Eq (R'.CoefPoly1.ap2 (MapRgP1.ap P) i) (f.ap (R.CoefPoly1.ap2 P i))
          = MapRgP_distrib NatIMonoid h
]
[     MapRgP1_homo : Homomorphism R.PolyRing1 R'.PolyRing1
          = MapRgP_homo NatIMonoid h
]
[     MapRgP1_zero : Eq (MapRgP1.ap R.ZeroPoly1) R'.ZeroPoly1
          = MapRgP_zero NatIMonoid h
]
[     MapRgP1_one
          : Eq (MapRgP1.ap R.OnePoly1) R'.OnePoly1
          = MapRgP_one NatIMonoid h
]
[     MapRgP1_plus
          : {x,y:el R.Poly1} Eq (MapRgP1.ap (R.PlusPoly1.ap2 x y))
                                (R'.PlusPoly1.ap2 (MapRgP1.ap x) (MapRgP1.ap y))
          = MapRgP_plus NatIMonoid h
]
[     MapRgP1_neg
          : {x:el R.Poly1} Eq (MapRgP1.ap (R.NegPoly1.ap x))
                              (R'.NegPoly1.ap (MapRgP1.ap x))
          = MapRgP_neg NatIMonoid h
]
[     MapRgP1_times
          : {x,y:el R.Poly1} Eq (MapRgP1.ap (R.TimesPoly1.ap2 x y))
                                (R'.TimesPoly1.ap2 (MapRgP1.ap x) (MapRgP1.ap y))
          = MapRgP_times NatIMonoid h
]
[      MapRgP1_power
          : {x:el R.Poly1}{n:el Nat} Eq (MapRgP1.ap (R.PowerPoly1.ap2 x n))
                                        (R'.PowerPoly1.ap2 (MapRgP1.ap x) n)
          = MapRgP_power NatIMonoid h
]
[      MapRgP1_const
          : {x:obj R} Eq (MapRgP1.ap (R.ConstPoly1.ap x)) (R'.ConstPoly1.ap (f.ap x))
          = MapRgP_const NatIMonoid h
];

Goal Eq (MapRgP1.ap R.IdPoly1) R'.IdPoly1;
  Refine exten2 (PlusMP NatIMonoid R') ? ?.Eq_refl;
  Refine eq_Monomial_intro; Refine +1 Eq_refl;
  Refine h.HomoRg_one;
Save MapRgP1_id;

Goal {P:el R.Poly1} {x:obj R}
     Eq (f.ap (apP1 R P x)) (apP1 R' (MapRgP1.ap P) (f.ap x));
  intros P' x;
  Refine list_ind [P:el R.Poly1] Eq (f.ap (apP1 R P x))
                              (apP1 R' (MapRgP1.ap P) (f.ap x));
  Refine h.HomoRg_zero;
  intros t P ih;
  [t0 = (CoefMon1 R).ap t] [t1 = (IndexMon1 R).ap t];
  Refine Eq_trans (R'.PlusRg.ap2 (f.ap (R.TimesRg.ap2 t0 (R.PowerRg.ap2 x t1)))
                                 (f.ap (apP1 R P x)));
    Refine h.HomoRg_plus;
  Refine exten2 R'.PlusRg; Refine +1 ih;
  Refine Eq_trans (R'.TimesRg.ap2 (f.ap t0) (f.ap (R.PowerRg.ap2 x t1)));
    Refine h.HomoRg_times;
  Refine exten2 ? ?.Eq_refl;
  Refine h.HomoRg_power;
Save apP1_lemma1;

Discharge R;

[      MapRgP1_invol
          : {R|Ring} {h:Homomorphism R R}
            (Involutive h.Homo_f) -> Involutive (MapRgP1 h)
          = MapRgP_invol NatIMonoid
];

(* ================================================================================
*)

[F,F' | Field] [h : Homomorphism F.GroupFd F'.GroupFd];

  $[f : Fun F.car F'.car = Homo_f h];

[     MapGrFP1 : Fun F.FPoly1 F'.FPoly1
          = MapGrP1 h
];

[     MapGrFP1_distrib
          : {P:el F.FPoly1} {i:el Nat}
            Eq (F'.CoefFPoly1.ap2 (MapGrFP1.ap P) i) (f.ap (F.CoefFPoly1.ap2 P i))
          = MapGrP1_distrib h
]
[     MapGrFP1_const
          : {x:obj F} Eq (MapGrFP1.ap (F.ConstFPoly1.ap x))
                         (F'.ConstFPoly1.ap (f.ap x))
          = MapGrP1_const h
];

Discharge h;

[h : Homomorphism F.RingFd F'.RingFd];

  $[f : Fun F.car F'.car = Homo_f h];

[     MapRgFP1 : Fun F.FPoly1 F'.FPoly1
          = MapRgP1 h
];

[     MapRgFP1_distrib
          : {P:el F.FPoly1} {i:el Nat}
            Eq (F'.CoefFPoly1.ap2 (MapRgFP1.ap P) i) (f.ap (F.CoefFPoly1.ap2 P i))
          = MapRgP1_distrib h
];

Discharge F;

Goal {F|Field} {h:Endomorphism F.GroupFd}
     (Involutive h.Homo_f) -> Involutive h.MapGrFP1;
  intros _;
  Refine MapGrP1_invol;
Save MapGrFP1_invol;

Unfreeze DegreeP1;
