
Module Nat_more Import Monoid;

(*
   Now we have monoids, we can use them to get a few definitions and
   lemma's for free. Also here we introduce substraction, odd, even,
   power and double.
*)

[     DoubleN : Fun Nat Nat
          = NatMonoid.SquareMN
];

Goal DoubleN_lemma1 : {x|el Nat} (Eq x ZeroN) -> Eq (DoubleN.ap x) ZeroN;
  Refine SquareMN_lemma1 NatMonoid;
Save;

Goal DoubleN_lemma2 : {x|el Nat} ~(Eq (DoubleN.ap x) ZeroN) -> ~(Eq x ZeroN);
  Refine SquareMN_lemma2 NatMonoid;
Save;

Goal ZeroSuccN : {n:Nat.el} or (Eq n ZeroN) (Ex [k:Nat.el] (Eq n (Succ.ap k))); 
  Refine nat_ind [n:Nat.el] or (Eq n ZeroN) (Ex ([k:Nat.el]Eq n (Succ.ap k)));
  orIL; Refine Eq_refl;
  intros; orIR; orE ih;
  intros; exI ?; Refine ZeroN; Refine exten Succ H;
  intros; exE H; intros; exI ?; Refine succ t; Refine exten Succ H1;
Save;

Goal ZeroOneSuccN : {n:el Nat}
         or3 (Eq n ZeroN) (Eq n OneN) (Ex[k:Nat.el] (Eq n (Succ.ap (Succ.ap k))));
  intros;
  orE ZeroSuccN n;
  intros; Refine or3_in1; Immed;
  intros; Refine H; intros m _; Qrepl H1;
  orE ZeroSuccN m;
  intros; Refine or3_in2; Refine exten Succ H2;
  intros; Refine or3_in3; Refine H2; intros k _;
    exI ?; Refine k; Refine exten Succ H3;
Save;

(* --------------------------------------------------------------------------------
   Some additional lemma's for the addition.
*)

Goal PlusN_cancel : Cancelation PlusN;
  andI;
  Intros ____;
    Refine ?4 a;
    Qrepl (PlusN_commut x a); Qrepl (PlusN_commut y a);
    Refine H;
  Refine nat_ind [a:nat]{x,x':nat} (Q (plusN x a) (plusN x' a)) -> Q x x';
    intros; Immed;
    intros; Refine ih; Refine Succ_inj H;
Save;

[     lPlusN_cancel : lCancelation PlusN
          = fst PlusN_cancel
]
[     rPlusN_cancel : rCancelation PlusN
          = snd PlusN_cancel
];

Freeze lPlusN_cancel rPlusN_cancel PlusN_cancel;

Goal PlusN_lemma2 : {a,b,c,d,e,f:el Nat}
           (Eq (PlusN.ap2 a b) (PlusN.ap2 c d)) ->
           (Eq (PlusN.ap2 c e) (PlusN.ap2 f b)) -> Eq (PlusN.ap2 a e) (PlusN.ap2 f d);
  intros;
  Refine lPlusN_cancel b;
  Refine Eq_trans (PlusN.ap2 (PlusN.ap2 b a) e); Refine PlusN_assoc;
  Qrepl (PlusN_commut b a);
  Qrepl H;
  Refine Eq_trans (PlusN.ap2 c (PlusN.ap2 d e)); Refine Eq_sym; Refine PlusN_assoc;
  Qrepl (PlusN_commut d e);
  Refine Eq_trans (PlusN.ap2 (PlusN.ap2 c e) d); Refine PlusN_assoc;
  Qrepl H1;
  Qrepl (PlusN_commut f b);
  Refine Eq_sym; Refine PlusN_assoc;
Save;

Goal PlusN_ZeroN : {x,y:el Nat} (Eq (PlusN.ap2 x y) ZeroN) ->
                                 ((Eq x ZeroN) /\ (Eq y ZeroN));
  intros _;
  Refine nat_ind [y:nat] (Q (plusN x y) ZeroN) -> ((Q x ZeroN) /\ (Q y ZeroN));
  intros; andI; Refine H; Refine Q_refl;
  intros; Refine Succ_not_zero (PlusN.ap2 x n) H;
Save;

[     plusN' : bop Nat.el
          = [x,y:nat] nat_iter y Succ.ap x
]
[     PlusN' : Fun2 Nat Nat Nat
          = QFun2 plusN'
];

Goal plusN_plusN' : {x,y:el Nat} Eq (PlusN.ap2 x y) (PlusN'.ap2 x y);
  Refine nat_double_elim [x,y:nat] Q (plusN x y) (plusN' x y);
  Refine Q_refl;
  intros; Refine lZeroN_ident;
  intros; Qrepl (lPlusSuccN n ZeroN); Refine exten Succ (n_ih ZeroN);
  intros; Refine exten Succ; Qrepl (lPlusSuccN n n'); Refine (n_ih (Succ.ap n'));
Save;

(* --------------------------------------------------------------------------------
   Some additional lemma's for multiplication.
*)

Goal TimesN_axiom_1 : {y:el Nat} Eq (TimesN.ap2 ZeroN y) ZeroN;
  Refine nat_ind [y:el Nat] Eq (TimesN.ap2 ZeroN y) ZeroN;
  Refine Eq_refl;
  intros;
     Equiv Eq (PlusN.ap2 ZeroN (TimesN.ap2 ZeroN n)) ZeroN;
    Qrepl ih; Refine Eq_refl;
Save;

Goal TimesN_axiom_2
   : {x,y:el Nat} Eq (TimesN.ap2 (Succ.ap x) y) (PlusN.ap2 (TimesN.ap2 x y) y);
  intros x;
  Refine nat_ind [y:nat] Q (timesN (succ x) y) (plusN (timesN x y) y);
  Refine Q_refl;
  intros y _;
    Equiv Q (PlusN.ap2 (Succ.ap x) (TimesN.ap2 (Succ.ap x) y))
            (PlusN.ap2 (TimesN.ap2 x (Succ.ap y)) (Succ.ap y));
    Qrepl ih;
    Refine Eq_trans (PlusN.ap2 (PlusN.ap2 (Succ.ap x) (TimesN.ap2 x y)) y);
      Refine PlusN_assoc;
    Qrepl lPlusSuccN x (TimesN.ap2 x y);
    Refine lPlusSuccN;
Save;

Goal TimesN_ZeroN
   : {x,y:el Nat} (Eq (TimesN.ap2 x y) ZeroN) -> or (Eq x ZeroN) (Eq y ZeroN);
  intros _;
  Refine nat_ind [y:nat] (Q (timesN x y) ZeroN) -> ((Q x ZeroN) \/ (Q y ZeroN));
  intros; orIR; Refine Q_refl;
  intros; orIL; Refine fst (PlusN_ZeroN x (TimesN.ap2 x n) H);
Save;

Goal TimesN_OneN
   : {x,y:el Nat} (Eq (TimesN.ap2 x y) OneN) -> and (Eq x OneN) (Eq y OneN);
  intros;
  Claim {a,b:nat} (Q (timesN a b) OneN) -> Q b OneN;
  andI;
    Refine ?+2 y x; Qrepl TimesN_commut y x; Immed;
    Refine ?+1 x y H;
  intros; Refine ZeroOneSuccN b;
  intros; Refine Succ_not_zero ZeroN; Qrepl H1.Q_sym; Qrepl H2; Refine Eq_refl;
  intros; Immed;
  intros; Refine ZeroSuccN a;
  intros;
    Refine Succ_not_zero ZeroN; Qrepl H1.Q_sym; Qrepl H3; Refine TimesN_axiom_1 b;
  intros;
    Refine H2; Refine H3; intros c _ c' _;
    Refine Succ_not_zero (PlusN.ap2 c (PlusN.ap2 c (TimesN.ap2 (Succ.ap c) c')));
    Equiv Eq (PlusN.ap2 c (Succ.ap (PlusN.ap2 c (TimesN.ap2 (Succ.ap c) c')))) ZeroN;
    Qrepl (lPlusSuccN c (TimesN.ap2 (Succ.ap c) c')).Q_sym;
    Refine Succ_inj;
    Qrepl (lPlusSuccN c (PlusN.ap2 (Succ.ap c) (TimesN.ap2 (Succ.ap c) c'))).Q_sym;
    Qrepl H4.Q_sym;
    Equiv Eq (TimesN.ap2 a (Succ.ap (Succ.ap c'))) OneN;
    Qrepl H5.Q_sym;
    Refine H1;
Save;

Goal TimesN_cancel
   : {a:el Nat}{x,x'|el Nat}
     (Eq (TimesN.ap2 a x) (TimesN.ap2 a x')) -> or (Eq a ZeroN) (Eq x x');
  intros _;
  Refine nat_double_elim [x,x':el Nat]
               (Eq (timesN a x) (timesN a x')) -> or (Eq a ZeroN) (Eq x x');
  intros; orIR; Refine Eq_refl;
  intros; orIL; orE (TimesN_ZeroN a (succ n') ?);
    Refine Q_sym H; Refine Id; intros; Refine Succ_not_zero ? H1;
  intros; orE (TimesN_ZeroN a (succ n));
    Refine H; intros; orIL; Refine H1; intros; Refine Succ_not_zero ? H1;
  intros; Refine n_ih n'; Refine lPlusN_cancel a; Refine H;
  intros; orIL; Immed;
  intros; orIR; Refine exten Succ; Immed;
Save;

(* --------------------------------------------------------------------------------
   Define the powering function.
*)

[     PowerN : Fun2 Nat Nat Nat
          = PowerMN NatMulMonoid
];

(* --------------------------------------------------------------------------------
   Define substraction.
*)

[     minusN : Nat.el -> Nat.el -> Nat.el
          = nat_rec (nat\ZeroN)
                    ([x:nat][ih_x:nat->el Nat] nat_rec (succ x) ([y,_:nat]ih_x y))
]
[     MinusN : Fun2 Nat Nat Nat
          = QFun2 minusN
];

Goal {x:el Nat} Eq (MinusN.ap2 x ZeroN) x;
  Refine nat_ind [x:el Nat] Eq (MinusN.ap2 x ZeroN) x;
  Refine Eq_refl;
  intros; Refine Eq_refl;
Save MinusN_lemma1;

(* --------------------------------------------------------------------------------
   Define the odd and even predicates.
*)

[     odd [n:el Nat] : Prop
          = Ex [p:el Nat] Eq (Succ.ap (DoubleN.ap p)) n
]
[     even [n:el Nat] : Prop
          = Ex [p:el Nat] Eq (DoubleN.ap p) n
]
[     Odd : Pred Nat
          = QPred odd
];
[     Even : Pred Nat
          = QPred even
];

Goal odd_or_even : {n:el Nat} (Odd.ap n) \/ (Even.ap n);
  Refine nat_ind [n:nat] or (odd n) (even n);
  orIR; exI ?; Refine ZeroN; Refine Eq_refl;
  intros; orE ih;
  intros; orIR; exE H; intros; exI ?; Refine succ t;
    Refine exten Succ;
    Qrepl lPlusSuccN t t; Immed;
  intros; orIL; exE H; intros; exI ?; Refine t; Refine exten Succ H1;
Save;

Goal {n|el Nat} (Even.ap (Succ.ap n)) -> Odd.ap n;
  intros; exE H; intros x _;
  Refine ExIntro; Refine PredN.ap x;
  Refine Succ_inj;
  Refine Eq_trans ?? H1;
  Refine Eq_trans (DoubleN.ap (Succ.ap (PredN.ap x)));
    Refine Eq_sym; Refine lPlusSuccN;
  Refine exten; Refine PredN_lemma1;
  Refine DoubleN_lemma2;
  Intros _; Refine Succ_not_zero n;
  Refine Eq_trans ? H1.Eq_sym;
  Qrepl H2; Refine Eq_refl;
Save EvenOdd;
  
Goal {n|el Nat} (Odd.ap (Succ.ap n)) -> Even.ap n;
  intros; exE H; intros x _;
  Refine ExIntro; Refine x; Refine Succ_inj; Refine H1;
Save OddEven;

Goal {x:el Nat} (Even.ap x) -> (Odd.ap x) -> absurd;
  Refine nat_elim [x:el Nat] (Even.ap x) -> (Odd.ap x) -> absurd;
  intros; Refine H1; intros x _; Refine Succ_not_zero ? H2;
  intros; Refine n_ih;
  Refine OddEven H1;
  Refine EvenOdd H;
Save notEvenAndOdd;
