
Module MapP Import Product;

(* This module extends a function to a function over n-ary tuples of sets. *)

(* --------------------------------------------------------------------------------
   For any two sets A and B and function f from A to B.
   Define a function MapP from A^n to B^n for any number n such that for i <= n

      (MapP <x_1..x_n>)_i  == f (x_i)
*)

[A,B | Set] [f : Fun A B];

Goal {n|nat} (Product A n).el -> (Product B n).el;
  Refine nat_elim_01 [n:nat] (Product A n).el -> (Product B n).el;
  intros; Refine star;
  Refine f.ap;
  intros n ih p; Refine tuple (f.ap p.first) (ih p.second);
Save mapP;

Goal {n:nat} extensional (mapP|n);
  Refine nat_elim_01 [n:nat] extensional (mapP|n);
  Intros ___; Refine Product_zero;
  Refine exten f;
  Intros _____; Refine pair;
  Refine exten f H1.fst;
  Refine H H1.snd;
Save mapP_exten;

Goal {n:nat} Fun (Product A n) (Product B n);
  intros;
  Refine Fun_intro;
  Refine +1 mapP_exten;
Save MapP;

Discharge A;

(* Show that the map of the identity function is an identity as well. *)

Goal {A|Set} {n|nat} {p:el (Product A n)} Eq p (mapP A.Iden p);
  intros _;
  Refine nat_elim_01 [n:nat] {p:el (Product A n)} Eq p (mapP A.Iden p);
  intros; Refine Product_zero;
  Refine Eq_refl;
  intros; Refine pair ?.Eq_refl; Refine H;
Save mapP_iden;

(* Show that the composition of maps equals the map of a compostion. *)

Goal {A,B,C|Set} {f:Fun A B} {g:Fun B C} {n|nat} {p:el (Product A n)}
      Eq (mapP g (mapP f p)) (mapP (Comp g f) p);
  intros _____;
  Refine nat_elim_01 [n:nat] {p:el (Product A n)}
                          Eq (mapP g (mapP f p)) (mapP (Comp g f) p);
  intros; Refine Product_zero;
  intros; Refine Eq_refl;
  intros; Refine pair ?.Eq_refl ?.H;
Save mapP_comp;

(* --------------------------------------------------------------------------------
   And now the same for a binary function f from A to B to C.
   Define a function Map2P from A^n to B^n to C^n for any number n such that
   for i <= n

      (Map2P <x_1..x_n> <y_1..y_n>)_i  == f (x_i) (y_i)
*)

[A,B,C | Set] [f : Fun2 A B C];

Goal {n|nat} (Product A n).el -> (Product B n).el -> (Product C n).el;
  Refine nat_elim_01 [n:nat] (Product A n).el -> (Product B n).el -> (Product C n).el;
  intros; Refine star;
  Refine f.ap2;
  intros n ih p q; Refine tuple (f.ap2 p.first q.first) (ih p.second q.second);
Save map2P;

Goal {n:nat} extensional2 (map2P|n);
  Refine nat_elim_01 [n:nat] extensional2 (map2P|n);
  Intros ______; Refine Product_zero;
  Intros ______; Refine exten2 ? H H1;
  Intros ________; Refine pair;
  Refine exten2 f H1.fst H2.fst;
  Refine H H1.snd H2.snd;
Save map2P_exten;

Goal {n:nat} Fun2 (Product A n) (Product B n) (Product C n);
  intros;
  Refine Fun2_intro;
  Refine +1 map2P_exten;
Save Map2P;

Discharge A;

(* --------------------------------------------------------------------------------
   Given an f satisfying some properties. Show that these properties
   are inherited by the map of f.
*)

(* Define a element of (product A.el n) such that for any x:el A, n:N

     el_n x n  ==  <x, ..., x>
*)

Goal {A|Set} A.el -> {n:nat} (Product A n).el;
  intros A e;
  Refine nat_elim_01 [n:nat] (Product A n).el;
  Refine star;
  Refine e;
  intros; Refine tuple e H;
Save el_n;

[A | Set] [f | Fun2 A A A] [e | el A];

[f_assoc : Associative f]
[f_commut : Commutative f]
[f_cancel : rCancelation f]
[e_ident : rIdentity f e]
[LE_dec : DecidableRel f.rLessEq];

Goal {n:nat} Associative (Map2P f n);
  Refine nat_elim_01 [n:nat] Associative (Map2P f n);
  Intros ___; Refine Product_zero;
  Refine f_assoc;
  Intros n ih x y z; Refine pair;
  Refine f_assoc;
  Refine ih;
Save Map2P_assoc;

Goal {n:nat} Commutative (Map2P f n);
  Refine nat_elim_01 [n:nat] Commutative (Map2P f n);
  Intros __; Refine Product_zero;
  Refine f_commut;
  Intros n ih x y; Refine pair;
  Refine f_commut;
  Refine ih;
Save Map2P_commut;

Goal {n:nat} rCancelation (Map2P f n);
  Refine nat_elim_01 [n:nat] rCancelation (Map2P f n);
  Intros ____; Refine Product_zero;
  Refine f_cancel;
  Intros __ x y z _;
  Refine H1; intros; Refine pair;
  Refine f_cancel ? H2;
  Refine H ? H3;
Save Map2P_cancel;

Goal {n:nat} rIdentity (Map2P f n) (el_n e n);
  Refine nat_elim_01 [n:nat] rIdentity (Map2P f n) (el_n e n);
  Intros _; Refine Product_zero;
  Refine e_ident;
  Intros _ ih x;
  Refine pair; Refine e_ident; Refine ih;
Save el_n_ident;

Goal {n:nat} DecidableRel (Map2P f n).rLessEq;
  Refine nat_elim_01 [n:nat] DecidableRel (Map2P f n).rLessEq;

  Intros t u; Refine inl;
  Refine ExIntro; Refine t; Refine Product_zero;

  Refine LE_dec;

  Intros _ n_ih v w;
  [v0 = v.first ] [w0 = w.first ];
  [v1 = v.second] [w1 = w.second];
  orE LE_dec v0 w0;

  intros; orE H; intros k0 _;
  orE n_ih v1 w1;

  intros; orE H2; intros k1 _;
  Refine inl; Refine ExIntro; Refine tuple k0 k1; Refine pair H1 H3;

  intros; Refine inr; Intros _; Refine H2;
  orE H3; intros k _; Refine ExIntro; Refine second k; Refine snd H4;

  intros; Refine inr; Intros _; Refine H;
  orE H1; intros k _; Refine ExIntro; Refine first k; Refine fst H2;
Save Map2P_rLessEq_dec;

Discharge A;
