
Module Homomorphism Import semantics Pred MapP Subsets;

(* Now we have defined structures, we can define the notion of a
homomorphism between two structures (models) of the same signature. *)

[s | Signature];
[ax,ax' | Axioms s] [M | Model ax] [M' | Model ax'];

(* --------------------------------------------------------------------------------
   Express what it is for a function f to respect the structure of a
   symbol c from the signature. This symbol can be a function or
   predicate symbol.

   For meta theory it is more convenient to work with n-ary products,
   for applications n-ary arrows is more suitable. We develop both and
   show they are equivalent.
*)

[h : Fun M.car M'.car];

Goal {n|nat} (arrow M.obj M.obj n) -> (arrow M'.obj M'.obj n) -> Prop;
  Refine nat_elim [n:nat] (arrow M.obj M.obj n) -> (arrow M'.obj M'.obj n) -> Prop;
  intros x x'; Refine Eq (h.ap x) x'; 
  intros n ih f f'; Refine {x:obj M} ih (f x) (f' (h.ap x));
Save h_resp_Functions;

Goal {n|nat} (arrow M.obj Prop n) -> (arrow M'.obj Prop n) -> Prop;
  Refine nat_elim [n:nat] (arrow M.obj Prop n) -> (arrow M'.obj Prop n) -> Prop;
  Refine iff;
  intros n ih f f'; Refine {x:obj M} ih (f x) (f' (h.ap x));
Save h_resp_Predicates;

[     homo_resp_Functions : s.FuncSymb -> Prop
          = [c:FuncSymb s] h_resp_Functions (intFunc M c).apn (intFunc M' c).apn
]
[     homo_resp_Predicates : s.PredSymb -> Prop
          = [c:PredSymb s] h_resp_Predicates (intPred M c).apn (intPred M' c).apn
];

[     homo_resp_Functions' : s.FuncSymb -> Prop
          = [c:FuncSymb s] {p:el (Product M.car c.FuncArity)}
            Eq (h.ap ((intFunc M c).app p)) ((intFunc M' c).app (mapP h p))
]
[     homo_resp_Predicates' : s.PredSymb -> Prop
          = [c:PredSymb s] {p:el (Product M.car c.PredArity)}
            Eq ((intPred M c).app p) ((intPred M' c).app (mapP h p))
];

Goal {c:FuncSymb s} c.homo_resp_Functions' -> c.homo_resp_Functions;
  intros _;
  Refine nat_elim_01 [n:nat] {f:nFunc M.car n}{f':nFunc M'.car n}
    ({p:el (Product M.car n)} Eq (h.ap (f.app p)) (f'.app (mapP h p))) ->
    (h_resp_Functions f.apn f'.apn);
  intros; Refine H star;
  intros; Refine H;
  Intros n ih f f' H z; Refine ih (f.ap1 z) (f'.ap1 (h.ap z));
  intros; Refine H (tuple z p);
Save homo_resp_func_lemma;

Goal {c:PredSymb s} c.homo_resp_Predicates' -> c.homo_resp_Predicates;
  intros _;
  Refine nat_elim_01 [n:nat] {f:nPred M.car n}{f':nPred M'.car n}
    ({p:el (Product M.car n)} iff (f.app p) (f'.app (mapP h p))) ->
    (h_resp_Predicates f.apn f'.apn);
  intros; Refine H star;
  intros; Refine H;
  Intros n ih f f' H z; Refine ih (f.ap1 z) (f'.ap1 (h.ap z));
  intros; Refine H (tuple z p);
Save homo_resp_pred_lemma;

Discharge h;

(* --------------------------------------------------------------------------------
   Now we can state what it is for two models to have a homomorphism.
*)

DischargeKeep M;

[     Homomorphism [M:Model ax] [M':Model ax'] : SET
          = <h : Fun M.car M'.car> ({c:FuncSymb s} homo_resp_Functions h c) /\
                                   ({c:PredSymb s} homo_resp_Predicates h c)
];

DischargeKeep ax;

[     Endomorphism [M : Model ax]
          = Homomorphism M M
]
[     Automorphism [M : Model ax]
          = <Endo : Endomorphism M> <f : UFunMdl M> Isomorphic Endo.1 f
];

(* --------------------------------------------------------------------------------
   Next define terms to build and decompose homomorphisms.
*)

[     Homomorphism_intro [h : Fun M.car M'.car]
                         [ax1 : {c:FuncSymb s} homo_resp_Functions h c]
                         [ax2 : {c:PredSymb s} homo_resp_Predicates h c]
          : Homomorphism M M'
          = (h, pair ax1 ax2 : Homomorphism M M')
];

Goal Homomorphism_intro' : {h : Fun M.car M'.car}
                           ({c:FuncSymb s} homo_resp_Functions' h c) ->
                           ({c:PredSymb s} homo_resp_Predicates' h c) ->
                           Homomorphism M M';
  intros h ax1 ax2;
  Refine Homomorphism_intro h;
  intros; Refine homo_resp_func_lemma ?? ?.ax1;
  intros; Refine homo_resp_pred_lemma ?? ?.ax2;
Save;

[h : Homomorphism M M'];

  [     Homo_f : Fun M.car M'.car
            = h.1
  ]
  [     Homo_resp_Functions : {c:FuncSymb s} homo_resp_Functions Homo_f c
            = h.2.fst
  ]
  [     Homo_resp_Predicates : {c:PredSymb s} homo_resp_Predicates Homo_f c
            = h.2.snd
  ];

  Goal Homo_resp_Functions' : {c:FuncSymb s} homo_resp_Functions' Homo_f c;
    intros _;
    Refine nat_elim_01 [n:nat] {f:nFunc M.car n}{f':nFunc M'.car n}
      (h_resp_Functions Homo_f f.apn f'.apn) ->
      ({p:el (Product M.car n)} Eq (Homo_f.ap (f.app p)) (f'.app (mapP Homo_f p)));
    intros; Refine H;
    intros; Refine H;
    Intros _ n_ih ____;
    Refine n_ih (f.ap1 p.first) (f'.ap1 (Homo_f.ap p.first)); Refine H;
    Refine Homo_resp_Functions;
  Save;

  Goal Homo_resp_Predicates' : {c:PredSymb s} homo_resp_Predicates' Homo_f c;
    intros _;
    Refine nat_elim_01 [n:nat] {f:nPred M.car n}{f':nPred M'.car n}
      (h_resp_Predicates Homo_f f.apn f'.apn) ->
      ({p:el (Product M.car n)} Eq (f.app p) (f'.app (mapP Homo_f p)));
    intros; Refine H;
    intros; Refine H;
    Intros _ n_ih ____;
    Refine n_ih (f.ap1 p.first) (f'.ap1 (Homo_f.ap p.first)); Refine H;
    Refine Homo_resp_Predicates;
  Save;

Discharge h;

(* --------------------------------------------------------------------------------
   Define the kernel of a homomorphism.
*)

[     kernel : (Homomorphism M M') -> M'.obj -> Subset M.car
          = [h:Homomorphism M M'] [id:obj M'] PreImage h.Homo_f (singleton id)
];

Discharge M;

(* ================================================================================
   Homomorphism are equal if there respective underlying functions are
   equal. So construct the set of homomorphisms between two models.
*)

Goal HOMOMORPHISM : (Model ax) -> (Model ax') -> Set;
  intros M1 M2;
  Refine Set_intro;
  Refine Homomorphism M1 M2;
  Intros h h'; Refine eq_Fun h.Homo_f h'.Homo_f;
  Intros _; Refine eq_Fun_refl;
  Intros __; Refine eq_Fun_sym;
  Intros ___; Refine eq_Fun_trans;
Save;

Discharge ax;

(* --------------------------------------------------------------------------------
   Define the identity homomorphism and the composition of homomorphisms.
*)

[ax1,ax2,ax3 | Axioms s] [M1 : Model ax1] [M2 : Model ax2] [M3 : Model ax3];

Goal IdenHomo : Homomorphism M1 M1;
  intros;
  Refine Homomorphism_intro';
  Refine Iden M1.car;
  Intros __; Refine extp (intFunc M1 c); Refine mapP_iden;
  Intros __; Refine extp (intPred M1 c); Refine mapP_iden;
Save;

Goal CompHomo : (Homomorphism M2 M3) -> (Homomorphism M1 M2) -> (Homomorphism M1 M3);
  intros H2 H1;
  h1 == H1.Homo_f  : Fun M1.car M2.car;
  h2 == H2.Homo_f  : Fun M2.car M3.car;
  h3 == Comp h2 h1 : Fun M1.car M3.car;
  Refine Homomorphism_intro';
  Refine h3;

  Intros __;
  f1 == intFunc M1 c : nFunc M1.car c.FuncArity;
  f2 == intFunc M2 c : nFunc M2.car c.FuncArity;
  f3 == intFunc M3 c : nFunc M3.car c.FuncArity;
  Equiv Eq (h2.ap (h1.ap (f1.app p))) (f3.app (mapP h3 p));
  Refine Eq_trans (h2.ap (f2.app (mapP h1 p)));
    Refine exten h2; Refine H1.Homo_resp_Functions';
  Refine Eq_trans (f3.app (mapP h2 (mapP h1 p)));
    Refine H2.Homo_resp_Functions';
  Refine extp; Refine mapP_comp;

  Intros __;
  f1 == intPred M1 c : nPred M1.car c.PredArity;
  f2 == intPred M2 c : nPred M2.car c.PredArity;
  f3 == intPred M3 c : nPred M3.car c.PredArity;
  Equiv iff (f1.app p) (f3.app (mapP h3 p));
  Refine Eq_trans (f2.app (mapP h1 p));
    Refine H1.Homo_resp_Predicates';
  Refine Eq_trans (f3.app (mapP h2 (mapP h1 p)));
    Refine H2.Homo_resp_Predicates';
  Refine extp; Refine mapP_comp;

Save;

Discharge ax1;

(* --------------------------------------------------------------------------------
   Show that IdenHomo is indeed an identity. Also show that the
   composition of homomorphisms is associative.
*)

Goal {ax,ax'|Axioms s} {M:Model ax} {M':Model ax'} {h:Homomorphism M M'}
     Eq|(HOMOMORPHISM M M') (CompHomo ??? (IdenHomo M') h) h;
  Intros;
  Refine Eq_refl;
Save lIdenHomo_ident;

Goal {ax,ax'|Axioms s} {M:Model ax} {M':Model ax'} {h:Homomorphism M M'}
     Eq|(HOMOMORPHISM M M') (CompHomo ??? h (IdenHomo M)) h;
  Intros;
  Refine Eq_refl;
Save rIdenHomo_ident;

Goal {ax,ax',ax'',ax'''|Axioms s}
     {M:Model ax} {M':Model ax'} {M'':Model ax''} {M''':Model ax'''}
     {f:Homomorphism M'' M'''} {g:Homomorphism M' M''} {h:Homomorphism M M'}
     Eq|(HOMOMORPHISM M M''') (CompHomo ??? (CompHomo ??? f g) h)
                              (CompHomo ??? f (CompHomo ??? g h));
  Intros;
  Equiv Eq (f.Homo_f.ap (g.Homo_f.ap (h.Homo_f.ap x))) ?;
  Refine Eq_refl;
Save CompHomo_assoc;

Discharge s;
