
Module AbsC Import AbsR Conjugate;

(* 
   Define the absolute value in C.
*)

[     absC : Cplx.el -> Real.el
          = [z:el Cplx] SqrtR.ap (ScProdC.ap2 z z)
]
[     AbsC : Fun Cplx Real
         = Fun_intro absC
                     ([x,x'|el Cplx][H:Eq|Cplx x x'] exten SqrtR (exten2 ScProdC H H))
];

(* --------------------------------------------------------------------------------
   Prove some basic lemma's for |_|.
*)

(*
    |x| is positive
*)

Goal {x:el Cplx} PositiveR.ap (AbsC.ap x);
  intros;
  Refine PositiveSqrtR;
  Refine PositivePlusR_compat;
  Refine PositiveSquareR;
  Refine PositiveSquareR;
Save AbsC_pos;

(*
    |0| = 0
*)

Goal Eq (AbsC.ap ZeroC) ZeroR;
  Refine Eq_trans (SqrtR.ap (PlusR.ap2 ZeroR ZeroR));
    Refine exten SqrtR; Refine exten2 PlusR; Refine ?+1; Refine rTimesZeroR;
  Refine Eq_trans (SqrtR.ap ZeroR);
    Refine exten; Refine rZeroR_ident;
  Refine SqrtZeroR;
Save AbsZeroC;

(*
    |1| = 1
*)

Goal Eq (AbsC.ap OneC) OneR;
  Refine Eq_trans (SqrtR.ap (PlusR.ap2 OneR ZeroR));
    Refine exten SqrtR; Refine exten2 PlusR; Refine rOneR_ident; Refine rTimesZeroR;
  Refine Eq_trans (SqrtR.ap OneR);
    Refine exten; Refine rZeroR_ident;
  Refine SqrtOneR;
Save AbsOneC;

(*
    |-1| = 1
*)

Goal Eq (AbsC.ap (NegC.ap OneC)) OneR;
  Refine Eq_trans (AbsC.ap OneC);
    Refine +1 AbsOneC;
  Refine exten SqrtR;
  Refine ScProdNegC;
Save AbsNegOneC;

(*
    |x y| = |x| |y|
*)

Goal {x,y:el Cplx} Eq (AbsC.ap (TimesC.ap2 x y)) (TimesR.ap2 (AbsC.ap x) (AbsC.ap y));
  intros;
  [xy = TimesC.ap2 x y] [cxy = Conj.ap xy]
  [xcx = TimesC.ap2 x (Conj.ap x)] [ycy = TimesC.ap2 y (Conj.ap y)];
  Refine Eq_trans (SqrtR.ap (TimesC.ap2 xy cxy).re);
    Refine exten SqrtR; Refine Eq_sym; Refine Conj_lemma2;
  Refine Eq_trans (SqrtR.ap (TimesR.ap2 (TimesC.ap2 x (Conj.ap x)).re
                                        (TimesC.ap2 y (Conj.ap y)).re));
    Next +1;
    Refine Eq_trans (TimesR.ap2 (SqrtR.ap (TimesC.ap2 x (Conj.ap x)).re)
                                (SqrtR.ap (TimesC.ap2 y (Conj.ap y)).re));
      Refine SqrtTimesR; Refine Conj_lemma5; Refine Conj_lemma5;
    Refine exten2;
    Refine exten SqrtR; Refine Conj_lemma2;
    Refine exten SqrtR; Refine Conj_lemma2;
  Refine exten;
  Refine Eq_trans (TimesC.ap2 xcx ycy).re;
    Refine exten Re; Refine Conj_lemma4;
  Refine Eq_trans (PlusR.ap2 (TimesR.ap2 xcx.re ycy.re) ZeroR);
    Refine +1 rZeroR_ident;
  Refine exten2 PlusR ?.Eq_refl;
  Refine Eq_trans (NegR.ap ZeroR);
    Refine +1 NegZeroR;
  Refine exten;
  Refine Eq_trans (TimesR.ap2 ZeroR ycy.im);
    Refine exten2 ? ? ?.Eq_refl; Refine Conj_lemma6;
  Refine lTimesZeroR;
Save AbsTimesC;

(*    2      2        2
    |x | = re (x) + im (x)
*)

Goal {x:el Cplx} Eq (AbsC.ap (SquareC.ap x))
                    (PlusR.ap2 (SquareR.ap x.re) (SquareR.ap x.im));
  intros;
  Refine Eq_trans (SquareR.ap (AbsC.ap x));
    Refine AbsTimesC;
  Refine SqrtR_lemma1;
  Refine ScProdC_pos;
Save AbsSquareC;

(*
    x != 0   ->   |x| != 0
*)

Goal {x|el Cplx} ~(Eq x ZeroC) -> ~(Eq (AbsC.ap x) ZeroR);
  intros;
  Refine SqrtR_not_zero;
  Refine SquarePosR_lemma1;
  Intros _; Refine H; andE PlusSquareR_zero H1;
    Refine eq_cplx_intro; Refine H2; Refine H3;
Save AbsC_not_zero;

(*
    x = 0   ->   |x| = 0
*)

Goal {x|el Cplx} (Eq x ZeroC) -> Eq (AbsC.ap x) ZeroR;
  intros;
  Refine Eq_trans (AbsC.ap ZeroC);
    Refine exten ? H;
  Refine Eq_trans (SqrtR.ap ZeroR);
    Refine +1 SqrtZeroR;
  Refine exten SqrtR;
  Refine Eq_trans (PlusR.ap2 ZeroR ZeroR);
    Refine +1 rZeroR_ident;
  Refine exten2 PlusR; Refine ?+1;
  Refine rTimesZeroR;
Save AbsC_lemma4;

(*
    |x| != 0   ->   x != 0
*)

Goal {x|el Cplx} ~(Eq (AbsC.ap x) ZeroR) -> ~(Eq x ZeroC);
  intros _; Refine Contrapos; Refine AbsC_lemma4;
Save AbsC_lemma5;

(*
    x != 0   ->   |1/x| = 1/|x|
*)

Goal {x|el Cplx} ~(Eq x ZeroC) -> Eq (AbsC.ap (RecipC.ap x)) (RecipR.ap (AbsC.ap x));
  intros;
  Refine Eq_trans (TimesR.ap2 (AbsC.ap (RecipC.ap x)) OneR);
    Refine Eq_sym; Refine rOneR_ident;
  Refine Eq_trans (TimesR.ap2 (AbsC.ap (RecipC.ap x))
                              (DivR.ap2 (AbsC.ap x) (AbsC.ap x)));
    Refine exten2 TimesR ?.Eq_refl;
    Refine Eq_sym; Refine rRecipR_invers; Refine AbsC_not_zero H;
  Refine Eq_trans (DivR.ap2 (TimesR.ap2 (AbsC.ap (RecipC.ap x)) (AbsC.ap x))
                            (AbsC.ap x));
    Refine TimesR_assoc;
  Refine Eq_trans (DivR.ap2 OneR (AbsC.ap x));
    Refine +1 lOneR_ident;
  Refine exten2 ? ? ?.Eq_refl;
  Refine Eq_trans (AbsC.ap (TimesC.ap2 (RecipC.ap x) x));
    Refine Eq_sym; Refine AbsTimesC;
  Refine Eq_trans (AbsC.ap OneC);
    Refine exten; Refine lRecipC_invers H;
  Refine AbsOneC;
Save AbsRecipC;

(*
    y != 0   ->   |x/y| = |x|/|y|
*)

Goal {x,y|el Cplx} ~(Eq y ZeroC) ->
     Eq (AbsC.ap (DivC.ap2 x y)) (DivR.ap2 (AbsC.ap x) (AbsC.ap y));
  intros;
  Refine Eq_trans (TimesR.ap2 (AbsC.ap x) (AbsC.ap (RecipC.ap y)));
    Refine AbsTimesC;
  Refine exten2 TimesR ?.Eq_refl;
  Refine AbsRecipC H;
Save AbsDivC;

(*
    |re(x)| <= |x|
*)

Goal {x:el Cplx} LessEqR.ap2 (AbsR.ap (Re.ap x)) (AbsC.ap x);
  intros;
  Refine SqrtLessEqR_compat; Refine PositiveSquareR;
  Refine LessEqPlusR_lemma1; Refine PositiveSquareR;
  Refine LessEqR_refl;
Save AbsC_lemma1;

(*
    |x| + re(x)  is positive
*)

Goal {x:el Cplx} PositiveR.ap (PlusR.ap2 (AbsC.ap x) (Re.ap x));
  intros;
  Refine extenPred; Refine MinusR.ap2 (AbsC.ap x) (NegR.ap (Re.ap x));
  Refine exten2 PlusR ?.Eq_refl; Refine NegR_invol;
  Refine LessEqR_trans (AbsR.ap (Re.ap x));
  Refine AbsLessEqR_lemma2;
  Refine AbsC_lemma1;
Save AbsC_lemma2;

(*
    |x| - re(x)  is positive
*)

Goal {x:el Cplx} PositiveR.ap (MinusR.ap2 (AbsC.ap x) (Re.ap x));
  intros;
  Refine LessEqR_trans (AbsR.ap (Re.ap x));
  Refine AbsLessEqR_lemma1;
  Refine AbsC_lemma1;
Save AbsC_lemma3;

(*   _
    |x| = |x|
*)

Goal {x:el Cplx} Eq (AbsC.ap (Conj.ap x)) (AbsC.ap x);
  intros;
  Refine exten SqrtR; Refine ScProd_lemma1;
Save AbsConjC;

(*
    ||x|| = |x|
*)

Goal {x:el Cplx} Eq (AbsR.ap (AbsC.ap x)) (AbsC.ap x);
  intros;
  Refine SqrtR_lemma2; Refine AbsC_pos;
Save AbsAbsC;

(*
    |cp(x)| = |x|   for real x
*)

Goal {x:el Real} Eq (AbsC.ap (Cp.ap x)) (AbsR.ap x);
  intros;
  Refine exten SqrtR;
  Refine Eq_trans (PlusR.ap2 (SquareR.ap x) ZeroR);
    Refine exten2 PlusR ?.Eq_refl; Refine rTimesZeroR;
  Refine rZeroR_ident;
Save AbsCp;

(*
    \forall x \exist y .  |y| = 1   &   |x| y = x
*)

Freeze TimesC;

Goal {x:el Cplx} Ex [y:el Cplx] (Eq (AbsC.ap y) OneR)
                             /\ (Eq (TimesC.ap2 (Cp.ap (AbsC.ap x)) y) x);
  intros; [cax = Cp.ap (AbsC.ap x)];
  orE Cplx_discr x ZeroC;

  intros;
  Refine ExIntro; Refine OneC;
  Refine pair AbsOneC;
  Refine Eq_trans cax;
    Refine rOneC_ident;
  Refine Eq_trans (Cp.ap (AbsC.ap ZeroC));
    Refine exten; Refine exten ? H;
  Refine Eq_trans (Cp.ap ZeroR);
    Refine exten ? AbsZeroC;
  Refine Eq_trans ZeroC;
    Refine Cp_zero;
  Refine H.Eq_sym;

  intros;
  Refine ExIntro; Refine DivC.ap2 x cax;
  Claim ~(Eq cax ZeroC);
  Refine pair;

  Refine Eq_trans (DivR.ap2 (AbsC.ap x) (AbsC.ap cax));
    Refine AbsDivC ?+3;
  Refine Eq_trans (DivR.ap2 (AbsC.ap x) (AbsC.ap x));
    Refine +1 rRecipR_invers (AbsC_not_zero H);
  Refine exten2 ? ?.Eq_refl;
  Refine Eq_trans (AbsR.ap (AbsC.ap x));
    Refine AbsCp;
  Refine AbsAbsC;

  Refine Eq_trans (TimesC.ap2 (DivC.ap2 x cax) cax);
    Refine TimesC_commut;
  Refine Eq_trans (TimesC.ap2 x (TimesC.ap2 (RecipC.ap cax) cax));
    Refine Eq_sym; Refine TimesC_assoc;
  Refine Eq_trans (TimesC.ap2 x OneC);
    Refine exten2 ? ?.Eq_refl; Refine lRecipC_invers ?+2;
  Refine rOneC_ident;

  Refine Cp_not_zero; Refine AbsC_not_zero H;
Save CplxSplit;

Unfreeze TimesC;

(*    _     2
    x x = |x |
*)

Goal {x:el Cplx} Eq (TimesC.ap2 x (Conj.ap x)) (Cp.ap (AbsC.ap (SquareC.ap x)));
  intros;
  Refine Eq_trans (Cp.ap (ScProdC.ap2 x x));
    Refine Conj_lemma3;
  Refine exten;
  Refine Eq_trans (SqrtR.ap (SquareR.ap (ScProdC.ap2 x x)));
    Refine Eq_sym; Refine SqrtR_lemma2;
    Refine ScProdC_pos;
  Refine exten; Refine ScProdC_square;
Save Conj_lemma7;
