
Module parameters;

(* SET is the sort of the carrier of sets. We want to be able to form
the set of relations, predicates, and subsets. So if T:SET, then
T->Prop should live in SET.  From this it follows that SET should at
least be defined as Type(0). *)

[     SET : Type(1)
          = Type(0)
];

(* When we define an inductive type X, we want to be able to eliminate
into the carrier of sets. So SET should live in TYPE. *)

[     TYPE
           = Type(1)
];

(*

So our type system needs at least

The sorts:  Prop, SET, TYPE
The axioms: Prop : SET : TYPE
            Prop : TYPE
The rules:  (Prop,Prop),
            (Prop,SET), (SET,SET),
            (SET,Prop), (TYPE,Prop)

*)

(* Some Lego modules also needs TYPE(-1) defined. *)

[     TYPE_minus1 : TYPE
           = Type(0)
];
