
Module Subsets Import Pred;

(* In this module, we define a notion of subset. A subset over a set A
is a function from A into the the set of propositions Omega. *)

[     Subset : Set -> SET
          = Pred
];

(*
   We will deal with subsets in a classical way.  That is, x \not\elem
   S is defined by

	\not (x \elem S)

   instead of a constructive approach as

	\forall y \elem S \rightarrow \apart x y
*)

[     Subsets : Set -> Set
          = Predicate
];

(* --------------------------------------------------------------------------------
   We have a variant of the comprehension axiom of set theory. Note
   that there is no danger for the Russell paradox to occur here.
*)

[     toSET : {T|SET} (T->Prop) -> SET
          = [T|SET] [phi:T->Prop] <x:T> phi x
];

[S | Set] [phi : Subset S];

[     eq_toSet : (toSET phi.ap) -> (toSET phi.ap) -> Prop
          = [x,y:toSET phi.ap] Eq x.1 y.1
];

Goal reflexive eq_toSet;
  Intros; Refine Eq_refl;
Save eq_toSet_refl;

Goal symmetric eq_toSet;
  Intros; Refine Eq_sym; Immed;
Save eq_toSet_sym;

Goal transitive eq_toSet;
  Intros; Refine Eq_trans; Immed;
Save eq_toSet_trans;

[     toSet : Set
          = Set_intro eq_toSet_refl eq_toSet_sym eq_toSet_trans
];

Discharge S;

[A | Set];

(* Define the relation `x is an element of S', where S is a subset of
S and x an element of A. *)

[     elem : A.el -> (Subsets A).el -> Prop
          = [x:el A] [P:Subset A] P.ap x
];

(* A subset is detachable if you know for every element if it belongs
to the subset or not. *)

[     detachable : (Subset A) -> Prop
          = DecidablePred|A
];

(* --------------------------------------------------------------------------------
   We are able to define the obvious operation on subsets like
   complement, union, intersection, et cetera.
*)

[S, T : el (Subsets A)];

[     void_ : A.el -> Prop
          = [x:el A] absurd
]
[     union_ : A.el -> Prop
          = [x:el A]  (elem x S) \/ (elem x T)
]
[     inter_ : A.el -> Prop
          = [x:el A]  (elem x S) /\ (elem x T)
]
[     compl_ : A.el -> Prop
          = [x:el A] ~(elem x S)
]
[     singleton_ : A.el -> A.el -> Prop
          = [x,y:el A] Eq y x
];

[     nonempty : Prop
          = Ex [x:el A] elem x S
];

Goal extensionalPred void_;
  Intros ____;
  Refine H1;
Save void__exten;

Goal extensionalPred compl_;
  Intros _____;
  Refine H1; Refine extenPred ? H.Eq_sym; Refine H2;
Save compl__exten;

Goal extensionalPred union_;
  Intros ____; orE H1;
  intros; Refine inl; Refine extenPred S H H2;
  intros; Refine inr; Refine extenPred T H H2;
Save union__exten;

Goal extensionalPred inter_;
  Intros ____; andE H1; Refine pair;
  Refine extenPred S H H2;
  Refine extenPred T H H3;
Save inter__exten;

Goal {x:el A} extensionalPred (singleton_ x);
  Intros _____; Refine Eq_trans ?  H.Eq_sym H1;
Save singleton__exten;

[     compl : el (Subsets A)
          = Pred_intro compl_ compl__exten
]
[     union : el (Subsets A)
          = Pred_intro union_ union__exten
]
[     inter : el (Subsets A)
          = Pred_intro inter_ inter__exten
]
[     singleton : A.el -> (Subsets A).el
          = [x:el A] Pred_intro x.singleton_ x.singleton__exten
];

Discharge A;

[     void [A:Set] : el (Subsets A)
          = Pred_intro (void_|A) (void__exten|A)
]
[     universe [A:Set] : (Subsets A).el
          = compl (void A)
];

(* --------------------------------------------------------------------------------
   Prove some lemma's mainly concerning subsets and complements.
*)

[A | Set];

Goal detachable (void A);
  Intros _; Refine inr; Refine Id;
Save void_detach;

Goal detachable (universe A);
  Intros _; Refine inl; Refine Id;
Save universe_detach;

(* For every subset R, R  <=  U *)

Goal {R:el (Subsets A)} Incl R (universe A);
  Intros ___; Refine trueprf;
Save universe_ok;

(* For every detachable subset R, R \/ -R  = U *)

Goal {R|el (Subsets A)} (detachable R) -> Eq (union R (compl R)) (universe A);
  intros; Refine Eq_pred_intro;
  Refine universe_ok;
  Intros __; Refine H;
Save union_compl;

(* For every subset R, R /\ -R  =  0 *)

Goal {R:el (Subsets A)} Eq (inter R (compl R)) (void A);
  Intros R z;
  Refine pair;
  intros; Refine H; intros; Refine H2 H1;
  intros; Refine H;
Save inter_compl;

(* For every subset R and S, -R U -S  <=  -(R /\ S) *)

Goal {R,S:el (Subsets A)} Incl (union (compl R) (compl S)) (compl (inter R S));
  Intros R S z _;
  Refine H;
  Intros __; Refine H1; Refine H2.fst;
  Intros __; Refine H1; Refine H2.snd;
Save DeMorgan_incl;

(* For every detachable subset R and S,  -R U -S  =  -(R /\ S) *)

Goal {R,S|el (Subsets A)} (detachable R) -> (detachable S) ->
     Eq (union (compl R) (compl S)) (compl (inter R S));
  intros; Refine Eq_pred_intro;
  Refine DeMorgan_incl;
  Intros z _;
  Refine H z; Refine H1 z;
  intros; Refine H2; Refine pair H4 H3;
  intros; Refine inr; Refine H3;
  intros; Refine inl; Refine H3;
Save DeMorgan;

(* For every subset R, R  <=  --R *)

Goal {R:el (Subsets A)} Incl R (compl (compl R));
  Intros ____;
  Refine H1; Refine H;
Save compl_compl_incl;

(* For every detachable subset R,   R  =  --R *)

Goal {R|el (Subsets A)} (detachable R) -> Eq R (compl (compl R));
  intros; Refine Eq_pred_intro;
  Refine compl_compl_incl;
  Intros __; Refine H x; Refine Id; intros; Refine H1 H2;
Save compl_compl;

Discharge A;

(* --------------------------------------------------------------------------------
   Operators over subsets can be turned into functions.
*)

[A : Set];

Goal extensional (compl|A);
  Refine extensional_Predicate;
  Intros P P' ____; Refine H1; Refine (H ?).snd; Refine H2;
Save compl_exten;

Goal extensional2 (union|A);
  Refine extensional2_Predicate;
  Intros P P' _ R R' _ z _; Refine H2;
  intros; Refine inl; Refine (H ?).fst H3;
  intros; Refine inr; Refine (H1 ?).fst H3;
Save union_exten;

Goal extensional2 (inter|A);
  Refine extensional2_Predicate;
  Intros P P' _ R R' _ z _;
  Refine pair;
  Refine (H z).fst; Refine H2.fst;
  Refine (H1 z).fst; Refine H2.snd;
Save inter_exten;

[     Void : el (Subsets A)
          = void A
]
[     Universe : el (Subsets A)
          = universe A
]
[     Compl : Fun (Subsets A) (Subsets A)
          = Fun_intro (compl|A) compl_exten
]
[     Union : Fun2 (Subsets A) (Subsets A) (Subsets A)
          = Fun2_intro (union|A) union_exten
]
[     Inter : Fun2 (Subsets A) (Subsets A) (Subsets A)
          = Fun2_intro (inter|A) inter_exten
];

Discharge A;
