
Module SqrtC Import AbsC;

(* 
   Construct a complex square root given the real square roots.
*)

Goal sqrtC : Cplx.el -> Cplx.el;
  intros x;
  [a = Re.ap x] [c = AbsC.ap x];
  Refine cart;
  Refine SqrtR.ap (DivR.ap2 (PlusR.ap2 c a) TwoR);
  Refine TimesR.ap2 (SignR.ap (Im.ap x)) (SqrtR.ap (DivR.ap2 (MinusR.ap2 c a) TwoR));
Save;

Goal SqrtC : Fun Cplx Cplx;
  Refine Fun_intro;
  Refine sqrtC;
  Intros x x' _; Refine eq_cplx_intro;
  Refine exten; Refine exten2 ? ? ?.Eq_refl; Refine exten2;
    Refine exten ? H; Refine exten ? H;
  Refine exten2; Refine exten; Refine exten ? H;
  Refine exten; Refine exten2 ? ? ?.Eq_refl; Refine exten2;
    Refine exten ? H; Refine exten ? H;
Save;

(* --------------------------------------------------------------------------------
                               ___ 2
   Prove     \forall x : C .  V x     =  x
*)

[x : el Cplx];

  $[a = Re.ap x] $[b = Im.ap x]
  $[c = AbsC.ap x];
  $[xpa = PlusR.ap2 c a] $[xma = MinusR.ap2 c a];
  $[C = DivR.ap2 xpa TwoR] $[D = DivR.ap2 xma TwoR];
  $[e = SqrtR.ap C] $[f = TimesR.ap2 (SignR.ap b) (SqrtR.ap D)];

Goal PositiveR.ap C;
  Refine PositiveTimesR_compat;
  Refine AbsC_lemma2;
  Refine PositiveRecipR_compat; Refine PositiveTwoR; Refine TwoR_not_zero;
Save SqrtC_lemma1_C;

Goal PositiveR.ap D;
  Refine PositiveTimesR_compat;
  Refine AbsC_lemma3;
  Refine PositiveRecipR_compat; Refine PositiveTwoR; Refine TwoR_not_zero;
Save SqrtC_lemma1_D;

Goal Eq (MinusR.ap2 (SquareR.ap e) (SquareR.ap f)) a;
  Expand e f;
  Refine Eq_trans (MinusR.ap2 C D);
    Refine exten2; Refine SqrtR_lemma1 SqrtC_lemma1_C;
    Refine Eq_trans (TimesR.ap2 (SquareR.ap (SignR.ap b)) (SquareR.ap (SqrtR.ap D)));
      Refine SquareTimesR;
    Refine Eq_trans (TimesR.ap2 OneR D);
      Refine exten2; Refine SignR_lemma1; Refine SqrtR_lemma1 SqrtC_lemma1_D;
    Refine lOneR_ident;
  Refine Eq_trans (DivR.ap2 (MinusR.ap2 xpa xma) TwoR);
    Refine Eq_sym; Refine rTimesMinusR_distrib;
  Refine Eq_trans (DivR.ap2 (TimesR.ap2 TwoR a) TwoR);
    Refine +1 DivR_lemma2; Refine +1 TwoR_not_zero;
  Refine exten2 ? ? ?.Eq_refl;
  Refine Eq_trans (PlusR.ap2 (PlusR.ap2 a c) (PlusR.ap2 (NegR.ap c) a));
    Refine exten2 PlusR; Refine PlusR_commut;
    Refine Eq_trans (MinusR.ap2 (NegR.ap c) (NegR.ap a));
      Refine Eq_sym; Refine PlusNegR_distrib;
    Refine exten2 PlusR ?.Eq_refl; Refine NegR_invol;
  Refine Eq_trans (PlusR.ap2 a (PlusR.ap2 c (PlusR.ap2 (NegR.ap c) a)));
    Refine Eq_sym; Refine PlusR_assoc;
  Refine Eq_trans (PlusR.ap2 a a);
    Refine +1 TwoR_lemma1;
  Refine exten2 ? ?.Eq_refl;
  Refine Eq_trans (PlusR.ap2 (MinusR.ap2 c c) a);
    Refine PlusR_assoc;
  Refine Eq_trans (PlusR.ap2 ZeroR a);
    Refine exten2 ? ? ?.Eq_refl; Refine rNegR_invers;
  Refine lZeroR_ident;
Save SqrtC_lemma1_Re;

Goal Eq (TimesR.ap2 TwoR (TimesR.ap2 e f)) b;
  Expand e f;
  Refine Eq_trans
         (TimesR.ap2 TwoR (TimesR.ap2 (SqrtR.ap (TimesR.ap2 C D)) (SignR.ap b)));
    Refine exten2 ? ?.Eq_refl;
    Refine Eq_trans (TimesR.ap2 (SqrtR.ap C) (TimesR.ap2 (SqrtR.ap D) (SignR.ap b)));
      Refine exten2 ? ?.Eq_refl; Refine TimesR_commut;
    Refine Eq_trans (TimesR.ap2 (TimesR.ap2 (SqrtR.ap C) (SqrtR.ap D)) (SignR.ap b));
      Refine TimesR_assoc;
    Refine exten2 ? ? ?.Eq_refl;
    Refine Eq_sym; Refine SqrtTimesR SqrtC_lemma1_C SqrtC_lemma1_D;
  Refine Eq_trans
         (TimesR.ap2 (TimesR.ap2 TwoR (SqrtR.ap (TimesR.ap2 C D))) (SignR.ap b));
    Refine TimesR_assoc;
  Refine Eq_trans (TimesR.ap2 (AbsR.ap b) (SignR.ap b));
    Refine +1 Eq_trans (TimesR.ap2 (SignR.ap b) (AbsR.ap b));
      Refine +1 TimesR_commut;
    Refine +1 SignAbsR_lemma1;
  Refine exten2 ? ? ?.Eq_refl;
  Refine Eq_trans (TimesR.ap2 (SqrtR.ap (SquareR.ap TwoR))
                              (SqrtR.ap (TimesR.ap2 C D)));
    Refine exten2 ? ? ?.Eq_refl; Refine Eq_sym; Refine SqrtR_lemma2 PositiveTwoR;
  Refine Eq_trans (SqrtR.ap (TimesR.ap2 (SquareR.ap TwoR) (TimesR.ap2 C D)));
    Refine Eq_sym; Refine SqrtTimesR;
    Refine PositiveSquareR; Refine PositiveTimesR_compat SqrtC_lemma1_C SqrtC_lemma1_D;
  Refine exten;
  Refine Eq_trans (TimesR.ap2 TwoR (TimesR.ap2 TwoR (TimesR.ap2 C D)));
    Refine Eq_sym; Refine TimesR_assoc;
  Refine Eq_trans (TimesR.ap2 TwoR
                              (DivR.ap2 (TimesR.ap2 (TimesR.ap2 TwoR C) xma) TwoR));
    Refine exten2 ? ?.Eq_refl;
    Refine Eq_trans (TimesR.ap2 (TimesR.ap2 TwoR C) D);
      Refine TimesR_assoc;
    Refine TimesR_assoc;
  Refine Eq_trans (DivR.ap2 (TimesR.ap2 TwoR (TimesR.ap2 (TimesR.ap2 TwoR C) xma))
                            TwoR);
    Refine TimesR_assoc;
  Refine Eq_trans (TimesR.ap2 (TimesR.ap2 TwoR C) xma);
    Refine DivR_lemma2 TwoR_not_zero;
  Refine Eq_trans (TimesR.ap2 xpa xma);
    Refine exten2 ? ? ?.Eq_refl;
    Refine Eq_trans (DivR.ap2 (TimesR.ap2 TwoR xpa) TwoR);
      Refine TimesR_assoc;
    Refine DivR_lemma2 TwoR_not_zero;
  Refine Eq_trans (MinusR.ap2 (SquareR.ap c) (SquareR.ap a));
    Refine SquareR_lemma1;
  Refine Eq_trans (MinusR.ap2 (PlusR.ap2 (SquareR.ap a) (SquareR.ap b)) (SquareR.ap a));
    Refine exten2 ? ? ?.Eq_refl;
    Refine SqrtR_lemma1; Refine PositivePlusR_compat;
    Refine PositiveSquareR; Refine PositiveSquareR;
  Refine Eq_trans (MinusR.ap2 (PlusR.ap2 (SquareR.ap b) (SquareR.ap a)) (SquareR.ap a));
    Refine exten2 ? ? ?.Eq_refl; Refine PlusR_commut;
  Refine Eq_trans (PlusR.ap2 (SquareR.ap b) (MinusR.ap2 (SquareR.ap a) (SquareR.ap a)));
    Refine Eq_sym; Refine PlusR_assoc;
  Refine Eq_trans (PlusR.ap2 (SquareR.ap b) ZeroR);
    Refine exten2 ? ?.Eq_refl; Refine rNegR_invers;
  Refine rZeroR_ident;
Save SqrtC_lemma1_Im;

Goal Eq (SquareC.ap (SqrtC.ap x)) x;
  Refine eq_cplx_intro;
  Refine SqrtC_lemma1_Re;
  Equiv Eq (PlusR.ap2 (TimesR.ap2 e f) (TimesR.ap2 f e)) b;
  Refine Eq_trans (PlusR.ap2 (TimesR.ap2 e f) (TimesR.ap2 e f));
    Refine exten2 ? ?.Eq_refl; Refine TimesR_commut;
  Refine Eq_trans (TimesR.ap2 TwoR (TimesR.ap2 e f));
    Refine TwoR_lemma1;
  Refine SqrtC_lemma1_Im;
Save SqrtC_lemma1;

Discharge x;

(* --------------------------------------------------------------------------------
                                 ___   ___
   Prove     \forall x,y : C .  V x = V y   ->  x = y
*)

Goal SqrtC_inj : Injection SqrtC;
  Intros x x' _;
  Refine Eq_trans (SquareC.ap (SqrtC.ap x));
    Refine Eq_sym; Refine SqrtC_lemma1;
  Refine Eq_trans (SquareC.ap (SqrtC.ap x'));
    Refine exten SquareC H;
  Refine SqrtC_lemma1;
Save;

(* --------------------------------------------------------------------------------
                                                               _____
   Prove     \forall x : C .  re(x) >= 0  ->  im(x) >= 0  ->  V x^2  = x
*)

Goal {x|el Cplx} (PositiveR.ap x.re) -> (PositiveR.ap x.im) ->
     Eq (SqrtC.ap (SquareC.ap x)) x;
  intros x a_pos b_pos;
  [a = re x] [b = im x] [sa = SquareR.ap a] [sb = SquareR.ap b];
  [dab = DoubleR.ap (TimesR.ap2 a b)];
  Refine eq_cplx_intro;

  Refine Eq_trans (SqrtR.ap (SquareR.ap a));
    Refine +1 SqrtR_lemma2 a_pos;
  Refine exten;
  Refine Eq_trans (DivR.ap2 (DoubleR.ap sa) TwoR);
    Refine +1 TwoR_lemma2;
  Refine exten2 ? ? ?.Eq_refl;
  Refine Eq_trans (PlusR.ap2 (PlusR.ap2 sa sb) (MinusR.ap2 sa sb));
    Refine exten2 PlusR ? ?.Eq_refl; Refine AbsSquareC;
  Refine Eq_trans (PlusR.ap2 (PlusR.ap2 sa (MinusR.ap2 sa sb)) sb);
    Refine rPlusR_commut;
  Refine Eq_trans (PlusR.ap2 (MinusR.ap2 (DoubleR.ap sa) sb) sb);
    Refine exten2 ? ? ?.Eq_refl; Refine PlusR_assoc;
  Refine Eq_trans (PlusR.ap2 (DoubleR.ap sa) (PlusR.ap2 (NegR.ap sb) sb));
    Refine Eq_sym; Refine PlusR_assoc;
  Refine Eq_trans (PlusR.ap2 (DoubleR.ap sa) ZeroR);
    Refine exten2 ? ?.Eq_refl; Refine lNegR_invers;    
  Refine rZeroR_ident;

  Refine Eq_trans (TimesR.ap2 (SignR.ap b) (AbsR.ap b));
    Refine +1 SignAbsR_lemma1;
  Refine exten2;
  Refine Eq_trans (SignR.ap dab);
    Refine exten; Refine exten2 ? ?.Eq_refl; Refine TimesR_commut;
    Refine Eq_trans (SignR.ap (TimesR.ap2 a b)); Refine SignDoubleR;
    Refine Eq_trans OneR; Refine SignTimesR a_pos b_pos;
    Refine (SignR_pos b_pos).Eq_sym;
  Refine exten;
  Refine Eq_trans (DivR.ap2 (DoubleR.ap sb) TwoR);
    Refine +1 TwoR_lemma2;
  Refine exten2 ? ? ?.Eq_refl;
  Refine Eq_trans (PlusR.ap2 (PlusR.ap2 sa sb) (PlusR.ap2 (NegR.ap sa) sb));
    Refine exten2 PlusR; Refine AbsSquareC;
    Refine Eq_trans (PlusR.ap2 (NegR.ap sa) (NegR.ap (NegR.ap sb)));
      Refine Eq_sym; Refine PlusNegR_distrib;
    Refine exten2 ? ?.Eq_refl; Refine NegR_invol;
  Refine Eq_trans (PlusR.ap2 (PlusR.ap2 sa (PlusR.ap2 (NegR.ap sa) sb)) sb);
    Refine rPlusR_commut;
  Refine exten2 ? ? ?.Eq_refl;
  Refine Eq_trans (PlusR.ap2 (MinusR.ap2 sa sa) sb);
    Refine PlusR_assoc;
  Refine Eq_trans (PlusR.ap2 ZeroR sb);
    Refine exten2 ? ? ?.Eq_refl; Refine rNegR_invers;
  Refine lZeroR_ident;
Save SqrtC_lemma2;

(* --------------------------------------------------------------------------------
                                                   ______      ___
                                                     ___      / _
   Prove     \forall x:C . x:R  ->  re(x) >= 0  ->  V x   =  V  x

*)

(* The assumption H is needed. For example:
     Conj (Sqrt (-4,0)) = Conj (0,2) = (0,-2)
     Sqrt (Conj (-4,0)) = Sqrt (-4,0) = (0,2)
*)

[x | el Cplx]
[H : (IsReal.ap x) -> PositiveR.ap x.re];

Goal (IsReal.ap x) -> Eq (SqrtR.ap (DivR.ap2 (MinusR.ap2 (AbsC.ap x) x.re) TwoR)) ZeroR;
  intros;
  Refine Eq_trans (SqrtR.ap ZeroR);
    Refine +1 SqrtZeroR;
  Refine exten;
  Refine Eq_trans (DivR.ap2 ZeroR TwoR);
    Refine +1 lTimesZeroR;
  Refine exten2 ? ? ?.Eq_refl;
  Refine Eq_trans (MinusR.ap2 x.re x.re);
    Refine +1 rNegR_invers;
  Refine exten2 ? ? ?.Eq_refl;
  Refine Eq_trans (AbsR.ap x.re);
    Refine +1 AbsR_pos (H H1);
  Refine exten SqrtR;
  Refine Eq_trans (PlusR.ap2 (SquareR.ap x.re) ZeroR);
    Refine +1 rZeroR_ident;
  Refine exten2 PlusR ?.Eq_refl;
  Refine Eq_trans (SquareR.ap ZeroR);
    Refine exten SquareR H1;
  Refine rTimesZeroR;
Save SqrtConj_lemma1_A;

Goal Eq (Conj.ap (SqrtC.ap x)) (SqrtC.ap (Conj.ap x));
  Refine eq_cplx_intro;

  Equiv Eq (SqrtC.ap x).re (SqrtC.ap (Conj.ap x)).re;
  Refine exten SqrtR; Refine exten2 ? ? ?.Eq_refl; Refine exten2 ? ? ?.Eq_refl;
  Refine Eq_sym; Refine AbsConjC;

  Equiv Eq (NegR.ap (SqrtC.ap x).im) (SqrtC.ap (Conj.ap x)).im;
  Refine Eq_trans (TimesR.ap2 (NegR.ap (SignR.ap x.im))
                  (SqrtR.ap (DivR.ap2 (MinusR.ap2 (AbsC.ap x) x.re) TwoR)));
    Refine Eq_sym; Refine lTimesNegR_distrib;
  Refine Eq_trans (TimesR.ap2 (SignR.ap (NegR.ap x.im))
                  (SqrtR.ap (DivR.ap2 (MinusR.ap2 (AbsC.ap x) x.re) TwoR)));
    Next +1;
    Refine exten2 TimesR ?.Eq_refl; Refine exten; Refine exten2 ? ? ?.Eq_refl;
    Refine exten2 ? ? ?.Eq_refl; Refine Eq_sym; Refine AbsConjC;
  orE Real_discr x.im ZeroR;

  intros;
  Refine Eq_trans (TimesR.ap2 (NegR.ap (SignR.ap x.im)) ZeroR);
    Refine exten2 ? ?.Eq_refl; Refine SqrtConj_lemma1_A H1;
  Refine Eq_trans ZeroR;
    Refine rTimesZeroR;
  Refine Eq_trans (TimesR.ap2 (SignR.ap (NegR.ap x.im)) ZeroR);
    Refine Eq_sym; Refine rTimesZeroR;
  Refine exten2 ? ?.Eq_refl;
  Refine Eq_sym; Refine SqrtConj_lemma1_A H1;

  intros;
  Refine exten2 TimesR ? ?.Eq_refl; Refine Eq_sym; Refine SignNegR H1;
Save SqrtConj_lemma1;

Discharge x;

(* --------------------------------------------------------------------------------
                            ___
   Prove     \forall x:C . V x  : R  ->  x : R
*)

Goal {x|el Cplx} (IsReal.ap (SqrtC.ap x)) -> IsReal.ap x;
  intros;
  orE Real_discr x.im ZeroR;
  Refine Id;
  intros;
  Refine ConjIsReal;
  Refine SqrtC_inj;
  Refine Eq_trans (Conj.ap (SqrtC.ap x));
    Refine IsRealConj H;
  Refine SqrtConj_lemma1;
  intros; Refine H1 H2;
Save SqrtC_is_real;

Goal SqrtC_not_zero
   : {x|el Cplx} ~(Eq x ZeroC) -> ~(Eq (SqrtC.ap x) ZeroC);
  intros _; Refine Contrapos; intros;
  Refine Eq_trans (SquareC.ap (SqrtC.ap x));
    Refine Eq_sym; Refine SqrtC_lemma1;
  Refine Eq_trans (SquareC.ap ZeroC);
    Refine exten ? H;
  Refine rTimesZeroC;
Save;

Freeze TimesC;

Goal {x|el Cplx} (Eq (AbsC.ap x) OneR) ->
                 Eq (DivC.ap2 (SqrtC.ap x) (Conj.ap (SqrtC.ap x))) x;
  intros;
  [d = SqrtC.ap x];
  Refine Eq_trans (DivC.ap2 (SquareC.ap d) (TimesC.ap2 d (Conj.ap d)));
    Refine DivFd_lemma3 COMPLEX;
    Refine Conj_not_zero ?+1;
    Refine SqrtC_not_zero; Refine AbsC_lemma5; Intros _; Refine OneR_not_zero;
      Refine Eq_trans ? H.Eq_sym H1;
  Refine Eq_trans (TimesC.ap2 x OneC);
    Refine +1 rOneC_ident;
  Refine exten2 TimesC; Refine SqrtC_lemma1;
  Refine Eq_trans (RecipC.ap OneC);
    Refine +1 RecipOneC;
  Refine exten;
  Refine Eq_trans (Cp.ap (AbsC.ap (SquareC.ap d)));
    Refine Conj_lemma7;
  Refine eq_cplx_intro; Refine +1 Eq_refl;
  Refine Eq_trans (AbsC.ap x);
    Refine exten; Refine SqrtC_lemma1;
  Refine H;
Save SqrtC_lemma3;
