
Module Pred Import Set;

(* --------------------------------------------------------------------------------
   Define Predicates and relations as functions into the set Omega.
*)

[     Pred [A:Set] : SET
          = Fun A Omega
]
[     Rel [A,B:Set] : SET
          = Fun2 A B Omega
];

(* Predicates can been seen as a set. *)

[     Predicate [A:Set] : Set
          = Function A Omega
];

[     DecidablePred [A|Set][P:Pred A] : Prop
          = decidable_pred P.ap
]
[     DecidableRel [A|Set][R:Rel A A] : Prop
          = decidable_rel R.ap2
];

(* --------------------------------------------------------------------------------
   A slightly modified notion of extensionality is much more convenient to use.
*)

[A,B | Set];

[P : A.el -> Prop] [R : A.el -> B.el -> Prop];

[     extensionalPred : Prop
          = {x,x'|A.el} (Eq x x') -> (P x) -> P x'
]
[     extensionalRel : Prop
          = {x,x'|A.el} (Eq x x') -> {y,y'|B.el} (Eq y y') -> (R x y) -> R x' y'
];

Goal extensionalPred -> (extensional|A|Omega P);
  Intros ____; Refine pair; Refine H H1; Refine H H1.Eq_sym;
Save extensionalPred_elim;

Goal extensionalRel -> (extensional2|A|B|Omega R);
  Intros _______; Refine pair; Refine H H1 H2; Refine H H1.Eq_sym H2.Eq_sym;
Save extensionalRel_elim;

[     Pred_intro : extensionalPred -> Pred A
          = [H:extensionalPred] Fun_intro|?|Omega P H.extensionalPred_elim
]
[     Rel_intro : extensionalRel -> Rel A B
          = [H:extensionalRel] Fun2_intro|?|?|Omega R H.extensionalRel_elim
];

Discharge P;

[P : Pred A] [R : Rel A B];

[     extenPred : extensionalPred P.ap
          = [x,x'|el A] [H:Eq x x'] fst (exten P H)
]
[     extenRel : extensionalRel R.ap2
          = [x,x'|el A] [H:Eq x x'] [y,y'|el B] [H1:Eq y y'] fst (exten2 R H H1)
];

(* --------------------------------------------------------------------------------
   Define what it means to be total or unique for a relation.
*)

[     Totalrel [T,U|SET] [R:T->U->Prop] : Prop
          = {x:T} Ex [y:U] R x y
]
[     Uniquerel [T,U|SET] [eq:U->U->Prop] [R:T->U->Prop] : Prop
          = {x:T} {y,y':U} (R x y) -> (R x y') -> eq y y'
]
[     TotalRel : Prop
          = Totalrel R.ap2
]
[     UniqueRel : Prop
          = Uniquerel (Eq|B) R.ap2
];

Discharge A;

Goal {A,B|Set} {R:A.el->B.el->Prop}
     iff ({x:el A} ExOne [y:el B] R x y) ((Totalrel R) /\ (Uniquerel (Eq|B) R));
  intros; Refine pair;
  intros; Refine pair;
  Intros x; Refine (H x).fst; 
  Intros x; Refine (H x).snd;
  intros; Refine pair;
  Refine H.fst;
  Refine H.snd;
Save ExOne_lemma;

(* --------------------------------------------------------------------------------
   Again we can use Leibniz equality to form predicates and relations
   out of operations.
*)

[     QPred [S|SET] : (S->Prop) -> Pred S.QSet
          = QFun|S|Omega
]
[     QRel [S,T|SET] : (S->T->Prop) -> Rel S.QSet T.QSet
          = QFun2|S|T|Omega
];

(* --------------------------------------------------------------------------------
   All logical connectives could be redefined on the level of the set Omega.
*)

Goal extensional2|Omega|Omega|Omega and;
  Refine extensionalRel_elim;
  Intros _______; Refine pair;
  Refine fst H; Refine fst H2; Refine fst H1; Refine snd H2;
Save and_exten;

[     And : Fun2 Omega Omega Omega
          = Fun2_intro ? and_exten
];

Goal Idempotent And;
  Intros _;
  Refine pair; Refine fst;
  intros; Refine pair H H;
Save And_idempot;

Goal extensional2|Omega|Omega|Omega iff;
  Refine extensionalRel_elim;
  Intros _______; Refine pair;
  intros; Refine fst H1; Refine fst H2; Refine snd H; Refine H3;
  intros; Refine fst H; Refine snd H2; Refine snd H1; Refine H3;
Save iff_exten;

[     Iff : Fun2 Omega Omega Omega
          = Fun2_intro ? iff_exten
];

Goal rIdentity Iff trueProp;
  Intros _; Refine pair;
  Refine trueProp_lemma1;
  Refine trueProp_lemma2;
Save rIff_ident;

(* --------------------------------------------------------------------------------
   Define the notion of inclusion over subsets. Show it is a partial ordering.
*)

[T | SET];

[     incl : (T->Prop) -> (T->Prop) -> Prop
          = [P,P':T->Prop] {x:T} (P x) -> P' x
];

Goal reflexive incl;
  Intros __;
  Refine Id;
Save incl_refl;

Goal transitive incl;
  Intros S T U ____;
  Refine H1 x (H x H2);
Save incl_trans;

Discharge T;

(* Next switch from the level of types to the level of sets. *)

[A | Set];

[     Incl : {A|Set} (Pred A) -> (Pred A) -> Prop
          = [A|Set] [P,P':Pred A] incl P.ap P'.ap
];

Goal reflexive (Incl|A);
  Intros _; Refine incl_refl;
Save  Incl_refl;

Goal transitive (Incl|A);
  Intros ___; Refine incl_trans;
Save Incl_trans;

(* --------------------------------------------------------------------------------
   Prove some trivial lemma's which make reasoning over equality of
   subsets more convenient.
*)

Goal {R,S|el (Predicate A)} (Incl R S) -> (Incl S R) -> Eq R S;
  Intros ____ z;
  Refine pair ?.H ?.H1;
Save Eq_pred_intro;

Goal {R,S|el (Predicate A)} (Eq R S) -> ((Incl R S) /\ (Incl S R));
  intros; Refine pair;
  Intros _; Refine (H ?).fst;
  Intros _; Refine (H ?).snd;
Save Eq_pred_elim;

Goal {f:op (Predicate A).el}
    ({P,P'|el (Predicate A)} (Eq P P') -> Incl (f P) (f P')) -> extensional f;
  Intros __ P P' __;
  Refine Eq_pred_intro; Refine H H1; Refine H H1.Eq_sym;
Save extensional_Predicate;

Goal {f:bop (Predicate A).el}
    ({P,P'|el (Predicate A)} (Eq P P') ->
     {R,R'|el (Predicate A)} (Eq R R') -> Incl (f P R) (f P' R')) -> extensional2 f;
  Intros __ P P' _ R R' __;
  Refine Eq_pred_intro; Refine H H1 H2; Refine H H1.Eq_sym H2.Eq_sym;
Save extensional2_Predicate;

Discharge A;

(* --------------------------------------------------------------------------------
   Define the image and pre-image subset of a unary function.
*)

[A,B | Set] [f : Fun A B];

[    image [C:Pred A] : B.el -> Prop
          = [b:el B] Ex [a:el A] (C.ap a) /\ (Eq (f.ap a) b)
]
[    pre_image [C:Pred B] : A.el -> Prop
          = [a:el A] C.ap (f.ap a)
];

Goal {C:Pred A} extensionalPred (image C);
  Intros _ b b' __;
  exE H1; Intros a _; andE H2;
  exI ?; Refine +1 pair H3 ?;
  Refine Eq_trans b; Immed;
Save image_exten;

Goal {C:Pred B} extensionalPred (pre_image C);
  Intros _ a a' __;
  Refine extenPred; Refine +2 H1;
  Refine exten; Refine H;
Save pre_image_exten;

[     Image : A.Pred -> (Predicate B).el
          = [C:Pred A] Pred_intro ? C.image_exten
]
[     PreImage : B.Pred -> (Predicate A).el
          = [C:Pred B] Pred_intro ? C.pre_image_exten
];

Goal image_lemma_1
   : f.Injection -> {C:Pred A} Eq|(Function A Omega) C (PreImage (Image C));
  Intros inj __; andI;
  intros;
    exI ?; Refine +1 pair H; Refine Eq_refl;
  intros;
    exE H; intros x' _; andE H1; Refine extenPred; Refine +2 H2;
    Refine inj; Refine H3;
Save;

Goal image_lemma_2
   : f.Surjection -> {C:Pred B} Eq|(Function B Omega) C (Image (PreImage C));
  Intros surj __; andI;
  intros;
    exE surj x; intros x' _;
    exI ?; Refine x'; andI;
    Equiv C.ap (f.ap x'); Refine extenPred; Refine +1 Eq_sym; Immed;
  intros;
    exE H; intros x' _; andE H1; Refine extenPred; Immed;
Save;

Discharge A;

(* --------------------------------------------------------------------------------
*)

[A | Set] [R : Rel A A];
  [Reflexive     : Prop = reflexive R.ap2];
  [Irreflexive   : Prop = irreflexive R.ap2];
  [Symmetric     : Prop = symmetric R.ap2];
  [Transitive    : Prop = transitive R.ap2];
  [AntiSymmetric : Prop = antisymmetric (Eq|A) R.ap2];
  [Total         : Prop = total R.ap2];
Discharge A;

(* --------------------------------------------------------------------------------
   Define a notion of less-equal by using an existential quantifier.
*)

[A | Set] [f : Fun2 A A A];

[     rless_eq : A.el -> A.el -> Prop
          = [i,j:el A] Ex [k:el A] Eq (f.ap2 i k) j
]
[     lless_eq : A.el -> A.el -> Prop
          = [i,j:el A] Ex [k:el A] Eq (f.ap2 k i) j
];

Goal extensionalRel rless_eq;
  Intros _______;
  Refine H2; intros k _; Refine ExIntro; Refine k;
  Refine Eq_trans (f.ap2 x k);
    Refine exten2; Refine H.Eq_sym; Refine Eq_refl;
  Refine Eq_trans y;
    Refine H3; 
 Refine H1;
Save rless_eq_exten;

Goal extensionalRel lless_eq;
  Intros _______;
  Refine H2; intros k _; Refine ExIntro; Refine k;
  Refine Eq_trans (f.ap2 k x);
    Refine exten2; Refine Eq_refl; Refine H.Eq_sym;
  Refine Eq_trans y;
    Refine H3;
  Refine H1;
Save lless_eq_exten;

[      rLessEq : Rel A A
          = Rel_intro rless_eq rless_eq_exten
]
[      lLessEq : Rel A A
          = Rel_intro lless_eq lless_eq_exten
];

[     LessEq_resp_One [LessEq:Rel A A] [One:el A] : Prop
          = lowerbound LessEq.ap2 One
]
[     LessEq_resp_Times [LessEq:Rel A A] [Times:Fun2 A A A] : Prop
          = preserve2 LessEq.ap2 LessEq.ap2 LessEq.ap2 Times.ap2
];

Discharge A;
