
Module Poly_degree Import Poly;

(*
   Remark that our implementation of degree is a non-constructive
   one. We need that the ring R is discrete to be able to test whether
   a coefficient is equal to zero or not.
*)

[IMN : indexMonoid]

  $[B_discr : Discrete IMN.car            = indexMonoid_discr IMN];

  $[PlusB   : BFunMdl IMN                 = PlusIMN IMN];
  $[ZeroB   : obj IMN                     = ZeroIMN IMN];
  $[LessEqB : BRelMdl IMN                 = LessEqIMN IMN];
  $[LessB   : BRelMdl IMN                 = LessIMN IMN];
  $[MaxB    : BFunMdl IMN                 = Max IMN.IMN_total_order];

[R : Ring] [R_discr : Discrete R.car];

  $[Plus    : BFunMdl R                   = R.PlusRg ]
  $[Times   : BFunMdl R                   = R.TimesRg]
  $[Zero    : obj R                       = R.ZeroRg ]
  $[One     : obj R                       = R.OneRg  ]
  $[Neg     : UFunMdl R                   = R.NegRg  ];

  $[Poly    : Ring                        = PolyRing IMN R]
  $[ZeroP   : obj Poly                    = Poly.ZeroRg]
  $[OneP    : obj Poly                    = Poly.OneRg]
  $[NegP    : UFunMdl Poly                = Poly.NegRg]
  $[PlusP   : BFunMdl Poly                = Poly.PlusRg]
  $[TimesP  : BFunMdl Poly                = Poly.TimesRg];

  $[CoefP   : Fun2 Poly.car IMN.car R.car = CoefPoly IMN R];

  $[Monom       : Set                          = Monomial IMN R];
  $[CoefM       : Fun Monom R.car              = CoefMon  IMN R];
  $[IndexM      : Fun Monom IMN.car            = IndexMon IMN R];
  $[Plus_MP     : Fun2 Monom Poly.car Poly.car = PlusMP   IMN R];
  $[Monom_intro : Fun2 R.car IMN.car Monom     = Monomial_intro IMN R];

  $[ConstP      : Fun R.car Poly.car           = ConstPoly IMN R];

[     degreeP' [h:obj Poly] : Poly.obj -> IMN.obj
          = list_iter 
                      ZeroB
                      ([t:el Monom][ih:obj IMN]
                       if R_discr (CoefP.ap2 h (IndexM.ap t)) Zero
                                  ih
                                  (MaxB.ap2 (IndexM.ap t) ih))
]
[     degreeP [h:obj Poly] : obj IMN
          = degreeP' h h
]
[     lcoefP : Poly.obj -> R.obj
          = [f:obj Poly] CoefP.ap2 f (degreeP f)
];

Goal degreeP_lemma1
   : {f|obj Poly}{i|obj IMN} ~(Eq (CoefP.ap2 f i) Zero) -> (LessEqB.ap2 i (degreeP f));
  intros h i _;
  Refine list_ind ([f:obj Poly] ~(Eq (CoefP.ap2 f i) Zero) ->
                                LessEqB.ap2 i (degreeP' h f)) ? ? ? H;

  intros; Refine H1; Refine CoefPoly_zero;

  intros t f ih _; [t1 = IndexM.ap t] [tf : obj Poly = cons t f];
  Refine B_discr t1 i;
  intros;
    Refine extenRel ? H2 ?.Eq_refl;
    Refine extenRel ? ?.Eq_refl ? (Max_lemma1l ? ? ?); Refine +2 degreeP' h f;
    Refine Eq_sym; Refine if_false;
    Intros _; Refine H;
    Refine Eq_trans (CoefP.ap2 h t1); Refine exten2 ? ?.Eq_refl H2.Eq_sym; Refine H3;
  intros;
    Refine IMN.LessEqIMN_trans (degreeP' h f); 
    Refine ih;
      Intros _; Refine H1; Refine Eq_trans (CoefP.ap2 f i);
      Refine Eq_trans ? (CoefPoly_MP IMN R t f i);
      Refine if_false H2; Refine H3;
    Refine select_lemma ([z:obj IMN] LessEqB.ap2 (degreeP' h f) z);
    intros; Refine IMN.LessEqIMN_refl;
    intros; Refine extenRel ? ?.Eq_refl (Max_commut ? ? ?) (Max_lemma1l ? ? ?);
Save;

Goal degreeP_lemma1'
   : {f|obj Poly}{i|obj IMN} (LessB.ap2 (degreeP f) i) -> Eq (CoefP.ap2 f i) Zero;
  intros;
  orE R_discr (CoefP.ap2 f i) Zero;
  Refine Id;
  intros; Refine H1;  Refine H.fst (IMN.LessEqIMN_antisym H.snd (degreeP_lemma1 H1));
Save;

Goal degreeP_lemma2
   : {f|obj Poly} (Eq (lcoefP f) Zero) -> Eq (degreeP f) ZeroB;
  intros h;
  Refine list_ind [f:obj Poly] (Eq (CoefP.ap2 h (degreeP' h f)) Zero) ->
                                Eq (degreeP' h f) ZeroB;
  intros; Refine Eq_refl;
  intros t f ih _;
  [t1 = IndexM.ap t];
  [df = degreeP' h f] [dtf = degreeP' h (cons t f)];
  Claim (Eq dtf df) -> Eq dtf ZeroB;
  Refine R_discr (CoefP.ap2 h t1) Zero;
  intros; Refine ?19; Refine if_true H1;
  intros; Refine IMN.LessEqIMN_total t1 df;
  intros; Refine ?19;
    Refine Eq_trans (MaxB.ap2 t1 df); Refine if_false H1;
    Refine Max_lemma2r ? H2;
  intros; Refine H1;
    Refine Eq_trans (CoefP.ap2 h dtf); Refine +1 H;
    Refine exten2 ? h.Eq_refl;
    Refine Eq_sym; Refine Eq_trans (MaxB.ap2 t1 df);
    Refine if_false H1;
    Refine Max_lemma2l ? H2;
  intros;
    Refine Eq_trans df; Refine H1;
    Refine ih;
    Refine Eq_trans (CoefP.ap2 h dtf);
      Refine exten2 ? ?.Eq_refl; Refine H1.Eq_sym;
    Refine H;
Save;

Goal degreeP_lemma3 : {f|obj Poly} (Eq (lcoefP f) Zero) -> Eq f ZeroP;
  Intros ___;
  Refine R_discr (CoefP.ap2 f i) Zero;
  intros; Refine Eq_trans Zero H1 ?.Eq_sym; Refine CoefPoly_zero;
  intros;
  Refine Eq_trans Zero ??.Eq_sym; Refine +1 CoefPoly_zero;
  Refine Eq_trans (lcoefP f); Refine +1 H;
  Refine exten2 CoefP f.Eq_refl;
  Refine IMN.LessEqIMN_antisym;
  Refine degreeP_lemma1 H1;
  Refine extenRel ? ? i.Eq_refl (IMN.LessEqIMN_zero i);
  Refine (degreeP_lemma2 H).Eq_sym;
Save;

Goal degreeP_lemma4 : {f|obj Poly} (Eq f ZeroP) -> Eq (lcoefP f) Zero;
  intros h _;
  Refine list_ind [f:obj Poly] Eq (CoefP.ap2 h (degreeP' h f)) Zero;
  Refine CoefPoly_zerop; Refine H;
  intros t f ih; [t1 = IndexM.ap t];
  Refine Eq_trans (CoefP.ap2 h (degreeP' h f));
  Refine exten2; Refine Eq_refl; Refine if_true;
  Refine CoefPoly_zerop; Refine H;
  Refine ih;
Save;

Goal ZeroP_dec : {f:obj Poly} (Eq f ZeroP) \/ ~(Eq f ZeroP);
  intros; [df = degreeP f];
  orE R_discr (CoefP.ap2 f df) Zero;
  intros; Refine inl; Refine degreeP_lemma3 H;
  intros; Refine inr; Intros _; Refine H; Refine CoefPoly_zerop; Refine H1;
Save;

Goal Poly_discr : Discrete Poly.car;
  Intros f g;
  orE ZeroP_dec (PlusP.ap2 f (NegP.ap g));
  intros; Refine inl;
    Refine Eq_trans (PlusP.ap2 f ZeroP);
      Refine Eq_sym; Refine rZeroPoly_ident;
    Refine Eq_trans (PlusP.ap2 f (PlusP.ap2 (NegP.ap g) g));
      Refine exten2 ? f.Eq_refl; Refine Eq_sym; Refine lNegPoly_invers;
    Refine Eq_trans (PlusP.ap2 (PlusP.ap2 f (NegP.ap g)) g);
      Refine PlusPoly_assoc;
    Refine Eq_trans (PlusP.ap2 ZeroP g);
      Refine exten2 ? ? g.Eq_refl; Refine H;
    Refine lZeroPoly_ident;
  intros; Refine inr; Intros _; Refine H;
    Refine Eq_trans (PlusP.ap2 g (NegP.ap g));
      Refine exten2 ? H1 ?.Eq_refl;
    Refine rNegPoly_invers;
Save;

Goal extensional degreeP;
  Intros f g _;
  [df = degreeP f] [dg = degreeP g];
  Refine ZeroP_dec f;

  intros;
    Refine Eq_trans ZeroB; Refine degreeP_lemma2; Refine degreeP_lemma4 H1;
    Refine Eq_sym; Refine degreeP_lemma2; Refine degreeP_lemma4;
    Refine Eq_trans f; Refine H.Eq_sym; Refine H1;

  intros;
    Refine IMN.LessEqIMN_antisym;
    Refine degreeP_lemma1;
      Intros _; Refine H1; Refine degreeP_lemma3;
      Refine Eq_trans (CoefP.ap2 g df); Refine H; Refine H2;
    Refine degreeP_lemma1;
      Intros _; Refine H1;
      Refine Eq_trans g; Refine H;
      Refine degreeP_lemma3;
      Refine Eq_trans (CoefP.ap2 f dg); Refine H.Eq_sym; Refine H2;
Save degreeP_exten;

[DegreeP : Fun Poly.car IMN.car = Fun_intro degreeP degreeP_exten];

Goal LCoefP : Fun Poly.car R.car;
  Refine Fun_intro;
  Refine lcoefP;
  Intros; Refine exten2; Refine +1 exten DegreeP; Immed;
Save;

Goal {f|obj Poly} ~(Eq f ZeroP) -> (Eq (DegreeP.ap f) ZeroB) ->
     Eq f (ConstP.ap (LCoefP.ap f));
  Intros ____;
  orE B_discr i ZeroB;
  intros;
    Refine Eq_trans (LCoefP.ap f) ??.Eq_sym;
      Refine +1 CoefPoly_const0 IMN R H2;
    Refine exten2 CoefP ?.Eq_refl;
    Refine Eq_trans ZeroB H2 H1.Eq_sym;
  intros;
    Refine Eq_trans Zero ??.Eq_sym;
      Refine +1 CoefPoly_const1 IMN R H2;
    Refine degreeP_lemma1';
    Refine extenRel ? H1.Eq_sym ?.Eq_refl;
    Refine LessIMN_lemma1 IMN H2;
Save LCoefP_const;

Goal {f:obj Poly}{i:obj IMN}
     ~(Eq (CoefP.ap2 f i) Zero) ->
     (LessEqB.ap2 (DegreeP.ap f) i) ->
     Eq (DegreeP.ap f) i;
  intros;
  Refine IMN.LessEqIMN_antisym H1 H.degreeP_lemma1;
Save DegreeP_intro;

(* --------------------------------------------------------------------------------
*)

Goal {f:obj Poly} Eq (degreeP' f ZeroP) ZeroB;
  intros;
  Refine Eq_refl;
Save DegreeP'_zero;

Goal {h:obj Poly}{t:el Monom}{f:obj Poly}
     Eq (degreeP' h (plusMP IMN R t f))
        (if R_discr (CoefP.ap2 h (IndexM.ap t)) Zero
                    (degreeP' h f)
                    (MaxB.ap2 (IndexM.ap t) (degreeP' h f)));
  intros;
  Refine Eq_refl;
Save DegreeP'_plusMP;

Goal Eq (DegreeP.ap ZeroP) ZeroB;
  intros;
  Refine DegreeP'_zero ZeroP;
Save DegreeP_zero;

Goal {t|el Monom}{f|obj Poly} (Eq f ZeroP) ->
     Eq (DegreeP.ap f) (DegreeP.ap ((TimesMP IMN R).ap2 t f));
  intros;
  Refine Eq_trans ZeroB ? ?.Eq_sym;
    Refine Eq_trans (DegreeP.ap ZeroP);
      Refine exten ? H;
    Refine DegreeP_zero;
  Refine Eq_trans (DegreeP.ap ZeroP);
    Refine +1 DegreeP_zero;
  Refine exten;
  Refine Eq_trans ((TimesMP IMN R).ap2 t ZeroP);
    Refine exten2 ? ?.Eq_refl H;
  Refine Eq_refl;
Save TimesMP_degree_zero;

Goal {M|el Monom} ~(Eq (CoefM.ap M) Zero) ->
                 Eq (DegreeP.ap ((Monomial2Poly IMN R).ap M)) (IndexM.ap M);
  intros;
  [P = (Monomial2Poly IMN R).ap M];
  Equiv Eq (if R_discr (CoefP.ap2 P (IndexM.ap M)) Zero
               ZeroB (MaxB.ap2 (IndexM.ap M) ZeroB)) (IndexM.ap M);
  Refine Eq_trans (MaxB.ap2 (IndexM.ap M) ZeroB);
    Refine +1 Max_lemma2l IMN.IMN_total_order; Refine +1 IMN.LessEqIMN_zero;
  Refine if_false;
  Intros _; Refine H;
  Refine Eq_trans (CoefP.ap2 P (IndexM.ap M));
    Refine +1 H1;
  Refine Eq_sym;
  Refine Eq_trans (Plus.ap2 (CoefM.ap M) Zero);
    Refine +1 rZeroRg_ident;
  Refine Eq_trans (Plus.ap2 (CoefM.ap M) (CoefP.ap2 ZeroP (IndexM.ap M)));
    Refine CoefPoly_MP_eq; Refine Eq_refl;
  Refine exten2 ??.Eq_refl; Refine CoefPoly_zero;
Save DegreeP_monom;

Goal {x:obj R} Eq (DegreeP.ap (ConstP.ap x)) ZeroB;
  intros;
  P == ConstP.ap x;
  Equiv Eq (if R_discr (CoefP.ap2 P ZeroB) Zero ZeroB (MaxB.ap2 ZeroB ZeroB)) ZeroB;
  Refine Eq_trans (if R_discr (CoefP.ap2 P ZeroB) Zero ZeroB ZeroB);
    Refine if_exten; Refine Id; Refine Id; Refine Eq_refl; Refine Max_idempot;
  Refine if_ident;
Save DegreeP_const;

(* --------------------------------------------------------------------------------
*)

Goal {f,g:obj Poly} LessEqB.ap2 (DegreeP.ap (PlusP.ap2 f g))
                                (MaxB.ap2 (DegreeP.ap f) (DegreeP.ap g));
  intros;
  [df = DegreeP.ap f] [dg = DegreeP.ap g] [dfg = DegreeP.ap (PlusP.ap2 f g)];
  Refine R_discr (CoefP.ap2 f dfg) Zero;
  intros;
  Refine R_discr (CoefP.ap2 g dfg) Zero;
  intros;
    Refine extenRel ? ? ?.Eq_refl (IMN.LessEqIMN_zero ?);
    Refine Eq_sym; Refine degreeP_lemma2;
    Refine Eq_trans (Plus.ap2 (CoefP.ap2 f dfg) (CoefP.ap2 g dfg));
      Refine CoefPoly_plus;
    Refine Eq_trans (Plus.ap2 Zero Zero);
      Refine +1 R.lZeroRg_ident;
    Refine exten2 ? H H1;
  intros;
    Refine IMN.LessEqIMN_trans dg;
    Refine degreeP_lemma1 H1;
    Refine Max_lemma1r;
  intros;
    Refine IMN.LessEqIMN_trans df;
    Refine degreeP_lemma1 H;
    Refine Max_lemma1l;
Save DegreeP_plus;

Goal {i|obj IMN}{t|el Monom}{f|obj Poly} (LessB.ap2 (IndexM.ap t) i) ->
        (LessB.ap2 (DegreeP.ap f) i) -> LessB.ap2 (DegreeP.ap (cons t f)) i;
  intros;
  orE R_discr (CoefM.ap t) Zero;

  intros; Refine extenRel ???.Eq_refl H1; Refine exten;
  Refine Eq_trans (Plus_MP.ap2 (Monom_intro.ap2 Zero (IndexM.ap t)) f);
    Refine Eq_sym; Refine PlusMP_lemma1 IMN R;
  Refine exten2 ???.Eq_refl; Refine eq_Monomial_intro; Refine H2.Eq_sym; Refine Eq_refl;

  intros;
  Refine LessEqLess_trans IMN.IMN_total_order (MaxB.ap2 (IndexM.ap t) (DegreeP.ap f));
  Refine LessEqIMN_trans IMN (MaxB.ap2 (DegreeP.ap (cons t ZeroP)) (DegreeP.ap f));
    Refine DegreeP_plus (cons t ZeroP) f;
  Refine extenRel ???.Eq_refl ?.(IMN.LessEqIMN_refl);
  Refine exten2 ??.Eq_sym ?.Eq_refl;
  Refine DegreeP_monom H2;
  Refine Max_Less_high_intro IMN.IMN_total_order;
  Refine H; Refine H1;
Save DegreeP_cons;

Goal {f,g:obj Poly} LessEqB.ap2 (DegreeP.ap (PlusP.ap2 f g))
                                (PlusB.ap2 (DegreeP.ap f) (DegreeP.ap g));
  Claim {f,g|obj Poly} (LessEqB.ap2 (DegreeP.ap f) (DegreeP.ap g)) ->
                       LessEqB.ap2 (DegreeP.ap (PlusP.ap2 f g))
                                   (PlusB.ap2 (DegreeP.ap f) (DegreeP.ap g));
  intros;
  Refine IMN.LessEqIMN_total (DegreeP.ap f) (DegreeP.ap g);
  Refine ?27;
  intros;
    Refine extenRel; Refine +4 ?27 H;
    Refine exten; Refine PlusPoly_commut; Refine IMN.PlusIMN_commut;
  intros;
    [df = DegreeP.ap f] [dg = DegreeP.ap g];
    Refine IMN.LessEqIMN_trans (MaxB.ap2 df dg);
      Refine DegreeP_plus;
    Refine extenRel ? ? ?.Eq_refl;
      Refine +1 Eq_sym; Refine +1 Max_lemma2r ? H;
    Refine extenRel ? ? ?.Eq_refl;
      Refine +1 IMN.lZeroIMN_ident;
    Refine IMN.LessEqIMN_plus; Refine IMN.LessEqIMN_zero; Refine IMN.LessEqIMN_refl;
Save DegreeP_triangle;

Goal {f,g|obj Poly} (LessB.ap2 (DegreeP.ap f) (DegreeP.ap g)) ->
                   ~(Eq (LCoefP.ap g) Zero);
  Intros ____;
  Refine fst H;
  Refine IMN.LessEqIMN_antisym; Refine snd H;
  Refine extenRel ? ? ?.Eq_refl; Refine +2 IMN.LessEqIMN_zero;
  Refine Eq_sym; Refine degreeP_lemma2 H1;
Save DegreeP_lemma1;

Goal {f,g|obj Poly} (LessB.ap2 (DegreeP.ap f) (DegreeP.ap g)) ->
                   Eq (DegreeP.ap (PlusP.ap2 f g)) (DegreeP.ap g);
  intros; Refine IMN.LessEqIMN_antisym;

  Refine extenRel ? ?.Eq_refl; Refine +2 DegreeP_plus;
  Refine Max_lemma2r; Refine snd H;

  Refine degreeP_lemma1;
  Intros _; Refine DegreeP_lemma1 H;
  Refine Eq_trans (Plus.ap2 Zero (LCoefP.ap g));
    Refine Eq_sym; Refine lZeroRg_ident;
  Refine Eq_trans (Plus.ap2 (CoefP.ap2 f (DegreeP.ap g)) (LCoefP.ap g));
    Refine exten2 ? ?.Eq_sym ?.Eq_refl; Refine degreeP_lemma1' H;
  Refine Eq_trans (CoefP.ap2 (PlusP.ap2 f g) (DegreeP.ap g));
    Refine Eq_sym; Refine CoefPoly_plus;
  Refine H1;
Save DegreePlusP_lemma;

Goal {f,g|obj Poly} (LessB.ap2 (DegreeP.ap g) (DegreeP.ap f)) ->
                   Eq (DegreeP.ap (PlusP.ap2 f g)) (DegreeP.ap f);
  intros;
  Refine Eq_trans (DegreeP.ap (PlusP.ap2 g f));
    Refine exten; Refine PlusRg_commut Poly;
  Refine DegreePlusP_lemma H;
Save DegreePlusP_lemma';

Goal {f,g|obj Poly} (Eq (DegreeP.ap f) ZeroB) ->
                   Eq (DegreeP.ap (PlusP.ap2 f g)) (DegreeP.ap g);
  intros;
  orE IMN.LessEqIMN_partit (DegreeP.ap g) (DegreeP.ap f);
  Refine +1 DegreePlusP_lemma;
  intros;
  Refine IMN.LessEqIMN_antisym;
  Refine extenRel ? ?.Eq_refl; Refine +2 DegreeP_triangle;
  Refine Eq_trans (PlusB.ap2 ZeroB (DegreeP.ap g));
    Refine +1 lZeroIMN_ident;
  Refine exten2 ? H ?.Eq_refl;
  Refine IMN.LessEqIMN_trans (DegreeP.ap f) H1;
  Refine extenRel ? H.Eq_sym ?.Eq_refl;
  Refine IMN.LessEqIMN_zero;
Save DegreePlusP_lemma1;

Goal {f,g|obj Poly} (Eq (DegreeP.ap g) ZeroB) ->
                   Eq (DegreeP.ap (PlusP.ap2 f g)) (DegreeP.ap f);
  intros;
  Refine Eq_trans (DegreeP.ap (PlusP.ap2 g f));
    Refine exten; Refine PlusPoly_commut;
  Refine DegreePlusP_lemma1 H;
Save DegreePlusP_lemma2;

Goal {P:obj Poly}{x:obj R}
     Eq (DegreeP.ap (PlusP.ap2 (ConstP.ap x) P)) (DegreeP.ap P);
  intros;
  c == ConstP.ap x;
  Refine IMN.LessEqIMN_antisym;

  Refine extenRel ? ?.Eq_refl; Refine MaxB.ap2 (DegreeP.ap c) (DegreeP.ap P);
    Refine +1 DegreeP_plus;
  Refine Max_lemma2r;
  Refine extenRel ? ?.Eq_sym ?.Eq_refl;
    Refine +2 IMN.LessEqIMN_zero; Refine DegreeP_const;

  orE B_discr ZeroB (DegreeP.ap P);
  intros; Refine extenRel ? ? ?.Eq_refl; Refine +1 H; Refine IMN.LessEqIMN_zero;
  intros; Refine degreeP_lemma1;
  Intros _; Refine H; Refine Eq_sym; Refine degreeP_lemma2;
  Refine Eq_trans (CoefP.ap2 (PlusP.ap2 c P) (DegreeP.ap P));
    Refine +1 H1;
  Refine Eq_sym; Refine CoefPoly_MP_neq; Refine H;
Save DegreeP_const_plus;

Goal {P:obj Poly}{x:obj R}
     Eq (DegreeP.ap (PlusP.ap2 P (ConstP.ap x))) (DegreeP.ap P);
  intros;
  Refine Eq_trans (DegreeP.ap (PlusP.ap2 (ConstP.ap x) P));
    Refine exten; Refine PlusPoly_commut;
  Refine DegreeP_const_plus;
Save DegreeP_plus_const;

Goal {m|el Monom}{f|obj Poly} ~(Eq (CoefM.ap m) Zero) ->
                              (LessB.ap2 (DegreeP.ap f) (IndexM.ap m)) ->
                              Eq (DegreeP.ap (cons m f)) (IndexM.ap m);
  intros;
  Refine Eq_trans (DegreeP.ap (PlusP.ap2 f ((Monomial2Poly IMN R).ap m)));
    Refine exten;
    Refine Eq_trans (PlusP.ap2 ((Monomial2Poly IMN R).ap m) f);
      Refine Eq_refl;
    Refine PlusRg_commut Poly;
  Refine Eq_trans (DegreeP.ap ((Monomial2Poly IMN R).ap m));
    Refine DegreePlusP_lemma;
    Refine extenRel ? ?.Eq_refl ?.Eq_sym H1; Refine ?+1;
  Refine DegreeP_monom H;
Save DegreeP_eq_cons;

(* ================================================================================
   Introduce the notion of ordered polynomials. They satisfy:

    - No leading zero's
    - The degrees of the monomials of the polynomial are strictly increasing

   This is a form of normal form of our representation of polynomials.
*)

Goal orderedP : Poly.obj -> Prop;
  Refine list_elim_elim Poly.obj\Prop;
  Refine trueProp;
  intros t; Refine ~(Eq (CoefM.ap t) Zero);
  intros t u f ih;
    Refine and3 ~(Eq (CoefM.ap t) Zero) (LessB.ap2 (IndexM.ap u) (IndexM.ap t)) ih;
Save;

Goal decidable_pred orderedP;
  Refine list_elim_elim [f:obj Poly] (orderedP f) \/ ~(orderedP f);
  Refine inl; Refine trueprf;
  intros t; orE R_discr (CoefM.ap t) Zero;
    intros; Refine inr; Intros _; Refine H1 H;
    intros; Refine inl; Refine H;
  intros t u f ih; orE R_discr (CoefM.ap t) Zero;
    intros; Refine inr; Intros _; Refine H1.and3_out1 H;
  intros;
  orE Less_dec IMN.IMN_total_order IMN.indexMonoid_discr (IndexM.ap u) (IndexM.ap t);
  intros; orE ih;
  intros; Refine inl; Refine pair3 H H1 H2;
  intros; Refine inr; Intros _; Refine H2 H3.and3_out3;
  intros; Refine inr; Intros _; Refine H1 H2.and3_out2;
Save orderedP_dec;

Goal {m:el Monom} ~(Eq (CoefM.ap m) Zero) -> orderedP (cons m ZeroP);
  intros _; Refine Id;
Save orderedP_monom;

Goal {m|el Monom}{f|obj Poly} (orderedP (cons m f)) -> orderedP f;
  intros _;
  Refine Polyn_ind IMN R [f:obj Poly] (orderedP (cons m f)) -> orderedP f;
  intros; Refine trueprf;
  intros n f __; Refine and3_out3 H;
Save orderedP_lemma1;

Goal {t,u|el Monom}{f|obj Poly} (orderedP (cons t (cons u f))) -> orderedP (cons t f);
  intros __;
  Refine Polyn_ind IMN R [f|obj Poly] (orderedP (cons t (cons u f))) ->
                                                              orderedP (cons t f);
  intros; Refine orderedP_monom; Refine and3_out1 H;
  intros v f __; Refine pair3;
  Refine and3_out1 H;
  Refine Less_trans ?? (and3_out2 (and3_out3 H)) (and3_out2 H);
  Refine and3_out3 (and3_out3 H);
Save orderedP_lemma2;

Goal {t|el Monom} ~(Eq (IndexM.ap t) ZeroB) ->
     {f|obj Poly} (orderedP (cons t f)) -> LessB.ap2 (DegreeP.ap f) (IndexM.ap t);
  intros __;
  Refine Polyn_ind IMN R
           [f|obj Poly] (orderedP (cons t f)) -> LessB.ap2 (DegreeP.ap f) (IndexM.ap t);
  intros; Refine LessOMN_lemma1 IMN.orderMonoidIMN; Refine H;
  intros u f __;
  Refine DegreeP_cons; Refine and3_out2 H1;
  Refine ih;
  Refine orderedP_lemma2 H1;
Save orderedP_lemma3;

Goal {m,n|el Monom}{f|obj Poly} (orderedP (cons m (cons n f))) ->
                                LessB.ap2 (DegreeP.ap (cons n f)) (IndexM.ap m);
  intros;
  Refine B_discr (IndexM.ap m) ZeroB;
  intros;
  Refine IMN.LessIMN_lemma2 (IndexM.ap n) (and3_out2 H);
  Refine H1;
  intros; Refine orderedP_lemma3 H1 H;
  (* too slow *)
Save orderedP_lemma4;

Goal {m|el Monom}{f|obj Poly} (orderedP (cons m f)) ->
                              Eq (DegreeP.ap (cons m f)) (IndexM.ap m);
  intros _;
  Refine Polyn_ind IMN R [f|obj Poly] (orderedP (cons m f)) ->
                                      Eq (DegreeP.ap (cons m f)) (IndexM.ap m);
  intros; Refine DegreeP_monom H;
  intros n f __;
  Refine DegreeP_eq_cons; Refine and3_out1 H;
  Refine orderedP_lemma4 H;
Save orderedP_lemma5;

Goal {m|el Monom} ~(Eq (CoefM.ap m) Zero) ->
     {f|obj Poly} (orderedP f) -> (LessB.ap2 (DegreeP.ap f) (IndexM.ap m)) ->
     orderedP (cons m f);
  intros __;
  Refine Polyn_ind IMN R
          [f|obj Poly](orderedP f)->(LessB.ap2 (DegreeP.ap f) (IndexM.ap m))->
          orderedP (cons m f);
  intros; Refine H;
  intros n f ___; Refine pair3 H ? H1;
  Refine extenRel ??? H2; Refine +1 Eq_refl;
  Refine orderedP_lemma5 H1;
Save orderedP_lemma6;

Goal {m,n|el Monom} ~(Eq (CoefM.ap n) Zero) -> (Eq (IndexM.ap m) (IndexM.ap n)) ->
     {f|obj Poly} (orderedP (cons m f)) -> (orderedP (cons n f));
  intros ____;
  Refine Polyn_ind IMN R [f|obj Poly] (orderedP (cons m f)) -> (orderedP (cons n f));
  intros; Refine H;
  intros t f ih _; Refine pair3;
  Refine H;
  Refine extenRel ? ?.Eq_refl H1; Refine and3_out2 H2;
  Refine and3_out3 H2;
Save orderedP_lemma7;

(* --------------------------------------------------------------------------------
   Now prove the main results concerning ordered polynomials:

    - For every polynomial there exists an order polynomial which is equal to it.

    - For every predicate P over polynomials,
      if (P.ap ZeroP) holds, and
      if for all monomial m which have a non-zero coefficent (P.ap m) holds, and
      if for all polynomial f, monomial m which have non-zero coefficient,
         such that (P.ap f) and (degree f < degree M), we have (P.ap m^f),
      then for all polynomail f, we have (P.ap f).

    The last result is a very useful induction scheme for
    polynomials. It allows us to hide our representation of polynomials.
*)

[t,u | el Monom]
[f,g | obj Poly];

$[u1 = CoefM.ap u] $[u2 = IndexM.ap u]
$[t1 = CoefM.ap t] $[t2 = IndexM.ap t];
$[tu1 = Plus.ap2 t1 u1];

[ug_ord : orderedP (Plus_MP.ap2 u g)]
[z : Eq (Plus_MP.ap2 u g) f]
[ih : {f:obj Poly} ((orderedP g) /\ (Eq g f)) ->
      Ex [h':obj Poly] (orderedP h') /\ (Eq h' (Plus_MP.ap2 t f))];

Goal {f:obj Poly} (Eq g f) -> Ex [h':obj Poly] (orderedP h') /\ (Eq h' (cons t f));
  intros;
  Refine ih ? (pair ? H);
  Refine orderedP_lemma1 ug_ord;
Save AllPolyOrdered_lemma0;

Goal (Eq u1 Zero) ->
     Ex [h:obj Poly] (orderedP h) /\ (Eq h (cons t f));
  intros;
  exE AllPolyOrdered_lemma0 f;
  Refine Eq_trans ? ?.Eq_sym z;
  Refine PlusMP_lemma3 IMN R H;
  intros h' _;
  Refine ExIntro; Refine h'; Refine H1;
Save AllPolyOrdered_lemma1;

Goal (Eq tu1 Zero) -> (Eq t2 u2) ->
     Ex [h:obj Poly] (orderedP h) /\ (Eq h (cons t f));
  intros;
  Refine ExIntro; Refine g;
  Refine pair (orderedP_lemma1 ug_ord);
  Refine Eq_trans (Plus_MP.ap2 t (cons u g));
    Refine +1 exten2 ? ?.Eq_refl z;
  Refine Eq_sym;
  Refine Eq_trans (Plus_MP.ap2 (Monom_intro.ap2 tu1 t2) g);
    Refine PlusMP_lemma4 IMN R H1;
  Refine PlusMP_lemma3 IMN R;
  Refine H;
Save AllPolyOrdered_lemma2;

Goal ~(Eq t1 Zero) -> (LessB.ap2 u2 t2) ->
     Ex [h:obj Poly] (orderedP h) /\ (Eq h (cons t f));
  intros;
  Refine ExIntro; Refine cons t (cons u g);
  Refine pair;
  Refine orderedP_lemma6 H ug_ord;
  Refine extenRel ? ?.Eq_sym ?.Eq_refl H1;
  Refine orderedP_lemma5 ug_ord;
  Refine exten2 Plus_MP ?.Eq_refl z;
Save AllPolyOrdered_lemma3;

Goal ~(Eq tu1 Zero) -> (Eq t2 u2) ->
     Ex [h:obj Poly] (orderedP h) /\ (Eq h (cons t f));
  intros;
  Refine ExIntro; Refine cons (Monom_intro.ap2 tu1 t2) g;
  Refine pair;
  Refine orderedP_lemma7 ? ? ug_ord; Refine H; Refine H1.Eq_sym;
  Refine Eq_trans (Plus_MP.ap2 t (cons u g));
    Refine Eq_sym; Refine PlusMP_lemma4 IMN R H1;
  Refine exten2 Plus_MP ?.Eq_refl z;
Save AllPolyOrdered_lemma4;

Goal ~(Eq u1 Zero) -> (LessB.ap2 t2 u2) ->
     Ex [h:obj Poly] (orderedP h) /\ (Eq h (cons t f));
  intros;
  [nu = (NegMon IMN R).ap u];
  Claim Eq g (Plus_MP.ap2 nu f);
  exE AllPolyOrdered_lemma0 (cons nu f) ?+1;

  intros h _;
  Refine ExIntro; Refine cons u h; Refine pair;
  Refine orderedP_lemma6 H H2.fst;
  Refine extenRel ?? ?.Eq_refl; Refine +1 exten DegreeP; Refine cons t g;
    Refine Eq_trans ?? H2.snd.Eq_sym; Refine exten2 Plus_MP ?.Eq_refl ?6;
  Refine DegreeP_cons H1;
  Refine orderedP_lemma3 ? ug_ord;
  Refine IMN.LessIMN_lemma2 ? H1;

  Refine Eq_trans (Plus_MP.ap2 u (Plus_MP.ap2 t (Plus_MP.ap2 nu f)));
    Refine exten2 Plus_MP ?.Eq_refl H2.snd;
  Refine Eq_trans (Plus_MP.ap2 t (Plus_MP.ap2 u (Plus_MP.ap2 nu f)));
    Refine PlusMP_commut;
  Refine exten2 ? ?.Eq_refl;
  Refine Eq_trans (Plus_MP.ap2 nu (Plus_MP.ap2 u f));
    Refine PlusMP_commut;
  Refine lPlusMP_invers;

  Refine Eq_trans (Plus_MP.ap2 nu (Plus_MP.ap2 u g));
    Refine Eq_sym; Refine lPlusMP_invers;
  Refine exten2 ? ?.Eq_refl z;
Save AllPolyOrdered_lemma5;

Discharge t;

Goal {f:obj Poly} Ex [g:obj Poly] (orderedP g) /\ (Eq g f);
  Refine Polyn_ind IMN R [f:obj Poly] Ex [h:obj Poly] (orderedP h) /\ (Eq h f);

  (* f == 0, take h == 0 *)
  Refine ExIntro; Refine ZeroP; Refine pair;
  Refine trueprf; Refine Eq_refl;

  intros t f' ih_f';
  exE ih_f'; intros g' _;
  orE R_discr (CoefM.ap t) Zero;

  (* t_1 = 0, take h == g *)
  intros;
  Refine ExIntro; Refine g';
  Refine pair H.fst;
  Refine Eq_trans ? H.snd ?.Eq_sym;
  Refine PlusMP_lemma3 IMN R H1;

  intros;
  Refine Polyn_ind IMN R [g:obj Poly] {f:obj Poly} ((orderedP g) /\ (Eq g f)) ->
         Ex [h:obj Poly] (orderedP h) /\ (Eq h (Plus_MP.ap2 t f));
  Refine +3 H;

  (* g == 0, f = 0, take h == t *)
  intros f _; Refine ExIntro; Refine (Plus_MP.ap2 t ZeroP); Refine pair;
  Refine orderedP_monom ? H1;
  Refine exten2 ? ?.Eq_refl; Refine H2.snd;

  intros u g ih_g f _;
  orE R_discr (CoefM.ap u) Zero;
  intros;
  Refine AllPolyOrdered_lemma1 H2.fst H2.snd ih_g H3;

  intros;
  Refine Less_partit IMN.IMN_total_order B_discr (IndexM.ap t) (IndexM.ap u);
  intros;
  Refine AllPolyOrdered_lemma5 H2.fst H2.snd ih_g H3 H4;

  intros;
  orE R_discr (Plus.ap2 (CoefM.ap t) (CoefM.ap u)) Zero;
  intros;
  Refine AllPolyOrdered_lemma2 H2.fst H2.snd H5 H4;

  intros;
  Refine AllPolyOrdered_lemma4 H2.fst H2.snd H5 H4;

  intros;
  Refine AllPolyOrdered_lemma3 H2.fst H2.snd H1 H4;
Save AllPolyOrdered;

Goal {phi:Pred Poly.car}
     (phi.ap ZeroP) ->
     ({m|el Monom} ~(Eq (CoefM.ap m) Zero) -> phi.ap ((Monomial2Poly IMN R).ap m)) ->
     ({f|obj Poly}{m|el Monom} (phi.ap f) ->
                               ~(Eq (CoefM.ap m) Zero) ->
                               (LessB.ap2 (DegreeP.ap f) (IndexM.ap m)) ->
                               phi.ap (Plus_MP.ap2 m f)) ->
     {f:obj Poly} phi.ap f;
  intros ____ f';
  exE AllPolyOrdered f'; intros g _;
  Refine extenPred ? H3.snd;
  Refine list_elim_elim [f:obj Poly] (orderedP f) -> phi.ap f;
  Refine +3 H3.fst;
  intros; Refine H;
  Refine H1;
  intros m n f __;
    Refine H2 (and3_out3 H5).H4 H5.and3_out1;
    Refine orderedP_lemma4 H5;
Save Poly_degree_ind;

(* --------------------------------------------------------------------------------
   Formulate another version of the induction principle. Not sure if I'll need it
   though...
*)

[     lessPM : Poly.obj -> Monom.el -> Prop
          = [f:Poly.obj][m:Monom.el] ~(Eq (CoefM.ap m) Zero) /\
                                     (LessB.ap2 (DegreeP.ap f) (IndexM.ap m))
];

Goal extensionalRel lessPM;
  Intros f f' _ m m' __;
  andE H2; Refine pair;
  Intros _; Refine H3; Refine Eq_trans ?? H5; Refine exten ? H1;
  Refine extenRel; Refine +4 H4; Refine exten ? H; Refine exten ? H1;
Save lessPM_exten;

[     LessPM : Rel Poly.car Monom
          = Rel_intro lessPM lessPM_exten
];

Goal {phi:Pred Poly.car}
     ({x:obj R} phi.ap (ConstP.ap x)) ->
     ({f|obj Poly}{m|el Monom} (phi.ap f) ->
                             (LessPM.ap2 f m) -> phi.ap (Plus_MP.ap2 m f)) ->
     {f:obj Poly} phi.ap f;
  intros _ bas ih f';
  Claim phi.ap ZeroP;
  Refine Poly_degree_ind;
  Refine ?4;
  intros t _;
  orE B_discr (IndexM.ap t) ZeroB;
  intros;
    Refine extenPred ?? (bas (CoefM.ap t));
    Refine exten2 Plus_MP ??.Eq_refl;
    Refine eq_Monomial_intro; Refine Eq_refl; Refine H1.Eq_sym;
  intros;
    Refine ih ?4;
    Refine pair H;
    Refine IMN.LessIMN_lemma1; Refine H1;
  intros; Refine ih H; Refine pair H1 H2;
  Refine extenPred ?? (bas Zero); Refine PlusMP_lemma1 IMN R;
Save Poly_degree_ind';

Discharge IMN;
