
Module Poly Import case Monomial;

[IMN : indexMonoid]
  $[PlusB    : BFunMdl IMN            = IMN.PlusIMN   ]
  $[ZeroB    : obj IMN                = IMN.ZeroIMN   ]

  $[B_discr  : Discrete IMN.car       = IMN.indexMonoid_discr ];

[R : Ring]
  $[Plus  : BFunMdl R   = R.PlusRg ]
  $[Times : BFunMdl R   = R.TimesRg]
  $[Zero  : obj R       = R.ZeroRg ]
  $[One   : obj R       = R.OneRg  ]
  $[Neg   : UFunMdl R   = R.NegRg  ];

  $[Monom       : Set                      = Monomial IMN R ]
  $[Monom_intro : Fun2 R.car IMN.car Monom = Monomial_intro IMN R]
  $[CoefM       : Fun Monom R.car          = CoefMon IMN R  ]
  $[IndexM      : Fun Monom IMN.car        = IndexMon IMN R ]
  $[NegM        : Fun Monom Monom          = NegMon IMN R   ]
  $[TimesM      : Fun2 Monom Monom Monom   = TimesMon IMN R ];

(* --------------------------------------------------------------------------------
   Define the set of polynomials.
*)

[     poly
          = list Monom.el
];

[     coefPoly [l:poly] [i:obj IMN] : obj R
          = list_iter Zero
                      ([t:el Monom][ih:obj R]
                       if B_discr (IndexM.ap t) i (Plus.ap2 (CoefM.ap t) ih) ih)
                      l
];

[     eq_poly : poly -> poly -> Prop
          = [f,g:poly] {i:obj IMN} Eq (coefPoly f i) (coefPoly g i)
];

[     eq_poly_refl : reflexive eq_poly
          = [f:poly][i:obj IMN] Eq_refl (coefPoly f i)
]
[     eq_poly_sym : symmetric eq_poly
          = [f,g:poly][H:eq_poly f g][i:obj IMN] Eq_sym (H i)
]
[     eq_poly_trans : transitive eq_poly
          = [f,g,h:poly][H:eq_poly f g][H1:eq_poly g h][i:obj IMN]
              Eq_trans (coefPoly g i) (H i) (H1 i)
];

[     Polyn : Set
          = Set_intro eq_poly_refl eq_poly_sym eq_poly_trans
];

Goal extensional2 (coefPoly : Polyn.el -> IMN.obj -> R.obj);
  Intros f f' _ i i' _;
  Refine Eq_trans (coefPoly f i'); Refine +1 H;
  Refine list_ind ([f:poly] Eq (coefPoly f i) (coefPoly f i'));
  Refine Eq_refl;
  intros t g _;
  [gi = coefPoly g i] [z = Plus.ap2 (CoefM.ap t) gi];
  [gi' = coefPoly g i'] [z' = Plus.ap2 (CoefM.ap t) gi'];
  orE B_discr (IndexM.ap t) i;

  intros;
    Refine Eq_trans z; Refine if_true H2;
    Refine Eq_trans z'; Refine exten2; Refine Eq_refl; Refine ih;
    Refine Eq_sym; Refine if_true;
    Refine Eq_trans i; Immed;

  intros;
    Refine Eq_trans gi; Refine if_false H2;
    Refine Eq_trans gi'; Refine ih;
    Refine Eq_sym; Refine if_false;
    notI; notE H2;
    Refine Eq_trans i'; Refine H3; Refine H1.Eq_sym;
Save coefPoly_exten;

[      CoefPoly : Fun2 Polyn IMN.car R.car
          = Fun2_intro|Polyn coefPoly coefPoly_exten
];

(* --------------------------------------------------------------------------------
   Define    PlusMP : Monomial -> Polyn -> Polyn
*)

[     plusMP : Monom.el -> Polyn.el -> Polyn.el
          = cons | Monom.el
];

Goal extensional2 plusMP;
  Intros t u _ f g __;
  andE eq_Monomial_elim H;
  [fi = coefPoly f i] [gi = coefPoly g i];
  Equiv Eq (if B_discr (IndexM.ap t) i (Plus.ap2 (CoefM.ap t) fi) fi)
           (if B_discr (IndexM.ap u) i (Plus.ap2 (CoefM.ap u) gi) gi);
  Refine if_exten;
  intros; Refine Eq_trans (IndexM.ap t) H3.Eq_sym H4;
  intros; Refine Eq_trans (IndexM.ap u) H3 H4;
  Refine exten2; Immed;
Save plusMP_exten;

[     PlusMP : Fun2 Monom Polyn Polyn
          = Fun2_intro plusMP plusMP_exten
];

Goal {f:el Polyn}{b:obj IMN} Eq|Polyn (PlusMP.ap2 (Monom_intro.ap2 Zero b) f) f;
  Intros ___; Refine B_discr b i;
  intros;
    Refine Eq_trans (Plus.ap2 Zero (CoefPoly.ap2 f i));
    Refine if_true H;
    Refine lZeroRg_ident;
  intros; Refine if_false H;
Save PlusMP_lemma1;

Goal PlusMP_lemma2
   : {t|el Monom}{f,g|el Polyn}
     (Eq|Polyn (PlusMP.ap2 t f) g) -> Eq f (PlusMP.ap2 (NegM.ap t) g);
  Intros ____;
  Refine Eq_trans (PlusMP.ap2 (NegM.ap t) (PlusMP.ap2 t f));
    Refine +1 exten2 ? ?.Eq_refl H;
  Intros i;
  [t0 = CoefM.ap t] [u0 = Neg.ap t0]
  [fi = CoefPoly.ap2 f i]
  [tfi = CoefPoly.ap2 (PlusMP.ap2 t f) i];
  Refine B_discr (IndexM.ap t) i;

  intros;
  Refine Eq_trans (Plus.ap2 Zero fi);
    Refine Eq_sym; Refine lZeroRg_ident;
  Refine Eq_trans (Plus.ap2 (Plus.ap2 u0 t0) fi);
    Refine exten2; Refine Eq_sym; Refine lNegRg_invers; Refine Eq_refl;
  Refine Eq_trans (Plus.ap2 u0 (Plus.ap2 t0 fi));
    Refine Eq_sym; Refine PlusRg_assoc;
  Refine Eq_trans (Plus.ap2 u0 tfi);
    Refine exten2; Refine Eq_refl;
    Refine Eq_sym; Refine if_true H1;
  Refine Eq_sym; Refine if_true H1;

  intros;
  Refine Eq_trans tfi;
    Refine Eq_sym; Refine if_false H1;
  Refine Eq_sym; Refine if_false H1;
Save;

Goal {t|el Monom}{f|el Polyn} (Eq (CoefM.ap t) Zero) -> Eq (PlusMP.ap2 t f) f;
  intros;
  Refine Eq_trans (PlusMP.ap2 (Monom_intro.ap2 Zero (IndexM.ap t)) f);
    Refine exten2 ???.Eq_refl;
    Refine eq_Monomial_intro; Refine H; Refine Eq_refl;
  Refine PlusMP_lemma1;
Save PlusMP_lemma3;

(* Define the two identity polynomials. *)

[     ZeroPoly : el Polyn
          = nil Monom.el
];

[     monomial2Poly : Monom.el -> Polyn.el
          = [t:el Monom] PlusMP.ap2 t ZeroPoly
];

Goal extensional monomial2Poly;
  Intros ___;
  Refine exten2 ? H ?.Eq_refl;
Save monomial2Poly_exten;

[     Monomial2Poly : Fun Monom Polyn
          = Fun_intro monomial2Poly monomial2Poly_exten
];

[     constPoly : R.obj -> Polyn.el
          =  [x:obj R] Monomial2Poly.ap (Monom_intro.ap2 x ZeroB)
];

Goal extensional constPoly;
  Intros ___;
  Refine exten ? (exten2 ? H ?.Eq_refl);
Save constPoly_exten;

[     ConstPoly : Fun R.car Polyn
          = Fun_intro constPoly constPoly_exten
];

(* --------------------------------------------------------------------------------
*)

[     OnePoly : el Polyn
          = ConstPoly.ap One
];

Goal {i:obj IMN} Eq (CoefPoly.ap2 ZeroPoly i) Zero;
  intros;
  Refine Eq_refl;
Save CoefPoly_zero;

Goal {f|el Polyn} (Eq f ZeroPoly) -> {i:obj IMN} Eq (CoefPoly.ap2 f i) Zero;
  intros;
  Refine Eq_trans ? (H i);
  Refine CoefPoly_zero;
Save CoefPoly_zerop;

Goal {m:el Monom}{p:el Polyn}{i:obj IMN}
     Eq (CoefPoly.ap2 (PlusMP.ap2 m p) i)
        (if B_discr (IndexM.ap m) i (Plus.ap2 (CoefM.ap m) (CoefPoly.ap2 p i))
                                    (CoefPoly.ap2 p i));
  intros; Refine Eq_refl;
Save CoefPoly_MP;

Goal {m|el Monom}{i|obj IMN} (Eq (IndexM.ap m) i) -> {p:el Polyn}
     Eq (CoefPoly.ap2 (PlusMP.ap2 m p) i) (Plus.ap2 (CoefM.ap m) (CoefPoly.ap2 p i));
  intros; Refine if_true H;
Save CoefPoly_MP_eq;

Goal {m|el Monom}{i|obj IMN} ~(Eq (IndexM.ap m) i) -> {p:el Polyn}
     Eq (CoefPoly.ap2 (PlusMP.ap2 m p) i) (CoefPoly.ap2 p i);
  intros; Refine if_false H;
Save CoefPoly_MP_neq;

Goal {t,u|el Monom}{f|el Polyn} (Eq (IndexM.ap t) (IndexM.ap u)) ->
     Eq (PlusMP.ap2 t (PlusMP.ap2 u f))
        (PlusMP.ap2 (Monom_intro.ap2 (Plus.ap2 (CoefM.ap t) (CoefM.ap u))
                                                (IndexM.ap t)) f);
  Intros _____;
  [u1 = CoefM.ap u] [u2 = IndexM.ap u]
  [t1 = CoefM.ap t] [t2 = IndexM.ap t];
  [tu1 = Plus.ap2 t1 u1];
  Equiv Eq (CoefPoly.ap2 (cons t (cons u f)) i)
           (CoefPoly.ap2 (cons (Monom_intro.ap2 tu1 t2) f) i);
  orE B_discr t2 i;

  intros;
  Refine Eq_trans (Plus.ap2 t1 (CoefPoly.ap2 (cons u f) i));
    Refine CoefPoly_MP_eq H1;
  Refine Eq_trans (Plus.ap2 t1 (Plus.ap2 u1 (CoefPoly.ap2 f i)));
    Refine exten2 ? ?.Eq_refl;
    Refine CoefPoly_MP_eq;
    Refine Eq_trans ? H.Eq_sym H1;
  Refine Eq_trans (Plus.ap2 tu1 (CoefPoly.ap2 f i));
    Refine PlusRg_assoc;
  Refine Eq_sym;
  Refine CoefPoly_MP_eq;
  Refine H1;

  intros;
  Refine Eq_trans (CoefPoly.ap2 (cons u f) i);
    Refine CoefPoly_MP_neq H1;
  Refine Eq_trans (CoefPoly.ap2 f i);
    Refine CoefPoly_MP_neq;
    Intros _; Refine H1; Refine Eq_trans ? H H2;
  Refine Eq_sym;
  Refine CoefPoly_MP_neq;
  Intros _; Refine H1; Refine H2;
Save PlusMP_lemma4;

Goal {f,g|el Polyn} {t,u|el Monom} {i,j|obj IMN}
     (Eq i j) ->
     (Eq t u) ->
     (Eq (CoefPoly.ap2 f i) (CoefPoly.ap2 g j)) ->
     Eq (CoefPoly.ap2 (PlusMP.ap2 t f) i) (CoefPoly.ap2 (PlusMP.ap2 u g) j);
  intros;
  Refine Eq_trans (CoefPoly.ap2 (PlusMP.ap2 u f) i);
    Refine exten2 ???.Eq_refl; Refine exten2 ? H1 ?.Eq_refl;
  Refine B_discr (IndexM.ap u) j;
  intros;
    Refine Eq_trans (Plus.ap2 (CoefM.ap u) (CoefPoly.ap2 f i));
      Refine CoefPoly_MP_eq; Refine Eq_trans ? H3 H.Eq_sym;
    Refine Eq_trans (Plus.ap2 (CoefM.ap u) (CoefPoly.ap2 g j));
      Refine exten2 ??.Eq_refl H2;
    Refine Eq_sym; Refine CoefPoly_MP_eq; Refine H3;
  intros;
    Refine Eq_trans (CoefPoly.ap2 f i);
      Refine CoefPoly_MP_neq;
      Intros _; Refine H3; Refine Eq_trans ? H4 H;
    Refine Eq_trans ? H2;
    Refine Eq_sym; Refine CoefPoly_MP_neq;
    Intros _; Refine H3; Refine H4;
Save CoefPoly_PlusMP;

Goal {x:obj R} Eq (CoefPoly.ap2 (ConstPoly.ap x) ZeroB) x;
  intros;
  Refine Eq_trans (Plus.ap2 x Zero);
    Refine +1 rZeroRg_ident;
  Refine if_true; Refine Eq_refl;
Save CoefPoly_const;

Goal {x|obj R}{i|obj IMN} (Eq i ZeroB) -> Eq (CoefPoly.ap2 (ConstPoly.ap x) i) x;
  intros;
  Refine Eq_trans (CoefPoly.ap2 (ConstPoly.ap x) ZeroB);
    Refine exten2 ??.Eq_refl H;
      Refine CoefPoly_const;
Save CoefPoly_const0;

Goal {x|obj R}{i|obj IMN} ~(Eq i ZeroB) -> Eq (CoefPoly.ap2 (ConstPoly.ap x) i) Zero;
  intros;
 Refine if_false;
 Intros _; Refine H H1.Eq_sym;
Save CoefPoly_const1;

Goal {c|obj R} (Eq (ConstPoly.ap c) ZeroPoly) -> (Eq c Zero);
  intros;
  Refine Eq_trans (CoefPoly.ap2 (ConstPoly.ap c) ZeroB) ?.Eq_sym;
    Refine CoefPoly_const;
  Refine Eq_trans (CoefPoly.ap2 ZeroPoly ZeroB);
    Refine exten2 ? H ?.Eq_refl;
  Refine CoefPoly_zero;
Save ConstPoly_zero;

Goal Eq (CoefPoly.ap2 OnePoly ZeroB) One;
  Refine CoefPoly_const One;
Save CoefPoly_one;

(* --------------------------------------------------------------------------------
   Hide the internal structure of Polyn.
*)

Freeze coefPoly;

(*
Goal {phi:Polyn.el->TYPE}
     (phi ZeroPoly) ->
     ({m:el Monom}{p:el Polyn}{ih:phi p} phi (PlusMP.ap2 m p)) ->
     {p:Polyn.el} phi p;
  Refine list_elim;
Save Polyn_elim;
*)

[     Polyn_iter : {T|TYPE} T -> ({m:el Monom}{ih:T} T) -> (Polyn.el -> T)
          = list_iter | Monom.el
]
[     Polyn_ind : {phi:Polyn.el -> Prop}
                  (phi ZeroPoly) ->
                  ({m:el Monom}{p:el Polyn}{ih:phi p} phi (PlusMP.ap2 m p)) ->
                  {p:el Polyn} phi p
          = list_ind | Monom.el
]
[     Pollyn_ind2 : {phi:Polyn.el -> Polyn.el -> Prop}
                    (phi ZeroPoly ZeroPoly) ->
                    ({m2:el Monom}{p2:el Polyn}{ih:phi ZeroPoly p2}
                            phi ZeroPoly (PlusMP.ap2 m2 p2)) ->
                    ({m1:el Monom}{p1:el Polyn}{ih:{p2:el Polyn}phi p1 p2}
                            phi (PlusMP.ap2 m1 p1) ZeroPoly) ->
                    ({m1:el Monom}{p1:el Polyn}{ih_p1:{p2:el Polyn}phi p1 p2}
                            {m2:el Monom}{p2:el Polyn}{ih_p2:phi (PlusMP.ap2 m1 p1) p2}
                            phi (PlusMP.ap2 m1 p1) (PlusMP.ap2 m2 p2)) ->
                    {p1,p2:el Polyn} phi p1 p2
          = [phi:Polyn.el -> Polyn.el -> Prop] list_elim2 phi
];

(* Freeze poly; *)

(* --------------------------------------------------------------------------------
   Define the addition of polynomials.
*)

[      plusP : bop Polyn.el
          = [p1,p2:el Polyn]
            Polyn_iter p2 ([m:el Monom][ih:el Polyn] PlusMP.ap2 m ih) p1
];

Goal {f,g:Polyn.el} {i:obj IMN}
     Eq (CoefPoly.ap2 (plusP f g) i) (Plus.ap2 (CoefPoly.ap2 f i) (CoefPoly.ap2 g i));
  intros;
  Refine Polyn_ind [f:el Polyn]
      Eq ((plusP f g).coefPoly i) (ap2 Plus (f.coefPoly i) (g.coefPoly i));

  Equiv Eq (coefPoly g i) (Plus.ap2 (coefPoly ZeroPoly i) (coefPoly g i));
  Refine Eq_sym; 
  Refine Eq_trans (Plus.ap2 Zero (coefPoly g i));
    Refine exten2 ???.Eq_refl; Refine CoefPoly_zero;
  Refine lZeroRg_ident;

  intros t l;
  [lgi = coefPoly (plusP l g) i];
  [li = coefPoly l i];
  [gi = coefPoly g i];
  Equiv (Eq lgi (Plus.ap2 li gi)) ->
         Eq (coefPoly (plusMP t (plusP l g)) i) (ap2 Plus (coefPoly (plusMP t l) i) gi);
  intros;
  Refine B_discr (IndexM.ap t) i;

  intros;
    Refine Eq_trans (Plus.ap2 (CoefM.ap t) lgi); Refine CoefPoly_MP_eq H1;
    Refine Eq_trans (Plus.ap2 (CoefM.ap t) (Plus.ap2 li gi));
      Refine exten2; Refine Eq_refl; Refine H;
    Refine Eq_trans (Plus.ap2 (Plus.ap2 (CoefM.ap t) li) gi); Refine PlusRg_assoc;
    Refine exten2; Refine +1 Eq_refl; Refine Eq_sym; Refine CoefPoly_MP_eq H1;

  intros;
    Refine Eq_trans lgi; Refine CoefPoly_MP_neq H1;
    Refine Eq_trans (Plus.ap2 li gi); Refine H;
    Refine exten2; Refine +1 Eq_refl;
    Refine Eq_sym; Refine CoefPoly_MP_neq H1;

Save CoefPoly_plus;

Goal extensional2 plusP;
  Intros;
  Refine Eq_trans (Plus.ap2 (coefPoly x i) (coefPoly y i));
  Refine CoefPoly_plus;
  Refine Eq_trans (Plus.ap2 (coefPoly x' i) (coefPoly y' i));
  Refine exten2; Refine H; Refine H1;
  Refine Eq_sym; Refine CoefPoly_plus;
Save plusP_exten;

[      PlusPoly : Fun2 Polyn Polyn Polyn
          = Fun2_intro plusP plusP_exten
];

Goal Associative PlusPoly;
  Intros t u v i;
  Refine Eq_trans (Plus.ap2 (coefPoly t i) (coefPoly (PlusPoly.ap2 u v) i));
  Refine CoefPoly_plus;
  Refine Eq_trans (Plus.ap2 (coefPoly t i) (Plus.ap2 (coefPoly u i) (coefPoly v i)));
  Refine exten2; Refine Eq_refl; Refine CoefPoly_plus;
  Refine Eq_trans (Plus.ap2 (Plus.ap2 (coefPoly t i) (coefPoly u i)) (coefPoly v i));
  Refine PlusRg_assoc;
  Refine Eq_trans (Plus.ap2 (coefPoly (PlusPoly.ap2 t u) i) (coefPoly v i));
  Refine exten2; Refine Eq_sym; Refine CoefPoly_plus; Refine Eq_refl;
  Refine Eq_sym; Refine CoefPoly_plus;
Save PlusPoly_assoc;

Goal Commutative PlusPoly;
  Intros t u i;
  Refine Eq_trans (Plus.ap2 (coefPoly t i) (coefPoly u i));
  Refine CoefPoly_plus;
  Refine Eq_trans (Plus.ap2 (coefPoly u i) (coefPoly t i));
  Refine PlusRg_commut;
  Refine Eq_sym; Refine CoefPoly_plus;
Save PlusPoly_commut;

Goal rIdentity PlusPoly ZeroPoly;
  Intros t i;
  Refine Eq_trans (Plus.ap2 (coefPoly t i) (CoefPoly.ap2 ZeroPoly i));
    Refine CoefPoly_plus;
  Refine Eq_trans (Plus.ap2 (coefPoly t i) Zero);
    Refine exten2 ??.Eq_refl; Refine CoefPoly_zero;
  Refine rZeroRg_ident;
Save rZeroPoly_ident;

Goal lIdentity PlusPoly ZeroPoly;
  Intros f;
  Refine Eq_trans (PlusPoly.ap2 f ZeroPoly);
  Refine PlusPoly_commut;
  Refine rZeroPoly_ident;
Save lZeroPoly_ident;

Goal {m,n:el Monom}{f:el Polyn}
     Eq (PlusMP.ap2 m (PlusMP.ap2 n f)) (PlusMP.ap2 n (PlusMP.ap2 m f));
  intros;
  [M = Monomial2Poly.ap m];
  [N = Monomial2Poly.ap n];
  Equiv Eq (PlusPoly.ap2 M (PlusPoly.ap2 N f)) (PlusPoly.ap2 N (PlusPoly.ap2 M f));
  Refine Eq_trans (PlusPoly.ap2 (PlusPoly.ap2 M N) f);
    Refine PlusPoly_assoc;
  Refine Eq_trans (PlusPoly.ap2 (PlusPoly.ap2 N M) f);
    Refine exten2 ???.Eq_refl; Refine PlusPoly_commut;
  Refine Eq_sym;
  Refine PlusPoly_assoc;
Save PlusMP_commut;

(* ================================================================================
   Define the shift of a polynomial with a constant in B.
*)

[     timesBP : IMN.obj -> Polyn.el -> Polyn.el
          = [j:obj IMN]
            Polyn_iter ZeroPoly
                       ([m:el Monom] [ih:el Polyn]
                        plusMP (Monom_intro.ap2 (CoefM.ap m)
                                                (PlusB.ap2 j (IndexM.ap m))) ih)
];

Goal {i,j:obj IMN}{f:el Polyn}
     Eq (CoefPoly.ap2 (timesBP j f) (PlusB.ap2 j i)) (CoefPoly.ap2 f i);
  intros __;
  Refine Polyn_ind [f:poly] Eq (CoefPoly.ap2 (timesBP j f) (PlusB.ap2 j i))
                               (CoefPoly.ap2 f i);
  Refine Eq_trans Zero;
    Refine CoefPoly_zero;
  Refine Eq_sym; Refine CoefPoly_zero;

  intros t f ih;
    [jfji = CoefPoly.ap2 (timesBP j f) (PlusB.ap2 j i)];
    [fi = CoefPoly.ap2 f i];
    Refine Eq_trans (if B_discr (PlusB.ap2 j (IndexM.ap t)) (PlusB.ap2 j i)
                        (Plus.ap2 (CoefM.ap t) jfji) jfji);
      Refine CoefPoly_MP;
    Refine Eq_trans (if B_discr (IndexM.ap t) i (Plus.ap2 (CoefM.ap t) fi) fi);
    Refine +1 Eq_sym; Refine +1 CoefPoly_MP;
    Refine if_exten;
    Refine lPlusIMN_cancel;
    intros; Refine exten2 PlusB; Refine Eq_refl; Refine H;
    Refine exten2; Refine Eq_refl; Refine ih; Refine ih;
Save CoefPoly_timesBP;

Goal {i,j|obj IMN}{f:el Polyn} ~(IMN.rLessEqIMN.ap2 j i) ->
                               Eq (CoefPoly.ap2 (timesBP j f) i) Zero;
  intros __ g _;
  Refine Polyn_ind [f:el Polyn] Eq (CoefPoly.ap2 (timesBP j f) i) Zero;
  Refine CoefPoly_zero;
  intros t f _;
  [jfi = CoefPoly.ap2 (timesBP j f) i];
  Refine Eq_trans (if B_discr (PlusB.ap2 j (IndexM.ap t)) i
                      (Plus.ap2 (CoefM.ap t) jfi) jfi);
    Refine CoefPoly_MP;
  Refine Eq_trans jfi;
  Refine if_false;
  Intros _; Refine H; Refine ExIntro; Refine +1 H1;
  Refine ih;
Save timesBP_lemma2;

Goal extensional2 timesBP;
  Intros j j' _ f f' __;
  Refine IMN.rLessEqIMN_dec j i;
  intros;
    Refine H2; intros k _;
    Refine Eq_trans (CoefPoly.ap2 (timesBP j f) (PlusB.ap2 j k));
      Refine exten2 CoefPoly; Refine Eq_refl; Refine H3.Eq_sym;
    Refine Eq_trans (CoefPoly.ap2 f k); Refine CoefPoly_timesBP;
    Refine Eq_trans (CoefPoly.ap2 f' k); Refine H1;
    Refine Eq_trans (CoefPoly.ap2 (timesBP j' f') (PlusB.ap2 j' k));
      Refine Eq_sym; Refine CoefPoly_timesBP;
    Refine exten2 CoefPoly; Refine Eq_refl;
    Refine Eq_trans (PlusB.ap2 j k); Refine exten2; Refine H.Eq_sym; Refine Eq_refl;
    Refine H3;
  intros;
    Refine Eq_trans Zero; Refine timesBP_lemma2 f H2;
    Refine Eq_sym; Refine timesBP_lemma2 f';
    Intros _; Refine H2; exE H3; intros k _; Refine ExIntro; Refine k;
    Refine Eq_trans (PlusB.ap2 j' k); Refine exten2; Refine H; Refine Eq_refl;
    Refine H4;
Save timesBP_exten;

[      TimesBP : Fun2 IMN.car Polyn Polyn
          = Fun2_intro timesBP timesBP_exten
];

(* --------------------------------------------------------------------------------
   Define the shift of a polynomial and a constant in B.
*)

[     timesPB : Polyn.el -> IMN.obj -> Polyn.el
          = [tf:el Polyn] [j:obj IMN]
            Polyn_iter ZeroPoly
                       ([m:el Monom] [ih:el Polyn]
                        plusMP (Monom_intro.ap2 (CoefM.ap m)
                                                (PlusB.ap2 (IndexM.ap m) j))
                               ih)
                       tf
];

Goal {i,j:obj IMN}{f:el Polyn} Eq (CoefPoly.ap2 (timesPB f j) (PlusB.ap2 i j))
                               (CoefPoly.ap2 f i);
  intros __;
  Refine Polyn_ind [f:poly]Eq (CoefPoly.ap2 (timesPB f j) (PlusB.ap2 i j))
                               (CoefPoly.ap2 f i);
  Refine Eq_trans Zero;
    Refine CoefPoly_zero;
  Refine Eq_sym; Refine CoefPoly_zero;

  intros t f ih;
    [fjij = CoefPoly.ap2 (timesPB f j) (PlusB.ap2 i j)];
    [fi = CoefPoly.ap2 f i];
    Refine Eq_trans (if B_discr (PlusB.ap2 (IndexM.ap t) j) (PlusB.ap2 i j)
                       (Plus.ap2 (CoefM.ap t) fjij) fjij);
      Refine CoefPoly_MP;
    Refine Eq_trans (if B_discr (IndexM.ap t) i (Plus.ap2 (CoefM.ap t) fi) fi);
    Refine +1 Eq_sym; Refine +1 CoefPoly_MP;
    Refine if_exten;
    Refine rPlusIMN_cancel;
    intros; Refine exten2; Refine H; Refine Eq_refl;
    Refine exten2; Refine Eq_refl; Refine ih; Refine ih;
Save CoefPoly_timesPB;

Goal {i,j|obj IMN}{f:el Polyn} ~(IMN.lLessEqIMN.ap2 j i) ->
                           Eq (CoefPoly.ap2 (timesPB f j) i) Zero;
  intros __ g _;
  Refine Polyn_ind [f:el Polyn] Eq (CoefPoly.ap2 (timesPB f j) i) Zero;
  Refine CoefPoly_zero;
  intros t f _;
  [fji = CoefPoly.ap2 (timesPB f j) i];
  Refine Eq_trans (if B_discr (PlusB.ap2 (IndexM.ap t) j) i
                    (Plus.ap2 (CoefM.ap t) fji) fji);
    Refine CoefPoly_MP;
  Refine Eq_trans fji;
  Refine if_false;
  Intros _; Refine H; Refine ExIntro; Refine +1 H1;
  Refine ih;
Save timesPB_lemma2;

Goal extensional2 timesPB;
  Intros f f' _ j j' __;
  Refine IMN.lLessEqIMN_dec j i;
  intros;
    Refine H2; intros k _;
    Refine Eq_trans (CoefPoly.ap2 (timesPB f j) (PlusB.ap2 k j));
      Refine exten2 CoefPoly ?.Eq_refl H3.Eq_sym;
    Refine Eq_trans (CoefPoly.ap2 f k);
      Refine CoefPoly_timesPB;
    Refine Eq_trans (CoefPoly.ap2 f' k);
      Refine H;
    Refine Eq_trans (CoefPoly.ap2 (timesPB f' j') (PlusB.ap2 k j'));
      Refine Eq_sym; Refine CoefPoly_timesPB;
    Refine exten2 CoefPoly ?.Eq_refl;
    Refine Eq_trans (PlusB.ap2 k j);
      Refine exten2 ? ?.Eq_refl H1.Eq_sym;
    Refine H3;
  intros;
    Refine Eq_trans Zero;
      Refine timesPB_lemma2 f H2;
    Refine Eq_sym; Refine timesPB_lemma2 f';
    Intros _; Refine H2; exE H3; intros k _; Refine ExIntro; Refine k;
    Refine Eq_trans (PlusB.ap2 k j');
      Refine exten2 ? ?.Eq_refl H1;
    Refine H4;
Save timesPB_exten;

[      TimesPB : Fun2 Polyn IMN.car Polyn
          = Fun2_intro timesPB timesPB_exten
];

(* --------------------------------------------------------------------------------
   Define the multiplication of a constant in A and a polynomial.
*)

[      timesAP : R.obj -> Polyn.el -> Polyn.el
          = [x:obj R]
            Polyn_iter ZeroPoly
                       ([t:el Monom] [ih:el Polyn]
                       plusMP (Monom_intro.ap2 (Times.ap2 x (CoefM.ap t))
                                               (IndexM.ap t))
                              ih)
];

Goal {x:obj R}{i:obj IMN}{f:el Polyn} Eq (CoefPoly.ap2 (timesAP x f) i)
                                         (Times.ap2 x (CoefPoly.ap2 f i));
  intros __;
  Refine Polyn_ind [f:el Polyn] Eq (CoefPoly.ap2 (timesAP x f) i)
                                   (Times.ap2 x (CoefPoly.ap2 f i));

  Refine Eq_trans Zero;
    Refine CoefPoly_zero;
  Refine Eq_sym; Refine Eq_trans (Times.ap2 x Zero);
    Refine exten2 ??.Eq_refl; Refine CoefPoly_zero;
  Refine rTimesZeroRg;

  intros t f ih;
  [t0 = CoefM.ap t] [t1 = IndexM.ap t];
  [fi = CoefPoly.ap2 f i] [xfi = Times.ap2 x fi];
  Refine Eq_trans (if B_discr t1 i
                      (Plus.ap2 (Times.ap2 x t0) (CoefPoly.ap2 (timesAP x f) i))
                      (CoefPoly.ap2 (timesAP x f) i));
    Refine CoefPoly_MP;
  Refine Eq_trans (if B_discr t1 i (Times.ap2 x (Plus.ap2 t0 fi)) xfi);
    Refine if_exten ? ? ? ih; Refine Id; Refine Id;
    Refine Eq_trans (Plus.ap2 (Times.ap2 x t0) xfi);
      Refine exten2 ? ?.Eq_refl ih;
    Refine Eq_sym; Refine lTimesPlusRg_distrib;
  Refine Eq_trans (Times.ap2 x (if B_discr t1 i (Plus.ap2 t0 fi) fi));
    Refine if_distrib;
  Refine exten2 ??.Eq_refl ?.Eq_sym; Refine CoefPoly_MP;
Save CoefPoly_timesAP;

Goal extensional2 timesAP;
  Intros a b _ f g _ i;
  Refine Eq_trans (Times.ap2 a (CoefPoly.ap2 f i));
    Refine CoefPoly_timesAP;
  Refine Eq_trans (Times.ap2 b (CoefPoly.ap2 g i));
    Refine exten2 ? H; Refine exten2 ? H1 ?.Eq_refl;
  Refine Eq_sym; Refine CoefPoly_timesAP;
Save timesAP_exten;

[     TimesAP : Fun2 R.car Polyn Polyn
          = Fun2_intro timesAP timesAP_exten
];

(* --------------------------------------------------------------------------------
   Define the multiplication of a polynomial and a constant in R.car.
*)

[      timesPA : Polyn.el -> R.obj -> Polyn.el
          = [tf:el Polyn] [x:obj R]
            Polyn_iter ZeroPoly
                       ([t:el Monom] [ih:el Polyn]
                        plusMP (Monom_intro.ap2 (Times.ap2 (CoefM.ap t) x)
                                                (IndexM.ap t))
                               ih)
                       tf
];

Goal {x:obj R}{i:obj IMN}{f:el Polyn} Eq (CoefPoly.ap2 (timesPA f x) i)
                                         (Times.ap2 (CoefPoly.ap2 f i) x);
  intros __;
  Refine Polyn_ind [f:el Polyn] Eq (CoefPoly.ap2 (timesPA f x) i)
                                   (Times.ap2 (CoefPoly.ap2 f i) x);
  Refine Eq_trans Zero;
    Refine CoefPoly_zero;
  Refine Eq_sym; Refine Eq_trans (Times.ap2 Zero x);
    Refine exten2 ???.Eq_refl; Refine CoefPoly_zero;
  Refine lTimesZeroRg;

  intros t f ih;
  [t0 = CoefM.ap t] [t1 = IndexM.ap t];
  [fi = CoefPoly.ap2 f i] [fix = Times.ap2 fi x];
  Refine Eq_trans (if B_discr t1 i
                      (Plus.ap2 (Times.ap2 t0 x) (CoefPoly.ap2 (timesPA f x) i))
                      (CoefPoly.ap2 (timesPA f x) i));
    Refine CoefPoly_MP;
  Refine Eq_trans (if B_discr t1 i (Times.ap2 (Plus.ap2 t0 fi) x) fix);
    Refine if_exten ? ? ? ih; Refine Id; Refine Id;
    Refine Eq_trans (Plus.ap2 (Times.ap2 t0 x) (Times.ap2 fi x));
      Refine exten2 ? ?.Eq_refl ih;
    Refine Eq_sym; Refine rTimesPlusRg_distrib;
  Refine Eq_trans (Times.ap2 (if B_discr t1 i (Plus.ap2 t0 fi) fi) x);
    Refine if_distrib ([y:obj R]Times.ap2 y x);
  Refine exten2 ??.Eq_sym ?.Eq_refl; Refine CoefPoly_MP;
Save CoefPoly_timesPA;

Goal extensional2 timesPA;
  Intros f g _ a b _ i;
  Refine Eq_trans (Times.ap2 (CoefPoly.ap2 f i) a);
    Refine CoefPoly_timesPA;
  Refine Eq_trans (Times.ap2 (CoefPoly.ap2 g i) b);
    Refine exten2 ? ?.H H1;
  Refine Eq_sym; Refine CoefPoly_timesPA;
Save timesPA_exten;

[      TimesPA : Fun2 Polyn R.car Polyn
          = Fun2_intro timesPA timesPA_exten
];

(* --------------------------------------------------------------------------------
   Define the multiplication of a monomial and a polynomial.
*)

[      timesMP : Monom.el -> Polyn.el -> Polyn.el
          = [a:el Monom]
            Polyn_iter ZeroPoly
                       ([b:el Monom] [ih:el Polyn] plusMP (TimesM.ap2 a b) ih)
];

Goal {t:el Monom}{f:el Polyn}
     Eq (timesMP t f) (TimesAP.ap2 (CoefM.ap t) (TimesBP.ap2 (IndexM.ap t) f));
  intros _;
  Refine Polyn_ind [f:el Polyn]
     Eq (timesMP t f) (TimesAP.ap2 (CoefM.ap t) (TimesBP.ap2 (IndexM.ap t) f));
  Refine Eq_refl;
  intros u g ih; Refine exten2 PlusMP ?.Eq_refl ih;
Save timesMP_lemma1;

Goal extensional2 timesMP;
  Intros t t' _ f f' _;
  Refine Eq_trans (TimesAP.ap2 (CoefM.ap t) (TimesBP.ap2 (IndexM.ap t) f));
    Refine timesMP_lemma1;
  Refine Eq_trans (TimesAP.ap2 (CoefM.ap t') (TimesBP.ap2 (IndexM.ap t') f'));
    Refine +1 Eq_sym; Refine +1 timesMP_lemma1;
  Refine exten2 TimesAP; Refine exten ? H;
  Refine exten2 TimesBP; Refine exten ? H;
  Refine H1;
Save timesMP_exten;

[      TimesMP : Fun2 Monom Polyn Polyn
          = Fun2_intro timesMP timesMP_exten
];

(* --------------------------------------------------------------------------------
   Define the multiplication of a Polynomial and a Monomial.
*)

[     timesPM : Polyn.el -> Monom.el -> Polyn.el
          = [tf:el Polyn] [a:el Monom]
            Polyn_iter ZeroPoly
                      ([b:el Monom] [ih:el Polyn] plusMP (TimesM.ap2 b a) ih)
                      tf
];

Goal {t:el Monom}{f:el Polyn}
     Eq (timesPM f t) (TimesPA.ap2 (TimesPB.ap2 f (IndexM.ap t)) (CoefM.ap t));
  intros _;
  Refine Polyn_ind [f:el Polyn]
     Eq (timesPM f t) (TimesPA.ap2 (TimesPB.ap2 f (IndexM.ap t)) (CoefM.ap t));
  Refine Eq_refl;
  intros u g ih; Refine exten2 PlusMP ?.Eq_refl ih;
Save timesPM_lemma1;

Goal extensional2 timesPM;
  Intros f f' _ t t' _;
  Refine Eq_trans (TimesPA.ap2 (TimesPB.ap2 f (IndexM.ap t)) (CoefM.ap t));
    Refine timesPM_lemma1;
  Refine Eq_trans (TimesPA.ap2 (TimesPB.ap2 f' (IndexM.ap t')) (CoefM.ap t'));
    Refine +1 Eq_sym; Refine +1 timesPM_lemma1;
  Refine exten2 TimesPA;   Refine exten2 TimesPB H;
  Refine exten ? H1; Refine exten ? H1;
Save timesPM_exten;

[     TimesPM : Fun2 Polyn Monom Polyn
          = Fun2_intro timesPM timesPM_exten
];

(* --------------------------------------------------------------------------------
   Define the multiplication of two polynomials.
*)

[     timesP : bop Polyn.el
          = [af,g:el Polyn]
            Polyn_iter ZeroPoly
                       ([a:el Monom][ih:el Polyn]ap2 PlusPoly (ap2 TimesMP a g) ih)
                       af
];

Goal {f:el Polyn} Eq (timesP f ZeroPoly) ZeroPoly;
  Refine Polyn_ind [f:el Polyn] Eq (timesP f ZeroPoly) ZeroPoly;
  Refine Eq_refl;
  intros t f ih;
    Refine Eq_trans (PlusPoly.ap2 ZeroPoly ZeroPoly);
    Refine exten2; Refine Eq_refl; Refine ih;
    Refine rZeroPoly_ident;
Save rTimesP_zero;

Goal {f:el Polyn}{u:el Monom}{g:el Polyn}
     Eq (timesP f (plusMP u g)) (plusP (timesPM f u) (timesP f g));
  intros g' t f;
  Refine Polyn_ind [g:el Polyn]
         Eq (timesP g (plusMP t f)) (plusP (timesPM g t) (timesP g f));
  Refine Eq_refl;
  intros u g ih;
    [ut = TimesM.ap2 u t];
    [uf = TimesMP.ap2 u f] [gt = TimesPM.ap2 g t] [gf = timesP g f];
    Equiv Eq (PlusMP.ap2 ut (PlusPoly.ap2 uf (timesP g (PlusMP.ap2 t f))))
             (PlusMP.ap2 ut (PlusPoly.ap2 gt (PlusPoly.ap2 uf gf)));
    Refine exten2; Refine Eq_refl;
    Refine Eq_trans (PlusPoly.ap2 uf (PlusPoly.ap2 gt gf));
      Refine exten2; Refine Eq_refl; Refine ih;
    Refine Eq_trans (PlusPoly.ap2 (PlusPoly.ap2 uf gt) gf);
      Refine PlusPoly_assoc;
    Refine Eq_trans (PlusPoly.ap2 (PlusPoly.ap2 gt uf) gf);
      Refine exten2 ???.Eq_refl; Refine PlusPoly_commut;
    Refine Eq_sym; Refine PlusPoly_assoc;
Save TimesP_right;

Goal {g,g':el Polyn} (Eq g g') -> {f:el Polyn} Eq (timesP f g) (timesP f g');
  intros ___;
  Refine Polyn_ind [f:poly] Eq (timesP f g) (timesP f g');
  Refine Eq_refl;
  intros t f ih;
    Refine exten2; Refine exten2; Refine Eq_refl; Refine H; Refine ih;
Save timesP_extenR;

Goal {f,f':el Polyn} (Eq f f') -> {g:el Polyn} Eq (timesP f g) (timesP f' g);
  intros ___;
  Refine Polyn_ind ([g:poly] Eq (timesP f g) (timesP f' g));
  Refine Eq_trans ZeroPoly;
    Refine rTimesP_zero; Refine Eq_sym; Refine rTimesP_zero;
  intros u g ih;
    Refine Eq_trans (PlusPoly.ap2 (TimesPM.ap2 f u) (timesP f g));
      Refine TimesP_right;
    Refine Eq_trans (PlusPoly.ap2 (TimesPM.ap2 f' u) (timesP f' g));
      Refine +1 Eq_sym; Refine +1 TimesP_right;
    Refine exten2; Refine exten2; Refine H; Refine Eq_refl; Refine ih;
Save timesP_extenL;

Goal extensional2 timesP;
  Intros f f' _ g g' _;
  Refine Eq_trans (timesP f g');
  Refine timesP_extenR; Refine H1;
  Refine timesP_extenL; Refine H;
Save timesP_exten;

[      TimesPoly : Fun2 Polyn Polyn Polyn
          = Fun2_intro timesP timesP_exten
];

Goal {f:el Polyn}{x:obj R} Eq (TimesPoly.ap2 (ConstPoly.ap x) f) (TimesAP.ap2 x f);
  intros;
  Refine Eq_trans (TimesMP.ap2 (Monom_intro.ap2 x ZeroB) f);
    Refine rZeroPoly_ident;
  Refine Eq_trans (TimesAP.ap2 x (TimesBP.ap2 ZeroB f));
    Refine timesMP_lemma1;
  Refine exten2 ? ?.Eq_refl;
  Intros j;
  Refine Eq_trans (CoefPoly.ap2 (TimesBP.ap2 ZeroB f) (PlusB.ap2 ZeroB j));
    Refine exten2 CoefPoly ?.Eq_refl; Refine Eq_sym; Refine lZeroIMN_ident;
  Refine CoefPoly_timesBP;
Save TimesAP_lemma1;

Goal {f:el Polyn}{x:obj R} Eq (TimesPoly.ap2 f (ConstPoly.ap x)) (TimesPA.ap2 f x);
  intros;
  Refine Eq_trans (PlusPoly.ap2 (TimesPM.ap2 f (Monom_intro.ap2 x ZeroB))
                                (TimesPoly.ap2 f ZeroPoly));
    Refine TimesP_right;
  Refine Eq_trans (PlusPoly.ap2 (TimesPM.ap2 f (Monom_intro.ap2 x ZeroB)) ZeroPoly);
    Refine exten2 ??.Eq_refl; Refine rTimesP_zero;
  Refine Eq_trans (TimesPM.ap2 f (Monom_intro.ap2 x ZeroB));
    Refine rZeroPoly_ident;
  Refine Eq_trans (TimesPA.ap2 (TimesPB.ap2 f ZeroB) x);
    Refine timesPM_lemma1;
  Refine exten2 ? ? ?.Eq_refl;
  Intros j;
  Refine Eq_trans (CoefPoly.ap2 (TimesPB.ap2 f ZeroB) (PlusB.ap2 j ZeroB));
    Refine exten2 CoefPoly ?.Eq_refl; Refine Eq_sym; Refine rZeroIMN_ident;
  Refine CoefPoly_timesPB;
Save TimesPA_lemma1;

Goal {x,y:obj R} Eq (ConstPoly.ap (Times.ap2 x y))
                    (TimesPoly.ap2 (ConstPoly.ap x) (ConstPoly.ap y));
  intros;
  Refine Eq_sym;
  Refine TimesAP_lemma1;
Save ConstPoly_times;

Goal {f:el Polyn}{x:obj R}{i:obj IMN}
      Eq (CoefPoly.ap2 (TimesPoly.ap2 (ConstPoly.ap x) f) i)
         (Times.ap2 x (CoefPoly.ap2 f i));
  intros;
  Refine Eq_trans (CoefPoly.ap2 (TimesAP.ap2 x f) i);
    Refine exten2 ? ? ?.Eq_refl; Refine TimesAP_lemma1;
  Refine CoefPoly_timesAP;
Save lTimesPoly_const;

Goal {f:el Polyn}{x:obj R}{i:obj IMN}
     Eq (CoefPoly.ap2 (TimesPoly.ap2 f (ConstPoly.ap x)) i)
        (Times.ap2 (CoefPoly.ap2 f i) x);
  intros;
  Refine Eq_trans (CoefPoly.ap2 (TimesPA.ap2 f x) i);
    Refine exten2 ? ? ?.Eq_refl; Refine TimesPA_lemma1;
  Refine CoefPoly_timesPA;
Save rTimesPoly_const;

(* ================================================================================
   Prove some basic ring lemma's.
*)

Goal Identity TimesPoly OnePoly;
  andI;
  Intros f;
  Refine Polyn_ind [g:poly] Eq (TimesPoly.ap2 OnePoly g) g;
  Refine rTimesP_zero;
  intros u g ih;
    Refine exten2 PlusMP;
    Refine eq_Monomial_intro;
    Refine lOneRg_ident;
    Refine lZeroIMN_ident;
    Refine ih;
  Refine Polyn_ind [f:poly] Eq (timesP f OnePoly) f;
  Refine Eq_refl;
  intros t f ih;
    Refine exten2 PlusMP;
    Refine eq_Monomial_intro;
    Refine rOneRg_ident;
    Refine rZeroIMN_ident;
    Refine ih;
Save OnePoly_ident;

Goal Distributive PlusPoly TimesPoly;
  andI;
  Intros f ug h;
    Freeze TimesPoly PlusPoly;
    Refine Polyn_ind
      [g:el Polyn] Eq (TimesPoly.ap2 f (PlusPoly.ap2 g h))
                      (PlusPoly.ap2 (TimesPoly.ap2 f g) (TimesPoly.ap2 f h));
    Unfreeze TimesPoly PlusPoly;
    Refine exten2 PlusPoly|ZeroPoly ?.Eq_sym ?.Eq_refl;
      Refine rTimesP_zero;
    Intros u g ih;
      Refine Eq_trans (PlusPoly.ap2 (TimesPM.ap2 f u)
                        (TimesPoly.ap2 f (PlusPoly.ap2 g h)));
        Refine TimesP_right;
      Refine Eq_trans (PlusPoly.ap2 (TimesPM.ap2 f u)
                        (PlusPoly.ap2 (TimesPoly.ap2 f g) (TimesPoly.ap2 f h)));
        Refine exten2; Refine Eq_refl; Refine ih;
      Refine Eq_trans (PlusPoly.ap2 (PlusPoly.ap2 (TimesPM.ap2 f u) (TimesPoly.ap2 f g))
                                    (TimesPoly.ap2 f h));
        Refine PlusPoly_assoc;
      Refine exten2 ? ?.Eq_sym ?.Eq_refl; Refine TimesP_right;
  Intros f ug h;
    Freeze TimesPoly PlusPoly;
    Refine Polyn_ind [g:el Polyn] Eq (TimesPoly.ap2 (PlusPoly.ap2 g h) f)
                                (PlusPoly.ap2 (TimesPoly.ap2 g f) (TimesPoly.ap2 h f));
    Unfreeze TimesPoly PlusPoly;
    Refine Eq_refl;
    Intros u g ih;
      Equiv Eq (PlusPoly.ap2 (TimesMP.ap2 u f) (TimesPoly.ap2 (PlusPoly.ap2 g h) f))
               (PlusPoly.ap2 (TimesPoly.ap2 (plusMP u g) f) (TimesPoly.ap2 h f));
      Refine Eq_trans (PlusPoly.ap2 (TimesMP.ap2 u f)
                             (PlusPoly.ap2 (TimesPoly.ap2 g f) (TimesPoly.ap2 h f)));
      Refine exten2; Refine Eq_refl; Refine ih;
      Refine PlusPoly_assoc;
Save DistribP;

Goal {t,u:el Monom} {h:el Polyn} Eq (TimesMP.ap2 t (TimesMP.ap2 u h))
                                    (TimesMP.ap2 (TimesM.ap2 t u) h);
  intros __;
  Refine Polyn_ind [h:poly] Eq (TimesMP.ap2 t (TimesMP.ap2 u h))
                               (TimesMP.ap2 (TimesM.ap2 t u) h);
  Refine Eq_refl;
  intros v h ih; Refine exten2 PlusMP; Refine TimesMon_assoc; Refine ih;
Save TimesMMP_assoc;

Goal {t:el Monom} {g,h:el Polyn}
     Eq (TimesMP.ap2 t (PlusPoly.ap2 g h))
        (PlusPoly.ap2 (TimesMP.ap2 t g) (TimesMP.ap2 t h));
  intros t ug h;
  Refine Polyn_ind
    [g:poly] Eq (TimesMP.ap2 t (PlusPoly.ap2 g h))
                (PlusPoly.ap2 (TimesMP.ap2 t g) (TimesMP.ap2 t h));
  Refine Eq_refl;
  intros u g ih;
    Refine Eq_trans|Polyn
           (plusMP (TimesM.ap2 t u) (PlusPoly.ap2 (TimesMP.ap2 t g) (TimesMP.ap2 t h)));
    Refine exten2 PlusMP; Refine Eq_refl; Refine ih;
    Refine Eq_refl;
Save distribMP;

Goal {t:el Monom} {g,h:el Polyn} Eq (TimesMP.ap2 t (TimesPoly.ap2 g h))
                                      (TimesPoly.ap2 (TimesMP.ap2 t g) h);
  intros t g' h;
  Refine Polyn_ind [g:poly] Eq (TimesMP.ap2 t (TimesPoly.ap2 g h))
                               (TimesPoly.ap2 (TimesMP.ap2 t g) h);
  Refine Eq_refl;
  intros u g ih;
    Refine Eq_trans (PlusPoly.ap2 (TimesMP.ap2 t (TimesMP.ap2 u h))
                               (TimesMP.ap2 t (TimesPoly.ap2 g h)));
    Refine distribMP;
    Refine exten2; Refine TimesMMP_assoc; Refine ih;
Save TimesMPP_assoc;

Goal Associative TimesPoly;
  Intros f' g h;
  Refine Polyn_ind [f:poly] Eq (TimesPoly.ap2 f (TimesPoly.ap2 g h))
                               (TimesPoly.ap2 (TimesPoly.ap2 f g) h);
  Refine Eq_refl;
  intros t f ih;
    Equiv Eq (PlusPoly.ap2 (TimesMP.ap2 t (TimesPoly.ap2 g h))
                        (TimesPoly.ap2 f (TimesPoly.ap2 g h)))
             (TimesPoly.ap2 (TimesPoly.ap2 (plusMP t f) g) h);
    Refine Eq_trans (PlusPoly.ap2 (TimesPoly.ap2 (TimesMP.ap2 t g) h)
                               (TimesPoly.ap2 (TimesPoly.ap2 f g) h));
    Refine exten2; Refine TimesMPP_assoc; Refine ih;
    Refine Eq_sym; Refine DistribP.snd;
Save TimesPoly_assoc;

Discharge R;

(* ================================================================================
   Define the negation of a polynomial.
*)

[     mapPn : {R,R'|Ring} (R.obj -> R'.obj) -> (R.Polyn.el -> R'.Polyn.el)
          = [R,R':Ring] [f:R.obj->R'.obj] mapL (mapM IMN f)
];

[R,R' | Ring] [h : Homomorphism R.applGroup R'.applGroup];

  $[Monom       : Set                      = Monomial IMN R ]
  $[Monom_intro : Fun2 R.car IMN.car Monom = Monomial_intro IMN R]
  $[CoefM       : Fun Monom R.car          = CoefMon IMN R  ]
  $[IndexM      : Fun Monom IMN.car        = IndexMon IMN R ];

  $[f : Fun R.car R'.car = Homo_f h];

Goal {P:el R.Polyn} {i:obj IMN}
     Eq (R'.CoefPoly.ap2 (mapPn f.ap P) i) (f.ap (R.CoefPoly.ap2 P i));
  intros P' i;
  [g = mapM IMN f.ap];
  [coefR = R.CoefPoly.ap2] [coefR' = R'.CoefPoly.ap2];
  Refine Polyn_ind R [P:el R.Polyn] Eq (coefR' (mapL g P) i) (f.ap (coefR P i));

  Refine Eq_trans R'.ZeroRg; Refine CoefPoly_zero;
  Refine Eq_sym;
  Refine Eq_trans (ap f R.ZeroRg); Refine exten; Refine CoefPoly_zero;
  Refine HomoGr_one h;

  intros t l ih;
  [t0 = CoefM.ap t] [t1 = IndexM.ap t];
  [li = coefR l i]
  [fli = coefR' (mapL g l) i] [fli' = f.ap li];
  Refine Eq_trans (if B_discr t1 i (R'.PlusRg.ap2 (f.ap t0) fli) fli);
    Refine CoefPoly_MP;
  Refine Eq_trans (f.ap (if B_discr t1 i (R.PlusRg.ap2 t0 li) li));
    Refine +1 exten ??.Eq_sym; Refine +1 CoefPoly_MP;
  orE B_discr t1 i;
  intros;
    Refine Eq_trans (R'.PlusRg.ap2 (f.ap t0) fli);
      Refine if_true H;
    Refine Eq_trans (R'.PlusRg.ap2 (f.ap t0) fli');
      Refine exten2 ? ?.Eq_refl ih;
    Refine Eq_trans (f.ap (R.PlusRg.ap2 t0 li));
      Refine Eq_sym; Refine HomoGr_times h;
    Refine exten f; Refine Eq_sym; Refine if_true H;
  intros;
    Refine Eq_trans fli;
      Refine if_false H;
    Refine Eq_trans fli';
      Refine ih;
    Refine exten f; Refine Eq_sym; Refine if_false H;
Save mapGrP_distrib;

Goal extensional (mapPn f.ap);
  Intros P P' __;
  Refine Eq_trans (f.ap (R.CoefPoly.ap2 P i));
    Refine mapGrP_distrib;
  Refine Eq_trans (f.ap (R.CoefPoly.ap2 P' i));
    Refine exten; Refine H;
  Refine Eq_sym; Refine mapGrP_distrib;
Save mapPn_exten;

[     MapGrP : Fun R.Polyn R'.Polyn
          = Fun_intro (mapPn f.ap) mapPn_exten
];

Goal {P:el R.Polyn} {i:obj IMN}
     Eq (R'.CoefPoly.ap2 (MapGrP.ap P) i) (f.ap (R.CoefPoly.ap2 P i));
  Refine mapGrP_distrib;
Save MapGrP_distrib;

Discharge R;

[R : Ring];

[     NegPoly : Fun R.Polyn R.Polyn
          =  MapGrP (InvGr_homoGr|R.applGroup R.PlusRg_commut)
];

Goal {f:R.Polyn.el}{i:obj IMN} Eq (R.CoefPoly.ap2 (NegPoly.ap f) i)
                                  (R.NegRg.ap (R.CoefPoly.ap2 f i));
  Refine MapGrP_distrib;
Save CoefPoly_neg;

Goal rInverse R.PlusPoly R.ZeroPoly NegPoly;
  Intros t i;
  Refine Eq_trans (R.PlusRg.ap2 (R.CoefPoly.ap2 t i) (R.CoefPoly.ap2 (NegPoly.ap t) i));
    Refine CoefPoly_plus;
  Refine Eq_trans (R.PlusRg.ap2 (R.CoefPoly.ap2 t i) (R.NegRg.ap (R.CoefPoly.ap2 t i)));
    Refine exten2; Refine Eq_refl; Refine CoefPoly_neg;
  Refine Eq_trans R.ZeroRg;
    Refine rNegRg_invers;
  Refine Eq_sym; Refine CoefPoly_zero;
Save rNegPoly_invers;

Goal {m:el (Monomial IMN R)}{f:el R.Polyn}
      Eq (R.PlusMP.ap2 ((NegMon IMN R).ap m) (R.PlusMP.ap2 m f)) f;
  intros;
  [M = R.Monomial2Poly.ap m];
  Equiv Eq (R.PlusPoly.ap2 (NegPoly.ap M) (R.PlusPoly.ap2 M f)) f;
  Refine Eq_trans (R.PlusPoly.ap2 (R.PlusPoly.ap2 (NegPoly.ap M) M) f);
    Refine PlusPoly_assoc;
  Refine Eq_trans (R.PlusPoly.ap2 R.ZeroPoly f);
    Refine +1 R.lZeroPoly_ident;
  Refine exten2 ???.Eq_refl;
  Refine Eq_trans (R.PlusPoly.ap2 M (NegPoly.ap M));
    Refine PlusPoly_commut;
  Refine rNegPoly_invers;
Save lPlusMP_invers;

Discharge R;

(* --------------------------------------------------------------------------------
   Define the ring of polynomials.
*)

[R : Ring];

[    PolyRing : Ring
          = Ring_intro R.Polyn R.PlusPoly R.TimesPoly R.NegPoly R.ZeroPoly R.OnePoly
                       R.PlusPoly_assoc R.PlusPoly_commut
                       R.rZeroPoly_ident R.rNegPoly_invers
                       R.TimesPoly_assoc R.OnePoly_ident
                       R.DistribP
];

Goal lInverse R.PlusPoly R.ZeroPoly R.NegPoly;
  Refine PolyRing.lNegRg_invers;
Save lNegPoly_invers;

[     PowerPoly : Fun2 R.Polyn Nat R.Polyn
          = PowerRg PolyRing
];

Discharge IMN;

Goal nat -> indexMonoid -> Ring -> Ring;
  intros n IMN R;
  Refine PolyRing;
  Refine n_indexMonoid IMN n;
  Refine R;
Save nPolyRing;
