
Module Monoid_order Import Monoid Order;

(* Define the notion of a totally ordered monoid. *)

[     sigOMN : Signature
          = Signature_intro (TwoSET_iter ZeroN    (* 1 constant *)
                                         TwoN     (* 1 binary function *)
                            ) 
                            (UnitSET_iter TwoN)   (* 1 binary relation *)
];

Goal axiomsOMN : Axioms sigOMN;
  Refine Axioms_intro;
  Intros A IC IP;
  One    == (IC star21).apn : el A;
  Times  == IC star22       : Fun2 A A A;
  LessEq == IP star         : Rel A A;
  Refine and5 (Associative Times) (Identity Times One)
              (TotallyOrdered LessEq)
              (LessEq_resp_One LessEq One) (LessEq_resp_Times LessEq Times);
Save;

[     orderMonoid
          = Model axiomsOMN
];

Goal orderMonoid_intro
   : {A|Set} {Times|Fun2 A A A} {One|el A} {LE|Rel A A}
     {Times_assoc     : Associative Times}
     {One_ident       : Identity Times One}
     {LE_total_order  : TotallyOrdered LE}
     {LE_One          : LessEq_resp_One LE One}
     {LE_Times        : LessEq_resp_Times LE Times}
     orderMonoid;
  intros;
  Refine Model_intro;
  Refine A;
  Refine TwoSET_elim [c:FuncSymb sigOMN] nFunc A (FuncArity c);
    Refine constant One;
    Refine Times;
  Refine UnitSET_elim [p:PredSymb sigOMN] nPred A (PredArity p);
    Refine LE;
  Refine pair5 Times_assoc One_ident LE_total_order LE_One LE_Times;
Save;

(* --------------------------------------------------------------------------------
   Let OMN be an ordered monoid. Define functions to extract all components of OMN.
*)

[OMN : orderMonoid];
  [OneOMN            : obj OMN               = intCons OMN star21]
  [TimesOMN          : BFunMdl OMN           = intFunc OMN star22]
  [LessEqOMN         : BRelMdl OMN           = intPred OMN star  ];

  [TimesOMN_assoc    : Associative TimesOMN                 = and5_out1 OMN.axioms]
  [OneOMN_ident      : Identity TimesOMN OneOMN             = and5_out2 OMN.axioms]
  [OMN_total_order   : TotallyOrdered LessEqOMN             = and5_out3 OMN.axioms]
  [LessEqOMN_one     : LessEq_resp_One LessEqOMN OneOMN     = and5_out4 OMN.axioms]
  [LessEqOMN_times   : LessEq_resp_Times LessEqOMN TimesOMN = and5_out5 OMN.axioms];

Freeze OneOMN TimesOMN LessEqOMN;

  [lOneOMN_ident     : lIdentity TimesOMN OneOMN = fst OneOMN_ident]
  [rOneOMN_ident     : rIdentity TimesOMN OneOMN = snd OneOMN_ident];

  [MonoidOMN         : Monoid               = Monoid_intro TimesOMN_assoc OneOMN_ident];

  [SquareOMN         : UFunMdl OMN              = SquareMN MonoidOMN];

  [LessEqOMN_refl    : Reflexive LessEqOMN      = OMN_total_order.LessEq_refl]
  [LessEqOMN_antisym : AntiSymmetric LessEqOMN  = OMN_total_order.LessEq_antisym]
  [LessEqOMN_trans   : Transitive LessEqOMN     = OMN_total_order.LessEq_trans]
  [LessEqOMN_total   : Total LessEqOMN          = OMN_total_order.LessEq_total];

  [LessOMN           : BRelMdl OMN              = OMN_total_order.Less]
  [LessOMN_irrefl    : Irreflexive LessOMN      = OMN_total_order.Less_irrefl]
  [LessOMN_trans     : Transitive LessOMN       = OMN_total_order.Less_trans];

(* --------------------------------------------------------------------------------
   Prove some basic properties about OMN.
*)

  Goal {x,y:OMN.obj} LessEqOMN.ap2 x (TimesOMN.ap2 x y);
    intros;
    Refine extenRel ? ? ?.Eq_refl; Refine +1 rOneOMN_ident;
    Refine LessEqOMN_times ?.LessEqOMN_refl;
    Refine LessEqOMN_one;
  Save rLessEqOMN_lemma1;

  Goal {x,y:OMN.obj} LessEqOMN.ap2 x (TimesOMN.ap2 y x);
    intros;
    Refine extenRel ? ? ?.Eq_refl; Refine +1 lOneOMN_ident;
    Refine LessEqOMN_times ? ?.LessEqOMN_refl;
    Refine LessEqOMN_one;
  Save lLessEqOMN_lemma1;

  Goal {x|OMN.obj} ~(Eq x OneOMN) -> (LessOMN.ap2 OneOMN x);
    intros; Refine pair;
    Intros _; Refine H H1.Eq_sym;
    Refine LessEqOMN_one;
  Save LessOMN_lemma1;

  Goal {x:OMN.obj}{y|OMN.obj} (LessOMN.ap2 x y) -> ~(Eq y OneOMN);
    Intros ____;
    Refine Less_irrefl OMN_total_order y;
    Refine extenRel ? H1.Eq_sym ?.Eq_refl;
    Refine LessEqLess_trans OMN_total_order x;
    Refine LessEqOMN_one;
    Refine H;
  Save LessOMN_lemma2;

  Goal {x:OMN.obj} LessEqOMN.ap2 x (SquareOMN.ap x);
    intros;
    Refine rLessEqOMN_lemma1;
  Save LessEqOMN_square_lemma1;

  Goal {x|OMN.obj} (Eq (SquareOMN.ap x) OneOMN) -> Eq x OneOMN;
    intros;
    Refine LessEqOMN_antisym ? ?.LessEqOMN_one;
    Refine extenRel ? ?.Eq_refl H;
    Refine LessEqOMN_square_lemma1;
  Save SquareOMN_one;

  Goal {x|OMN.obj} ~(Eq x OneOMN) -> ~(Eq (SquareOMN.ap x) OneOMN);
    intros _; Refine Contrapos; Refine SquareOMN_one;
  Save SquareOMN_not_one;

  Goal {x|OMN.obj} (LessEqOMN.ap2 x OneOMN) -> Eq x OneOMN;
    intros; Refine LessEqOMN_antisym H; Refine LessEqOMN_one;
  Save LessEqOMN_eq_one;

  Goal r_cancelation LessOMN.ap2 LessOMN.ap2 TimesOMN.ap2;
    Intros ____; orE LessEqOMN_total x y;
    intros;
      Refine pair ? H1; Intros _;
      Refine LessOMN_irrefl (TimesOMN.ap2 x a);
      Refine extenRel ? ?.Eq_refl ? H; Refine exten2 ? H2.Eq_sym ?.Eq_refl;
    intros;
      Refine LessOMN_irrefl (TimesOMN.ap2 x a);
      Refine LessLessEq_trans OMN_total_order (TimesOMN.ap2 y a) H;
      Refine LessEqOMN_times H1 ?.LessEqOMN_refl;
  Save rLessOMN_cancel;

  Goal l_cancelation LessOMN.ap2 LessOMN.ap2 TimesOMN.ap2;
    Intros ____; orE LessEqOMN_total x y;
    intros;
      Refine pair ? H1; Intros _;
      Refine LessOMN_irrefl (TimesOMN.ap2 a x);
      Refine extenRel ? ?.Eq_refl ? H; Refine exten2 ? ?.Eq_refl H2.Eq_sym;
    intros;
      Refine LessOMN_irrefl (TimesOMN.ap2 a x);
      Refine LessLessEq_trans OMN_total_order ? H;
      Refine LessEqOMN_times ?.LessEqOMN_refl H1;
  Save lLessOMN_cancel;

  Goal (Discrete OMN.car) ->
       {x,x',y,y'|OMN.obj} (LessOMN.ap2 (TimesOMN.ap2 x x') (TimesOMN.ap2 y y')) ->
                           ((LessOMN.ap2 x y) \/ (LessOMN.ap2 x' y'));
    intros OMN_discr _____;
    orE LessEqOMN_total x y; intros;
    orE OMN_discr x y;
    intros; Refine inr;
      Refine lLessOMN_cancel x;
      Refine extenRel ? ?.Eq_refl ? H; Refine exten2 ? H2.Eq_sym ?.Eq_refl;
    intros; Refine inl; Refine pair H2 H1;
    intros; Refine inr;
      Refine lLessOMN_cancel x;
      Refine LessLessEq_trans OMN_total_order ? H;
      Refine LessEqOMN_times H1 ?.LessEqOMN_refl;
  Save LessOMN_cancel;

  Goal {x,y|obj OMN} (Eq (TimesOMN.ap2 x y) OneOMN) -> ((Eq x OneOMN) /\ (Eq y OneOMN));
    intros;
    Refine pair;
    Refine LessEqOMN_eq_one; Refine +1 LessEqOMN_eq_one;
    Refine extenRel ? ?.Eq_refl H; Refine rLessEqOMN_lemma1;
    Refine extenRel ? ?.Eq_refl H; Refine lLessEqOMN_lemma1;
  Save OneOMN_lemma1;

(* --------------------------------------------------------------------------------
   Some handy lemma's need the cancelation law. Assume it temporarily for those cases.
*)

  [TimesOMN_cancel : Cancelation TimesOMN];

  [rTimesOMN_cancel : rCancelation TimesOMN = snd TimesOMN_cancel]
  [lTimesOMN_cancel : lCancelation TimesOMN = fst TimesOMN_cancel];

  Goal r_cancelation LessEqOMN.ap2 LessEqOMN.ap2 TimesOMN.ap2;
    Intros ____;
    orE LessEqOMN_total x y; Refine Id;
    intros;
    Refine extenRel ? ?.Eq_refl ? ?.LessEqOMN_refl;
    Refine rTimesOMN_cancel a;
    Refine LessEqOMN_antisym H;
    Refine LessEqOMN_times H1 ?.LessEqOMN_refl;
  Save rLessEqOMN_cancel;

  Goal l_cancelation LessEqOMN.ap2 LessEqOMN.ap2 TimesOMN.ap2;
    Intros ____;
    orE LessEqOMN_total x y; Refine Id;
    intros;
    Refine extenRel ? ?.Eq_refl ? ?.LessEqOMN_refl;
    Refine lTimesOMN_cancel a;
    Refine LessEqOMN_antisym H;
    Refine LessEqOMN_times ?.LessEqOMN_refl H1;
  Save lLessEqOMN_cancel;

  Goal {x,x',y,y'|OMN.obj} (LessEqOMN.ap2 (TimesOMN.ap2 x x') (TimesOMN.ap2 y y')) ->
                           ((LessEqOMN.ap2 x y) \/ (LessEqOMN.ap2 x' y'));
    intros;
    orE LessEqOMN_total x y; Refine inl;
    intros; Refine inr;
    Refine lLessEqOMN_cancel x;
    Refine LessEqOMN_trans ? H;
    Refine LessEqOMN_times H1 ?.LessEqOMN_refl;
  Save LessEqOMN_cancel;

  Goal {x,y|obj OMN}{a:obj OMN} (LessOMN.ap2 x y) ->
       LessOMN.ap2 (TimesOMN.ap2 x a) (TimesOMN.ap2 y a);
    intros;
    Refine pair; Refine +1 LessEqOMN_times H.snd ?.LessEqOMN_refl;
    Intros _; Refine H.fst; Refine rTimesOMN_cancel ? H1;
  Save rLessOMN_times;

  Goal {x,y|obj OMN}{a:obj OMN} (LessOMN.ap2 x y) ->
       LessOMN.ap2 (TimesOMN.ap2 a x) (TimesOMN.ap2 a y);
    intros;
    Refine pair; Refine +1 LessEqOMN_times ?.LessEqOMN_refl H.snd;
    Intros _; Refine H.fst; Refine lTimesOMN_cancel ? H1;
  Save lLessOMN_times;

  Goal preserve2 LessOMN.ap2 LessOMN.ap2 LessOMN.ap2 TimesOMN.ap2;
    Intros ______;
    Refine LessOMN_trans (TimesOMN.ap2 x y');
      Refine lLessOMN_times ? H1;
    Refine rLessOMN_times ? H;
  Save LessOMN_times;

  Goal {x|OMN.obj} ~(Eq x OneOMN) -> LessOMN.ap2 x (SquareOMN.ap x);
    intros;
    Refine extenRel ? ?.rOneOMN_ident ?.Eq_refl;
    Refine lLessOMN_times;
    Refine LessOMN_lemma1 H;
  Save LessOMN_lemma3;

Discharge OMN;

Unfreeze OneOMN TimesOMN LessEqOMN;
