
Module Binomium Import AbMonoid_sum Ring;

(* --------------------------------------------------------------------------------
   Define the binonium by nested induction.

     / n \               / 0 \               /S n\         / n \     / n \
    (     )  ==>  1     (     )  ==>  0     (     )  ==>  (     ) + (     )
     \ 0 /               \S m/               \S m/         \ m /     \S m/

                    / n \
     binom n m  =  (     )
                    \ m /
*)

Goal binom : bop Nat.el;
  Intros n' m'; Refine nat_elim (nat\nat->nat) ?? m' n';
  intros n; Refine OneN;
  intros m ih_m; Refine nat_elim nat\nat;
  Refine zeroN;
  intros n ih_n; Refine plusN (ih_m n) ih_n;
Save;

Goal Binom : Fun2 Nat Nat Nat;
  Refine QFun2 binom;
Save;

(*   / n \
    (     )  =  1
     \ 0 /
*)

Goal {n:el Nat} Eq (Binom.ap2 n ZeroN) OneN;
  intros;
  Refine Eq_refl;
Save Binom_n_zero;

(*   / 0 \
    (     )  =  0
     \S m/
*)

Goal {m:el Nat} Eq (Binom.ap2 ZeroN (Succ.ap m)) ZeroN;
  intros;
  Refine Eq_refl;
Save Binom_zero_Sm;

(*   /S n\      / n \     / n \
    (     )  = (     ) + (     )
     \S m/      \ m /     \S m/
*)

Goal {n,m:el Nat} Eq (Binom.ap2 (Succ.ap n) (Succ.ap m))
                     (PlusN.ap2 (Binom.ap2 n m) (Binom.ap2 n (Succ.ap m)));
  intros;
  Refine Eq_refl;
Save Binom_Sn_Sm;

(*               / n \
    n < m  -->  (     ) = 0
                 \ m /
*)

Goal {n,m|el Nat} (LessN.ap2 n m) -> Eq (Binom.ap2 n m) ZeroN;
  intros n' m';
  Refine nat_elim [m:el Nat]{n:el Nat} (LessN.ap2 n m) -> Eq (Binom.ap2 n m) ZeroN;
  intros n _; Refine LessN_zero H;
  intros m ih_m;
  Refine nat_elim [n:el Nat] (LessN.ap2 n (Succ.ap m)) ->
                                        Eq (Binom.ap2 n (Succ.ap m)) ZeroN;
  intros; Refine Eq_refl;
  intros n ih_n _;
  Refine Eq_trans (PlusN.ap2 ZeroN ZeroN);
    Refine +1 rZeroN_ident;
  Refine exten2 PlusN;
  Refine ih_m;
  Refine +1 ih_n (LessN_succ_intro ?+0);
  Refine LessN_succ_inj H;
Save Binom_less;

(*    / n \
     (     ) = 0
      \ n /
*)

Goal {n:el Nat} Eq (Binom.ap2 n n) OneN;
  Refine nat_elim [n:el Nat] Eq (Binom.ap2 n n) OneN;
  Refine Eq_refl;
  intros n ih;
  Refine Eq_trans (PlusN.ap2 OneN ZeroN);
    Refine +1 rZeroN_ident;
  Refine exten2 PlusN ih;
  Equiv Eq (Binom.ap2 n (succ n)) ZeroN; Refine Binom_less;
  Refine LessN_succ;
Save Binom_n;

(* ================================================================================

   Binomial Theorem.

   Let R be a commutative ring, x and y elements of R and n a natural number.

                              n
                             ---                 / n \
                 n           \      (n-i)   i   (     )
          (x + y)     =      /     x       y     \ i /
                             ---
                             i=0
*)

[R | Ring];

  $[Zero  : el R.car             = R.ZeroRg]
  $[One   : el R.car             = R.OneRg]
  $[Plus  : BFunMdl R            = R.PlusRg]
  $[Times : BFunMdl R            = R.TimesRg]
  $[Mult  : Fun2 R.car Nat R.car = R.MultRg]
  $[Power : Fun2 R.car Nat R.car = R.PowerRg];

[Times_commut : Commutative Times];

[sum0Rg : (Nat.el -> R.obj) -> Nat.el -> R.obj
      = sum0MN|(R.applGroup.MonoidGr)
];

(*     S n			     n
       ---			    ---
       \  	       / n \ 	    \ 		   / n \
       /    (f n i) * (	    )  	=   /   (f n i) * (     )
       ---	       \ i /	    ---		   \ i /
       i=0			    i=0
*)

Goal {f:Nat.el->Nat.el->R.obj} {n:el Nat}
     Eq (sum0Rg ([i:el Nat] Mult.ap2 (f n i) (Binom.ap2 n i)) (Succ.ap n))
        (sum0Rg ([i:el Nat] Mult.ap2 (f n i) (Binom.ap2 n i)) n);
  intros;
  Refine Eq_trans (Plus.ap2 (sum0Rg ([i:el Nat] Mult.ap2 (f n i) (Binom.ap2 n i)) n)
                            Zero);
    Refine +1 rZeroRg_ident;
  Refine exten2 Plus ?.Eq_refl;
  Refine Eq_trans (Mult.ap2 (f n (Succ.ap n)) ZeroN);
    Refine +1 MultRg_zero;
  Refine exten2 ? ?.Eq_refl; Refine Binom_less; Refine LessN_succ;
Save sum0Rg_binom;

(*     S n                           n
       ---      	            ---
       \               /S n\ 	    \ 		   /S n\
       /    (f n i) * (	    )  	=   /   (f n i) * (     )
       ---	       \S i/	    ---		   \S i/
       i=0			    i=0
*)

Goal {f:Nat.el->Nat.el->R.obj} {n:el Nat}
     Eq (sum0Rg ([i:el Nat] Mult.ap2 (f n i) (Binom.ap2 n.succ i.succ)) (Succ.ap n))
        (sum0Rg ([i:el Nat] Mult.ap2 (f n i) (Binom.ap2 n.succ i.succ)) n);
  intros;
  Refine Eq_trans (Plus.ap2
                    (sum0Rg ([i:el Nat] Mult.ap2 (f n i) (Binom.ap2 n.succ i.succ)) n)
                    Zero);
    Refine +1 rZeroRg_ident;
  Refine exten2 Plus ?.Eq_refl;
  Refine Eq_trans (Mult.ap2 (f n (Succ.ap n)) ZeroN);
    Refine +1 MultRg_zero;
  Refine exten2 ? ?.Eq_refl; Refine Binom_less; Refine LessN_succ;
Save sum0Rg_binom';

(* Fix an x and y elements of R. Define

              (n-i)    i
   psi n i = x	    * y


			  / n \     /  (n-i)    i \    / n \
   phi n i = (psi n i) * (     ) =  | x	     * y  | * (     )
			  \ i /	    \             /    \ i /
*)

[x,y : el R.car];

  $[xy : obj R
          = Plus.ap2 x y
  ]
  $[psi : Nat.el -> Nat.el -> R.obj
          = [n,i:el Nat] Times.ap2 (Power.ap2 x (MinusN.ap2 n i)) (Power.ap2 y i)
  ]
  $[phi : Nat.el -> Nat.el -> R.obj
          = [n,i:el Nat] Mult.ap2 (psi n i) (Binom.ap2 n i)
  ];

(*		  0
    		 ---
    	   0	 \     /  (0-i)    i \    / 0 \
    (x + y)   =  /     | x      * y  | * (     )
		 ---   \             /    \ i /
		 i=0
*)

Goal Eq (Power.ap2 xy ZeroN) (sum0Rg (phi ZeroN) ZeroN);
  Refine Eq_trans One;
    Refine PowerRg_zero;
  Refine Eq_sym; Refine Eq_trans (Mult.ap2 One OneN);
    Refine +1 MultRg_one;
  Refine exten2 ? ? ?.Eq_refl;
  Refine Eq_trans (Times.ap2 One One);
    Refine +1 rOneRg_ident;
  Refine exten2;
  Refine PowerRg_zero;
  Refine PowerRg_zero;
Save Binom_lemma0;

(*		  1
    		 ---
    	   1	 \     /  (1-i)    i \    / 1 \
    (x + y)   =  /     | x      * y  | * (     )
		 ---   \             /    \ i /
		 i=0
*)

Goal Eq (Power.ap2 xy OneN) (sum0Rg (phi OneN) OneN);
  Refine Eq_trans xy;
    Refine PowerRg_one;
  Refine Eq_sym;
  Refine exten2 Plus;

  Refine Eq_trans (Mult.ap2 x OneN);
    Refine +1 MultRg_one;
  Refine exten2 ? ? ?.Eq_refl;
  Refine Eq_trans (Times.ap2 x One);
    Refine +1 rOneRg_ident;
  Refine exten2;
  Refine PowerRg_one;
  Refine PowerRg_zero;

  Refine Eq_trans (Mult.ap2 y OneN);
    Refine +1 MultRg_one;
  Refine exten2 ? ? ?.Eq_refl;
  Refine Eq_trans (Times.ap2 One y);
    Refine +1 lOneRg_ident;
  Refine exten2;
  Refine PowerRg_zero;
  Refine PowerRg_one;
Save Binom_lemma1;

(* Let q be a natural number, p=q+1, n=p+1. Assume
        	  p
    		 ---
    	   p	 \     /  (p-i)    i \    / p \
    (x + y)   =  /     | x      * y  | * (     )
		 ---   \             /    \ i /
		 i=0
*)

[q : el Nat] $[p = Succ.ap q] $[n = Succ.ap p];

[ih : Eq (Power.ap2 xy p) (sum0Rg (phi p) p)];

(*	   	      p
       		     ---
    	   p	     \     /  ((p+1)-i)    i \    / p \
    (x + y)  * x  =  /     | x          * y  | * (     )
		     ---   \                 /    \ i /
		     i=0
*)

Goal Eq (Times.ap2 (Power.ap2 xy p) x)
        (sum0Rg ([i:nat] Mult.ap2 (psi p.succ i) (Binom.ap2 p i)) p);
  Refine Eq_trans (Times.ap2 (sum0Rg (phi p) p) x);
    Refine exten2 ? ih ?.Eq_refl;
  Refine Eq_trans (sum0Rg ([i:nat] Times.ap2 (phi p i) x) p);
    Refine sum0MN_distrib|(R.applGroup.MonoidGr) ([a:el R.car] Times.ap2 a x);
    Refine rTimesPlusRg_distrib;
  Refine Eq_trans (sum0Rg ([i:nat] select (LessEqN_partit i p)
                      (Times.ap2 (phi p i) x) (Mult.ap2 (psi n i) (Binom.ap2 p i))) p);
    Refine sum0MN_if|(R.applGroup.MonoidGr) ? ?
                     ([i:el Nat] (ap2 Mult (psi n i) (ap2 Binom p i)));
  Refine sum0MN_exten|(R.applGroup.MonoidGr);
  intros i;
  [xpi = Power.ap2 x (MinusN.ap2 p i)] [yi = Power.ap2 y i] [pi = Binom.ap2 p i];
  orE LessEqN_partit i p;

  intros;
  Refine Eq_trans (Times.ap2 (phi p i) x);
    Refine select_left ? H; Refine LessEqN_partit_ok;
  Refine Eq_trans (Mult.ap2 (Times.ap2 (psi p i) x) pi);
    Refine Eq_sym; Refine rMultTimesRg;
  Refine exten2 ? ? ?.Eq_refl;
  Refine Eq_trans (Times.ap2 (Times.ap2 xpi x) yi);
    Refine R.multMonoid.rTimesMN_commut Times_commut;
  Refine exten2 ? ? ?.Eq_refl;
  Refine Eq_trans (Power.ap2 x (Succ.ap (MinusN.ap2 p i)));
    Refine Eq_sym; Refine PowerRg_succ;
  Refine exten2 ? ?.Eq_refl ?.Eq_sym;
  Refine MinusN_lemma2 H;

  intros; Refine select_right ? H; Refine LessEqN_partit_ok;
Save Binom_lemma2a;

(*	   	      p
       		     ---
    	   p	     \     /  ((S p)-(S i))    (S i) \    / p \
    (x + y)  * y  =  /     | x              * y      | * (     )
		     ---   \                         /    \ i /
		     i=0
*)

Goal Eq (Times.ap2 (Power.ap2 xy p) y)
        (sum0Rg ([i:nat] Mult.ap2 (psi p.succ i.succ) (Binom.ap2 p i)) p);
  Refine Eq_trans (Times.ap2 (sum0Rg (phi p) p) y);
    Refine exten2 ? ih ?.Eq_refl;
  Refine Eq_trans (sum0Rg ([i:nat] Times.ap2 (phi p i) y) p);
    Refine sum0MN_distrib|(R.applGroup.MonoidGr) ([a:el R.car] Times.ap2 a y);
    Refine rTimesPlusRg_distrib;
  Refine sum0MN_exten|(R.applGroup.MonoidGr);
  intros i;
  [xpi = Power.ap2 x (MinusN.ap2 p i)] [yi = Power.ap2 y i] [pi = Binom.ap2 p i];
  Refine Eq_trans (Mult.ap2 (Times.ap2 (psi p i) y) pi);
    Refine Eq_sym; Refine rMultTimesRg;
  Refine exten2 ? ? ?.Eq_refl;
  Refine Eq_trans (Times.ap2 xpi (Times.ap2 yi y));
    Refine Eq_sym; Refine TimesRg_assoc;
  Refine exten2 ? ?.Eq_refl; Refine Eq_sym; Refine PowerRg_succ;
Save Binom_lemma2b;

(*

    	   p	      /  (n-0)	  0 \	 / n \
    (x + y)  * x  =   | x      * y  | * (     )	+
		      \    	    /	 \ 0 /

                      /  p                                      \
		      | ---                                     |
		      | \     /  (n-(S i))    (S i) \    / p \  |
		      | /     | x          * y      | * (     ) |
		      | ---   \                     /    \ i /  |
		      \ i=0                                     /
*)

Goal Eq (Times.ap2 (Power.ap2 xy p) x)
        (Plus.ap2 (phi p.succ ZeroN)
                  (sum0Rg ([i:nat] Mult.ap2 (psi p.succ i.succ) (Binom.ap2 p i.succ))
                          p));
  Refine Eq_trans (sum0Rg ([i:nat] Mult.ap2 (psi n i) (Binom.ap2 p i)) p);
    Refine Binom_lemma2a;
  Refine Eq_trans (Plus.ap2 (phi n ZeroN)
                  (sum0Rg ([i:nat] Mult.ap2 (psi n i.succ) (Binom.ap2 p i.succ)) q));
    Refine sum0MN_zero|(R.applGroup.MonoidGr);
  Refine exten2 ? ?.Eq_refl ?.Eq_sym;
  Refine sum0Rg_binom' ([q,i:el Nat]psi (Succ.ap (Succ.ap q)) (Succ.ap i)) q;
Save Binom_lemma2c;

Discharge q;

(*                            n
                             ---                 / n \
                 n           \      (n-i)   i   (     )
          (x + y)     =      /     x       y     \ i /
                             ---
                             i=0
*)

Goal {n:el Nat}
      Eq (Power.ap2 (Plus.ap2 x y) n)
         (sum0Rg ([i:el Nat] Mult.ap2 (Times.ap2 (Power.ap2 x (MinusN.ap2 n i))
                                                 (Power.ap2 y i))
                                      (Binom.ap2 n i)) n);
  Refine nat_elim [n:el Nat] Eq (Power.ap2 xy n) (sum0Rg (phi n) n);
  Refine Binom_lemma0;

  intros p'; orE ZeroSuccN p';

  intros; Qrepl H; Refine Binom_lemma1;

  intros _; exE H; intros q _; Qrepl H1;
  [p = Succ.ap q] [n = Succ.ap p] [xyp = Power.ap2 xy p];
  Equiv (Eq xyp (sum0Rg (phi p) p)) ->
         Eq (Power.ap2 xy n) (sum0Rg (phi n) n);
  intros ih;
  Refine Eq_trans (Times.ap2 xyp xy);
    Refine PowerRg_succ;
  Refine Eq_trans (Plus.ap2 (Times.ap2 xyp x) (Times.ap2 xyp y));
    Refine lTimesPlusRg_distrib;
  [X = [i:nat] Mult.ap2 (psi n i.succ) (Binom.ap2 p i.succ)]
  [Y = [i:nat] Mult.ap2 (psi n i.succ) (Binom.ap2 p i)];
  Refine Eq_trans (Plus.ap2 (Plus.ap2 (phi n ZeroN) (sum0Rg X p)) (sum0Rg Y p));
    Refine exten2; Refine Binom_lemma2c ? ih; Refine Binom_lemma2b ? ih;
  Refine Eq_trans (Plus.ap2 (phi n ZeroN) (Plus.ap2 (sum0Rg X p) (sum0Rg Y p)));
    Refine Eq_sym; Refine PlusRg_assoc;
  Refine Eq_trans (Plus.ap2 (phi n ZeroN) (sum0Rg ([i:nat]phi n (Succ.ap i)) p));
    Refine +1 Eq_sym; Refine +1 sum0MN_zero|(R.applGroup.MonoidGr);
  Refine exten2 Plus; Refine Eq_refl;
  Refine Eq_trans (sum0Rg (compose2 R.PlusRg.ap2 X Y) p);
    Refine sum0MN_times|(R.applGroup.MonoidGr);
    Refine PlusRg_commut;
  Refine sum0MN_exten|(R.applGroup.MonoidGr);
  intros i;
  Refine Eq_trans (Plus.ap2 (Y i) (X i));
    Refine PlusRg_commut;
  Refine Eq_sym; Refine R.applGroup.MonoidGr.PowerMN_plus;
Save Binom_theom;

Discharge R;
