module odbc_example;

import StdEnv,odbc;

GetDesktopWindow :: Int;
GetDesktopWindow = code {
	ccall GetDesktopWindow@0 ":I"
}

GlobalAlloc :: !Int !Int !*World -> (!Int,!*World);
GlobalAlloc flags size w = code {
	ccall GlobalAlloc@8 "PII:I:A"
}

GlobalFree ::  !Int !*World -> (!Int,!*World);
GlobalFree p w = code {
	ccall GlobalFree@4 "PI:I:A"
}

read_int :: !Int !Int -> Int;
read_int p i = code {
	addI
	pushI -4
	addI
	push_b_a 0
	pop_b 1
	push_arraysize INT 0 1
}

read_char :: !Int !Int -> Char;
read_char s_p i = code {
	pushI -8
	addI
	push_b_a 0
	pop_b 1
	select CHAR 0 1
}

Start world
	# (sql_state,world) = openSqlState world
	# (r,env_h,sql_state) = SQLAllocHandle SQL_HANDLE_ENV SQL_NULL_HANDLE sql_state;
	| r<>SQL_SUCCESS
		= abort "SQLAllocHandle SQL_HANDLE_ENV failed";
	# (r,sql_state) = SQLSetEnvAttr env_h SQL_ATTR_ODBC_VERSION SQL_OV_ODBC2 0 sql_state;
	| r<>SQL_SUCCESS
		= abort "SQLSetEnvAttr failed";
	# (r,dbc_h,sql_state) = SQLAllocHandle SQL_HANDLE_DBC env_h sql_state;
	| r<>SQL_SUCCESS
		= abort "SQLAllocHandle SQL_HANDLE_DBC failed";

	# p="D:\\ODBC";
	# s="DSN=MS Access Database;DBQ="+++p+++"\\Northwind.mdb;DefaultDir="+++p+++";FIL=MS Access;\0";

	# (r,s,l,sql_state) = SQLDriverConnect dbc_h 0 s SQL_NTS 0 SQL_DRIVER_COMPLETE sql_state;
//	# (r,s,l) = SQLDriverConnect dbc_h GetDesktopWindow "\0" SQL_NTS 1024 SQL_DRIVER_COMPLETE;
	| r<>SQL_SUCCESS
		= abort "SQLDriverConnect failed";
	# (r,stmt_h,sql_state) = SQLAllocHandle SQL_HANDLE_STMT dbc_h sql_state;
	| r<>SQL_SUCCESS
		= abort "SQLAllocHandle SQL_HANDLE_STMT failed";
//	# t = "employees";
//	# t = "categories";
//	# t = "products";
//	# t = "suppliers";
	# t = "customers";
//	# t = "\"order details\"";
//	# t = "orders";
//	# t = "shippers";
	# (r,sql_state) = SQLExecDirect stmt_h ("select * from "+++t+++"\0") SQL_NTS sql_state;
	| r<>SQL_SUCCESS
		= abort "SQLExecDirect failed";
	# (r,n_columns,sql_state) = SQLNumResultCols stmt_h sql_state;
	| r<>SQL_SUCCESS
		= abort "SQLNumResultCols failed";

	#! (c,sql_state) = get_col_attributes 1 n_columns stmt_h sql_state;
		with {
			get_col_attributes i n_columns stmt_h sql_state
				| i>n_columns
					= ([],sql_state)
				# (r,display_size,sql_state) = SQLColAttributeInt stmt_h i SQL_DESC_DISPLAY_SIZE sql_state;
				| r<>SQL_SUCCESS
					= abort "SQLColAttribute SQL_DESC_DISPLAY_SIZE failed";				
				# (r,desc_concise_type,sql_state) = SQLColAttributeInt stmt_h i SQL_DESC_CONCISE_TYPE sql_state;
				| r<>SQL_SUCCESS
					= abort "SQLColAttribute SQL_DESC_CONCISE_TYPE failed";								
				# (r,desc_name,l,sql_state) = SQLColAttributeString stmt_h i SQL_DESC_NAME 101 sql_state;
				| r<>SQL_SUCCESS
					= abort "SQLColAttribute SQL_DESC_NAME failed";
				#! (l,sql_state) = get_col_attributes (i+1) n_columns stmt_h sql_state;
				= ([(display_size,desc_concise_type,desc_name):l],sql_state);
		}

//	| True = (r,env_h,dbc_h,c,0,[],sql_state world);

	# row_size = foldl (\ n (display_size,_,_) -> n+4+((display_size+3) bitand -4)) 0 c;
	# (sql_state,world) = syncSqlState sql_state world;
	# (p,world) = GlobalAlloc 0 row_size world;
	| p==0
		= abort "GlobalAlloc failed"
	#! (stmt_h,sql_state) = bind_columns c 1 p 0 stmt_h sql_state;
		with {
			bind_columns [] i p offset stmt_h sql_state
				= (stmt_h,sql_state);
			bind_columns [((display_size,desc_concise_type,desc_name)):cs] i p offset stmt_h sql_state
				# (r,sql_state)=SQLBindCol stmt_h i SQL_C_CHAR (p+offset+4) (display_size+1) (p+offset) sql_state;
				| r<>SQL_SUCCESS
					= abort "SQLBindCol failed"
				= bind_columns cs (i+1) p (offset+4+((display_size+3) bitand -4)) stmt_h sql_state;
		}
	#! (v,sql_state) = fetch stmt_h c p sql_state;
		with {
			fetch stmt_h c p sql_state
				# (r,sql_state)=SQLFetch stmt_h sql_state;
				| r==SQL_NO_DATA_FOUND
					= ([],sql_state)
				| r<>SQL_SUCCESS
					= abort "SQLFetch failed"
				#! (r,v) = get_values c p 0;
				| r==0
					#! (vs,sql_state)=fetch stmt_h c p sql_state;
					= ([v:vs],sql_state);

			get_values [(display_size,desc_concise_type,desc_name):cs] p i
				#! l=read_int p i;
				| l==SQL_NULL_DATA
					#! (r,v) = get_values cs p (i+4+((display_size + 3) bitand -4));
					= (r,["<NULL>":v]);
				| l<=0
					= abort "get_values"
					#! s_p=p+4+i;
					#! s = {read_char s_p n \\ n<-[0..l-1]};
//					# s = if (size s<display_size) (s+++createArray (display_size-size s) ' ') s
					| size s>=0 // to read characters before calling next get_values
						#! (r,v) = get_values cs p (i+4+((display_size + 3) bitand -4));
						= (r,[s:v]);
			get_values [] p i
				= (0,["\n"]);			
		}
	| stmt_h<>stmt_h
		= undef;
	# (sql_state,world) = syncSqlState sql_state world;
	# (r,world) = GlobalFree p world;
	| r<>0
		= abort "GlobalFree failed"
	# (r,sql_state)=SQLFreeStmt stmt_h SQL_CLOSE sql_state;
	| r<>SQL_SUCCESS
		= abort "SQLFreeStmt failed"
	# (r,sql_state)=SQLDisconnect dbc_h sql_state;
	| r<>SQL_SUCCESS
		= abort "SQLDisconnect failed"
	# (r,sql_state)=SQLFreeHandle SQL_HANDLE_DBC dbc_h sql_state;
	| r<>SQL_SUCCESS
		= abort "SQLFreeHandle SQL_HANDLE_DBC failed"
	# (r,sql_state)=SQLFreeHandle SQL_HANDLE_ENV env_h sql_state;
	| r<>SQL_SUCCESS
		= abort "SQLFreeHandle SQL_HANDLE_ENV failed"
	# world=closeSqlState sql_state world
	= (r,env_h,dbc_h,c,row_size,v,world);
