/*
 * Decompiled with CFR 0.152.
 */
package sapllinker;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class FastLinker {
    String DIR_STDENV = "stdenv";
    String DIR_SAPLFILES = "saplfiles";
    String[] stdenvfiles;
    String[] saplfiles;
    Map<String, String[]> modfuncs = new HashMap<String, String[]>();
    Map<String, Module> modules;

    public FastLinker() throws Exception {
        this.stdenvfiles = new File(this.DIR_STDENV).list();
        this.saplfiles = new File(this.DIR_SAPLFILES).list();
        for (int i = 0; i < this.stdenvfiles.length; ++i) {
            String modname = this.stdenvfiles[i];
            if (!modname.endsWith(".deps")) continue;
            modname = modname.substring(0, modname.indexOf(".deps"));
            String string = this.DIR_STDENV;
        }
    }

    List<FuncDepend> readFunDepends(String dir, String modname) throws Exception {
        ArrayList<FuncDepend> funcdepends = new ArrayList<FuncDepend>();
        FileInputStream f = new FileInputStream(dir + "/" + modname + ".deps");
        InputStreamReader isr = new InputStreamReader(f);
        BufferedReader in = new BufferedReader(isr);
        String line = in.readLine();
        while ((line = in.readLine()) != null) {
            StringTokenizer stk = new StringTokenizer(line);
            String name = stk.nextToken();
            ArrayList<String> deps = new ArrayList<String>();
            while (stk.hasMoreTokens()) {
                deps.add(stk.nextToken());
            }
            funcdepends.add(new FuncDepend(name, deps));
        }
        f.close();
        return funcdepends;
    }

    class LinkInfo {
        String[] modnames;
        ModFunc[][] depends;

        LinkInfo() {
        }
    }

    class FuncDepend {
        String funcname;
        String[] depends;

        public FuncDepend(String funcname, List<String> depends) {
            this.funcname = funcname;
            this.depends = depends.toArray(new String[0]);
        }
    }

    class Module {
        String modname;
        FuncDepend[] depends;

        Module() {
        }
    }

    class ModFunc {
        int module;
        int funcnr;

        ModFunc() {
        }
    }
}

