/*
 * Decompiled with CFR 0.152.
 */
package jme;

import java.io.InputStream;
import java.util.BitSet;
import java.util.Map;
import java.util.TreeMap;
import jme.Evaluator;
import jme.Func;
import jme.Reduct;
import jme.SymTable;
import jme.Token;
import jme.Tokenizer;

public class Parse {
    String[] vars = new String[128];
    int nvar;
    BitSet sfuncs;
    BitSet inlinefuncs;
    Map funcnames = new TreeMap();
    String[] localdeffuncs = new String[256];
    int nrlocaldeffuncs = 0;
    boolean hasLocalDef = false;
    boolean localok = true;
    SymTable symtable;
    Tokenizer tnz;
    int nof = 0;
    Evaluator ev;
    boolean showErrors = true;
    boolean autovar = true;
    int curfunc = 0;
    int npat = 0;

    public Parse(Evaluator ev) {
        this.ev = ev;
        this.symtable = new SymTable();
        this.tnz = new Tokenizer();
        this.sfuncs = new BitSet(7000);
        this.inlinefuncs = new BitSet(7000);
    }

    void setVars(int pr) {
        Reduct r = this.ev.cells[pr];
        switch (r.type) {
            case 0: {
                this.setVars(r.l);
                this.setVars(r.r);
                break;
            }
            case 15: {
                int i;
                boolean found = false;
                for (i = 0; i < this.nvar && !found; ++i) {
                    found = this.vars[i].equals(this.symtable.get(r.l));
                }
                if (!found) break;
                this.ev.cells[pr].type = (byte)14;
                this.ev.cells[pr].l = i - 1;
            }
        }
    }

    int readExp(int prevop, int left) throws Exception {
        boolean found = false;
        this.tnz.gettoken();
        switch (this.tnz.tokentype) {
            case Eof: {
                return left;
            }
            case NewLine: 
            case Rpar: {
                return left;
            }
            case Lpar: {
                int pres = this.readExp(-1, -1);
                if (left != -1) {
                    pres = this.makeApp(left, pres);
                }
                if (this.tnz.tokentype != Token.Rpar) {
                    this.tnz.perror("missing )");
                    return -1;
                }
                return this.readExp(prevop, pres);
            }
            case Comma: {
                return left;
            }
            case Iden: {
                if (this.tnz.tokenstring.equals("let")) {
                    return this.readLet();
                }
                if (this.tnz.tokenstring.equals("in")) {
                    return left;
                }
                int pres = this.ev.newR((byte)15, this.symtable.insert(this.tnz.tokenstring), 0);
                if (this.autovar) {
                    int i;
                    for (i = 0; i < this.nvar && !found; ++i) {
                        found = this.vars[i].equals(this.tnz.tokenstring);
                    }
                    if (found) {
                        this.ev.cells[pres].type = (byte)14;
                        this.ev.cells[pres].l = i - 1;
                    }
                }
                if (left >= 0) {
                    pres = this.makeApp(left, pres);
                }
                return this.readExp(prevop, pres);
            }
            case Num: {
                int pres = this.ev.newR((byte)17, this.tnz.tokenval, 0);
                if (left >= 0) {
                    pres = this.makeApp(left, pres);
                }
                return this.readExp(prevop, pres);
            }
            case Char: {
                int pres = this.ev.newR((byte)18, this.tnz.tokenchar, 0);
                if (left >= 0) {
                    pres = this.makeApp(left, pres);
                }
                return this.readExp(prevop, pres);
            }
            case String: {
                int pres = this.makeString(this.tnz.tokenstring);
                if (left > 0) {
                    pres = this.makeApp(left, pres);
                }
                return this.readExp(prevop, pres);
            }
            case AnVar: {
                int pres = this.ev.newR((byte)14, this.nvar + this.tnz.tokenval, 0);
                if (left > 0) {
                    pres = this.makeApp(left, pres);
                }
                return this.readExp(prevop, pres);
            }
            case Local: {
                int pres = this.readLocalFunc();
                if (!this.localok) {
                    this.tnz.perror("Error in local func");
                    return 0;
                }
                if (left >= 0) {
                    pres = this.makeApp(left, pres);
                }
                return pres;
            }
        }
        this.tnz.perror("Unexpected token");
        return 0;
    }

    int makeApp(int l, int r) {
        int res = this.ev.newR((byte)0, l, r);
        return res;
    }

    int makeList(int hd, int tl) {
        return this.ev.newR((byte)0, this.ev.newR((byte)0, this.ev.newR((byte)15, this.symtable.insert("cons"), 0), hd), tl);
    }

    void setTail(int lst, int tl) {
        this.ev.cells[lst].r = tl;
    }

    int makeCharList(String ts) {
        int res;
        int k = 0;
        String str = ts;
        int nullist = this.ev.newR((byte)15, this.symtable.insert("nil"), 0);
        if (ts.length() == 0) {
            return nullist;
        }
        char ch = str.charAt(k);
        int h1 = res = this.ev.newR((byte)0, this.ev.newR((byte)0, this.ev.newR((byte)15, this.symtable.insert("cons"), 0), this.ev.newR((byte)18, ch, 0)), nullist);
        ++k;
        for (k = 1; k < str.length(); ++k) {
            int h2;
            ch = str.charAt(k);
            this.ev.cells[h1].r = h2 = this.makeList(this.ev.newR((byte)18, ch, 0), nullist);
            h1 = h2;
        }
        return res;
    }

    int makeString(String ts) {
        return this.ev.newSTRING(ts);
    }

    Func readFunc() throws Exception {
        this.hasLocalDef = false;
        String name = this.tnz.tokenstring;
        this.nvar = 0;
        this.tnz.gettoken();
        while (this.tnz.tokentype == Token.Iden) {
            this.vars[this.nvar++] = this.tnz.tokenstring;
            this.tnz.gettoken();
        }
        if (this.tnz.tokentype != Token.Eq && this.tnz.tokentype != Token.Sel) {
            this.tnz.perror("= expected");
        }
        boolean isSel = this.tnz.tokentype == Token.Sel;
        int body = this.readExp(-1, -1);
        Func res = new Func(name, this.nvar, body);
        this.nvar = 0;
        if (this.hasLocalDef) {
            this.localdeffuncs[this.nrlocaldeffuncs++] = name;
        }
        return res;
    }

    void shiftvars(int shift, String[] lvars) {
        if (shift > 0) {
            int i;
            for (i = 1; i <= this.nvar; ++i) {
                this.vars[this.nvar - i + shift] = this.vars[this.nvar - i];
            }
            for (i = 0; i < shift; ++i) {
                this.vars[i] = lvars[i];
            }
            this.nvar += shift;
        } else {
            for (int i = 0; i < this.nvar; ++i) {
                this.vars[i] = this.vars[i - shift];
            }
            this.nvar += shift;
        }
    }

    int readLocalFunc() throws Exception {
        String[] lvars = new String[128];
        int nlvar = 0;
        this.tnz.gettoken();
        while (this.tnz.tokentype == Token.Iden) {
            lvars[nlvar++] = this.tnz.tokenstring;
            this.tnz.gettoken();
        }
        if (this.tnz.tokentype != Token.Eq) {
            this.tnz.perror("= expected");
            this.localok = false;
            return 0;
        }
        this.shiftvars(nlvar, lvars);
        int body = this.readExp(-1, -1);
        this.shiftvars(-nlvar, lvars);
        return this.ev.newR((byte)12, body, nlvar);
    }

    void reverseVars(String[] vars, int nvars) {
        for (int i = 0; i < nvars / 2; ++i) {
            String tmp = vars[i];
            vars[i] = vars[nvars - i - 1];
            vars[nvars - i - 1] = tmp;
        }
    }

    int readLet() throws Exception {
        String[] lvars = new String[64];
        int[] bodies = new int[64];
        int nrlet = 0;
        boolean ready = false;
        this.autovar = false;
        while (!ready) {
            this.tnz.gettoken();
            if (this.tnz.tokentype != Token.Iden) {
                this.tnz.perror("identifier expected");
                return 0;
            }
            lvars[nrlet] = this.tnz.tokenstring;
            this.tnz.gettoken();
            if (this.tnz.tokentype != Token.Eq) {
                this.tnz.perror("= expected");
                return 0;
            }
            bodies[nrlet++] = this.readExp(-1, -1);
            if (this.tnz.tokenstring.equals("in")) {
                ready = true;
                continue;
            }
            if (this.tnz.tokentype == Token.Comma) continue;
            this.tnz.perror("',' or 'in' expected");
        }
        this.autovar = true;
        this.reverseVars(lvars, nrlet);
        this.shiftvars(nrlet, lvars);
        for (int i = 0; i < nrlet; ++i) {
            this.setVars(bodies[i]);
        }
        int fbody = this.readExp(-1, -1);
        this.shiftvars(-nrlet, lvars);
        int res = this.ev.newR((byte)16, bodies[nrlet - 1], fbody);
        for (int i = nrlet - 2; i >= 0; --i) {
            res = this.ev.newR((byte)16, bodies[i], res);
        }
        this.ev.cells[res].funcnr = (short)nrlet;
        return res;
    }

    int readLetold() throws Exception {
        String[] lvars = new String[1];
        this.tnz.gettoken();
        if (this.tnz.tokentype != Token.Iden) {
            this.tnz.perror("identifier expected");
            return 0;
        }
        lvars[0] = this.tnz.tokenstring;
        this.tnz.gettoken();
        if (this.tnz.tokentype != Token.Eq) {
            this.tnz.perror("= expected");
            return 0;
        }
        this.shiftvars(1, lvars);
        this.autovar = false;
        int body = this.readExp(-1, -1);
        this.setVars(body);
        this.autovar = true;
        if (!this.tnz.tokenstring.equals("in")) {
            this.tnz.perror("in expected");
            return 0;
        }
        int fbody = this.readExp(-1, -1);
        this.shiftvars(-1, lvars);
        int res = this.ev.newR((byte)16, body, fbody);
        return res;
    }

    void setPVar(Func f) {
        int body;
        int t = body = f.body[0];
        int depth = 0;
        while (this.ev.cells[t].type == 0 || this.ev.cells[t].type == 1) {
            ++depth;
            t = this.ev.cells[t].l;
        }
        if (this.ev.cells[t].type == 14) {
            short pvar = (short)this.ev.cells[t].l;
            f.selnr = pvar = (short)(pvar - depth);
            f.nrpatarg = depth;
        } else {
            f.selnr = 0;
        }
    }

    boolean isselfunc(int funcnr) {
        return this.sfuncs.get(funcnr);
    }

    boolean islocaldeffunc(String s) {
        for (int k = 0; k < this.nrlocaldeffuncs; ++k) {
            if (!this.localdeffuncs[k].equals(s)) continue;
            return true;
        }
        return false;
    }

    int copyinline(int pt, int[] args, int nrargs) {
        int res;
        Reduct t = this.cell(pt);
        if (t.type < 8) {
            res = this.ev.newR(t.type, this.copyinline(t.l, args, nrargs), this.copyinline(t.r, args, nrargs), t.funcnr);
        } else if (t.type < 14) {
            res = this.ev.newR(t.type, this.copyinline(t.l, args, nrargs), t.r, t.funcnr);
        } else if (t.type == 14) {
            res = args[nrargs - 1 - t.l];
        } else if (t.type == 15) {
            res = this.ev.newR((byte)15, t.l, t.r, t.funcnr);
        } else {
            return pt;
        }
        return res;
    }

    void setBIN(int pred, Func[] funcs) {
        int pappp = 0;
        Reduct red = this.cell(pred);
        switch (red.type) {
            case 16: {
                this.setBIN(red.l, funcs);
                this.setBIN(red.r, funcs);
                break;
            }
            case 12: {
                this.setBIN(red.l, funcs);
                break;
            }
            case 15: {
                if (!this.isselfunc(red.funcnr) || funcs[red.funcnr].nrpatarg != 0) break;
                red.type = (byte)21;
                red.r = funcs[red.funcnr].selnr;
                break;
            }
            case 0: {
                int[] args = new int[100];
                int p = 0;
                int pt = pred;
                Reduct t = this.cell(pt);
                boolean pos_inline = true;
                while (t.type == 0) {
                    byte rtype = this.cell((int)t.r).type;
                    this.setBIN(t.r, funcs);
                    args[p++] = t.r;
                    pappp = pt;
                    pt = t.l;
                    t = this.cell(pt);
                }
                if (pos_inline && t.type == 15 && this.inlinefuncs.get(t.funcnr) && p == funcs[t.funcnr].nvar) {
                    int newp = this.copyinline(funcs[t.funcnr].body[0], args, p);
                    red.overwrite(this.cell(newp));
                    this.setBIN(pred, funcs);
                    return;
                }
                short ty = t.type;
                short funcnr = t.funcnr;
                if (ty == 23) {
                    if (p == 2 && funcnr != 29) {
                        int dif = -12;
                        red.funcnr = funcnr != 30 && funcnr != 33 && funcnr != 35 && funcnr != 34 && funcnr != 40 ? (short)(funcnr + dif) : funcnr;
                        red.type = (byte)3;
                        red.l = args[p - 1];
                        red.r = args[p - 2];
                        if (red.funcnr == 0 && this.cell((int)red.r).type == 17) {
                            red.type = (byte)13;
                            red.funcnr = (short)24;
                            red.r = this.cell((int)red.r).l;
                            break;
                        }
                        if (red.funcnr == 1 && this.cell((int)red.r).type == 17) {
                            red.type = (byte)13;
                            red.funcnr = (short)24;
                            red.r = -this.cell((int)red.r).l;
                            break;
                        }
                        if (red.funcnr != 5 || this.cell((int)red.r).type != 17) break;
                        red.type = (byte)13;
                        red.funcnr = (short)25;
                        red.r = this.cell((int)red.r).l;
                        break;
                    }
                    if (p == 1 && (funcnr == 28 || funcnr == 29 || funcnr == 27 || funcnr == 31 || funcnr == 32 || funcnr == 36 || funcnr == 37 || funcnr == 38 || funcnr == 41)) {
                        red.funcnr = funcnr;
                        red.type = (byte)13;
                        red.l = args[0];
                        break;
                    }
                    if (p <= 1 || funcnr != 29) break;
                    this.cell((int)pappp).funcnr = funcnr;
                    this.cell((int)pappp).type = (byte)13;
                    this.cell((int)pappp).l = args[p - 1];
                    break;
                }
                if (ty != 15) break;
                if (p == 2) {
                    red.type = this.isselfunc(t.funcnr) && funcs[t.funcnr].nrpatarg == 2 ? (byte)4 : (byte)5;
                    red.funcnr = t.funcnr;
                    red.l = args[p - 1];
                    red.r = args[p - 2];
                    break;
                }
                if (p == 1) {
                    if (this.isselfunc(t.funcnr) && funcs[t.funcnr].nrpatarg == 1) {
                        red.type = (byte)9;
                        red.r = funcs[t.funcnr].selnr;
                    } else {
                        red.type = (byte)8;
                    }
                    red.funcnr = t.funcnr;
                    red.l = args[p - 1];
                    break;
                }
                if (!this.isselfunc(t.funcnr) || funcs[t.funcnr].nrpatarg != p) break;
                red.type = 1;
                red.funcnr = funcs[t.funcnr].selnr;
            }
        }
    }

    boolean isPatDef(int pt) {
        Reduct t = this.cell(pt);
        while (t.type == 0 || t.type == 1) {
            pt = t.l;
            t = this.cell(pt);
        }
        return t.type == 27;
    }

    boolean isPatDef(Func f) {
        return this.isPatDef(f.body[0]);
    }

    void makePats(int[] pats, int[] nrlvars, int[] lastpats, int current_pat, int nlvar) {
        int nlpat = 0;
        int tnlv = 0;
        int pt = pats[current_pat];
        Reduct t = this.cell(pt);
        int[] tmp = new int[128];
        while (t.type == 0 || t.type == 1) {
            tmp[nlpat++] = t.r;
            pt = t.l;
            t = this.cell(pt);
        }
        for (int i = 0; i < nlpat - 1; ++i) {
            pats[this.npat + i] = tmp[nlpat - i - 2];
        }
        pats[current_pat] = current_pat != 0 ? this.ev.newR((byte)11, tmp[nlpat - 1], this.npat) : tmp[nlpat - 1];
        int onpat = this.npat;
        this.npat += nlpat - 1;
        for (int i = 0; i < nlpat - 1; ++i) {
            if (this.cell((int)pats[onpat + i]).type == 12) {
                tnlv = this.cell((int)pats[onpat + i]).r;
                pats[onpat + i] = this.cell((int)pats[onpat + i]).l;
                nrlvars[onpat + i] = nlvar + tnlv;
            } else {
                tnlv = 0;
                nrlvars[onpat + i] = nlvar;
            }
            if (this.isPatDef(pats[onpat + i])) {
                this.makePats(pats, nrlvars, lastpats, onpat + i, nlvar + tnlv);
                lastpats[onpat + i] = 0;
                continue;
            }
            lastpats[onpat + i] = 1;
        }
    }

    void makePatterns(Func f) {
        int[] pats = new int[1000];
        int[] nrlvars = new int[1000];
        int[] lastpats = new int[1000];
        this.npat = 1;
        int current_pat = 0;
        pats[0] = f.body[0];
        nrlvars[0] = 0;
        lastpats[0] = 0;
        this.makePats(pats, nrlvars, lastpats, current_pat, 0);
        int[] res = new int[this.npat];
        f.nrlvars = new int[this.npat];
        f.lastpats = new int[this.npat];
        f.npat = this.npat;
        for (int i = 0; i < this.npat; ++i) {
            res[i] = pats[i];
            f.nrlvars[i] = nrlvars[i];
            f.lastpats[i] = lastpats[i];
        }
        f.body = res;
    }

    int getselnr(int e, Func[] funcs) {
        int pt = e;
        Reduct t = this.cell(pt);
        while (t.type == 0 || t.type == 1) {
            pt = t.l;
            t = this.cell(pt);
        }
        return funcs[t.funcnr].selnr;
    }

    void setSel(Func f, int fnr) {
        int pt = f.body[0];
        Reduct t = this.cell(pt);
        int na = 0;
        int firstvar = -1;
        boolean ok = true;
        while (ok && t.type == 0 && this.cell((int)t.r).type == 14) {
            if (firstvar == -1) {
                firstvar = this.cell((int)t.r).l;
            } else {
                ok = this.cell((int)t.r).l == firstvar - na;
            }
            pt = t.l;
            t = this.cell(pt);
            ++na;
        }
        if (ok && t.type == 14 && na == firstvar + 1) {
            this.sfuncs.set(fnr);
            this.setPVar(f);
        } else {
            this.setInline(f, fnr);
        }
    }

    void setInline(Func f, int funcnr) {
        int pt = f.body[0];
        Reduct t = this.cell(pt);
        boolean ok = true;
        while (ok && t.type == 0) {
            ok = this.cell((int)t.r).type == 14;
            pt = t.l;
            t = this.cell(pt);
        }
        if (ok && t.type != 27 && t.type != 16) {
            this.inlinefuncs.set(funcnr);
        }
    }

    void checkNestedSelectIf(int pred, boolean notnested) {
        int[] args = new int[100];
        int p = 0;
        int pt = pred;
        Reduct t = this.cell(pt);
        switch (t.type) {
            default: 
        }
        while (t.type == 0) {
            args[p++] = t.r;
            pt = t.l;
            t = this.cell(pt);
        }
        if (t.type == 27) {
            // empty if block
        }
    }

    isSys isSysFunc(String n) {
        if (n.equals("true")) {
            return new isSys(true, 19);
        }
        if (n.equals("false")) {
            return new isSys(true, 20);
        }
        if (n.equals("True")) {
            return new isSys(true, 19);
        }
        if (n.equals("False")) {
            return new isSys(true, 20);
        }
        if (n.equals("if")) {
            return new isSys(true, 27);
        }
        if (n.equals("case")) {
            return new isSys(true, 27);
        }
        if (n.equals("select")) {
            return new isSys(true, 27);
        }
        if (n.equals("string_update")) {
            return new isSys(true, 24);
        }
        if (n.equals("string_slice")) {
            return new isSys(true, 25);
        }
        return new isSys(false, 20);
    }

    short isOper(String n) {
        if (n.equals("add")) {
            return 12;
        }
        if (n.equals("sub")) {
            return 13;
        }
        if (n.equals("mult")) {
            return 14;
        }
        if (n.equals("div")) {
            return 15;
        }
        if (n.equals("mod")) {
            return 16;
        }
        if (n.equals("ge")) {
            return 20;
        }
        if (n.equals("gt")) {
            return 19;
        }
        if (n.equals("eq")) {
            return 17;
        }
        if (n.equals("neq")) {
            return 18;
        }
        if (n.equals("bitand")) {
            return 21;
        }
        if (n.equals("shiftleft")) {
            return 22;
        }
        if (n.equals("shiftright")) {
            return 23;
        }
        if (n.equals("sapldebug")) {
            return 30;
        }
        if (n.equals("sapldebug_sapldebug")) {
            return 30;
        }
        if (n.equals("string_create")) {
            return 33;
        }
        if (n.equals("string_select")) {
            return 34;
        }
        if (n.equals("string_append")) {
            return 35;
        }
        if (n.equals("fwrite")) {
            return 40;
        }
        return -1;
    }

    short isSingOper(String n) {
        if (n.equals("toChar")) {
            return 27;
        }
        if (n.equals("toInt")) {
            return 28;
        }
        if (n.equals("string_to_graph")) {
            return 29;
        }
        if (n.equals("graph_to_sapl_string_string_to_graph")) {
            return 29;
        }
        if (n.equals("graph_to_string")) {
            return 31;
        }
        if (n.equals("graph_to_sapl_string_graph_to_sapl_string")) {
            return 31;
        }
        if (n.equals("strlen")) {
            return 36;
        }
        if (n.equals("_string_create")) {
            return 32;
        }
        if (n.equals("error")) {
            return 37;
        }
        if (n.equals("abort")) {
            return 38;
        }
        if (n.equals("fread")) {
            return 41;
        }
        return -1;
    }

    void funcloop(Func[] funcs) throws Exception {
        int i = 0;
        int prevnof = this.nof = 0;
        this.tnz.line = 0;
        this.tnz.indent = 0;
        this.tnz.gettoken();
        while (this.tnz.tokentype == Token.NewLine) {
            this.tnz.gettoken();
        }
        while (this.tnz.tokentype != Token.Eof) {
            funcs[this.nof] = this.readFunc();
            this.funcnames.put(funcs[this.nof].name, this.nof);
            ++this.nof;
            while (this.tnz.tokentype == Token.NewLine) {
                this.tnz.gettoken();
            }
        }
        for (i = prevnof; i < this.nof; ++i) {
            try {
                this.substfuncs(funcs[i].body[0], funcs);
                continue;
            }
            catch (Exception ex) {
                System.out.println("In " + funcs[i].name + ": " + ex.getMessage());
            }
        }
        for (i = prevnof; i < this.nof; ++i) {
            this.setSel(funcs[i], i);
        }
        for (i = prevnof; i < this.nof; ++i) {
            this.curfunc = i;
            this.setBIN(funcs[i].body[0], funcs);
        }
        for (i = prevnof; i < this.nof; ++i) {
            if (!this.isPatDef(funcs[i])) continue;
            this.makePatterns(funcs[i]);
        }
        for (i = prevnof; i < this.nof; ++i) {
            int npat = funcs[i].npat;
            for (int l = 0; l < npat; ++l) {
                this.setPFUNC(funcs[i].body[l], funcs);
            }
        }
    }

    short findfunc(String s, Func[] funcs) throws Exception {
        for (short k = 0; k < this.nof; k = (short)(k + 1)) {
            if (!funcs[k].name.equals(s)) continue;
            return k;
        }
        if (this.showErrors) {
            System.out.println("Function " + s + " not found");
        }
        return -1;
    }

    int substfuncs(int pred, Func[] funcs) throws Exception {
        Reduct red = this.cell(pred);
        switch (red.type) {
            case 15: {
                isSys issys = this.isSysFunc(this.symtable.get(red.l));
                if (issys.ok) {
                    red.type = (byte)issys.type;
                    break;
                }
                short oper = this.isOper(this.symtable.get(red.l));
                if (oper >= 0) {
                    red.type = (byte)23;
                    red.funcnr = oper;
                    break;
                }
                oper = this.isSingOper(this.symtable.get(red.l));
                if (oper >= 0) {
                    red.type = (byte)23;
                    red.funcnr = oper;
                    break;
                }
                Integer fn = (Integer)this.funcnames.get(this.symtable.get(red.l));
                if (fn != null) {
                    red.funcnr = fn.shortValue();
                    red.r = 0;
                    break;
                }
                red.type = (byte)37;
                System.out.println("Function " + this.symtable.get(red.l) + " not found.");
                break;
            }
            case 0: 
            case 1: 
            case 16: {
                this.substfuncs(red.l, funcs);
                this.substfuncs(red.r, funcs);
                break;
            }
            case 12: {
                this.substfuncs(red.l, funcs);
            }
        }
        return pred;
    }

    int setPFUNC(int pred, Func[] funcs) {
        Reduct red = this.cell(pred);
        switch (red.type) {
            case 15: {
                if (funcs[red.funcnr].npat <= 1) break;
                red.type = (byte)22;
                break;
            }
            case 5: {
                if (funcs[red.funcnr].npat > 1) {
                    red.type = (byte)6;
                }
                this.setPFUNC(red.l, funcs);
                this.setPFUNC(red.r, funcs);
                break;
            }
            case 4: {
                this.setPFUNC(red.l, funcs);
                this.setPFUNC(red.r, funcs);
                break;
            }
            case 8: {
                if (funcs[red.funcnr].npat > 1) {
                    red.type = (byte)10;
                }
                this.setPFUNC(red.l, funcs);
                break;
            }
            case 9: {
                this.setPFUNC(red.l, funcs);
                break;
            }
            case 11: 
            case 13: {
                this.setPFUNC(red.l, funcs);
                break;
            }
            case 0: 
            case 1: 
            case 3: 
            case 7: 
            case 16: {
                this.setPFUNC(red.l, funcs);
                this.setPFUNC(red.r, funcs);
            }
        }
        return pred;
    }

    void readfuncs(String ffile) throws Exception {
        long start = System.currentTimeMillis();
        this.sfuncs.clear();
        this.inlinefuncs.clear();
        this.tnz.readFile(ffile);
        this.funcloop(this.ev.funcs);
        this.ev.nof = this.nof;
        System.out.println("Reading time " + (System.currentTimeMillis() - start) + " ms");
    }

    void readInputStream(InputStream stream) throws Exception {
        this.sfuncs.clear();
        this.inlinefuncs.clear();
        this.tnz.readInputStream(stream);
        this.funcloop(this.ev.funcs);
        this.ev.nof = this.nof;
    }

    void readfuncsfromstring(String defs) throws Exception {
        this.sfuncs.clear();
        this.inlinefuncs.clear();
        this.tnz.readString(defs);
        this.funcloop(this.ev.funcs);
        this.ev.nof = this.nof;
    }

    int readExpression(String line) throws Exception {
        this.tnz.readString(line);
        int e = this.readExp(-1, -1);
        if (this.tnz.tokentype != Token.Eof) {
            while (this.tnz.tokentype != Token.Eof) {
                this.tnz.gettoken();
            }
        }
        this.substfuncs(e, this.ev.funcs);
        this.setBIN(e, this.ev.funcs);
        this.setPFUNC(e, this.ev.funcs);
        return e;
    }

    Reduct left(int i) {
        return this.ev.cells[this.ev.cells[i].l];
    }

    Reduct right(int i) {
        return this.ev.cells[this.ev.cells[i].r];
    }

    Reduct cell(int i) {
        return this.ev.cells[i];
    }

    class isSys {
        boolean ok;
        short type;

        public isSys(boolean b, short t) {
            this.ok = b;
            this.type = t;
        }
    }
}

