definition module EdMenuItems;

//
// Operations for updating the menu bar
//

import EdTypes, EdProgramState;

/*	updates the menu items after an edit operation has taken place.
	i.e. after actions selected from the edit/search menu's or mouse/keyboard events. */
	
Edit_UpdateMenuItems :: !ProgState !IO -> ProgIO;

/*	updates the menu items after a new window has been opened */

Opened_UpdateMenuItems :: !EditWdId !Int !EditWdId !String !ProgState !IO -> ProgIO;

/*	updates the menu items after a window has been closed */

Closed_UpdateMenuItems :: !Bool !EditWdId !ProgState !IO -> ProgIO;

/*	updates the menu items after a new window has been set in front. */

Window_UpdateMenuItems :: !EditWdId !EditWdId !ProgState !IO -> ProgIO;

/*	updates the menu items after the text in the front window or the project has been saved. */

Saved_UpdateMenuItems :: !Pathname !ProgState !IO -> ProgIO;

/*	updates the menu items after the text in the front window has been saved due to text typed
	on the keyboard */
	
Changed_UpdateMenuItems :: !ProgState !IO -> ProgIO;

/*	updates the menu items after an undoable action was followed by typing text */

Undo_UpdateMenuItems :: !ProgState !IO -> ProgIO;
