implementation module mandelbrot;

import StdEnv;
import gtk,gtk_window,gtk_scrolled_window;
import gtk_widget,gtk_container;
import gtk_drawing_area;
import gtk_style;
import gdk,gdk_threads,gdk_rgb;
import g_signal;
import glib;

import StdDebug;

global_argc_p :: Int;
global_argc_p = code {
	pushLc global_argc
}

global_argv_p :: Int;
global_argv_p = code {
	pushLc global_argv
}

load_int32 :: !Int -> Int;
load_int32 p = code {
	instruction 139
	instruction 0
|   8b 00       mov    (%eax),%eax
}

load_int :: !Int -> Int;
load_int p = code {
	load_i 0
|	instruction 72
|	instruction 139
|	instruction 0
|   8b 00       mov    (%rax),%rax
}

store_byte :: !Int !Int !Int -> Int;
store_byte v o p = code {
	instruction 68
	instruction 136
	instruction 20
	instruction 3
|  44 88 14 03          	mov    %r10b,(%rbx,%rax,1)
	pop_b 2
}

store_int :: !Int !Int !Int -> Int;
store_int v o p = code {
	push_b 1
	pushI -8
	addI
	update_b 0 2
	pop_b 1

	push_b 2
	push_b 2
	addI
	push_b_a 0
	pop_b 1
	fill1_r _ 0 1 0 01
	push_a_b 0
	pop_a 1

	push_b 1
	push_b 1
	subI
	updatepop_b 0 3
}

(:>) infixl;
(:>) s f :== f s;

foreign export destroy_window_callback;

destroy_window_callback_adress :: Int;
destroy_window_callback_adress = code {
	pushLc destroy_window_callback
}

destroy_window_callback :: !GtkWidgetP !Int -> Int;
destroy_window_callback widget data
	# gs = newGtkSt;
	  gs = gs:> gtk_main_quit
	= endGtkSt gs;

foreign export expose_drawing_area;

expose_drawing_area_adress :: Int;
expose_drawing_area_adress = code {
	pushLc expose_drawing_area
}

Depth:==512;

fractal :: !(!Real,!Real) !Int !(!Real,!Real) -> Int;
fractal (r,i) iter c=:(cr,ci)
	# (r2,i2) = (r*r,i*i);
	| r2 + i2 <= 4.0
		| iter < Depth
			# pri=r*i;
			= fractal (r2-i2+cr,pri+pri+ci) (iter+1) c;
//			= fractal (r2-i2+cr,2.0*pri+ci) (iter+1) c;
			= iter;
		= iter;

fractal_pixel_color x y 
  #	w=1000.0;
	h= 800.0;
	c = (2.0*toReal x/w - 1.5, 2.0*toReal y/h - 1.0);
  	n = fractal (0.0,0.0) 0 c;
  = rgb_color (n bitand 7);  	

rgb_color 0 = 0x000000;
rgb_color 1 = 0xff0000;
rgb_color 2 = 0x00ff00;
rgb_color 3 = 0x0000ff;
rgb_color 4 = 0xffff00;
rgb_color 5 = 0x00ffff;
rgb_color 6 = 0xff00ff;
rgb_color 7 = 0xffffff;

draw_mandelbrot :: !Int !Int !Int !Int !Int !GtkSt -> (!Int,!GtkSt);
draw_mandelbrot y end_y p gdk_window black_gc gs
	| y<end_y
		# p = store_line_colors 0 y 0 p;
		  gs = gs :> gdk_threads_enter;
	      gs = gs :> gdk_draw_rgb_image gdk_window black_gc 0 y 1000 1 GDK_RGB_DITHER_NORMAL p 3000;
		  gs = gs :> gdk_threads_leave;
//		  gs = gs :> gdk_flush;
		= draw_mandelbrot (y+1) end_y p gdk_window black_gc gs;
		= (p,gs);

store_line_colors :: !Int !Int !Int !Int -> Int;
store_line_colors x y o p
	| x<1000
		# color = fractal_pixel_color x y;
		# p = store_byte color o p;
		# p = store_byte (color>>8) (o+1) p
		# p = store_byte (color>>16) (o+2) p
		= store_line_colors (x+1) y (o+3) p;
		= p;

foreign export thread_function;

thread_function :: !Int -> Int;
thread_function p
	# gs = newGtkSt;
	# (buffer_p,gs) = g_malloc 3000 gs;
	| buffer_p==0
		= abort "g_malloc failed";
		= thread_loop buffer_p gs p;

thread_loop :: !Int !GtkSt !Int -> Int;
thread_loop buffer_p gs p
	# semb = load_int (p+24);
	# seme = load_int (p+32);
	# r = sem_wait semb;
	| r<>0
		= abort "sem_wait failed";

	# thread_n = load_int (p+48);

	# gtk_widget_a = load_int (p+40);
	# gdk_window = load_int (gtk_widget_window_offset+gtk_widget_a);
	# black_gc = load_int (gtk_style_black_gc_offset+load_int (gtk_widget_style_offset+gtk_widget_a));

	# (y,end_y)
		= case thread_n of {
			0 -> (0,230);
			1 -> (230,400);
			2 -> (400,570);
			3 -> (570,800);
		  }

	# (buffer_p,gs) = draw_mandelbrot y end_y buffer_p gdk_window black_gc gs;
	| buffer_p==0
		= abort "buffer_p == 0";

	# r = sem_post seme;
	| r<>0
		= abort "sem_post failed";
	 = thread_loop buffer_p gs p;

expose_drawing_area :: !GtkWidgetP !Int !Int -> Int;
expose_drawing_area widget event_p p
	# gs = newGtkSt;

	# r = sem_post (load_int (p+0));
	| r<>0
		= abort "sem_post failed";

	# r = sem_post (load_int (p+16));
	| r<>0
		= abort "sem_post failed";

	# r = sem_post (load_int (p+32));
	| r<>0
		= abort "sem_post failed";

	# r = sem_post (load_int (p+48));
	| r<>0
		= abort "sem_post failed";


	# gs = gs :> gdk_threads_leave;
	# (t,gs) = trueGtkSt gs;
	| not t
		= undef;

	# r = sem_wait (load_int (p+8));
	| r<>0
		= abort "sem_wait failed";

	# r = sem_wait (load_int (p+24));
	| r<>0
		= abort "sem_wait failed";

	# r = sem_wait (load_int (p+40));
	| r<>0
		= abort "sem_wait failed";

	# r = sem_wait (load_int (p+56));
	| r<>0
		= abort "sem_wait failed";

	# gs = gs :> gdk_threads_enter;
	# (t,gs) = trueGtkSt gs;
	| not t
		= undef;
/*
	# gtk_widget_a = gtk_widget_p_to_int widget;
	  gdk_window = load_int (gtk_widget_window_offset+gtk_widget_a);
	#  black_gc = load_int (gtk_style_black_gc_offset+load_int (gtk_widget_style_offset+gtk_widget_a));

	| trace_tn ("expose_drawing_area "+++toString gdk_window+++" "+++toString black_gc)

	# (buffer_p,gs) = g_malloc 3000 gs;

	  (buffer_p,gs) = draw_mandelbrot 0 800 buffer_p gdk_window black_gc gs;

	  gs = g_free buffer_p gs;
*/
	= endGtkSt gs;

Start
	# gs = g_thread_init 0 newGtkSt;
	# gs = gdk_threads_init gs;
	| endGtkSt gs<>0
		= undef;
	# gs = gtk_init global_argc_p global_argv_p;
	  (window,gs) = gs:> gtk_window_new GTK_WINDOW_TOPLEVEL;
//	  gs = gs :> gtk_widget_set_size_request window 1000 800;


	  (da,gs) = gtk_drawing_area_new gs;

//	  gs = gtk_widget_modify_bg_a da GTK_STATE_NORMAL {0,0xffffffff,0xffff} gs; // 32 bit white
//	  gs = gtk_widget_modify_bg_a da GTK_STATE_NORMAL {0xffffffff00000000,0xffff} gs; // 64 bit white
	  gs = gtk_widget_modify_bg_a da GTK_STATE_NORMAL {0,0} gs; // 64 bit black

	  gs = gtk_drawing_area_size da 1000 800 gs;

	  gs = gs :> gtk_container_add window da;

	# p0 = start_thread 0 (gtk_widget_p_to_int da);
	| p0==0
		= abort "start_thread failed";
	# p1 = start_thread 1 (gtk_widget_p_to_int da);
	| p1==0
		= abort "start_thread failed";
	# p2 = start_thread 2 (gtk_widget_p_to_int da);
	| p2==0
		= abort "start_thread failed";
	# p3 = start_thread 3 (gtk_widget_p_to_int da);
	| p3==0
		= abort "start_thread failed";

	# (expose_event_p,gs) = g_malloc 64 gs;
	  expose_event_p = store_int (load_int (p0+24)) 0 expose_event_p;
	  expose_event_p = store_int (load_int (p0+32)) 8 expose_event_p;
	  expose_event_p = store_int (load_int (p1+24)) 16 expose_event_p;
	  expose_event_p = store_int (load_int (p1+32)) 24 expose_event_p;
	  expose_event_p = store_int (load_int (p2+24)) 32 expose_event_p;
	  expose_event_p = store_int (load_int (p2+32)) 40 expose_event_p;
	  expose_event_p = store_int (load_int (p3+24)) 48 expose_event_p;
	  expose_event_p = store_int (load_int (p3+32)) 56 expose_event_p;

	# window_i = gtk_widget_p_to_int window;

	  (_,gs) = g_signal_connect da "expose_event\0" expose_drawing_area_adress expose_event_p gs;

	  (_,gs) = g_signal_connect window "destroy\0" destroy_window_callback_adress window_i gs;

	  gs = gs :> gtk_widget_show_all window;
	= gtk_main gs;

malloc :: !Int -> Int;
malloc n_bytes = code {
	ccall malloc "p:p"
}

SIZEOF_pthread_attr_t:==64;
SIZEOF_pthread_t:==8;

pthread_attr_init :: !Int -> Int;
pthread_attr_init attr_p = code {
	ccall pthread_attr_init "p:I"
}

//PTHREAD_CREATE_DETACHED:==2; // Mac OS X
PTHREAD_CREATE_DETACHED:==1;

pthread_attr_setdetachstate :: !Int !Int -> Int;
pthread_attr_setdetachstate attr_p detachstate = code {
	ccall pthread_attr_setdetachstate "pI:I"
}

pthread_create :: !Int !Int !Int !Int -> Int;
pthread_create thread_id_p attr_p function_address arg = code {
	ccall pthread_create "pppp:I"
}

clean_new_thread_address :: Int;
clean_new_thread_address = code {
	pushLc clean_new_thread
}

thread_function_address :: Int;
thread_function_address = code {
	pushLc thread_function
}

errno_address :: Int;
errno_address = code {
	ccall __errno_location ":p"
}

//O_CREAT:==512; // Mac OS X
O_CREAT:==64;

sem_open :: !String !Int !Int !Int -> Int;
sem_open name oflag mode v = code {
	ccall sem_open "sppp:p"
}

sem_post :: !Int -> Int;
sem_post semaphore_p = code {
	ccall sem_post "p:I"
}

sem_wait :: !Int -> Int;
sem_wait semaphore_p = code {
	ccall sem_wait "p:I"
}

start_thread n widget_i
	# attr_p = malloc SIZEOF_pthread_attr_t;
	| attr_p==0
		= abort "malloc failed";
	# r = pthread_attr_init attr_p;
	| r<>0
		= abort "pthread_attr_init failed";
	# r = pthread_attr_setdetachstate attr_p PTHREAD_CREATE_DETACHED;
	| r<>0
		= abort "pthread_attr_setdetachstate failed";
	# thread_id_p = malloc SIZEOF_pthread_t;
	| thread_id_p==0
		= abort "malloc failed";
	# arg_p = malloc 56;
	| arg_p==0
		= abort "malloc failed";
	# arg_p = store_int thread_function_address 0 arg_p;
	# arg_p = store_int 0 8 arg_p;
	# arg_p = store_int 0 16 arg_p;
	# semb=sem_open ("/semb"+++toString n+++"\0") O_CREAT 0600 0;
	| semb==0 || semb== -1 // SEM_FAILED==-1 on Mac OS X
		= abort ("sem_open failed "+++toString ((load_int errno_address) bitand 0xffff));
	# seme=sem_open ("/seme"+++toString n+++"\0") O_CREAT 0600 0;
	| seme==0 || seme== -1 // SEM_FAILED==-1 on Mac OS X
		= abort ("sem_open failed "+++toString ((load_int errno_address) bitand 0xffff));
	# arg_p = store_int semb 24 arg_p;
	# arg_p = store_int seme 32 arg_p;
	# arg_p = store_int widget_i 40 arg_p;
	# arg_p = store_int n 48 arg_p;
	# r = pthread_create thread_id_p attr_p clean_new_thread_address arg_p;
	| r<>0
		= abort "pthread_create failed";
		= arg_p;

