definition module EdFiles

//	File I/O routines for the editor.

import EdProgramState

from UtilNewlinesFile import
	:: NewlineConvention (
	NewlineConventionNone,
	NewlineConventionMac, NewlineConventionUnix, NewlineConventionDos)
:: MixedNewlines = MixedNewlines | NoMixedNewlines

CheckMixedNewlines :: !Pathname MixedNewlines !ProgState !IO -> (!ProgState, !IO);

GetFullPathname	:: !Modulename !ProgState !Files -> ((!ProgState,!Pathname), !Files)
SearchABCFile :: !Modulename !(List Pathname) !*Files -> ((!Bool,!Pathname),!*Files);
SearchDisk :: !Bool !Modulename !(List Pathname) !(List Pathname) !*Files -> ((!Bool,!Pathname),!*Files)

ReadFile :: !Pathname !*Files -> ((!Bool, !Text, !NrLines, (!MixedNewlines, !NewlineConvention)),*Files)
SaveFile :: !Pathname !NewlineConvention !Text !*Files -> (!Bool, !*Files);

ReadDefaultSettings	:: !Editor !*Files -> (!Editor, !*Files);
SaveDefaultSettings	:: !Editor !*Files -> (!Editor, !*Files);

ReadProjectFile	:: !Pathname !(List Pathname) !Pathname !*Files -> ((!Project, !Bool),!*Files)
SaveProjectFile	:: !Pathname !Project !Pathname !*Files -> (!Bool, !*Files)
