module CleanOptions

import StdInt, StdBool, StdArray, StdMisc

import EdProgramState, EdOptionsMenu1, EdCleanSystem, EdWindowsMenu, EdPath
import linker_resources

import deltaTimer, deltaWindow, deltaEventIO, deltaFileSelect, deltaDialog

// RWS
import RWSDebug

Start :: !* World -> * World;
Start world
	# (aboutDialogue,world)
		=	accFiles (\f->MakeAboutDialog "Clean Options" f Help) world
	# (events, world)
		=	OpenEvents world
	# ({world}, events)
		=	StartIO [about, menus,appleEvents] {editor=InitEditor "", world=world} [] events
		with
			about
				=	DialogSystem [aboutDialogue]
			menus
				=	MenuSystem [file]

			appleEvents
				=	AppleEventSystem {openHandler = OpenFile, quitHandler = Quit, clipboardChangedHandler = NoOp}

			file
				=	PullDownMenu 0 "File" Able
					[	MenuItem	1	"Open Application..."	(Key 'O')	Able	Open,
						MenuItem	2	"Help"		(Key 'H')	Able	Help,
						MenuSeparator,
						MenuItem	3	"Quit"		(Key 'Q')	Able	Quit
					]

	# world
		=	CloseEvents events world
	=	world

Quit :: *p (IOState *p) -> (*p, (IOState *p))
Quit p io
	=	(p, QuitIO io)

Open :: ProgState IO -> ProgIO
Open p io
	# (open, path, p, io)
		=	SelectInputFile p io
	| not open
		=	(p, io)
	# (p, io)
		=	ChangeApplicationOptions path p io
	=	(p, io)

OpenFile :: {#Char} ProgState IO -> ProgIO
OpenFile path p io
	| RemovePath path == HelpFile
		=	Help p io
	// otherwise
		=	ChangeApplicationOptions path p io

Alert  :: String !*state !(IOState *state) -> (*state, IOState *state)
Alert message state ioState
   	=  OpenModalDialog alertDialog state ioState
	where
		alertDialog
			=	CommandDialog 1 "" [size] okID [text, okButton]
		size
			=	DialogSize (Pixel 341) (Pixel 98)

		okButton
			=	DialogButton okID okPosition "OK" Able AlertOK
		okID
			=	11
		okPosition
			= ItemBox 273 68 60 20

		text
			= StaticText 12 textPosition message
		textPosition
			= ItemBox 25 8 306 55

AlertOK	:: DialogInfo *state (IOState *state) -> (*state, IOState *state)
AlertOK info state ioState
		=  (state, CloseActiveDialog ioState)

Error :: {#Char} ProgIO -> ProgIO
Error message (state, ioState)
	=	Alert message state ioState

ChangeApplicationOptions :: {#Char} ProgState IO -> ProgIO
ChangeApplicationOptions path p=:{world} io
	# ((read, applicationOptions, pef_size), world)
		=	accFiles (ReadApplicationOptions p.editor.defaults.ao path) world
	| not read
		=	Error "Application options could not be read" ({p & world = world}, io)
	# p
		=	{p & world = world, editor.defaults.ao = applicationOptions}
	# (p=:{world}, io)
		=	ApplicationOptions p io
	# (written, world)
		=	accFiles (WriteApplicationOptions p.editor.defaults.ao pef_size path) world
	| not written
		=	Error "Application options could not be written" ({p & world = world}, io)
		=	({p & world = world}, io)

ReadApplicationOptions :: ApplicationOptions {#Char} *Files -> ((Bool, ApplicationOptions, Int), *Files)
ReadApplicationOptions applicationOptions path files
	# (ok, (fs, fn), hs, heap_size_multiple, ss, flags,
			initial_heap_size, memoryProfilingMinimumHeapSize, pef_size, application_and_extra_memory_size, files)
		=	read_application_options path files
	| not ok
		=	((ok, applicationOptions, 0), files)
		=	((ok, {FlagsToApplicationOptions flags applicationOptions & ss=ss, fs=fs,  fn=fn, hs=hs,
						em=application_and_extra_memory_size-pef_size,
						heap_size_multiple=heap_size_multiple, initial_heap_size=initial_heap_size,
						memoryProfilingMinimumHeapSize=memoryProfilingMinimumHeapSize}, pef_size),
			 files)

WriteApplicationOptions :: ApplicationOptions Int {#Char} *Files -> (!Bool, !*Files)
WriteApplicationOptions applicationOptions=:{ss, fs,  fn, hs, em, heap_size_multiple, initial_heap_size,
													memoryProfilingMinimumHeapSize} pef_size path files
	=	create_application_resource path (fs, fn) hs heap_size_multiple ss flags
												(pef_size+em) initial_heap_size memoryProfilingMinimumHeapSize files
		where
			flags
				=	ApplicationOptionsToFlags applicationOptions

NoOp :: *p (IOState *p) -> (*p, (IOState *p))
NoOp p io
	=	(p, io)
