implementation module EdMyIO2;

/* OS dependent module for linux/Intel */

import StdClass,StdFile, StdChar, StdInt, StdBool, StdString, StdMisc,StdArray;

import pointer;

IF_SOLARIS a b :== b;
IF_INTEL a b :== a;

NoDate	:== {exists=False,yy=0,mm=0,dd=0,h=0,m=0,s=0};

::	DATE = {	exists	:: !Bool,
				yy		:: !Int,
				mm		:: !Int,
				dd		:: !Int,
				h		:: !Int,
				m		:: !Int,
				s		:: !Int };
				
FExists	:: !String !*Files -> (!Bool, !*Files);
FExists name disk
	# s = createArray 88/*64*/ '\0';
	# r = stat /*1*/ (name+++"\0") s;
	= (r==0,disk);

stat :: /*!Int*/ !{#Char} !{#Char} -> Int;
stat /*i*/ file_name stat_struct
	= code {
		ccall stat "ss:I"
	}
/*
	= code {
		ccall _xstat "Iss:I"
	}
*/
localtime :: !{#Char} -> Int;
localtime time_t_p
	= code {
		ccall localtime "s:I"
	}

FModified :: !String !*Files -> (!DATE, !*Files);
FModified path disk
	# s = createArray 88/*64*/ '\0';
	# result = stat /*1*/ (path+++"\0") s;
	| result<>0
		= (NoDate,disk);
//		# struct_tm = localtime (s % (40,43));
		# struct_tm = localtime (s % (64,67));
		| struct_tm<>0
			# sec=load_long (struct_tm+0);
			# min=load_long (struct_tm+4);
			# hour=load_long (struct_tm+8);
			# day=load_long (struct_tm+12);
			# mon=load_long (struct_tm+16);
			# year=load_long (struct_tm+20);
			= ({exists=True,yy=1900+year,mm=mon+1,dd=day,h=hour,m=min,s=sec},disk);

