implementation module types


import	StdEnv
import	language


/***************************************************************************************************************
	Type definitions.
****************************************************************************************************************/
::	Playmode			=	EndPlayer1 | EndPlayer2 | Playing
::	Playerkind			=	Computer | Person
::	Player				=	Player1 | Player2
::	Strength			=	Maximum | First | Strength Real
::	Direction			=	Hor | Ver 
::	Word				:==	String
::	Position			:==	(!Int,!Int)

MediumStrength			:==	Strength 0.5
EasyStrength			:==	Strength 0.25
VeryEasyStrength		:==	Strength 0.125

instance == Playmode
where
	(==) :: !Playmode !Playmode -> Bool
	(==) EndPlayer1	mode	= case mode of
								EndPlayer1	-> True
								_			-> False
	(==) EndPlayer2	mode	= case mode of
								EndPlayer2	-> True
								_			-> False
	(==) Playing	mode	= case mode of
								Playing		-> True
								_			-> False
instance == Playerkind
where
	(==) :: !Playerkind !Playerkind -> Bool
	(==) Computer	Computer= True
	(==) Person		Person	= True
	(==) _			_		= False
instance == Player
where
	(==) :: !Player !Player -> Bool
	(==) Player1 Player1 = True
	(==) Player2 Player2 = True
	(==) _		 _		 = False
instance == Strength
where
	(==) :: !Strength !Strength -> Bool
	(==) Maximum		strength	= case strength of
										Maximum			-> True
										_				-> False
	(==) First			strength	= case strength of
										First			-> True
										_				-> False
	(==) (Strength s1)	strength	= case strength of
										(Strength s2)	-> s1==s2
										_				-> False
instance == Direction
where
	(==) :: !Direction !Direction -> Bool
	(==) Hor Hor = True
	(==) Ver Ver = True
	(==) _	 _	 = False
instance == Placing
where
	(==) :: !Placing !Placing -> Bool
	(==) p1 p2 = p1.word==p2.word && p1.pos==p2.pos && p1.dir==p2.dir && p1.score==p2.score

otherplayer :: !Player -> Player
otherplayer Player1 = Player2
otherplayer Player2 = Player1


/***************************************************************************************************************
	The type Progress is by the computer player function when determining a move. The computer player checks in 
	alfabetic order all words starting with a particular letter.
	
	Words starting with a particular letter are handled quickly when the starting letter does not occur on the 
	letter bar. In that case the positions on the board are checked if they are valid as a starting position for 
	the word (horizontal and vertical are handled separately).
	
	For words starting with a particular letter on the letter bar more board positions need to be examined.
****************************************************************************************************************/
::	Progress
	=	Letter Char Placing
	|	Finish Placing
::	Placing
	=	{	word	:: Word
		,	pos		:: Position
		,	dir		:: Direction
		,	score	:: Int
		}

initplacing :: Placing
initplacing = {word="",pos=(0,0),dir=Hor,score=0}

getplacing :: !Progress -> Placing
getplacing (Letter _ p)	= p
getplacing (Finish p)	= p

getletter :: !Progress -> Char
getletter (Letter l _)	= l
getletter (Finish _)	= 'z'
	
notyetready :: !Progress -> Bool
notyetready (Finish _)	= False
notyetready _			= True


/***************************************************************************************************************
	The Tree type stores the lexicon. 
****************************************************************************************************************/

::	Tree
	=	Leaf !String
	|	Node Tree !String Tree

maketree :: ![Word] -> Tree
maketree xs
	| isEmpty xs	= Leaf ""
	| nrwords==1	= Leaf (toString (hd xs))
	| otherwise		= Node (maketree firsthalf) middle (maketree secondhalf)
where
	nrwords							= length xs
	(firsthalf,[middle:secondhalf])	= splitAt (nrwords/2) xs

wordsstartingwith :: !Char !Tree -> [Word]
wordsstartingwith letter (Node l w r)
	| w.[0]>letter
	= wordsstartingwith letter l
	| w.[0]<letter
	= wordsstartingwith letter r
	= wordsstartingwithleft letter l [w:wordsstartingwithright letter r]
where
	wordsstartingwithleft :: !Char !Tree ![Word] -> [Word]
	wordsstartingwithleft letter (Node l w r) t
		| w.[0]==letter
		= wordsstartingwithleft letter l [w:wordsintree r t]
		= wordsstartingwithleft letter r t
	wordsstartingwithleft letter (Leaf b) t
		| size b>0 && b.[0]==letter
		= [b:t]
		= t
	
	wordsstartingwithright :: !Char !Tree -> [Word]
	wordsstartingwithright letter (Node l w r)
		| w.[0]==letter
		= wordsintree l [w:wordsstartingwithright letter r]
		= wordsstartingwithright letter l
	wordsstartingwithright letter b
		= wordsstartingwith letter b
	
	wordsintree :: !Tree ![Word] -> [Word]
	wordsintree (Node l w r) t
		= wordsintree l [w:wordsintree r t]
	wordsintree (Leaf b) t
		| size b<>0
		= [b:t]
		= t
wordsstartingwith letter (Leaf b)
	| size b>0 && b.[0]==letter
	= [b]
	= []

readtree :: !*Files -> (!Tree,!*Files)
readtree files
	# (woorden,files)	= readwords (ApplicationPath lexiconfilename) files
	= (maketree woorden,files)
where
	readwords :: !String !*Files -> (![Word],!*Files)
	readwords filename files
		# (ok,f,files)= fopen filename FReadText files
		| not ok
		= shownl ("Warning: could not open file '"+++filename+++"' for reading") ([],files)
		# (lines,f)		= readlines f
		  (_,files)		= fclose f files
		| otherwise		= (lines,files)
	where
		readlines :: !*File -> (![Word],!*File)
		readlines f
			| sfend f
			= ([],f)
			# (line, f)	= freadline f
			  (lines,f)	= readlines f
			  length	= size line
			| length>1
			= ([fromString (line%(0,length-2)):lines],f)	// remove '\n'
			| otherwise
			= (lines,f)

writetree :: !Tree !*Files -> *Files
writetree b files
	= writewords (ApplicationPath lexiconfilename) (toList b) files
where
	writewords :: !String [String] !*Files -> *Files
	writewords filename woorden files
		# (ok,f,files)= fopen filename FWriteText files
		| not ok
		= shownl ("Warning: could not open file '"+++filename+++"' for writing") files
		# (ok,f)		= writelines woorden f
		  (_,files)		= fclose f files
		| not ok
		= shownl ("Error occurred while writing file '"+++filename+++"'") files
		| otherwise
		= files
	where
		writelines :: ![String] !*File -> (!Bool,!*File)
		writelines [w:ws] f
			# f			= f<<<w<<<'\n'
			  (error,f)	= ferror f
			| error
			= (False,f)
			| otherwise
			= writelines ws f
		writelines _ f
			= (True,f)
	
	toList :: !Tree -> [String]
	toList (Leaf word)
		| word==""
		= []
		= [word]
	toList (Node l word r)
		| word==""
		= toList l ++ toList r
		= toList l ++ [word: toList r]

shownl :: !String .x -> .x
shownl text x
	#! written = fwrites (text+++"\n") stderr
	= const x written

addwordstotree :: !Tree ![Word] -> Tree
addwordstotree b wrds
	= foldl addwordtotree b wrds
where
	addwordtotree :: !Tree !Word -> Tree
	addwordtotree b=:(Node l w r) x
		| x<w		= Node (addwordtotree l x) w r
		| x>w		= Node l w (addwordtotree r x)
		| otherwise	= b
	addwordtotree b=:(Leaf w) x
		| x<w		= Node (Leaf x)  w (Leaf "")
		| x>w		= Node (Leaf "") w (Leaf x)
		| otherwise	= b

seek :: !Tree !String -> Bool
seek (Leaf b) x		= b==x
seek (Node l w r) x	= w==x || (x<w && seek l x) || (x>w && seek r x)

sizetree :: !Tree -> Int
sizetree (Leaf _)		= 1
sizetree (Node l _ r)	= sizetree l+sizetree r+1

depthtree :: !Tree -> Int
depthtree (Leaf _)		= 1
depthtree (Node l _ r)	= max (depthtree l+1) (depthtree r+1)


/***************************************************************************************************************
	Global Ids.
****************************************************************************************************************/

scrabbleId		:==	1
toevoegId		:==	2
computerId		:== 1
