definition module elf_relocations;

import StdInt,StdArray,StdFile;
import elf_linker_types;

BigOrLittleEndian big little :== big;

SIZE_OF_RELOCATION:==12;

R_SPARC_NONE:==0;
R_SPARC_32:==3;
R_SPARC_WDISP30:==7;
R_SPARC_WDISP22:==8;
R_SPARC_HI22:==9;
R_SPARC_LO10:==12;
R_SPARC_UA32:==23;

SHT_RELA:==4;
SHT_REL:==9;

SHT_relocations:==SHT_RELA;

RELOCATION_TYPE_OFFSET :== 7;
RELOCATION_SYMBOL_N_OFFSET :== 4;

(BYTE) string i :== toInt (string.[i]);

(WORD) :: !{#Char} !Int -> Int;
// (WORD) string i = (string BYTE i<<8) bitor (string BYTE (i+1));
                                                                                                                        
(LONG) :: !{#Char} !Int -> Int;
// (LONG) string i = (string BYTE i<<24) bitor (string BYTE (i+1)<<16) bitor (string BYTE (i+2)<<8) bitor (string BYTE (i+3));

(TBYTE) :: !{#Char} !Int -> Int;
// (TBYTE) string i = (string BYTE i<<16) bitor (string BYTE (i+1)<<8) bitor (string BYTE (i+2));

shstrtab_data_relocations_section_name_offset :== 39;
shstrtab_symbol_table_section_name_offset :== 50;
shstrtab_string_table_section_name_offset :== 58;
shstrtab_size :== 68;

write_elf_header :: !*File -> *File;
write_shstrtab_end :: !*File -> *File;

count_relocations :: !Int !{#Char} !{!Symbol} -> Int;

write_module_relocations :: !Symbol !Int !Int !SSymbolArray !XcoffArray !{#Int} !{#Int} !*File -> *File;

relocate_text :: !.Int Int Int Int Int {#Char} {#SXcoff} {#Int} {#Int} {!Symbol} !*{#.Char} -> .{#Char};
relocate_data :: Int Int Int Int Int String Int {#Int} {#Int} {!Symbol} XcoffArray *{#Char}-> *{#Char};
