#include <Carbon.r>

/*
# Build carbonIde app skeleton...
/Developer/Tools/Rez carbonIde.r -s /System/Library/Frameworks/Carbon.framework/Headers -creator "'3PRM'" -o mmIde
*/

data '3PRM' (0, "Owner resource") {
	$"00"                                                 /* . */
};

resource 'vers' (1) {
	0x02, 0x02, development, 0x01, verUS,
	"2.0.2d1",
	"2.0.2d1,  1987-2003 University of Nijmegen"
};

resource 'vers' (2) {
	0x02, 0x03, alpha, 0x03, verUS,
	"2.0.3 alpha 3",
	"(for Clean Programming System 2.0.3 alpha 3)"
};

resource 'SIZE' (-1) {
	reserved,
	acceptSuspendResumeEvents,
	1,
	canBackground,
	multiFinderAware,
	backgroundAndForeground,
	getFrontClicks,
	acceptChildDiedEvents,
	is32BitCompatible,
	isHighLevelEventAware,
	localAndRemoteHLEvents,
	notStationeryAware,
	dontUseTextEditServices,
	notDisplayManagerAware,
	reserved,
	reserved,
	40566432,
	40566432
};

resource 'BNDL' (128) {
	'3PRM',
	0,
	{	/* array TypeArray: 2 elements */
		/* [1] */
		'FREF',
		{	/* array IDArray: 4 elements */
			/* [1] */
			0, 128,
			/* [2] */
			1, 129,
			/* [3] */
			2, 130,
			/* [4] */
			3, 131
		},
		/* [2] */
		'ICN#',
		{	/* array IDArray: 4 elements */
			/* [1] */
			0, 128,
			/* [2] */
			1, 129,
			/* [3] */
			2, 130,
			/* [4] */
			3, 129
		}
	}
};

resource 'FREF' (128) {	'APPL',	0,	""};
resource 'FREF' (129) {	'TEXT',	1,	""};
resource 'FREF' (130) {	'CgOb',	2,	""};
resource 'FREF' (131) {	'****',	3,	""};

data 'ICN#' (-16455) {
	$"0001 0000 0002 8000 0004 4000 000B 2000"            /* .........@... . */
	$"0017 9000 0027 C800 004F C400 008F B200"            /* ....'..O... */
	$"011F 7900 021F 7C80 041F 7C40 083E F820"            /* ..y...|..|@.>  */
	$"103E F810 203E FE08 403E 8104 803F 0082"            /* .>. >.@>.?. */
	$"403E 6044 203F F028 103C FF1E 081C 600E"            /* @>`D ?(.<...`. */
	$"041E 000E 021F 000E 010F C00E 008F FFCE"            /* ............ */
	$"0047 E43E 0023 C81E 0013 9000 0009 2000"            /* .G>.#..... . */
	$"0004 4000 0002 8000 0001 0000 0000 0000"            /* ..@............ */
	$"0001 0000 0003 8000 0007 C000 000F E000"            /* ............. */
	$"001F F000 003F F800 007F FC00 00FF FE00"            /* ....?...... */
	$"01FF FF00 03FF FF80 07FF FFC0 0FFF FFE0"            /* ..... */
	$"1FFF FFF0 3FFF FFF8 7FFF FFFC FFFF FFFE"            /* .?. */
	$"7FFF FFFC 3FFF FFF8 1FFF FFFE 0FFF FFFE"            /* .?.. */
	$"07FF FFFE 03FF FFFE 01FF FFFE 00FF FFFE"            /* .... */
	$"007F FC3E 003F F81E 001F F000 000F E000"            /* ..>.?....... */
	$"0007 C000 0003 8000 0001 0000 0000 0000"            /* .............. */
};

data 'ICN#' (128) {
	$"0001 0000 0002 8000 0004 4000 000B 2000"            /* .........@... . */
	$"0017 9000 0027 C800 004F C400 008F B200"            /* ....'..O... */
	$"011F 7900 021F 7C80 041F 7C40 083E F820"            /* ..y...|..|@.>  */
	$"103E F810 203E FE08 403E 8104 803F 0082"            /* .>. >.@>.?. */
	$"403E 6044 203F F028 103C FF1E 081C 600E"            /* @>`D ?(.<...`. */
	$"041E 000E 021F 000E 010F C00E 008F FFCE"            /* ............ */
	$"0047 E43E 0023 C81E 0013 9000 0009 2000"            /* .G>.#..... . */
	$"0004 4000 0002 8000 0001 0000 0000 0000"            /* ..@............ */
	$"0001 0000 0003 8000 0007 C000 000F E000"            /* ............. */
	$"001F F000 003F F800 007F FC00 00FF FE00"            /* ....?...... */
	$"01FF FF00 03FF FF80 07FF FFC0 0FFF FFE0"            /* ..... */
	$"1FFF FFF0 3FFF FFF8 7FFF FFFC FFFF FFFE"            /* .?. */
	$"7FFF FFFC 3FFF FFF8 1FFF FFFE 0FFF FFFE"            /* .?.. */
	$"07FF FFFE 03FF FFFE 01FF FFFE 00FF FFFE"            /* .... */
	$"007F FC3E 003F F81E 001F F000 000F E000"            /* ..>.?....... */
	$"0007 C000 0003 8000 0001 0000 0000 0000"            /* .............. */
};

data 'ICN#' (129) {
	$"0FFF F000 0800 1800 0800 1400 0808 1200"            /* .............. */
	$"081C 1100 083E 1080 083F 1040 087E 9FE0"            /* .....>..?.@.~ */
	$"087D C020 08FB E020 08FB F020 08FB E020"            /* .} . . .  */
	$"09F7 C020 09F7 C020 09F7 C020 09F7 C020"            /*      */
	$"09F7 C020 09F7 C020 09F7 C020 09F7 FFFE"            /*     */
	$"08FB FFFE 08FB BFDE 08FB 8B46 087D BCDE"            /* ...F.} */
	$"087F BCDE 083F CB66 083F FFFE 081D FFFE"            /* ...?f.?.. */
	$"0809 FFFE 0800 0020 0800 0020 0FFF FFE0"            /* .... ... . */
	$"0FFF F000 0FFF F800 0FFF FC00 0FFF FE00"            /* ........ */
	$"0FFF FF00 0FFF FF80 0FFF FFC0 0FFF FFE0"            /* ..... */
	$"0FFF FFE0 0FFF FFE0 0FFF FFE0 0FFF FFE0"            /* .... */
	$"0FFF FFE0 0FFF FFE0 0FFF FFE0 0FFF FFE0"            /* .... */
	$"0FFF FFE0 0FFF FFE0 0FFF FFE0 0FFF FFFE"            /* .... */
	$"0FFF FFFE 0FFF FFFE 0FFF FFFE 0FFF FFFE"            /* .... */
	$"0FFF FFFE 0FFF FFFE 0FFF FFFE 0FFF FFFE"            /* .... */
	$"0FFF FFFE 0FFF FFE0 0FFF FFE0 0FFF FFE0"            /* .... */
};

data 'ICN#' (130) {
	$"0FFF F000 0800 1800 0820 1400 0870 1200"            /* ....... ...p.. */
	$"08E8 1100 09DC 1080 09B8 1040 09B0 1FE0"            /* ....Ƹ.@ư. */
	$"09B0 0020 09B8 0020 09DC 0020 08E8 0020"            /* ư. Ƹ. . ..  */
	$"0870 0020 0820 0020 0800 0020 0800 0020"            /* .p. . . ... ...  */
	$"0800 0020 088C 6020 0992 9020 0893 FFFE"            /* ... .` ƒ . */
	$"09CD FFFE 0801 F9F6 0801 FDFE 08C5 9C62"            /* .....Ŝb */
	$"092D 6DB6 0925 6DB6 08CF 9876 0801 FFCE"            /* -m%m.Ϙv.. */
	$"0801 FFFE 0800 0020 0800 0020 0FFF FFE0"            /* ..... ... . */
	$"0FFF F000 0FFF F800 0FFF FC00 0FFF FE00"            /* ........ */
	$"0FFF FF00 0FFF FF80 0FFF FFC0 0FFF FFE0"            /* ..... */
	$"0FFF FFE0 0FFF FFE0 0FFF FFE0 0FFF FFE0"            /* .... */
	$"0FFF FFE0 0FFF FFE0 0FFF FFE0 0FFF FFE0"            /* .... */
	$"0FFF FFE0 0FFF FFE0 0FFF FFE0 0FFF FFFE"            /* .... */
	$"0FFF FFFE 0FFF FFFE 0FFF FFFE 0FFF FFFE"            /* .... */
	$"0FFF FFFE 0FFF FFFE 0FFF FFFE 0FFF FFFE"            /* .... */
	$"0FFF FFFE 0FFF FFE0 0FFF FFE0 0FFF FFE0"            /* .... */
};

data 'icl4' (-16455) {
	$"0000 0000 0000 000F 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 00F0 F000 0000 0000 0000"            /* .............. */
	$"0000 0000 0000 0F0C DF00 0000 0000 0000"            /* ............... */
	$"0000 0000 0000 F0DD CDF0 0000 0000 0000"            /* ............ */
	$"0000 0000 000F 0DDD DCDF 0000 0000 0000"            /* ............. */
	$"0000 0000 00F0 CDDD DDCD F000 0000 0000"            /* .......... */
	$"0000 0000 0F0C DDDD DDCC DF00 0000 0000"            /* ........... */
	$"0000 0000 F0CC DDDD DCDD CDF0 0000 0000"            /* ........ */
	$"0000 000F 0CCD DDDD CDDD DCDF 0000 0000"            /* ......... */
	$"0000 00F0 CCCD DDDD CDDD DDCD F000 0000"            /* ...... */
	$"0000 0F0C CCCD DDDD CDDD DDCC DF00 0000"            /* ....... */
	$"0000 F0CC CCDD DDDC DDDD DCCC CDF0 0000"            /* .... */
	$"000F 0CCC CCDD DDDC DDDD DCCC CCDF 0000"            /* ..... */
	$"00F0 CCCC CCDD DDDC DFFF FFFC CCCD F000"            /* .. */
	$"0F0C CCCC CCDD DDDC FCCC CCCF CCCC DF00"            /* ... */
	$"F0CC CCCC CCDD DDDF CCCC CCCC FCCC CDF0"            /*  */
	$"0F0C CCCC CCDD DDFC CFFC CCCC CFCC DF00"            /* ... */
	$"00F0 CCCC CCDD DDFF FDDF CCCC CCFD F000"            /* .. */
	$"000F 0CCC CCDD FFCC FFFF FFFF CCCF FFF0"            /* ... */
	$"0000 F0CC CCCD DFCC CFFC CCCC CCCC FFF0"            /* .. */
	$"0000 0F0C CCCD DDFC CCCC CCCC CCCC FFF0"            /* .... */
	$"0000 00F0 CCCD DDDF CCCC CCCC CCCC FFF0"            /* ... */
	$"0000 000F 0CCC DDDD FFCC CCCC CCCC FFF0"            /* ..... */
	$"0000 0000 F0CC DDDD DDFF FFFF FFCC FFF0"            /* .... */
	$"0000 0000 0F0C CDDD DDDC DF00 00FF FFF0"            /* ........ */
	$"0000 0000 00F0 CCDD DDCD F000 000F FFF0"            /* ........ */
	$"0000 0000 000F 0CDD DCDF 0000 0000 0000"            /* ............. */
	$"0000 0000 0000 F0CD CDF0 0000 0000 0000"            /* ............ */
	$"0000 0000 0000 0F0C DF00 0000 0000 0000"            /* ............... */
	$"0000 0000 0000 00F0 F000 0000 0000 0000"            /* .............. */
	$"0000 0000 0000 000F 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
};

data 'icl4' (128) {
	$"0000 0000 0000 000F 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 00F0 F000 0000 0000 0000"            /* .............. */
	$"0000 0000 0000 0F0C DF00 0000 0000 0000"            /* ............... */
	$"0000 0000 0000 F0DD CDF0 0000 0000 0000"            /* ............ */
	$"0000 0000 000F 0DDD DCDF 0000 0000 0000"            /* ............. */
	$"0000 0000 00F0 CDDD DDCD F000 0000 0000"            /* .......... */
	$"0000 0000 0F0C DDDD DDCC DF00 0000 0000"            /* ........... */
	$"0000 0000 F0CC DDDD DCDD CDF0 0000 0000"            /* ........ */
	$"0000 000F 0CCD DDDD CDDD DCDF 0000 0000"            /* ......... */
	$"0000 00F0 CCCD DDDD CDDD DDCD F000 0000"            /* ...... */
	$"0000 0F0C CCCD DDDD CDDD DDCC DF00 0000"            /* ....... */
	$"0000 F0CC CCDD DDDC DDDD DCCC CDF0 0000"            /* .... */
	$"000F 0CCC CCDD DDDC DDDD DCCC CCDF 0000"            /* ..... */
	$"00F0 CCCC CCDD DDDC DFFF FFFC CCCD F000"            /* .. */
	$"0F0C CCCC CCDD DDDC FCCC CCCF CCCC DF00"            /* ... */
	$"F0CC CCCC CCDD DDDF CCCC CCCC FCCC CDF0"            /*  */
	$"0F0C CCCC CCDD DDFC CFFC CCCC CFCC DF00"            /* ... */
	$"00F0 CCCC CCDD DDFF FDDF CCCC CCFD F000"            /* .. */
	$"000F 0CCC CCDD FFCC FFFF FFFF CCCF FFF0"            /* ... */
	$"0000 F0CC CCCD DFCC CFFC CCCC CCCC FFF0"            /* .. */
	$"0000 0F0C CCCD DDFC CCCC CCCC CCCC FFF0"            /* .... */
	$"0000 00F0 CCCD DDDF CCCC CCCC CCCC FFF0"            /* ... */
	$"0000 000F 0CCC DDDD FFCC CCCC CCCC FFF0"            /* ..... */
	$"0000 0000 F0CC DDDD DDFF FFFF FFCC FFF0"            /* .... */
	$"0000 0000 0F0C CDDD DDDC DF00 00FF FFF0"            /* ........ */
	$"0000 0000 00F0 CCDD DDCD F000 000F FFF0"            /* ........ */
	$"0000 0000 000F 0CDD DCDF 0000 0000 0000"            /* ............. */
	$"0000 0000 0000 F0CD CDF0 0000 0000 0000"            /* ............ */
	$"0000 0000 0000 0F0C DF00 0000 0000 0000"            /* ............... */
	$"0000 0000 0000 00F0 F000 0000 0000 0000"            /* .............. */
	$"0000 0000 0000 000F 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
};

data 'icl4' (129) {
	$"0000 FFFF FFFF FFFF FFFF 0000 0000 0000"            /* ........ */
	$"0000 F000 0000 0000 000F F000 0000 0000"            /* .............. */
	$"0000 F0CC CCCC CCCC CCCF 0F00 0000 0000"            /* ........ */
	$"0000 F0CC CCCC DCCC CCCF 0CF0 0000 0000"            /* ....... */
	$"0000 F0CC CCCD DDCC CCCF 0CCF 0000 0000"            /* ....... */
	$"0000 F0CC CCDD DDDC CCCF 0CCC F000 0000"            /* ...... */
	$"0000 F0CC CCDD DDDD CCCF 0CCC CF00 0000"            /* ...... */
	$"0000 F0CC CDDD DDDC DCCF FFFF FFF0 0000"            /* .... */
	$"0000 F0CC CDDD DDCD DDCC CCCC CCF0 0000"            /* .... */
	$"0000 F0CC DDDD DCDD DDDC CCCC CCF0 0000"            /* .... */
	$"0000 F0CC DDDD DCDD DDDD CCCC CCF0 0000"            /* .... */
	$"0000 F0CC DDDD DCDD DDDC CCCC CCF0 0000"            /* .... */
	$"0000 F0CD DDDD CDDD DDCC CCCC CCF0 0000"            /* .... */
	$"0000 F0CD DDDD CDDD DDCC CCCC CCF0 0000"            /* .... */
	$"0000 F0CD DDDD CDDD DDCC CCCC CCF0 0000"            /* .... */
	$"0000 F0CD DDDD CDDD DDCC CCCC CCF0 0000"            /* .... */
	$"0000 F0CD DDDD CDDD DDCC CCCC CCF0 0000"            /* .... */
	$"0000 F0CD DDDD CDDD DDCC CCCC CCF0 0000"            /* .... */
	$"0000 F0CD DDDD CDDD DDCC CCCC CCF0 0000"            /* .... */
	$"0000 F0CD DDDD CDD8 8888 8888 8888 88E0"            /* ..؈ */
	$"0000 F0CC DDDD DCD8 DDDD DDDD DDDD DDE0"            /* .. */
	$"0000 F0CC DDDD DCD8 D0DD DDDD DD0D DDE0"            /* ... */
	$"0000 F0CC DDDD DCD8 D000 D0DD 0D00 0DE0"            /* ...... */
	$"0000 F0CC CDDD DDC8 D0DD DD00 DD0D DDE0"            /* .... */
	$"0000 F0CC CDDD DDD8 D0DD DD00 DD0D DDE0"            /* .... */
	$"0000 F0CC CCDD DDD8 DD00 D0DD 0DD0 0DE0"            /* ..... */
	$"0000 F0CC CCDD DDD8 DDDD DDDD DDDD DDE0"            /* .. */
	$"0000 F0CC CCCD DDC8 DDDD DDDD DDDD DDE0"            /* .. */
	$"0000 F0CC CCCC DCCE EEEE EEEE EEEE EEE0"            /* .. */
	$"0000 F0CC CCCC CCCC CCCC CCCC CCF0 0000"            /* .... */
	$"0000 F0CC CCCC CCCC CCCC CCCC CCF0 0000"            /* .... */
	$"0000 FFFF FFFF FFFF FFFF FFFF FFF0 0000"            /* .... */
};

data 'icl4' (130) {
	$"0000 FFFF FFFF FFFF FFFF 0000 0000 0000"            /* ........ */
	$"0000 F000 0000 0000 000F F000 0000 0000"            /* .............. */
	$"0000 F0CC CCDC CCCC CCCF 0F00 0000 0000"            /* ........ */
	$"0000 F0CC CDDD CCCC CCCF 0CF0 0000 0000"            /* ....... */
	$"0000 F0CC DDDC DCCC CCCF 0CCF 0000 0000"            /* ....... */
	$"0000 F0CD DDCD DDCC CCCF 0CCC F000 0000"            /* ...... */
	$"0000 F0CD DCDD DCCC CCCF 0CCC CF00 0000"            /* ...... */
	$"0000 F0CD DCDD CCCC CCCF FFFF FFF0 0000"            /* .... */
	$"0000 F0CD DCDD CCCC CCCC CCCC CCF0 0000"            /* .... */
	$"0000 F0CD DCDD DCCC CCCC CCCC CCF0 0000"            /* .... */
	$"0000 F0CD DDCD DDCC CCCC CCCC CCF0 0000"            /* .... */
	$"0000 F0CC DDDC DCCC CCCC CCCC CCF0 0000"            /* .... */
	$"0000 F0CC CDDD CCCC CCCC CCCC CCF0 0000"            /* .... */
	$"0000 F0CC CCDC CCCC CCCC CCCC CCF0 0000"            /* .... */
	$"0000 F0CC CCCC CCCC CCCC CCCC CCF0 0000"            /* .... */
	$"0000 F0CC CCCC CCCC CCCC CCCC CCF0 0000"            /* .... */
	$"0000 F0CC CCCC CCCC CCCC CCCC CCF0 0000"            /* .... */
	$"0000 F0CC ACCC AACC CAAC CCCC CCF0 0000"            /* ..̬̪ʬ.. */
	$"0000 F0CA ACCA CCAC ACCA CCCC CCF0 0000"            /* ..ʬ̬.. */
	$"0000 F0CC ACCA CCA8 8888 8888 8888 88E0"            /* ..̨̬ */
	$"0000 F0CA AACC AAC8 DDDD DDDD DDDD DDE0"            /* ..ʪ̪ */
	$"0000 F0CC CCCC CCC8 DDDD D00D DDDD 0DE0"            /* .... */
	$"0000 F0CC CCCC CCC8 DDDD DD0D DDDD DDE0"            /* ... */
	$"0000 F0CC AACC CAC8 D00D DD00 0DD0 00E0"            /* ..̪.... */
	$"0000 F0CA CCAC AAC8 0DD0 DD0D D0DD 0DE0"            /* ..̬... */
	$"0000 F0CA CCAC CAC8 0DD0 DD0D D0DD 0DE0"            /* ..̬... */
	$"0000 F0CC AACC AAA8 D00D D000 0DDD 0DE0"            /* ..̪̪.... */
	$"0000 F0CC CCCC CCC8 DDDD DDDD DD00 DDE0"            /* ... */
	$"0000 F0CC CCCC CCCE EEEE EEEE EEEE EEE0"            /* .. */
	$"0000 F0CC CCCC CCCC CCCC CCCC CCF0 0000"            /* .... */
	$"0000 F0CC CCCC CCCC CCCC CCCC CCF0 0000"            /* .... */
	$"0000 FFFF FFFF FFFF FFFF FFFF FFF0 0000"            /* .... */
};

data 'icl8' (-16455) {
	$"0000 0000 0000 0000 0000 0000 0000 00FF"            /* ............... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 FF00"            /* ............... */
	$"FF00 0000 0000 0000 0000 0000 0000 0000"            /* ............... */
	$"0000 0000 0000 0000 0000 0000 00FF 002B"            /* ..............+ */
	$"F9FF 0000 0000 0000 0000 0000 0000 0000"            /* .............. */
	$"0000 0000 0000 0000 0000 0000 FF00 7F7F"            /* ............... */
	$"2BF9 FF00 0000 0000 0000 0000 0000 0000"            /* +............. */
	$"0000 0000 0000 0000 0000 00FF 007F 7F7F"            /* ............... */
	$"7F2B F9FF 0000 0000 0000 0000 0000 0000"            /* .+............ */
	$"0000 0000 0000 0000 0000 FF00 2B7F 7F7F"            /* ...........+... */
	$"7F7F 2BF9 FF00 0000 0000 0000 0000 0000"            /* ..+........... */
	$"0000 0000 0000 0000 00FF 002B 7F7F 7F7F"            /* ..........+.... */
	$"7F7F 2A2B F9FF 0000 0000 0000 0000 0000"            /* ..*+.......... */
	$"0000 0000 0000 0000 FF00 2B2A 7F7F 7F7F"            /* .........+*.... */
	$"7F2A 7F7F 2BF9 FF00 0000 0000 0000 0000"            /* .*..+......... */
	$"0000 0000 0000 00FF 002B 2A7F 7F7F 7F7F"            /* ........+*..... */
	$"2A7F 7F7F 7F2B F9FF 0000 0000 0000 0000"            /* *....+........ */
	$"0000 0000 0000 FF00 2B2A 2B7F 7F7F 7F7F"            /* .......+*+..... */
	$"2B7F 7F7F 7F7F 2BF9 FF00 0000 0000 0000"            /* +.....+....... */
	$"0000 0000 00FF 002B 2A2B 2A7F 7F7F 7F7F"            /* ......+*+*..... */
	$"2A7F 7F7F 7F7F 2A2B F9FF 0000 0000 0000"            /* *.....*+...... */
	$"0000 0000 FF00 2B2A 2B2A 7F7F 7F7F 7F2A"            /* .....+*+*.....* */
	$"7F7F 7F7F 7F2A 2B2A 2BF9 FF00 0000 0000"            /* .....*+*+..... */
	$"0000 00FF 002B 2A2B 2A2B 7F7F 7F7F 7F2B"            /* ....+*+*+.....+ */
	$"7F7F 7F7F 7F2B 2A2B 2A2B F9FF 0000 0000"            /* .....+*+*+.... */
	$"0000 FF00 2B2A 2B2A 2B2A 7F7F 7F7F 7F2A"            /* ...+*+*+*.....* */
	$"7FFF FFFF FFFF FF2A 2B2A 2BF9 FF00 0000"            /* .*+*+... */
	$"00FF 002B 2A2B 2A2B 2A2B 7F7F 7F7F 7F2B"            /* ..+*+*+*+.....+ */
	$"FF08 0808 0808 08FF 2A2B 2A2B F9FF 0000"            /* ......*+*+.. */
	$"FF00 2B2A 2B2A 2B2A 2B2A 7F7F 7F7F 7FFF"            /* .+*+*+*+*..... */
	$"0808 0808 0808 0808 FF2A 2B2A 2BF9 FF00"            /* ........*+*+. */
	$"00FF 002B 2A2B 2A2B 2A2B 7F7F 7F7F FF08"            /* ..+*+*+*+..... */
	$"08FF FF08 0808 0808 08FF 2A2B F9FF 0000"            /* .......*+.. */
	$"0000 FF00 2B2A 2B2A 2B2A 7F7F 7F7F FFFF"            /* ...+*+*+*.... */
	$"FF7F 7FFF 0808 0808 0808 FFF9 FF00 0000"            /* ........... */
	$"0000 00FF 002B 2A2B 2A2B 7F7F FFFF 0808"            /* ....+*+*+.... */
	$"FFFF FFFF FFFF FFFF 0808 08FF FFFF FF00"            /* .... */
	$"0000 0000 FF00 2B2A 2B2A 2B7F 7FFF 0808"            /* .....+*+*+.... */
	$"08FF FF08 0808 0808 0808 0808 FFFF FF00"            /* ........... */
	$"0000 0000 00FF 002B 2A2B 2A7F 7F7F FF08"            /* ......+*+*.... */
	$"0808 0808 0808 0808 0808 0808 FFFF FF00"            /* ............. */
	$"0000 0000 0000 FF00 2B2A 2B7F 7F7F 7FFF"            /* .......+*+.... */
	$"0808 0808 0808 0808 0808 0808 FFFF FF00"            /* ............. */
	$"0000 0000 0000 00FF 002B 2A2B 7F7F 7F7F"            /* ........+*+.... */
	$"FFFF 0808 0808 0808 0808 0808 FFFF FF00"            /* ........... */
	$"0000 0000 0000 0000 FF00 2B2A 7F7F 7F7F"            /* .........+*.... */
	$"7F7F FFFF FFFF FFFF FFFF 0808 FFFF FF00"            /* ..... */
	$"0000 0000 0000 0000 00FF 002B 2A7F 7F7F"            /* ..........+*... */
	$"7F7F 7F2B F9FF 0000 0000 FFFF FFFF FF00"            /* ...+..... */
	$"0000 0000 0000 0000 0000 FF00 2B2A 7F7F"            /* ...........+*.. */
	$"7F7F 2BF9 FF00 0000 0000 00FF FFFF FF00"            /* ..+....... */
	$"0000 0000 0000 0000 0000 00FF 002B 7F7F"            /* ............+.. */
	$"7F2B F9FF 0000 0000 0000 0000 0000 0000"            /* .+............ */
	$"0000 0000 0000 0000 0000 0000 FF00 2B7F"            /* .............+. */
	$"2BF9 FF00 0000 0000 0000 0000 0000 0000"            /* +............. */
	$"0000 0000 0000 0000 0000 0000 00FF 002B"            /* ..............+ */
	$"F9FF 0000 0000 0000 0000 0000 0000 0000"            /* .............. */
	$"0000 0000 0000 0000 0000 0000 0000 FF00"            /* ............... */
	$"FF00 0000 0000 0000 0000 0000 0000 0000"            /* ............... */
	$"0000 0000 0000 0000 0000 0000 0000 00FF"            /* ............... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
};

data 'icl8' (128) {
	$"0000 0000 0000 0000 0000 0000 0000 00FF"            /* ............... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 FF00"            /* ............... */
	$"FF00 0000 0000 0000 0000 0000 0000 0000"            /* ............... */
	$"0000 0000 0000 0000 0000 0000 00FF 002B"            /* ..............+ */
	$"F9FF 0000 0000 0000 0000 0000 0000 0000"            /* .............. */
	$"0000 0000 0000 0000 0000 0000 FF00 7F7F"            /* ............... */
	$"2BF9 FF00 0000 0000 0000 0000 0000 0000"            /* +............. */
	$"0000 0000 0000 0000 0000 00FF 007F 7F7F"            /* ............... */
	$"7F2B F9FF 0000 0000 0000 0000 0000 0000"            /* .+............ */
	$"0000 0000 0000 0000 0000 FF00 2B7F 7F7F"            /* ...........+... */
	$"7F7F 2BF9 FF00 0000 0000 0000 0000 0000"            /* ..+........... */
	$"0000 0000 0000 0000 00FF 002B 7F7F 7F7F"            /* ..........+.... */
	$"7F7F 2A2B F9FF 0000 0000 0000 0000 0000"            /* ..*+.......... */
	$"0000 0000 0000 0000 FF00 2B2A 7F7F 7F7F"            /* .........+*.... */
	$"7F2A 7F7F 2BF9 FF00 0000 0000 0000 0000"            /* .*..+......... */
	$"0000 0000 0000 00FF 002B 2A7F 7F7F 7F7F"            /* ........+*..... */
	$"2A7F 7F7F 7F2B F9FF 0000 0000 0000 0000"            /* *....+........ */
	$"0000 0000 0000 FF00 2B2A 2B7F 7F7F 7F7F"            /* .......+*+..... */
	$"2B7F 7F7F 7F7F 2BF9 FF00 0000 0000 0000"            /* +.....+....... */
	$"0000 0000 00FF 002B 2A2B 2A7F 7F7F 7F7F"            /* ......+*+*..... */
	$"2A7F 7F7F 7F7F 2A2B F9FF 0000 0000 0000"            /* *.....*+...... */
	$"0000 0000 FF00 2B2A 2B2A 7F7F 7F7F 7F2A"            /* .....+*+*.....* */
	$"7F7F 7F7F 7F2A 2B2A 2BF9 FF00 0000 0000"            /* .....*+*+..... */
	$"0000 00FF 002B 2A2B 2A2B 7F7F 7F7F 7F2B"            /* ....+*+*+.....+ */
	$"7F7F 7F7F 7F2B 2A2B 2A2B F9FF 0000 0000"            /* .....+*+*+.... */
	$"0000 FF00 2B2A 2B2A 2B2A 7F7F 7F7F 7F2A"            /* ...+*+*+*.....* */
	$"7FFF FFFF FFFF FF2A 2B2A 2BF9 FF00 0000"            /* .*+*+... */
	$"00FF 002B 2A2B 2A2B 2A2B 7F7F 7F7F 7F2B"            /* ..+*+*+*+.....+ */
	$"FF08 0808 0808 08FF 2A2B 2A2B F9FF 0000"            /* ......*+*+.. */
	$"FF00 2B2A 2B2A 2B2A 2B2A 7F7F 7F7F 7FFF"            /* .+*+*+*+*..... */
	$"0808 0808 0808 0808 FF2A 2B2A 2BF9 FF00"            /* ........*+*+. */
	$"00FF 002B 2A2B 2A2B 2A2B 7F7F 7F7F FF08"            /* ..+*+*+*+..... */
	$"08FF FF08 0808 0808 08FF 2A2B F9FF 0000"            /* .......*+.. */
	$"0000 FF00 2B2A 2B2A 2B2A 7F7F 7F7F FFFF"            /* ...+*+*+*.... */
	$"FF7F 7FFF 0808 0808 0808 FFF9 FF00 0000"            /* ........... */
	$"0000 00FF 002B 2A2B 2A2B 7F7F FFFF 0808"            /* ....+*+*+.... */
	$"FFFF FFFF FFFF FFFF 0808 08FF FFFF FF00"            /* .... */
	$"0000 0000 FF00 2B2A 2B2A 2B7F 7FFF 0808"            /* .....+*+*+.... */
	$"08FF FF08 0808 0808 0808 0808 FFFF FF00"            /* ........... */
	$"0000 0000 00FF 002B 2A2B 2A7F 7F7F FF08"            /* ......+*+*.... */
	$"0808 0808 0808 0808 0808 0808 FFFF FF00"            /* ............. */
	$"0000 0000 0000 FF00 2B2A 2B7F 7F7F 7FFF"            /* .......+*+.... */
	$"0808 0808 0808 0808 0808 0808 FFFF FF00"            /* ............. */
	$"0000 0000 0000 00FF 002B 2A2B 7F7F 7F7F"            /* ........+*+.... */
	$"FFFF 0808 0808 0808 0808 0808 FFFF FF00"            /* ........... */
	$"0000 0000 0000 0000 FF00 2B2A 7F7F 7F7F"            /* .........+*.... */
	$"7F7F FFFF FFFF FFFF FFFF 0808 FFFF FF00"            /* ..... */
	$"0000 0000 0000 0000 00FF 002B 2A7F 7F7F"            /* ..........+*... */
	$"7F7F 7F2B F9FF 0000 0000 FFFF FFFF FF00"            /* ...+..... */
	$"0000 0000 0000 0000 0000 FF00 2B2A 7F7F"            /* ...........+*.. */
	$"7F7F 2BF9 FF00 0000 0000 00FF FFFF FF00"            /* ..+....... */
	$"0000 0000 0000 0000 0000 00FF 002B 7F7F"            /* ............+.. */
	$"7F2B F9FF 0000 0000 0000 0000 0000 0000"            /* .+............ */
	$"0000 0000 0000 0000 0000 0000 FF00 2B7F"            /* .............+. */
	$"2BF9 FF00 0000 0000 0000 0000 0000 0000"            /* +............. */
	$"0000 0000 0000 0000 0000 0000 00FF 002B"            /* ..............+ */
	$"F9FF 0000 0000 0000 0000 0000 0000 0000"            /* .............. */
	$"0000 0000 0000 0000 0000 0000 0000 FF00"            /* ............... */
	$"FF00 0000 0000 0000 0000 0000 0000 0000"            /* ............... */
	$"0000 0000 0000 0000 0000 0000 0000 00FF"            /* ............... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
};

data 'icl8' (129) {
	$"0000 0000 FFFF FFFF FFFF FFFF FFFF FFFF"            /* .... */
	$"FFFF FFFF 0000 0000 0000 0000 0000 0000"            /* ............ */
	$"0000 0000 FFF5 F5F5 F5F5 F5F5 F5F5 F5F5"            /* .... */
	$"F5F5 F5FF FF00 0000 0000 0000 0000 0000"            /* ........... */
	$"0000 0000 FFF5 2A2B 2A2B 2A2B 2A2B 2A2B"            /* ....*+*+*+*+*+ */
	$"2A2B 2AFF F5FF 0000 0000 0000 0000 0000"            /* *+*.......... */
	$"0000 0000 FFF5 2B2A 2B2A 2B2A 7F2A 2B2A"            /* ....+*+*+*.*+* */
	$"2B2A 2BFF F52A FF00 0000 0000 0000 0000"            /* +*+*......... */
	$"0000 0000 FFF5 2A2B 2A2B 2A7F 7F7F 2A2B"            /* ....*+*+*...*+ */
	$"2A2B 2AFF F52B 2AFF 0000 0000 0000 0000"            /* *+*+*........ */
	$"0000 0000 FFF5 2B2A 2B2A 7F7F 7F7F 7F2A"            /* ....+*+*.....* */
	$"2B2A 2BFF F52A 2B2A FF00 0000 0000 0000"            /* +*+*+*....... */
	$"0000 0000 FFF5 2A2B 2A2B 7F7F 7F7F 7F7F"            /* ....*+*+...... */
	$"2A2B 2AFF F5F8 F8F8 F8FF 0000 0000 0000"            /* *+*...... */
	$"0000 0000 FFF5 2B2A 2B7F 7F7F 7F7F 7F2A"            /* ....+*+......* */
	$"7F2A 2BFF FFFF FFFF FFFF FF00 0000 0000"            /* .*+..... */
	$"0000 0000 FFF5 2A2B 2A7F 7F7F 7F7F 2A7F"            /* ....*+*.....*. */
	$"7F7F 2A2B 2A2B 2A2B 2AF8 FF00 0000 0000"            /* ..*+*+*+*..... */
	$"0000 0000 FFF5 2B2A 7F7F 7F7F 7F2A 7F7F"            /* ....+*.....*.. */
	$"7F7F 7F2A 2B2A 2B2A 2BF8 FF00 0000 0000"            /* ...*+*+*+..... */
	$"0000 0000 FFF5 2A2B 7F7F 7F7F 7F2B 7F7F"            /* ....*+.....+.. */
	$"7F7F 7F7F 2A2B 2A2B 2AF8 FF00 0000 0000"            /* ....*+*+*..... */
	$"0000 0000 FFF5 2B2A 7F7F 7F7F 7F2A 7F7F"            /* ....+*.....*.. */
	$"7F7F 7F2A 2B2A 2B2A 2BF8 FF00 0000 0000"            /* ...*+*+*+..... */
	$"0000 0000 FFF5 2A7F 7F7F 7F7F 2A7F 7F7F"            /* ....*.....*... */
	$"7F7F 2A2B 2A2B 2A2B 2AF8 FF00 0000 0000"            /* ..*+*+*+*..... */
	$"0000 0000 FFF5 2B7F 7F7F 7F7F 2B7F 7F7F"            /* ....+.....+... */
	$"7F7F 2B2A 2B2A 2B2A 2BF8 FF00 0000 0000"            /* ..+*+*+*+..... */
	$"0000 0000 FFF5 2A7F 7F7F 7F7F 2A7F 7F7F"            /* ....*.....*... */
	$"7F7F 2A2B 2A2B 2A2B 2AF8 FF00 0000 0000"            /* ..*+*+*+*..... */
	$"0000 0000 FFF5 2B7F 7F7F 7F7F 2B7F 7F7F"            /* ....+.....+... */
	$"7F7F 2B2A 2B2A 2B2A 2BF8 FF00 0000 0000"            /* ..+*+*+*+..... */
	$"0000 0000 FFF5 2A7F 7F7F 7F7F 2A7F 7F7F"            /* ....*.....*... */
	$"7F7F 2A2B 2A2B 2A2B 2AF8 FF00 0000 0000"            /* ..*+*+*+*..... */
	$"0000 0000 FFF5 2B7F 7F7F 7F7F 2B7F 7F7F"            /* ....+.....+... */
	$"7F7F 2B2A 2B2A 2B2A 2BF8 FF00 0000 0000"            /* ..+*+*+*+..... */
	$"0000 0000 FFF5 2A7F 7F7F 7F7F 2A7F 7F7F"            /* ....*.....*... */
	$"7F7F 2A2B 2A2B 2A2B 2AF8 FF00 0000 0000"            /* ..*+*+*+*..... */
	$"0000 0000 FFF5 2B7F 7F7F 7F7F 2B7F 7FE3"            /* ....+.....+.. */
	$"E3E3 E3E3 E3E3 E3E3 E3E3 E3E3 E3E3 A500"            /* . */
	$"0000 0000 FFF5 2A2B 7F7F 7F7F 7F2B 7FE3"            /* ....*+.....+. */
	$"9F9F 9F9F 9F9F 9F9F 9F9F 9F9F 9F9F A500"            /* . */
	$"0000 0000 FFF5 2B2A 7F7F 7F7F 7F2A 7FE3"            /* ....+*.....*. */
	$"9F00 9F9F 9F9F 9F9F 9F9F 009F 9F9F A500"            /* ... */
	$"0000 0000 FFF5 2A2B 7F7F 7F7F 7F2B 7FE3"            /* ....*+.....+. */
	$"9F00 0000 9F00 9F9F 009F 0000 009F A500"            /* ......... */
	$"0000 0000 FFF5 2B2A 2B7F 7F7F 7F7F 2BE3"            /* ....+*+.....+ */
	$"9F00 9F9F 9F9F 0000 9F9F 009F 9F9F A500"            /* ..... */
	$"0000 0000 FFF5 2A2B 2A7F 7F7F 7F7F 7FE3"            /* ....*+*...... */
	$"9F00 9F9F 9F9F 0000 9F9F 009F 9F9F A500"            /* ..... */
	$"0000 0000 FFF5 2B2A 2B2A 7F7F 7F7F 7FE3"            /* ....+*+*..... */
	$"9F9F 0000 9F00 9F9F 009F 9F00 009F A500"            /* ....... */
	$"0000 0000 FFF5 2A2B 2A2B 7F7F 7F7F 7FE3"            /* ....*+*+..... */
	$"9F9F 9F9F 9F9F 9F9F 9F9F 9F9F 9F9F A500"            /* . */
	$"0000 0000 FFF5 2B2A 2B2A 2B7F 7F7F 2BE3"            /* ....+*+*+...+ */
	$"9F9F 9F9F 9F9F 9F9F 9F9F 9F9F 9F9F A500"            /* . */
	$"0000 0000 FFF5 2A2B 2A2B 2A2B 7F2B 2AA5"            /* ....*+*+*+.+* */
	$"A5A5 A5A5 A5A5 A5A5 A5A5 A5A5 A5A5 A500"            /* . */
	$"0000 0000 FFF5 2B2A 2B2A 2B2A 2B2A 2B2A"            /* ....+*+*+*+*+* */
	$"2B2A 2B2A 2B2A 2B2A 2BF8 FF00 0000 0000"            /* +*+*+*+*+..... */
	$"0000 0000 FFF5 F8F8 F8F8 F8F8 F8F8 F8F8"            /* .... */
	$"F8F8 F8F8 F8F8 F8F8 F8F8 FF00 0000 0000"            /* ..... */
	$"0000 0000 FFFF FFFF FFFF FFFF FFFF FFFF"            /* .... */
	$"FFFF FFFF FFFF FFFF FFFF FF00 0000 0000"            /* ..... */
};

data 'icl8' (130) {
	$"0000 0000 FFFF FFFF FFFF FFFF FFFF FFFF"            /* .... */
	$"FFFF FFFF 0000 0000 0000 0000 0000 0000"            /* ............ */
	$"0000 0000 FFF5 F5F5 F5F5 F5F5 F5F5 F5F5"            /* .... */
	$"F5F5 F5FF FF00 0000 0000 0000 0000 0000"            /* ........... */
	$"0000 0000 FFF5 2B2A 2B2A 7F2A 2B2A 2B2A"            /* ....+*+*.*+*+* */
	$"2B2A 2BFF F5FF 0000 0000 0000 0000 0000"            /* +*+.......... */
	$"0000 0000 FFF5 2A2B 2A7F 7F7F 2A2B 2A2B"            /* ....*+*...*+*+ */
	$"2A2B 2AFF F52A FF00 0000 0000 0000 0000"            /* *+**......... */
	$"0000 0000 FFF5 2B2A 7F7F 7F2B 7F2A 2B2A"            /* ....+*...+.*+* */
	$"2B2A 2BFF F52B 2AFF 0000 0000 0000 0000"            /* +*++*........ */
	$"0000 0000 FFF5 2A7F 7F7F 2B7F 7F7F 2A2B"            /* ....*...+...*+ */
	$"2A2B 2AFF F52A 2B2A FF00 0000 0000 0000"            /* *+**+*....... */
	$"0000 0000 FFF5 2B7F 7F2B 7F7F 7F2A 2B2A"            /* ....+..+...*+* */
	$"2B2A 2BFF F5F8 F8F8 F8FF 0000 0000 0000"            /* +*+...... */
	$"0000 0000 FFF5 2A7F 7F2A 7F7F 2A2B 2A2B"            /* ....*..*..*+*+ */
	$"2A2B 2AFF FFFF FFFF FFFF FF00 0000 0000"            /* *+*..... */
	$"0000 0000 FFF5 2B7F 7F2B 7F7F 2A2A 2B2A"            /* ....+..+..**+* */
	$"2B2A 2B2A 2B2A 2B2A 2BF8 FF00 0000 0000"            /* +*+*+*+*+..... */
	$"0000 0000 FFF5 2A7F 7F2A 7F7F 7F2A 2A2B"            /* ....*..*...**+ */
	$"2A2B 2A2B 2A2B 2A2B 2AF8 FF00 0000 0000"            /* *+*+*+*+*..... */
	$"0000 0000 FFF5 2B7F 7F7F 2A7F 7F7F 2B2A"            /* ....+...*...+* */
	$"2B2A 2B2A 2B2A 2B2A 2BF8 FF00 0000 0000"            /* +*+*+*+*+..... */
	$"0000 0000 FFF5 2A2B 7F7F 7F2A 7F2B 2A2B"            /* ....*+...*.+*+ */
	$"2A2B 2A2B 2A2B 2A2B 2AF8 FF00 0000 0000"            /* *+*+*+*+*..... */
	$"0000 0000 FFF5 2B2A 2B7F 7F7F 2A2A 2B2A"            /* ....+*+...**+* */
	$"2B2A 2B2A 2B2A 2B2A 2BF8 FF00 0000 0000"            /* +*+*+*+*+..... */
	$"0000 0000 FFF5 2A2B 2A2B 7F2A 2A2B 2A2B"            /* ....*+*+.**+*+ */
	$"2A2B 2A2B 2A2B 2A2B 2AF8 FF00 0000 0000"            /* *+*+*+*+*..... */
	$"0000 0000 FFF5 2B2A 2B2A 2B2A 2B2A 2B2A"            /* ....+*+*+*+*+* */
	$"2B2A 2B2A 2B2A 2B2A 2BF8 FF00 0000 0000"            /* +*+*+*+*+..... */
	$"0000 0000 FFF5 2A2B 2A2B 2A2B 2A2B 2A2B"            /* ....*+*+*+*+*+ */
	$"2A2B 2A2B 2A2B 2A2B 2AF8 FF00 0000 0000"            /* *+*+*+*+*..... */
	$"0000 0000 FFF5 2B2A 2B2A 2B2A 2B2A 2B2A"            /* ....+*+*+*+*+* */
	$"2B2A 2B2A 2B2A 2B2A 2BF8 FF00 0000 0000"            /* +*+*+*+*+..... */
	$"0000 0000 FFF5 2A2B FD2B 2A2B FDFD 2A2B"            /* ....*++*+*+ */
	$"2AFD FD2B 2A2B 2A2B 2AF8 FF00 0000 0000"            /* *+*+*+*..... */
	$"0000 0000 FFF5 2BFD FD2A 2BFD 2B2A FD2A"            /* ....+*++** */
	$"FD2A 2BFD 2B2A 2B2A 2BF8 FF00 0000 0000"            /* *++*+*+..... */
	$"0000 0000 FFF5 2A2B FD2B 2AFD 2A2B FDE3"            /* ....*++**+ */
	$"E3E3 E3E3 E3E3 E3E3 E3E3 E3E3 E3E3 A500"            /* . */
	$"0000 0000 FFF5 2BFD FDFD 2B2A FDFD 2BE3"            /* ....++*+ */
	$"9F9F 9F9F 9F9F 9F9F 9F9F 9F9F 9F9F A500"            /* . */
	$"0000 0000 FFF5 2A2B 2A2B 2A2B 2A2B 2AE3"            /* ....*+*+*+*+* */
	$"9F9F 9F9F 9F00 009F 9F9F 9F9F 009F A500"            /* .... */
	$"0000 0000 FFF5 2B2A 2B2A 2B2A 2B2A 2BE3"            /* ....+*+*+*+*+ */
	$"9F9F 9F9F 9F9F 009F 9F9F 9F9F 9F9F A500"            /* .. */
	$"0000 0000 FFF5 2A2B FDFD 2A2B 2AFD 2AE3"            /* ....*+*+** */
	$"9F00 009F 9F9F 0000 009F 9F00 0000 A500"            /* ......... */
	$"0000 0000 FFF5 2BFD 2B2A FD2A FDFD 2BE3"            /* ....++**+ */
	$"009F 9F00 9F9F 009F 9F00 9F9F 009F A500"            /* ...... */
	$"0000 0000 FFF5 2AFD 2A2B FD2B 2AFD 2AE3"            /* ....**++** */
	$"009F 9F00 9F9F 009F 9F00 9F9F 009F A500"            /* ...... */
	$"0000 0000 FFF5 2B2A FDFD 2B2A FDFD FDE3"            /* ....+*+* */
	$"9F00 009F 9F00 0000 009F 9F9F 009F A500"            /* ........ */
	$"0000 0000 FFF5 2A2B 2B2B 2B2B 2B2B 2BE3"            /* ....*++++++++ */
	$"9F9F 9F9F 9F9F 9F9F 9F9F 0000 9F9F A500"            /* ... */
	$"0000 0000 FFF5 2B2A 2B2A 2B2A 2B2A 2BA5"            /* ....+*+*+*+*+ */
	$"A5A5 A5A5 A5A5 A5A5 A5A5 A5A5 A5A5 A500"            /* . */
	$"0000 0000 FFF5 2A2B 2A2B 2A2B 2A2B 2A2B"            /* ....*+*+*+*+*+ */
	$"2A2B 2A2B 2A2B 2A2B 2AF8 FF00 0000 0000"            /* *+*+*+*+*..... */
	$"0000 0000 FFF5 F8F8 F8F8 F8F8 F8F8 F8F8"            /* .... */
	$"F8F8 F8F8 F8F8 F8F8 F8F8 FF00 0000 0000"            /* ..... */
	$"0000 0000 FFFF FFFF FFFF FFFF FFFF FFFF"            /* .... */
	$"FFFF FFFF FFFF FFFF FFFF FF00 0000 0000"            /* ..... */
};

data 'ics#' (-16455) {
	$"0180 03C0 07E0 0B70 16F8 26EC 46F6 879B"            /* ....p.&F */
	$"C7CE 66F7 3703 1BFB 0FA7 0740 0380 0100"            /* f7....@... */
	$"0180 03C0 07E0 0FF0 1FF8 3FFC 7FFE FFFF"            /* .....?. */
	$"FFFE 7FFF 3FFF 1FFF 0FE7 07C0 0380 0100"            /* .?...... */
};

data 'ics#' (128) {
	$"0180 03C0 07E0 0B70 16F8 26EC 46F6 879B"            /* ....p.&F */
	$"C7CE 66F7 3703 1BFB 0FA7 0740 0380 0100"            /* f7....@... */
	$"0180 03C0 07E0 0FF0 1FF8 3FFC 7FFE FFFF"            /* .....?. */
	$"FFFE 7FFF 3FFF 1FFF 0FE7 07C0 0380 0100"            /* .?...... */
};

data 'ics#' (129) {
	$"3FE0 2270 2758 2FFC 2EC4 2DC4 3D84 3D84"            /* ?"p'X/.-== */
	$"3D84 3DF7 2FFF 2FFF 2FFF 27FF 23F7 3FFC"            /* ==///'#? */
	$"3FE0 3FF0 3FF8 3FFC 3FFC 3FFC 3FFC 3FFC"            /* ???????? */
	$"3FFC 3FFF 3FFF 3FFF 3FFF 3FFF 3FFF 3FFC"            /* ???????? */
};

data 'ics#' (130) {
	$"3FE0 2C70 3A58 367C 3604 3A04 2C04 2004"            /* ?,p:X6|6.:.,. . */
	$"2AC4 3DF7 3BFF 2BFF 37FF 2BFF 21F7 3FFC"            /* *=;+7+!? */
	$"3FE0 3FF0 3FF8 3FFC 3FFC 3FFC 3FFC 3FFC"            /* ???????? */
	$"3FFC 3FFF 3FFF 3FFF 3FFF 3FFF 3FFF 3FFC"            /* ???????? */
};

data 'ics4' (-16455) {
	$"0000 000F F000 0000 0000 00FD FF00 0000"            /* ............. */
	$"0000 0FDD DFF0 0000 0000 FCDD CDFF 0000"            /* ......... */
	$"000F CDDC DDDF F000 00FC CDDC DDDC FF00"            /* ..... */
	$"0FCC CDDC FFFF CFF0 FCCC CDDF FCCF FCFF"            /* . */
	$"FFCC CDDF FFCC FFF0 0FFC CDFC FFFF CFFF"            /* . */
	$"00FF CDDF CCCC CCFF 000F FCDD FFFF FCFF"            /* ... */
	$"0000 FFDD DDF0 0FFF 0000 0FFD DF00 0000"            /* ......... */
	$"0000 00FF F000 0000 0000 000F 0000 0000"            /* .............. */
};

data 'ics4' (128) {
	$"0000 000F F000 0000 0000 00FD FF00 0000"            /* ............. */
	$"0000 0FDD DFF0 0000 0000 FCDD CDFF 0000"            /* ......... */
	$"000F CDDC DDDF F000 00FC CDDC DDDC FF00"            /* ..... */
	$"0FCC CDDC FFFF CFF0 FCCC CDDF FCCF FCFF"            /* . */
	$"FFCC CDDF FFCC FFF0 0FFC CDFC FFFF CFFF"            /* . */
	$"00FF CDDF CCCC CCFF 000F FCDD FFFF FCFF"            /* ... */
	$"0000 FFDD DDF0 0FFF 0000 0FFD DF00 0000"            /* ......... */
	$"0000 00FF F000 0000 0000 000F 0000 0000"            /* .............. */
};

data 'ics4' (129) {
	$"00FF FFFF FFF0 0000 00FC CCDC CFFF 0000"            /* ...... */
	$"00FC CDDD CF0F F000 00FC DDDD DFFF FF00"            /* ..... */
	$"00FC DDDC DDCC CF00 00FC DDCD DDCC CF00"            /* .... */
	$"00FD DDCD DCCC CF00 00FD DDCD DCCC CF00"            /* .... */
	$"00FD DDCD DCCC CF00 00FD DDC8 8888 CF8E"            /* ...Ȉώ */
	$"00FC DDD8 DDDD DDDE 00FC DDD8 DDDD DDDE"            /* .. */
	$"00FC DDD8 DDDD DDDE 00FC CDD8 DDDD DDDE"            /* .. */
	$"00FC CCDE EEEE CFEE 00FF FFFF FFFF FF00"            /* ... */
};

data 'ics4' (130) {
	$"00FF FFFF FFF0 0000 00FC DDCC CFFF 0000"            /* ...... */
	$"00FD DCDC CF0F F000 00FD CDDC CFFF FF00"            /* ..... */
	$"00FD CDDC CCCC CF00 00FD DCDC CCCC CF00"            /* .... */
	$"00FC DDCC CCCC CF00 00FC CCCC CCCC CF00"            /* .... */
	$"00FC ACAC AACC CF00 00FA AACA AA88 CF8E"            /* ...ʪώ */
	$"00FA ACA8 DDDD DDDE 00FC ACA8 DDDD DDDE"            /* .. */
	$"00FA CAA8 DDDD DDDE 00FC ACAA DDDD DDDE"            /* .ʨ. */
	$"00FC CCCE EEEE CFEE 00FF FFFF FFFF FF00"            /* ... */
};

data 'ics8' (-16455) {
	$"0000 0000 0000 00FF FF00 0000 0000 0000"            /* .............. */
	$"0000 0000 0000 FF7F FFFF 0000 0000 0000"            /* ............. */
	$"0000 0000 00FF 7F7F 7FFF FF00 0000 0000"            /* ............. */
	$"0000 0000 FF2B 7F7F 2B7F FFFF 0000 0000"            /* ....+..+..... */
	$"0000 00FF 2B7F 7F2B 7F7F 7FFF FF00 0000"            /* ...+..+...... */
	$"0000 FF2B 2B7F 7F2B 7F7F 7F2B FFFF 0000"            /* ..++..+...+.. */
	$"00FF 2B2B 2B7F 7F2B FFFF FFFF 2BFF FF00"            /* .+++..++. */
	$"FF2B 2B2B 2B7F 7FFF FF08 08FF FF2B FFFF"            /* ++++....+ */
	$"FFFF 2B2B 2B7F 7FFF FFFF 0808 FFFF FF00"            /* +++..... */
	$"00FF FF2B 2B7F FF08 FFFF FFFF 08FF FFFF"            /* .++... */
	$"0000 FFFF 2B7F 7FFF 0808 0808 0808 FFFF"            /* ..+........ */
	$"0000 00FF FF2B 7F7F FFFF FFFF FF08 FFFF"            /* ...+... */
	$"0000 0000 FFFF 7F7F 7FF9 FF00 00FF FFFF"            /* ......... */
	$"0000 0000 00FF FF7F F9FF 0000 0000 0000"            /* ............ */
	$"0000 0000 0000 FFFF FF00 0000 0000 0000"            /* ............. */
	$"0000 0000 0000 00FF 0000 0000 0000 0000"            /* ............... */
};

data 'ics8' (128) {
	$"0000 0000 0000 00FF FF00 0000 0000 0000"            /* .............. */
	$"0000 0000 0000 FF7F FFFF 0000 0000 0000"            /* ............. */
	$"0000 0000 00FF 7F7F 7FFF FF00 0000 0000"            /* ............. */
	$"0000 0000 FF2B 7F7F 2B7F FFFF 0000 0000"            /* ....+..+..... */
	$"0000 00FF 2B7F 7F2B 7F7F 7FFF FF00 0000"            /* ...+..+...... */
	$"0000 FF2B 2B7F 7F2B 7F7F 7F2B FFFF 0000"            /* ..++..+...+.. */
	$"00FF 2B2B 2B7F 7F2B FFFF FFFF 2BFF FF00"            /* .+++..++. */
	$"FF2B 2B2B 2B7F 7FFF FF08 08FF FF2B FFFF"            /* ++++....+ */
	$"FFFF 2B2B 2B7F 7FFF FFFF 0808 FFFF FF00"            /* +++..... */
	$"00FF FF2B 2B7F FF08 FFFF FFFF 08FF FFFF"            /* .++... */
	$"0000 FFFF 2B7F 7FFF 0808 0808 0808 FFFF"            /* ..+........ */
	$"0000 00FF FF2B 7F7F FFFF FFFF FF08 FFFF"            /* ...+... */
	$"0000 0000 FFFF 7F7F 7FF9 FF00 00FF FFFF"            /* ......... */
	$"0000 0000 00FF FF7F F9FF 0000 0000 0000"            /* ............ */
	$"0000 0000 0000 FFFF FF00 0000 0000 0000"            /* ............. */
	$"0000 0000 0000 00FF 0000 0000 0000 0000"            /* ............... */
};

data 'ics8' (129) {
	$"0000 FFFF FFFF FFFF FFFF FF00 0000 0000"            /* ....... */
	$"0000 FF2B 2B2B 7F2B 2BFF FFFF 0000 0000"            /* ..+++.++.... */
	$"0000 FF2B 2B7F 7F7F 2BFF F5FF FF00 0000"            /* ..++...+... */
	$"0000 FF2B 7F7F 7F7F 7FFF FFFF FFFF 0000"            /* ..+....... */
	$"0000 FF2B 7F7F 7F2B 7F7F 2B2B F8FF 0000"            /* ..+...+..++.. */
	$"0000 FF2B 7F7F 2B7F 7F7F 2B2B F8FF 0000"            /* ..+..+...++.. */
	$"0000 FF7F 7F7F 2B7F 7F2B 2B2B F8FF 0000"            /* .....+..+++.. */
	$"0000 FF7F 7F7F 2B7F 7F2B 2B2B F8FF 0000"            /* .....+..+++.. */
	$"0000 FF7F 7F7F 2B7F 7F2B 2B2B F8FF 0000"            /* .....+..+++.. */
	$"0000 FF7F 7F7F 2BE3 E3E3 E3E3 F8FF E3A5"            /* .....+ */
	$"0000 FF2B 7F7F 7FE3 9F9F 9F9F 9F9F 9FA5"            /* ..+...㟟 */
	$"0000 FF2B 7F7F 7FE3 9F9F 9F9F 9F9F 9FA5"            /* ..+...㟟 */
	$"0000 FF2B 7F7F 7FE3 9F9F 9F9F 9F9F 9FA5"            /* ..+...㟟 */
	$"0000 FF2B 2B7F 7FE3 9F9F 9F9F 9F9F 9FA5"            /* ..++..㟟 */
	$"0000 FF2B 2B2B 7FA5 A5A5 A5A5 F8FF A5A5"            /* ..+++. */
	$"0000 FFFF FFFF FFFF FFFF FFFF FFFF 0000"            /* .... */
};

data 'ics8' (130) {
	$"0000 FFFF FFFF FFFF FFFF FF00 0000 0000"            /* ....... */
	$"0000 FF2B 7F7F 2B2B 2BFF FFFF 0000 0000"            /* ..+..+++.... */
	$"0000 FF7F 7F2B 7F2B 2BFF F5FF FF00 0000"            /* ....+.++... */
	$"0000 FF7F 2B7F 7F2B 2BFF FFFF FFFF 0000"            /* ...+..++.. */
	$"0000 FF7F 2B7F 7F2B 2B2B 2B2B F8FF 0000"            /* ...+..+++++.. */
	$"0000 FF7F 7F2B 7F2B 2B2B 2B2B F8FF 0000"            /* ....+.+++++.. */
	$"0000 FF2B 7F7F 2B2B 2B2B 2B2B F8FF 0000"            /* ..+..++++++.. */
	$"0000 FF2B 2B2B 2B2B 2B2B 2B2B F8FF 0000"            /* ..+++++++++.. */
	$"0000 FF2B FD2B FD2B FDFD 2B2B F8FF 0000"            /* ..+++++.. */
	$"0000 FFFD FDFD 2BFD FDFD E3E3 F8FF E3A5"            /* ..+ */
	$"0000 FFFD FD2B FDE3 9F9F 9F9F 9F9F 9FA5"            /* ..+㟟 */
	$"0000 FF2B FD2B FDE3 9F9F 9F9F 9F9F 9FA5"            /* ..++㟟 */
	$"0000 FFFD 2BFD FDE3 9F9F 9F9F 9F9F 9FA5"            /* ..+㟟 */
	$"0000 FF2B FD2B FDFD 9F9F 9F9F 9F9F 9FA5"            /* ..++ */
	$"0000 FF2B 2B2B 2BA5 A5A5 A5A5 F8FF A5A5"            /* ..++++ */
	$"0000 FFFF FFFF FFFF FFFF FFFF FFFF 0000"            /* .... */
};

resource 'open' (128) {
	'3PRM',
	{	'TEXT'
	}
};

resource 'kind' (1000)
{
   '3PRM',
   verUS,
   {
      'apnm',			      "Clean",
      'TEXT',                 "Clean text document",
      'CgOb',                 "Clean code object",
      'APPL',                 "Clean IDE application",
   }
}; 

#include "aboutIde.r"

read 'icns' (128) "carbonIde.app.icns";
read 'icns' (129) "carbonIde.txt.icns";
read 'icns' (130) "carbonIde.obj.icns";
read 'plst' (0) "carbonIde.plist";
