implementation module state


import	StdBool, StdList
import	board, language
import	Random


::	*State
	=	{	playmode		:: Playmode				//	The playing mode
		,	board			:: Board				//	The playing board
		,	player			:: Player				//	Who's move is it (Player1 or Player2)
		,	player1			:: Playerinfo			//	The information of player 1
		,	player2			:: Playerinfo			//	The information of player 2
		,	direction		:: Direction			//	Last direction chosen by a Person
		,	letterbox		:: [Char]				//	The current set of available letters
		,	lexicon			:: Tree					//	The current list of valid words
		,	wordsadded		:: Bool					//	Words have been added by the players
		,	dimensions		:: (Int,Int,Int,Int)	//	The smallest enclosing rectangle surrounding the layn words
		,	strength		:: Strength				//	Strength of the Computer player
		,	progress		:: Progress				//	The progress of a Computer player
		,	random			:: [Int]				//	An infinite random Integer list
		}
::	Playerinfo
	=	{	kind			:: Playerkind			//	The kind of the player
		,	letters			:: [Char]				//	Letters of player
		,	points			:: Int					//	Score of player
		,	placedword		:: Bool					//	Player placed a word in last turn (initially True)
		}


/***************************************************************************************************************
	The value initdimensions will cause the computer player to place its first word at the center position of 
	the board (7,7).
****************************************************************************************************************/
initdimensions :: (Int,Int,Int,Int)
initdimensions = (8,6,8,6)


/***************************************************************************************************************
	The initstate fixes the starting players. 
****************************************************************************************************************/
initstate :: Tree -> State
initstate wordlist
	= {	playmode		= EndPlayer2
	  ,	board			= initboard
	  ,	player			= Player2
	  ,	player1			= {	kind		= Person
						  ,	letters		= []
						  ,	points		= 0
						  ,	placedword	= True
						  }
	  ,	player2			= {	kind		= Computer
						  ,	letters		= []
						  ,	points		= 0
						  ,	placedword	= True
						  }
	  ,	direction		= Hor
	  ,	letterbox		= letterbox
	  ,	lexicon			= wordlist
	  ,	wordsadded		= False
	  ,	dimensions		= initdimensions
	  ,	strength		= Maximum
	  ,	progress		= Letter 'a' initplacing
	  ,	random			= []
	  }


/***************************************************************************************************************
	When starting a new game the word list should not be read in again because this takes to long. 
	For this purpose the function initialisestate is used.
****************************************************************************************************************/
initialisestate :: State (IOState *s) -> (State,IOState *s)
initialisestate t=:{random,player1,player2} io
	# (rs,io)					= getRandomList random io
	  (letterbox,letters1,rs)	= grab letterbox 7 rs
	  (letterbox,letters2,rs)	= grab letterbox 7 rs
	= (	{t	& playmode		= EndPlayer2
			, player		= Player2
			, player1		= {player1 & letters=letters1,points=0}
			, player2		= {player2 & letters=letters2,points=0}
			, board			= initboard
			, letterbox		= letterbox
			, dimensions	= initdimensions
			, random		= rs
		}
	  ,	io
	  )
where
	getRandomList :: ![Int] !(IOState *s) -> (![Int],!IOState *s)
	getRandomList rs io
		| not (isEmpty rs)
		= (rs,io)
		# (seed,io)	= GetNewRandomSeed io
		| otherwise
		= (random_list seed,io)
	where
		random_list :: !RandomSeed -> [Int]
		random_list seed
			# (random,seed)	= Random seed
			= [random : random_list seed]

getboardletters :: State -> ([Char],State)
getboardletters t=:{board}
	= (getplacedletters board,t)
