
Module nFunc Import Product;

(* This module introduces the concept of single-sorted n-ary functions
   and predicates.
*)

(* ---------------------------------------------------------------------------
   First we define two-sorted n-ary operators, called arrows.

       arrow T V n  =_\beta  T -> ... -> T -> V

   We need to allow different domain and codomain because predicates
   are functions from a type to Prop.
*)

[     arrow : SET -> SET -> nat -> SET
          = [T,V:SET] nat_iter V ([ih:SET] T->ih)
];

(* Next, we make the the set of arrows by adding an appropiate equivalence relation. *)

[A,B : Set];

Goal eq_arrow : {n|nat} (arrow A.el B.el n) -> (arrow A.el B.el n) -> Prop;
  Refine nat_elim [n:nat] (arrow A.el B.el n) -> (arrow A.el B.el n) -> Prop;
  Refine Eq;
  Intros __ f g; Refine {x:el A} n_ih (f x) (g x);
Save;

Goal {n:nat} reflexive (eq_arrow|n);
  Refine nat_ind [n:nat] reflexive (eq_arrow|n);
  Refine Eq_refl;
  Intros; Refine ih;
Save eq_arrow_refl;

Goal {n:nat} symmetric (eq_arrow|n);
  Intros ___;
  Refine nat_ind [n:nat] symmetric (eq_arrow|n);
  Refine Eq_sym;
  Intros; Refine ih ?.H;
Save eq_arrow_sym;

Goal {n:nat} transitive (eq_arrow|n);
  Intros ____;
  Refine nat_ind [n:nat] transitive (eq_arrow|n);
  Refine Eq_trans;
  Intros; Refine ih ? ?.H ?.H1;
Save eq_arrow_trans;

[     Arrow : nat -> Set
          = [n:el Nat] Set_intro n.eq_arrow_refl n.eq_arrow_sym n.eq_arrow_trans
];

Discharge A;

(* --------------------------------------------------------------------------------
   Define two-sorted n-ary functions and predicates. Also define apn
   and ext to extract the operator and extensionality proofs.
*)

[A,B | Set];

Goal arrow_extensional' : {n|nat} {f,f':arrow A.el B.el n} Prop;
  Refine nat_elim [n:nat] {f,f':arrow A.el B.el n} Prop;
  Refine Eq;
  intros; Refine {x,x'|el A} (Eq x x') -> n_ih (f x) (f' x');
Save;

Goal arrow_extensional : {n|nat} {f:arrow A.el B.el n} Prop;
  intros; Refine arrow_extensional' f f;
Save;

DischargeKeep A;

[    nFun [A,B:Set] [n:nat] : SET
          = <f:arrow A.el B.el n> arrow_extensional f
];

[    apn [n|nat][f:nFun A B n] : arrow A.el B.el n
          = f.1
]
[    ext [n|nat][f:nFun A B n] : arrow_extensional f.apn
          = f.2
]
[    nFun_intro [n|nat][f:arrow A.el B.el n][ext:arrow_extensional f] : nFun A B n
          = (f, ext : nFun A B n)
];

[   constant [x:el B] : nFun A B ZeroN
          = nFun_intro|ZeroN x x.Eq_refl
];

Discharge A;

(* --------------------------------------------------------------------------------
   Now we are able to define single-sorted n-ary functions and predicates.
*)

[     nFunc [A:Set] [n:nat] : SET
          = nFun A A n
]
[     nPred [A:Set] [n:nat] : SET
          = nFun A Omega n
];

Goal nFunction : Set -> Set -> nat -> Set;
  intros A B n;
  Refine Set_intro;
  Refine nFun A B n;
  Intros f g; Refine eq_arrow ?? f.apn g.apn;
  Intros _; Refine eq_arrow_refl;
  Intros __; Refine eq_arrow_sym;
  Intros ___; Refine eq_arrow_trans;
Save;

(* --------------------------------------------------------------------------------
   apn and ext do not always have convenient types:

     apn : {A,B|Set} {n|nat} (nFun A B n) -> arrow A.el B.el n
     ext : {A,B|Set} {n|nat} {f:nFun A B n} arrow_extensional f.apn

   Sometimes we would like:

     ap1 : {A,B|Set} {n|nat} (nFun A B (succ n)) -> A.el -> (nFunction A B n).el
     app : {A,B|Set} {n|nat} (nFun A B n) -> (Product A n).el -> B.el
     extp: {A,B|Set} {n|nat} {f:nFun A B n} {p,q|el (Product A n)}
                                            (Eq p q) -> Eq (app f p) (app f q)
*)

[A,B | Set];

Goal ap1 : {n|nat} (nFunction A B n.succ).el -> A.el -> (nFunction A B n).el;
  intros n f x; Refine nFun_intro;
  Refine apn f x;
  Refine ext f ?.Eq_refl;
Save;

(* Define swap such that

       swap f z x0 x1..xn  =  f x0 z x1..xn
*)

Goal app_swap : {n|nat} (nFun A B n.succ.succ) -> (el A) -> (nFun A B n.succ);
  intros n f z; Refine nFun_intro;
  Refine [x:el A] f.apn x z;
  Intros ___; Refine f.ext H ?.Eq_refl;
Save;

Goal {n|nat} extensional2 (ap1|n);
  Intros n' g g' _ x y _;
  Refine eq_arrow_trans ??? (g'.apn x) ?.H;
  Refine nat_elim [n:nat] {f:nFun A B n.succ} eq_arrow ?? (f.apn x) (f.apn y);
  intros; Refine ext f H1;
  Intros n ih f z; Refine ih (app_swap f z);
Save ap1_exten;

Goal {n|nat} (nFun A B n) -> (Product A n).el -> B.el;
  intros n f;
  Refine nat_elim_01 [n:nat] (arrow A.el B.el n) -> (product A.el n) -> B.el;
  intros a p; Refine a;
  intros a p; Refine a p;
  intros n ih a p; Refine ih (a p.first) p.second;
  Refine f.apn;
Save app;

Goal {n|nat} extensional2|(nFunction A B n) (app|n);
  Refine nat_elim_01 [n:nat] extensional2|(nFunction A B n) (app|n);
  Intros ______; Refine H;
  Intros f f' _ x y _;
    Refine Eq_trans; Refine +1 f.ext H1; Refine H;
  Intros __ f f' _ p p' _;
    Refine H|(ap1 f p.first)|(ap1 f' p'.first); Refine +1 H2.snd;
    Refine ap1_exten H1 H2.fst;
Save app_exten;

Goal {n|nat} {f:nFun A B n} {p,q|el (Product A n)} (Eq p q) -> Eq (f.app p) (f.app q);
  intros __; Refine app_exten ?.Eq_refl;
Save extp;

Discharge A;
