
Module Submodel Import semantics Subsets;

(* This very short module defines the notion of a submodel. *)

(* Given a model M and a predicate P over the carrier of M. A submodel
   is a proposition which states that for every function of symbol f of
   the model:

       (P.ap x_1) -> ... (P.ap x_n) -> (P.ap ([f].ap x_1 ... x_n))
*)

[sig | Signature] [ax | Axioms sig] [M | Model ax] [P : Subset M.car];

Goal submodel_axiom : sig.FuncSymb -> Prop;
  intros c;
  Refine nat_elim [n:nat] {f:arrow M.obj M.obj n} Prop;
  Refine P.ap;
  intros n ih f; Refine {x|obj M} (P.ap x) -> ih (f x);
  Refine +1 (intFunc M c).apn;
Save;

[     submodel : Prop
          = {c:FuncSymb sig} submodel_axiom c
];

Discharge sig;
