
Module Set Import basic Q;

(* --------------------------------------------------------------------------------
   Define the type of equality relations over a type T.
*)

[     EqRel [T:SET] : SET
          = <R:T->T->Prop> and3 R.reflexive R.symmetric R.transitive
]
[     EqRel_intro [T|SET] [R:T->T->Prop]
                  [refl:R.reflexive] [sym:R.symmetric] [trans:R.transitive]
          : EqRel T
          = (R, pair3 refl sym trans : EqRel T)
];

(* --------------------------------------------------------------------------------
   Define the type of set by means of a setoid.
*)

[     Set : TYPE
          = <T:SET> EqRel T
]
[     Set_intro [T|SET] [R|T->T->Prop]
                [refl : reflexive R] [sym : symmetric R] [trans : transitive R]
          : Set
          = (T, EqRel_intro R refl sym trans : Set)
];

[     el [A:Set] : SET
           = A.1
]
[     Eq_rel [A:Set] : EqRel A.el
          = A.2
];

[A | Set]
[     Eq : A.el->A.el->Prop
          = A.Eq_rel.1
]
[     Eq_refl : reflexive Eq
          = and3_out1 A.Eq_rel.2
]
[     Eq_sym : symmetric Eq
          = and3_out2 A.Eq_rel.2
]
[     Eq_trans : transitive Eq
          = and3_out3 A.Eq_rel.2
];
Discharge A;

(* A set is discrete if the underlying equality is decidable. *)

[     Discrete [A:Set] : Prop
          = decidable_rel (Eq|A)
];

[     ExOne [A|Set] [P:A.el->Prop] : Prop
          = (Ex P) /\ ({x,x':el A} (P x) -> (P x') -> Eq x x')
];

(* --------------------------------------------------------------------------------
   A type T can be transformed into a set by chosing Leibniz equality
   as the equivalence relation. *)

[     QSet : SET -> Set
          = [S:SET] Set_intro (Q_refl|S) (Q_sym|S) (Q_trans|S)
];

(* -------------------------------------------------------------------------------- *)

[     nonemptySet : Set -> Prop
          = [A:Set] Ex ([x:el A] trueProp)
];

(* --------------------------------------------------------------------------------
   Define sets with precisely zero, one, ... and seven elements.
*)

Inductive [EmptySET : SET]
Constructors;

Inductive [UnitSET : SET]
Constructors [star : UnitSET];

Inductive [TwoSET : SET]
Constructors [star21, star22 : TwoSET];

Inductive [ThreeSET : SET]
Constructors [star31, star32, star33 : ThreeSET];

Inductive [FourSET : SET]
Constructors [star41, star42, star43, star44 : FourSET];

Inductive [FiveSET : SET]
Constructors [star51, star52, star53, star54, star55 : FiveSET];

Inductive [SixSET : SET]
Constructors [star61, star62, star63, star64, star65, star66 : SixSET];

Inductive [SevenSET : SET]
Constructors [star71, star72, star73, star74, star75, star76, star77 : SevenSET];

(* Construct sets out of these types. *)

[    EmptySet : Set
          = QSet EmptySET
]
[    UnitSet : Set
          = QSet UnitSET
]
[    TwoSet : Set
          = QSet TwoSET
];

[    Star : el UnitSet
          = star
];

(* Define iteration for these types. *)

[     EmptySET_iter [T|SET] : EmptySET -> T
          = EmptySET_elim (EmptySET\T)
]
[     UnitSET_iter [T|SET] : T -> UnitSET -> T
          = UnitSET_elim (UnitSET\T)
]
[     TwoSET_iter [T|SET] : T -> T -> TwoSET -> T
          = TwoSET_elim (TwoSET\T)
]
[     ThreeSET_iter [T|SET] : T -> T -> T -> ThreeSET -> T
          = ThreeSET_elim (ThreeSET\T)
]
[     FourSET_iter [T|SET] : T -> T -> T -> T -> FourSET -> T
          = FourSET_elim (FourSET\T)
]
[     FiveSET_iter [T|SET] : T -> T -> T -> T -> T -> FiveSET -> T
          = FiveSET_elim (FiveSET\T)
]
[     SixSET_iter [T|SET] : T -> T -> T -> T -> T -> T -> SixSET -> T
          = SixSET_elim (SixSET\T)
]
[     SevenSET_iter [T|SET] : T -> T -> T -> T -> T -> T -> T -> SevenSET -> T
          = SevenSET_elim (SevenSET\T)
];

(* Two elements of a unit set are always equal. *)

Goal {x,y:el UnitSet} Eq x y;
  Refine UnitSET_elim [x:UnitSet.el] {y:el UnitSet} Eq x y;
  Refine UnitSET_elim (Eq Star);
  Refine Eq_refl;
Save UnitSet_trivial;

(* Prove that the unit set is discrete. *)

Goal Discrete UnitSet;
  Intros __; Refine inl;
  Refine UnitSet_trivial;
Save UnitSet_discr;

(* ================================================================================
   Define unary, binary and ternary functions as an operators over the
   elements of a set, together with a proof that it is extensional
   (preserves equality).
*)

[A,B,C,D | Set];
  [extensional  [o:A.el -> B.el]
     = preserve1 (Eq|A) (Eq|B) o
  ]
  [extensional2 [o:A.el -> B.el -> C.el]
     = preserve2 (Eq|A) (Eq|B) (Eq|C) o
  ]
  [extensional3 [o:A.el -> B.el -> C.el -> D.el]
     = {x,x'|A.el}(Eq x x') -> {y,y'|B.el}(Eq y y') -> {z,z'|C.el}(Eq z z') ->
       Eq (o x y z) (o x' y' z')
  ];
Discharge A;

[A,B,C,D : Set];
  [Fun  : SET = <f:A.el -> B.el> extensional f];
  [Fun2 : SET = <f:A.el -> B.el -> C.el> extensional2 f];
  [Fun3 : SET = <f:A.el -> B.el -> C.el -> D.el> extensional3 f];
Discharge A;

(* Define the application of a function and a term to extract the
proof of extensionality of a function. Also define a term which builds
a function from both components. *)

[A,B,C,D | Set];
  [ap  [f:Fun A B]      : A.el -> B.el         = f.1];
  [ap2 [f:Fun2 A B C]   : A.el -> B.el -> C.el = f.1];
  [ap3 [f:Fun3 A B C D] : A.el -> B.el -> C.el -> D.el = f.1];

  [exten  [f:Fun A B]      : extensional f.ap   = f.2];
  [exten2 [f:Fun2 A B C]   : extensional2 f.ap2 = f.2];
  [exten3 [f:Fun3 A B C D] : extensional3 f.ap3 = f.2];

  [Fun_intro [o:A.el->B.el] [exten:extensional o] : Fun  A B
     = (o, exten : Fun A B)
  ];
  [Fun2_intro [o:A.el->B.el->C.el] [exten:extensional2 o] : Fun2  A B C
     = (o, exten : Fun2 A B C)
  ];
  [Fun3_intro [o:A.el->B.el->C.el->D.el] [exten:extensional3 o] : Fun3  A B C D
     = (o, exten : Fun3 A B C D)
  ];

Discharge A;

(* --------------------------------------------------------------------------------
   From an operator from types into a set, a function can be made.
*)

[S,T | SET] [A | Set];

Goal {f:S->A.el} extensional (f:S.QSet.el -> A.el);
  Intros ____; Qrepl H; Refine Eq_refl;
Save QFun_exten;

Goal {f:S.QSet.el->T.QSet.el->A.el} extensional2 f;
  Intros _______; Qrepl H; Qrepl H1; Refine Eq_refl;
Save QFun2_exten;

[     QFun [f:S->el A] : Fun S.QSet A
        = Fun_intro ? f.QFun_exten
]
[     QFun2 [f:S->T->el A] : Fun2 S.QSet T.QSet A
          = Fun2_intro ? f.QFun2_exten
];

Discharge S;

(* --------------------------------------------------------------------------------
   The identity and composition of functions
*)

[A : Set];

[     iden : A.el -> A.el
          = Id | A.el
]
[     Iden : Fun A A
          = Fun_intro iden ([x,x'|el A][H:Eq x x']H)
];

Discharge A;

[A,B,C | Set] [g : Fun B C] [f : Fun A B];

[     comp [g:B.el->C.el][f:A.el->B.el] : A.el -> C.el
          = compose g f
]
[     Comp : Fun A C
          = Fun_intro (comp g.ap f.ap) ([x,x'|el A][H:Eq x x']exten g (exten f H))
];

Discharge A;

(* --------------------------------------------------------------------------------
   Define some predicates on functions.
*)

[A,B,C | Set]
[f : Fun2 A A A] [e : el A] [id, neg : Fun A A];
  [Associative   = associative   (Eq|A) f.ap2];
  [Commutative   = [f:Fun2 A A B] commutative (Eq|B) f.ap2];
  [Involutive    = involutive    (Eq|A) id.ap];
  [Idempotent    = idempotent    (Eq|A) f.ap2];
  [lIdentity     = [f:Fun2 B A A][e:el B] l_identity (Eq|A) f.ap2 e];
  [rIdentity     = [f:Fun2 A B A][e:el B] r_identity (Eq|A) f.ap2 e];
  [Identity      = identity      (Eq|A) f.ap2 e];
  [lInverse      = [o:Fun2 C B A][e:el A][f:Fun B C] l_inverse (Eq|A) o.ap2 e f.ap];
  [rInverse      = [o:Fun2 C B A][e:el A][f:Fun C B] r_inverse (Eq|A) o.ap2 e f.ap];
  [Inverse       = [o:Fun2 B B A][e:el A][f:Fun B B] inverse   (Eq|A) o.ap2 e f.ap];
  [lCancelation  = [f:Fun2 B A C] l_cancelation (Eq|A) (Eq|C) f.ap2];
  [rCancelation  = [f:Fun2 A B C] r_cancelation (Eq|A) (Eq|C) f.ap2];
  [Cancelation   = [f:Fun2 A B C] cancelation   (Eq|A) (Eq|B) (Eq|C) f.ap2];
Discharge f; DischargeKeep A;

[f | Fun2 A A A] [e | el A] [id, neg | Fun A A];

  Goal (Commutative f) -> (rIdentity f e) -> (Identity f e);
    Intros commut ident; Refine pair ? ident;
    Intros x; Refine Eq_trans (f.ap2 x e); Refine commut; Refine ident;
  Save Identity_intro;

  Goal (Commutative f) -> (rInverse f e neg) -> (Inverse f e neg);
    Intros commut invers; Refine pair ? invers;
    Intros x; Refine Eq_trans (f.ap2 x (neg.ap x)); Refine commut; Refine invers;
  Save Inverse_intro;

  Goal (Commutative f) -> (rCancelation f) -> (Cancelation f);
    Intros commut cancel; Refine pair ? cancel;
    Intros a x y _; Refine cancel a;
    Refine Eq_trans (f.ap2 a x); Refine commut;
    Refine Eq_trans (f.ap2 a y); Refine H; Refine commut;
  Save Cancelation_intro;

Discharge A;

[     lDistributive [A,B|Set] [Plus:Fun2 A A A] [Times:Fun2 B A A]
          = {y:el B} distributive (Eq|A) Plus.ap2 (Times.ap2 y)
]
[     rDistributive [A,B|Set] [Plus:Fun2 A A A] [Times:Fun2 A B A]
          = {y:el B} distributive (Eq|A) Plus.ap2 ([x:el A]Times.ap2 x y)
];

[A | Set] [Plus, Times : Fun2 A A A] [Zero, One : el A] [Recip : Fun A A];
  [MultInverse  = {x:el A} iff (not (Eq x Zero)) (Eq (Times.ap2 x (Recip.ap x)) One)];
  [Distributive = (lDistributive Plus Times) /\ (rDistributive Plus Times)];
Discharge A;

Goal {A|Set}{Plus,Times|Fun2 A A A}
     (Commutative Times) -> (rDistributive Plus Times) -> (Distributive Plus Times);
  Intros ___ commut distrib; Refine pair ? distrib;
  Intros x y y';
    Refine Eq_trans (Times.ap2 (Plus.ap2 y y') x); Refine commut;
    Refine Eq_trans (Plus.ap2 (Times.ap2 y x) (Times.ap2 y' x)); Refine distrib;
    Refine exten2; Refine commut; Refine commut;
Save Distributive_intro;

(* ================================================================================
   Define the set of functions.
*)

[A,B : Set];

[     eq_Fun [A,B|Set] : (Fun A B) -> (Fun A B) -> Prop
           = [f,g:Fun A B] {x:el A} Eq (f.ap x) (g.ap x)
]
[     eq_Fun_refl : reflexive (eq_Fun|A|B)
          = [f:Fun A B] [x:el A] Eq_refl (f.ap x)
]
[     eq_Fun_sym : symmetric (eq_Fun|A|B)
          = [f,g|Fun A B] [H:eq_Fun f g] [x:el A] Eq_sym (H x)
]
[     eq_Fun_trans : transitive (eq_Fun|A|B)
          = [f,g,h:Fun A B] [H:eq_Fun f g] [H1:eq_Fun g h] [x:el A]
            Eq_trans (g.ap x) (H x) (H1 x)
]
[     Function : Set
          = Set_intro eq_Fun_refl eq_Fun_sym eq_Fun_trans
];

Discharge A;

(* --------------------------------------------------------------------------------
   Define the identity and compostion over functions. Prove some
   lemma's about these.
*)

[     Identit
          : {A:Set} (Function A A).el
          = Iden
];

[     composition
          : {A,B,C|Set} (Function B C).el -> (Function A B).el -> (Function A C).el
          = Comp
];

Goal {A,B,C:Set}
     extensional2|(Function B C)|(Function A B)|(Function A C) (composition|A|B|C);
  Intros ___ f f' _ g g' _ x;
  Refine Eq_trans (f'.ap (g.ap x)); Refine H;
  Refine exten; Refine H1;
Save composition_exten;

[     Composition [A,B,C:Set] : Fun2 (Function B C) (Function A B) (Function A C)
          = Fun2_intro ? (composition_exten A B C)
];

[     associativeFn
          [O:{A,B,C|Set}(Function B C).el->(Function A B).el->(Function A C).el]
          = {A,B,C,D|Set} {h:Fun C D}{g:Fun B C}{f:Fun A B}
            Eq (O h (O g f)) (O (O h g) f)
]
[     AssociativeFn
          [O:{A,B,C|Set}Fun2 (Function B C) (Function A B) (Function A C)]
          = associativeFn ([A,B,C|Set](O|A|B|C).ap2)
];

Goal associativeFn Comp;
  Intros; Refine Eq_refl;
Save Comp_assoc;

Goal AssociativeFn Composition;
  Refine Comp_assoc;
Save Composition_assoc;

Goal {A:Set} Identity (Composition A A A) (Identit A);
  intros; andI;
  Intros f x; Refine Eq_refl;
  Intros f x; Refine Eq_refl;
Save Identit_ident;

Goal {A,B|Set} rIdentity (Composition A A B) (Identit A);
  intros;
  Intros f x; Refine Eq_refl;
Save rIdentit_ident;

Goal {A,B|Set} lIdentity (Composition B A A) (Identit A);
  intros;
  Intros f x; Refine Eq_refl;
Save lIdentit_ident;

(* --------------------------------------------------------------------------------
   Define a notion of (split) surjection, injection, bijection.
*)

[A,B | Set] [f : Fun A B];
  [Injection       = {a,a'|el A} (Eq (f.ap a) (f.ap a')) -> Eq a a'];
  [Surjection      = {b:el B} Ex [a:el A] Eq (f.ap a) b];
  [SplitSurjection = Ex [g:Fun B A] {b:el B} Eq (f.ap (g.ap b)) b];
  [Bijection       = Injection /\ Surjection];
  [SplitBijection  = Injection /\ SplitSurjection];
Discharge A;

[A,B,C | Set] [f | Fun B C] [g | Fun A B];

Goal f.Injection -> g.Injection -> (Comp f g).Injection;
  Intros f_inj g_inj ___; Refine g_inj; Refine f_inj; Refine H;
Save Comp_inj;

Goal f.Injection -> (Comp f g).Surjection -> g.Surjection;
  Intros f_inj fg_surj _; exE fg_surj (f.ap b);
  Intros a _; Refine ExIntro; Refine a;
  Refine f_inj H;
Save Decomp_surj;

Discharge g;

Goal (Injection f) -> {g,g'|el (Function A B)}
     (Eq (composition f g) (composition f g')) -> Eq g g';
  Intros f_inj ____;
  Refine f_inj; Refine H;
Save Injection_lemma1;

Discharge A;

(* --------------------------------------------------------------------------------
   Define a notion of isomorphism, and show it is an equivalence
   relation. So we can compare sets by looking if they are
   isomorphic.
*)

(* We define 1) the relation Isomorphic over two function,
             2) the relation Iso over two sets,
             3) the type Isomorphism over two sets.
*)

[     Isomorphic [A,B|Set] : (Fun A B) -> (Fun B A) -> Prop
          = [f:Fun A B] [g:Fun B A]
            (Eq (composition g f) (Iden A)) /\
            (Eq (composition f g) (Iden B))
]
[     Iso [A,B:Set] : Prop
          = Ex2 [f:Fun A B] [g:Fun B A] Isomorphic f g
]
[     Isomorphism [A,B:Set] : SET
          = <f:Fun A B> <g:Fun B A> Isomorphic f g
];

(* Show Iso is an equivalence relation. *)
 
Goal {A:Set} Iso A A;
  Intros A;
  Refine Ex2Intro; Refine Iden A; Refine Iden A;
  andI; Refine Eq_refl; Refine Eq_refl;
Save Iso_refl;

Goal {A,B|Set} (Iso A B) -> (Iso B A);
  Intros A B _;
  Refine H; Intros f g _; andE H1;
  Refine Ex2Intro; andI +2; Immed;
Save Iso_sym;

Goal {A|Set}{B:Set}{C|Set} (Iso A B) -> (Iso B C) -> (Iso A C);
  Intros A B C __;
  Refine H;  Intros f f' _; andE H2;
  Refine H1; Intros g g' _; andE H5;
  Refine Ex2Intro; Refine Comp g f; Refine Comp f' g';
  Equiv and ({a:el A} Eq (f'.ap (g'.ap (g.ap (f.ap a)))) a)
            ({b:el C} Eq (g.ap (f.ap (f'.ap (g'.ap b)))) b);
  andI;
  intros;
    Refine Eq_trans (f'.ap (f.ap a)); Refine +1 H3;
    Refine exten; Refine H6;
  intros;
    Refine Eq_trans (g.ap (g'.ap b)); Refine +1 H7;
    Refine exten; Refine H4;
Save Iso_trans;

(* Show Isomorphism is an equivalence relation too. *)
 
Goal {A:Set} (Isomorphism A A);
  intros;
  Intros #; Refine Iden;
  Intros #; Refine Iden;
  Refine pair;
  Intros _; Refine Eq_refl;
  Intros _; Refine Eq_refl;
Save Isomorphism_refl;

Goal {A,B|Set} (Isomorphism A B) -> (Isomorphism B A);
  intros;
  Intros #; Refine H.2.1;
  Intros #; Refine H.1;
  Refine pair;
  Refine snd H.2.2;
  Refine fst H.2.2;
Save Isomorphism_sym;

Goal {A|Set}{B:Set}{C|Set}
     (Isomorphism A B) -> (Isomorphism B C) -> (Isomorphism A C);
  intros ___ f g;
  [fab : Fun A B = f.1] [fba : Fun B A = f.2.1];
  [gbc : Fun B C = g.1] [gcb : Fun C B = g.2.1];
  Intros #; Refine Comp gbc fab;
  Intros #; Refine Comp fba gcb;
  Refine pair;

  Refine Eq_trans|(Function A A) (Comp fba (Comp gcb (Comp gbc fab)));
    Refine Comp_assoc;
  Refine Eq_trans|(Function A A) (Comp fba fab);
    Refine +1 f.2.2.fst;
  Refine exten2 (Composition ???) ?.Eq_refl;
  Refine Eq_trans|(Function A B) (Comp (Comp gcb gbc) fab);
    Refine Comp_assoc;
  Refine Eq_trans|(Function A B) (Comp (Iden ?) fab);
    Refine +1 rIdentit_ident;
  Refine exten2 (Composition ???) ??.Eq_refl;
  Refine g.2.2.fst;

  Refine Eq_trans|(Function C C) (Comp gbc (Comp fab (Comp fba gcb)));
    Refine Comp_assoc;
  Refine Eq_trans|(Function C C) (Comp gbc gcb);
    Refine +1 g.2.2.snd;
  Refine exten2 (Composition ???) ?.Eq_refl;
  Refine Eq_trans|(Function C B) (Comp (Comp fab fba) gcb);
    Refine Comp_assoc;
  Refine Eq_trans|(Function C B) (Comp (Iden ?) gcb);
    Refine +1 lIdentit_ident;
  Refine exten2 (Composition ???) ??.Eq_refl;
  Refine f.2.2.snd;
Save Isomorphism_trans;

(* ================================================================================
   Define the set of propositions Omega.
*)

Goal reflexive iff;
  Intros _;
  andI; Refine ?+1; intros; Immed;
Save iff_refl;

Goal symmetric iff;
  Intros ___;
  andE H; andI; Immed;
Save iff_sym;

Goal transitive iff;
  Intros _____;
  Refine pair;
  Refine [z:x] H1.fst (H.fst z);
  Refine [z:z] H.snd (H1.snd z);
Save iff_trans;

[     Omega : Set
          = Set_intro iff_refl iff_sym iff_trans
];

Goal {alpha|el Omega} (Eq alpha trueProp) -> alpha;
  intros;
  Refine H.snd trueprf;
Save trueProp_lemma1;

Goal {alpha|el Omega} alpha -> (Eq alpha trueProp);
  intros; Refine pair;
  intros; Refine trueprf;
  intros; Refine H;
Save trueProp_lemma2;

(* Show that from the discreteness of Omega, classical logic follows.*)

Goal (Discrete Omega) -> ExcludedMiddle;
  Intros discr alpha;
  Refine discr;
  Refine alpha; Refine trueProp;
  intros; Refine inl; Refine trueProp_lemma1 H;
  intros; Refine inr; Intros _; Refine H; Refine trueProp_lemma2 H1;
Save EM_lemma;

