
Module Prime Import Nat_order Nat_div mu;

(* In this module we

    1)  Define the subset of prime numbers.
    2)  Show that they are decidable.
    3)  Show that there are infinetly many primes.
    4)  Define a prime generator.
    5)  Show it generates increasingly all primes.
*)

(* --------------------------------------------------------------------------------
   Define a predicate `is prime number'.
*)

[     is_prime [x:el Nat] : Prop
          = (LessN.ap2 OneN x) /\
            ({y:el Nat} (LessN.ap2 OneN y) -> (LessN.ap2 y x) -> not_divides y x)
]
[     is_no_prime [x:el Nat] : Prop
          = (LessN.ap2 OneN x) ->
            (Ex [y:el Nat] and3 (LessN.ap2 OneN y) (LessN.ap2 y x) (divides y x))
]
[     is_prime_factor [a,b:el Nat] : Prop
          = (divides a b) /\ (is_prime a)
];

[     isPrime : Pred Nat
          = QPred is_prime
];

(* Now we can show for example that 3 is a prime. *)

Goal isPrime.ap ThreeN;
  Refine pair; Refine LessEqN_elim_succ; Refine LessEqN_succ;
  intros; Expand not_divides;
  Claim Eq y TwoN;
  Qrepl ?+1;
  Refine +1 LessEqN_antisym;
    Refine +1 LessEqN_intro_succ H1;
    Refine +1 LessN_elim_succ H;
  intros; Intros _;
  Refine notEvenAndOdd; Refine ThreeN;
  Refine +1 ExIntro; Refine +1 OneN; Refine +1 Eq_refl;
  Refine extenPred ? H2;
  Refine ExIntro; Refine x;
  Refine Eq_sym; Refine Eq_trans ? (lTimesSuccN ??);
  Refine exten2 ???.Eq_refl;
  Refine lOneN_ident;
Save ThreeIsPrime;

(* --------------------------------------------------------------------------------
   The next three lemma's are needed to prove that prime is decidable.
*)

Goal {x,a:el Nat}
     ({y:el Nat} (LessN.ap2 OneN y) -> (LessN.ap2 y a) -> not_divides y x) \/
     (Ex [y:el Nat] and3 (LessN.ap2 OneN y) (LessN.ap2 y a) (divides y x));
  intros x;
  Refine nat_ind [a:nat]
               or ({y:nat}(LessN.ap2 OneN y) -> (LessN.ap2 y a) -> not_divides y x)
                  (Ex [y:nat]and3 (LessN.ap2 OneN y) (LessN.ap2 y a) (divides y x));
  intros; orIL; intros; Refine LessN_zero H1;
  intros a ih; orE ih;
  intros; orE divides_decidable a x;
  intros; orE LessEqN_partit a OneN;
  intros; orIL; intros;
    notE LessN_irrefl a;
    Refine LessN_succ_inj; Refine LessEqN_elim_succ;
    Refine LessEqN_trans y; Refine +1 LessEqN_intro_succ H4;
    Refine LessEqN_trans TwoN; Refine H2; Refine LessN_elim_succ H3;
  intros; orIR; exI ?; Refine a; Refine pair3 H2 ?.LessN_succ H1;
  intros; orIL; intros; Refine LessN_partit a y;
  intros;
    notE LessN_irrefl a;
    Refine LessN_intro_succ;
    Refine LessEqN_trans y; Refine LessN_elim_succ H4; Refine LessEqN_intro_succ H3;
  intros; Qrepl H4.Eq_sym; Refine H1;
  intros; Refine H; Immed;
  intros; orIR; exE H; intros y _; exI ?; Refine y;
    Refine H1; intros; Refine pair3 H2 H3.LessN_succ_intro H4;
Save is_prime_decidable_lemma;

Goal {x:el Nat} (is_prime x) \/ (is_no_prime x);
  intros; orE LessEqN_partit x OneN;
  intros; orIR; Intros _; notE LessN_irrefl x; Refine LessN_intro_succ;
    Refine LessEqN_trans TwoN; Refine H; Refine LessN_elim_succ H1;
  intros; orE is_prime_decidable_lemma x x;
  intros; orIL; andI; Immed;
  intros; orIR; Intros _; Immed;
Save is_prime_decidable;

Goal {x|el Nat} (is_prime x) -> (is_no_prime x) -> absurd;
  Intros ___; Refine H1 H.fst;
  intros y _; Refine H2;
  intros; Refine divides_exclusive H5;
  Refine H.snd ? H3 H4;
Save  is_prime_exclusive;

(* --------------------------------------------------------------------------------
   Show that our definition of is_prime is decidable.
*)

Goal decidable_pred is_prime;
  Intros x;
  orE is_prime_decidable x;
  Refine inl;
  intros; Refine inr;
  Intros _; Refine is_prime_exclusive H1 H;
Save is_prime_dec;

(* 
   Now we are able to define the characteristic function K_prime such that

     K_prime t  =_\beta\iota  0     iff    t is a prime

*)

[     K_prime : nat -> nat
          = char is_prime_dec
]
[     K_Prime : Fun Nat Nat
          = Char isPrime is_prime_dec
];

Goal {x|nat} (is_prime x) -> Eq|Nat (K_prime x) ZeroN;
  intros _;
  Refine (char_ok ??).fst;
Save K_prime_intro;

Goal {x|nat} (Eq|Nat (K_prime x) ZeroN) -> (is_prime x);
  intros _;
  Refine (char_ok ??).snd;
Save K_prime_elim;

Goal is_prime FiveN;
  Refine K_prime_elim;
  Refine Eq_refl;
Save FiveIsPrime;

Goal ~(is_prime FourN);
  Intros _; Refine Succ_not_zero;
  Refine +1 K_prime_intro H;
Save NotFourIsPrime;

(* --------------------------------------------------------------------------------
   Prove we can always find bigger primes.
*)

Goal {x:el Nat} (LessN.ap2 OneN x) -> Ex [y:el Nat] is_prime_factor y x;
  Refine CourseValueInduction
         [x:nat] (LessN.ap2 OneN x) -> Ex ([y:nat] is_prime_factor y x);
  intros;
  orE is_prime_decidable x;
  intros; exI ?; Refine x; andI; Refine divides_refl; Immed;
  intros;
    exE H2 H1; intros z _; Refine H3; intros;
    exE H z H5 H4; intros y _;
    exI ?; Refine y; andE H7; andI; Refine divides_trans z; Immed;
Save has_prime_factor;

(* The main proof of the infiniteness of the primes *)

Goal {x:el Nat} Ex [y:el Nat] ((LessN.ap2 x y) /\ (LessEqN.ap2 y (succ (fac x)))) /\
                              (is_prime y);
  Intros x;
  z == succ (fac x);                     (* let z be x! + 1                          *)
  exE has_prime_factor z;                (* show z>1 and find a prime factor of z    *)
  Refine LessEqN_elim_succ; Refine le_one_fac;
  Intros y PF; exI ?; Refine y;          (* take for y this prime factor             *)
  D == fst PF : divides y z;
  P == snd PF : is_prime y;
  H == fst P  : LessN.ap2 OneN y;
  Refine pair; Refine pair;              (* prove y>x and is_prime(y)                *)
  Refine +2 P;
  Refine LessN_intro; notI;              (* to prove y>x, prove absurd from y<=x *)
  notE LessN_irrefl OneN;                (* to prove absurd, prove 1<1               *)
  Refine extenRel LessN ? ? H;
  Refine Eq_refl;
  Refine divides_lemma_3 ? D;
  Refine fac_divides;                    (* to prove y|x!, prove y>1 and y<x         *)
  Refine LessEqN_intro_succ; Refine LessN_succ_intro H; Refine H1;
  orE divides_lemma_1 ?? D;              (* prove y<z from                           *)
  Refine Id;				 (*  y|z                                     *)
  intros; Refine Succ_not_zero ? H1;	 (*  and z<>0                                *);
Save infinitely_bounded_primes_exist;

Goal {x:el Nat} Ex [y:el Nat] (LessN.ap2 x y) /\ (is_prime y);
  intros; orE infinitely_bounded_primes_exist x;
  intros y _; Refine ExIntro; Refine y; Refine pair H.fst.fst H.snd;
Save infinitely_primes_exist;

(*

$[less = less_nat] $[one = OneN] $[divides_lemma=divides_lemma_3]
$[less2le = less2le_nat] $[le2less = le2less_nat] $[faculty_lemma = le_one_fac];
$[less_irrefl=less_nat_irrefl] $[less_exten=less_nat_exten];
$[eq_refl = eq_nat_refl] $[less_succ = less_nat_succE];
$[less2not_le = less_lemma];

Goal {x:nat} Ex [y:nat] and (less_nat x y) (is_prime y);
  Intros x;
    z == succ (fac x);                  (* let z be x! + 1                            *)
  Refine has_prime_factor z;            (* we have a prime factor of z, if 1 < z      *)
    Refine le2less;                     (* we have 1 < z, if 1 <= x!                  *)
    Refine faculty_lemma;               (* prove 1 <= x!                              *)
  Intros y PF;                          (* assume y, assume prime factor(y,z)         *)
    D == fst PF : divides y z;          (* so y | z                                   *)
    P == snd PF : is_prime y;           (* so prime(y)                                *)
    H == fst P  : less one y;           (* so 1 < y                                   *)
  Refine ExIntro |? ?| y;               (* take y and prove x < y & is_prime(y)       *)
  Refine pair ? P;                      (* we have x < y and is_prime(y), if x < y    *)
  Refine less2not_le;                   (* we have x < y, if not(y <= x)              *)
  Intros H1;                            (* assume y <=x, prove absurd                 *)
  Refine less_irrefl one;               (* we have absurd, if 1 < 1                   *)
  Refine less_exten ? ? H;              (* we have 1 < 1, if 1=1 & y = 1 & 1 < y *)
  Refine eq_refl;                       (* prove 1 = 1                                *)
  Refine divides_lemma ? D;             (* we have y = 1, if y|x! & y|z               *)
  Refine fac_divides ? ? ? H1;          (* we have y|x!, if 1 <= y & y <= x           *)
  Refine less2le;                       (* we have 1 <= y, if 1 < y + 1               *)
  Refine less_succ H;                   (* prove 1 < y + 1, using 1 < y               *)
Save infinite_primes;

*)

(* --------------------------------------------------------------------------------
   Define a prime generator, and show it doesn't skip primes.
*)

[x : el Nat];

[     is_new_prime : Nat.el -> Prop
          = [p:el Nat] (is_prime p) /\ (LessN.ap2 x p)
];

Goal decidable_pred is_new_prime;
  Intros p; orE is_prime_dec p;
  intros; orE LessN_dec x p;
  intros; Refine inl; Refine pair H H1;
  intros; Refine inr; Intros _; Refine H1; Refine H2.snd;
  intros; Refine inr; Intros _; Refine H; Refine H1.fst;
Save is_new_prime_dec;

[     new_prime : el Nat
          = mu is_new_prime_dec (succ (succ (fac x)))
];

Goal ~(Eq new_prime (succ (succ (fac x))));
  exE infinitely_bounded_primes_exist x;
  intros p _; Refine H; intros; Refine H1; intros;
  Intros _; Refine LessN_irrefl new_prime;
  Refine extenRel ??.Eq_refl; Refine +1 H5.Eq_sym;
  Refine LessEqN_elim_succ;
  Refine LessEqN_trans p; Refine +1 H4;
  Refine mu_OK ?? (succ (succ (fac x)));
  Refine pair H2 H3;
Save new_prime_lemma1;

Goal is_prime new_prime;
  Refine fst (mu_phi ? new_prime_lemma1);
Save new_prime_is_prime;

Goal LessN.ap2 x new_prime;
  Refine snd (mu_phi ? new_prime_lemma1);
Save new_prime_is_new;

Goal {p:el Nat} (is_prime p) -> (LessN.ap2 x p) -> LessEqN.ap2 new_prime p;
  intros;
  Refine mu_OK ?? (succ (succ (fac x)));
  Refine pair H H1;
Save new_prime_lemma2;

Discharge x;

[     NewPrime : Fun Nat Nat
          = QFun new_prime
]
[     prime : Nat.el -> Nat.el
          = nat_iter TwoN new_prime
]
[     Prime : Fun Nat Nat
          = QFun prime
];

(* Show Prime only generates primes. *)

Goal {i:el Nat} is_prime (prime i);
  Refine nat_elim [i:nat] is_prime (prime i);
  Equiv is_prime TwoN;
  Refine pair; Refine LessN_succ;
  intros; Refine LessEqN_partit_ok ? H1; Refine LessN_elim_succ H;
  intros; Refine new_prime_is_prime;
Save prime_is_prime;

(* Show that Prime is stricly increasing. *)

Goal {i:el Nat} LessN.ap2 (prime i) (prime (succ i));
  intros;
  Equiv LessN.ap2 (prime i) (new_prime (prime i));
  Refine new_prime_is_new;
Save prime_grows;

Goal {x:el Nat} (is_prime x) -> Ex [i:el Nat] Eq x (prime i);
  intros;
  Refine monotone_increasing_lemma|Prime prime_grows x;
    Refine LessN_elim_succ H.fst;
  intros i _; Refine ExIntro; Refine i;
  Refine LessEq2LessN H1.fst; Refine Eq_sym;
  intros; Refine LessEqN_partit_ok ? H1.snd;
  Refine new_prime_lemma2 ?? H H2;
Save prime_surj;

(* Let's look if the definition of prime really works
   We'll try to verify:

     prime(0) = 2
     prime(1) = 3
     prime(2) = 5
*)

Goal Eq (prime ZeroN) TwoN;
  Refine Eq_refl;
Save prime_0;

Goal Eq (prime OneN) ThreeN;
  Equiv Eq (new_prime TwoN) ThreeN;
  Equiv Eq (mu' TwoN.is_new_prime_dec FourN FourN) ThreeN;

  Refine Eq_trans (mu' TwoN.is_new_prime_dec ThreeN ThreeN);
    Refine select_left;
    intros; Refine H1 H;
    Refine pair; Refine ThreeIsPrime;
    Refine LessN_succ;

  Refine Eq_trans (mu' TwoN.is_new_prime_dec TwoN ThreeN);
    Refine select_right;
    intros; Refine H1 H;
    Intros _; Refine LessN_irrefl ? H.snd;

  Refine Eq_trans (mu' TwoN.is_new_prime_dec OneN ThreeN);
    Refine select_right;
    intros; Refine H1 H;
    Intros _; Refine LessN_irrefl; Refine +1 LessN_succ_elim H.snd;

  Refine select_right;
  intros; Refine H1 H;
  Intros _; Refine LessN_irrefl;
     Refine +1 LessN_succ_elim; Refine +1 LessN_succ_elim H.snd;
Save prime_1;

(* But wait, so far we have build prime constructively, so why not let the type
   checker just normalize prime(two) to five?
*)

Goal Eq (prime OneN) ThreeN;
  Refine Eq_refl;
Save prime_1';

(*
   This one needs a heap of more than 300 Mb and takes a day to check.
   Don't try this at home on your Linux machines, kids!
*)

(*
Goal Eq (prime TwoN) FiveN;
  Refine Eq_refl;
Save prime_2;
*)
